/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class DebugRenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.getInstance();

    public static void renderDebug(float partialTick) {
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderDeviceAxes) {
            DebugRenderHelper.renderDeviceAxes(DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderVrPlayerAxes) {
            DebugRenderHelper.renderPlayerAxes(partialTick);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderTrackerPositions || DebugRenderHelper.MC.screen instanceof FBTCalibrationScreen) {
            boolean showNames = true;
            Screen screen = DebugRenderHelper.MC.screen;
            if (screen instanceof FBTCalibrationScreen) {
                FBTCalibrationScreen fbtScreen = (FBTCalibrationScreen)screen;
                showNames = fbtScreen.isCalibrated();
            }
            DebugRenderHelper.renderTackerPositions(showNames);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderGameplayTrackers) {
            DATA_HOLDER.getTrackers().stream().filter(t -> DebugRenderHelper.DATA_HOLDER.vrSettings.gameplayTrackerToRender.isEmpty() || t.getClass().getName().equals(DebugRenderHelper.DATA_HOLDER.vrSettings.gameplayTrackerToRender)).forEach(t -> {
                if (t instanceof DebugRenderTracker) {
                    DebugRenderTracker debugTracker = (DebugRenderTracker)t;
                    if (t.isActive(DebugRenderHelper.MC.player)) {
                        debugTracker.renderDebug();
                    }
                }
            });
        }
    }

    public static void renderPlayerAxes(float partialTick) {
        if (DebugRenderHelper.MC.player != null) {
            VertexConsumer consumer = null;
            Vec3 camPos = DebugRenderHelper.MC.gameRenderer.getMainCamera().getPosition();
            for (Player p : DebugRenderHelper.MC.player.level().players()) {
                if (!ClientVRPlayers.getInstance().isVRPlayer((Entity)p)) continue;
                ClientVRPlayers.RotInfo info = ClientVRPlayers.getInstance().getRotationsForPlayer(p.getUUID());
                if (consumer == null) {
                    consumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
                }
                Vector3f playerPos = MathUtils.subtractToVector3f(p.getPosition(partialTick), camPos);
                if (p == DebugRenderHelper.MC.player) {
                    playerPos = MathUtils.subtractToVector3f(((GameRendererExtension)DebugRenderHelper.MC.gameRenderer).vivecraft$getRvePos(partialTick), camPos);
                }
                if (p != DebugRenderHelper.MC.player || DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.headPos, info.headRot, info.headQuat);
                }
                if (!info.seated) {
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.mainHandPos, info.mainHandRot, info.mainHandQuat);
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.offHandPos, info.offHandRot, info.offHandQuat);
                }
                if (info.fbtMode != FBTMode.ARMS_ONLY) {
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.waistPos, info.waistQuat);
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.rightFootPos, info.rightFootQuat);
                    DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.leftFootPos, info.leftFootQuat);
                }
                if (info.fbtMode != FBTMode.WITH_JOINTS) continue;
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.rightElbowPos, info.rightElbowQuat);
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.leftElbowPos, info.leftElbowQuat);
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.rightKneePos, info.rightKneeQuat);
                DebugRenderHelper.addAxes(consumer, (Vector3fc)playerPos, info.leftKneePos, info.leftKneeQuat);
            }
            if (consumer != null) {
                MC.renderBuffers().bufferSource().endBatch();
            }
        }
    }

    public static void renderDeviceAxes(VRData data) {
        VertexConsumer consumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        ArrayList<VRData.VRDevicePose> list = new ArrayList<VRData.VRDevicePose>();
        list.add(data.c2);
        if (DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            list.add(data.hmd);
        }
        if (DebugRenderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            list.add(data.cam);
        }
        if (DebugRenderHelper.MC.player != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.player.getMainHandItem()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t0);
        } else {
            list.add(DebugRenderHelper.MC.player != null && DebugRenderHelper.MC.player.isShiftKeyDown() ? data.h0 : data.c0);
        }
        if (DebugRenderHelper.MC.player != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.player.getOffhandItem()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t1);
        } else {
            list.add(DebugRenderHelper.MC.player != null && DebugRenderHelper.MC.player.isShiftKeyDown() ? data.h1 : data.c1);
        }
        if (data.fbtMode != FBTMode.ARMS_ONLY) {
            list.add(data.waist);
            list.add(data.foot_left);
            list.add(data.foot_right);
        }
        if (data.fbtMode == FBTMode.WITH_JOINTS) {
            list.add(data.elbow_left);
            list.add(data.knee_left);
            list.add(data.elbow_right);
            list.add(data.knee_right);
        }
        list.forEach(p -> DebugRenderHelper.addAxes(consumer, data, p));
        MC.renderBuffers().bufferSource().endBatch();
    }

    private static void renderTackerPositions(boolean showNames) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        Vec3 camPos = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition();
        Quaternionf orientation = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Component[] labels = new Component[]{Component.translatable((String)"vivecraft.toasts.point_controller.right"), Component.translatable((String)"vivecraft.toasts.point_controller.left"), Component.translatable((String)"vivecraft.messages.tracker.camera"), Component.translatable((String)"vivecraft.messages.tracker.waist"), Component.translatable((String)"vivecraft.messages.tracker.rightFoot"), Component.translatable((String)"vivecraft.messages.tracker.leftFoot"), Component.translatable((String)"vivecraft.messages.tracker.rightElbow"), Component.translatable((String)"vivecraft.messages.tracker.leftElbow"), Component.translatable((String)"vivecraft.messages.tracker.rightKnee"), Component.translatable((String)"vivecraft.messages.tracker.leftKnee")};
        for (Triple<DeviceSource, Integer, Matrix4fc> tracker : MCVR.get().getTrackers()) {
            Vector3f pos = ((Matrix4fc)tracker.getRight()).getTranslation(new Vector3f());
            Vec3 trackerPos = VRPlayer.roomToWorldPos((Vector3fc)pos, data).subtract(camPos);
            pos.set((float)trackerPos.x, (float)trackerPos.y, (float)trackerPos.z);
            if (showNames) {
                if ((Integer)tracker.getMiddle() >= 0) {
                    DebugRenderHelper.addNamedCube((Vector3fc)pos, orientation, (Component)Component.translatable((String)"vivecraft.formatting.name_value", (Object[])new Object[]{Component.literal((String)((DeviceSource)tracker.getLeft()).source.toString()), labels[(Integer)tracker.getMiddle()]}), 0.05f, MathUtils.DARK_GRAY);
                    continue;
                }
                DebugRenderHelper.addNamedCube((Vector3fc)pos, orientation, (Component)Component.translatable((String)"vivecraft.formatting.name_value", (Object[])new Object[]{Component.literal((String)(((DeviceSource)tracker.getLeft()).source.toString() + ((DeviceSource)tracker.getLeft()).deviceIndex)), Component.translatable((String)"vivecraft.messages.tracker.unknown")}), 0.05f, MathUtils.DARK_GRAY);
                continue;
            }
            DebugRenderHelper.renderCube((Vector3fc)pos, 0.05f, MathUtils.DARK_GRAY);
        }
        MC.renderBuffers().bufferSource().endLastBatch();
    }

    public static void renderLocalAxes(Matrix4f matrix) {
        RenderSystem.getModelViewStack().pushMatrix().mul((Matrix4fc)matrix);
        VertexConsumer consumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        Vector3f position = new Vector3f();
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, MathUtils.BACK, MathUtils.BLUE);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, MathUtils.UP, MathUtils.GREEN);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, MathUtils.RIGHT, MathUtils.RED);
        MC.renderBuffers().bufferSource().endBatch();
        RenderSystem.getModelViewStack().popMatrix();
    }

    private static void addAxes(VertexConsumer consumer, VRData data, VRData.VRDevicePose pose) {
        Vector3f position = MathUtils.subtractToVector3f(pose.getPosition(), data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = pose.getDirection().mul(scale);
        Vector3f up = pose.getCustomVector(MathUtils.UP).mul(scale);
        Vector3f right = pose.getCustomVector(MathUtils.RIGHT).mul(scale);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)forward, MathUtils.BLUE);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)up, MathUtils.GREEN);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)right, MathUtils.RED);
    }

    private static void addAxes(VertexConsumer consumer, Vector3fc playerPos, Vector3fc devicePos, Quaternionfc rot) {
        DebugRenderHelper.addAxes(consumer, playerPos, devicePos, (Vector3fc)rot.transform(MathUtils.BACK, new Vector3f()), rot);
    }

    private static void addAxes(VertexConsumer consumer, Vector3fc playerPos, Vector3fc devicePos, Vector3fc dir, Quaternionfc rot) {
        Vector3f position = playerPos.add(devicePos, new Vector3f());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = dir.mul(scale, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f()).mul(scale);
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f()).mul(scale);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)forward, MathUtils.BLUE);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)up, MathUtils.GREEN);
        DebugRenderHelper.addLine(consumer, (Vector3fc)position, (Vector3fc)right, MathUtils.RED);
    }

    private static void addLine(VertexConsumer consumer, Vector3fc position, Vector3fc dir, Vector3fc color) {
        consumer.addVertex(position.x(), position.y(), position.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
        consumer.addVertex(position.x(), position.y(), position.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
        consumer.addVertex(position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
        consumer.addVertex(position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
    }

    public static void renderLine(Vector3fc color, Vector3fc ... points) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        for (Vector3fc point : points) {
            vertexConsumer.addVertex(point.x(), point.y(), point.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
        }
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void renderLine(List<Pair<Vector3fc, Boolean>> points, Vector3fc color) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        Pair<Vector3fc, Boolean> prev = null;
        for (Pair<Vector3fc, Boolean> point : points) {
            if (((Boolean)point.getRight()).booleanValue() && prev != null) {
                vertexConsumer.addVertex(((Vector3fc)prev.getLeft()).x(), ((Vector3fc)prev.getLeft()).y(), ((Vector3fc)prev.getLeft()).z()).setColor(color.x(), color.y(), color.z(), 0.0f);
                vertexConsumer.addVertex(((Vector3fc)point.getLeft()).x(), ((Vector3fc)point.getLeft()).y(), ((Vector3fc)point.getLeft()).z()).setColor(color.x(), color.y(), color.z(), 0.0f);
            }
            vertexConsumer.addVertex(((Vector3fc)point.getLeft()).x(), ((Vector3fc)point.getLeft()).y(), ((Vector3fc)point.getLeft()).z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            prev = point;
        }
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void renderLine(Vector3fc color, Vec3 camPos, Iterable<Vec3> points) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        for (Vec3 point : points) {
            vertexConsumer.addVertex((float)(point.x() - camPos.x()), (float)(point.y() - camPos.y()), (float)(point.z() - camPos.z())).setColor(color.x(), color.y(), color.z(), 1.0f);
        }
        MC.renderBuffers().bufferSource().endBatch();
    }

    private static void addNamedCube(Vector3fc cubePos, Quaternionf rot, Component label, float size, Vector3fc color) {
        DebugRenderHelper.renderCube(cubePos, size, color);
        if (label != null) {
            DebugRenderHelper.renderTextAtRelativePosition(cubePos.x(), cubePos.y(), cubePos.z(), rot, label);
        }
    }

    public static void renderTextAtDevice(PoseStack poseStack, int device, String text) {
        DebugRenderHelper.renderTextAtPosition(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld().getDevice(device).getPosition(), text);
    }

    public static void renderTextAtPosition(PoseStack poseStack, Vec3 position, String text) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        Vec3 camPos = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition();
        Quaternionf rot = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Vector3f pos = MathUtils.subtractToVector3f(position, camPos);
        DebugRenderHelper.renderTextAtRelativePosition(pos.x, pos.y, pos.z, rot, text);
    }

    public static void renderTextAtRelativePosition(float x, float y, float z, Quaternionf rot, String text) {
        DebugRenderHelper.renderTextAtRelativePosition(x, y, z, rot, (Component)Component.literal((String)text));
    }

    public static void renderTextAtRelativePosition(float x, float y, float z, Quaternionf rot, Component text) {
        Matrix4f matrix = new Matrix4f();
        matrix.translate(x, y + 0.05f, z);
        matrix.rotate((Quaternionfc)rot);
        matrix.scale(-0.005f, -0.005f, 0.005f);
        Font font = DebugRenderHelper.MC.font;
        float f = (float)DebugRenderHelper.MC.font.width((FormattedText)text) * -0.5f;
        Objects.requireNonNull(DebugRenderHelper.MC.font);
        font.drawInBatch(text, f, (float)(-9), -1, false, matrix, (MultiBufferSource)MC.renderBuffers().bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderCube(Vector3fc position, float size, Vector3fc color) {
        ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        RenderType renderType = VRRenderTypes.quads(false);
        VertexConsumer consumer = MC.renderBuffers().bufferSource().getBuffer(renderType);
        Vec3i iColor = new Vec3i((int)(color.x() * 255.0f), (int)(color.y() * 255.0f), (int)(color.z() * 255.0f));
        Vec3 start = new Vec3((double)position.x(), (double)position.y(), (double)position.z()).add(MathUtils.FORWARD_D.scale((double)(size * 0.5f)));
        Vec3 end = new Vec3((double)position.x(), (double)position.y(), (double)position.z()).add(MathUtils.BACK_D.scale((double)(size * 0.5f)));
        RenderHelper.renderBox(consumer, start, end, size, size, iColor, (byte)-1, new Matrix4f());
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void addCircle(VertexConsumer vertexConsumer, Vector3fc center, Vector3fc forward, float radius, Vector3fc color) {
        Vector3f offset = MathUtils.getPerpendicularVec(forward).mul(radius);
        vertexConsumer.addVertex(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
        for (int i = 0; i <= 20; ++i) {
            vertexConsumer.addVertex(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            if (i == 20) continue;
            offset.rotateAxis(0.31415927f, forward.x(), forward.y(), forward.z());
        }
        vertexConsumer.addVertex(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
    }

    public static void renderCircle(Vector3fc center, Vector3fc forward, float radius, Vector3fc color) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        DebugRenderHelper.addCircle(vertexConsumer, center, forward, radius, color);
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void renderSphere(Vector3fc center, float radius, Vector3fc color) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        DebugRenderHelper.addCircle(vertexConsumer, center, MathUtils.LEFT, radius, color);
        DebugRenderHelper.addCircle(vertexConsumer, center, MathUtils.FORWARD, radius, color);
        DebugRenderHelper.addCircle(vertexConsumer, center, MathUtils.UP, radius, color);
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void renderCone(Vector3fc tip, Vector3fc dir, float angle, float length, Vector3fc color) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        Vector3f center = dir.normalize(new Vector3f()).mul(length).add(tip);
        float radius = length * (float)Math.tan(Math.toRadians(angle));
        DebugRenderHelper.addCircle(vertexConsumer, (Vector3fc)center, dir, radius, color);
        Vector3f offset = MathUtils.getPerpendicularVec(dir).mul(radius);
        for (int i = 0; i < 2; ++i) {
            vertexConsumer.addVertex(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
            vertexConsumer.addVertex(center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.addVertex(tip.x(), tip.y(), tip.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.addVertex(center.x() - offset.x(), center.y() - offset.y(), center.z() - offset.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.addVertex(center.x() - offset.x(), center.y() - offset.y(), center.z() - offset.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
            offset.rotateAxis(1.5707964f, dir.x(), dir.y(), dir.z());
        }
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void renderCylinder(Vector3fc bottom, Vector3fc topDir, float radius, Vector3fc color) {
        VertexConsumer vertexConsumer = MC.renderBuffers().bufferSource().getBuffer(RenderType.debugLineStrip((double)2.0));
        Vector3f dir = topDir.normalize(new Vector3f());
        DebugRenderHelper.addCircle(vertexConsumer, bottom, (Vector3fc)dir, radius, color);
        DebugRenderHelper.addCircle(vertexConsumer, (Vector3fc)bottom.add(topDir, new Vector3f()), (Vector3fc)dir, radius, color);
        Vector3f offset = MathUtils.getPerpendicularVec(topDir).mul(radius);
        for (int i = 0; i < 4; ++i) {
            Vector3f bot = bottom.add((Vector3fc)offset, new Vector3f());
            Vector3f top = bot.add(topDir, new Vector3f());
            vertexConsumer.addVertex(bot.x(), bot.y(), bot.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
            vertexConsumer.addVertex(bot.x(), bot.y(), bot.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.addVertex(top.x(), top.y(), top.z()).setColor(color.x(), color.y(), color.z(), 1.0f);
            vertexConsumer.addVertex(top.x(), top.y(), top.z()).setColor(color.x(), color.y(), color.z(), 0.0f);
            offset.rotateAxis(1.5707964f, dir.x(), dir.y(), dir.z());
        }
        MC.renderBuffers().bufferSource().endBatch();
    }

    public static void renderAABB(AABB aabb, Vector3fc color) {
        DebugRenderHelper.renderCubeOutline((Vector3fc)new Vector3f((float)aabb.minX, (float)aabb.minY, (float)aabb.minZ), (Vector3fc)new Vector3f((float)aabb.minX, (float)aabb.maxY, (float)aabb.minZ), (Vector3fc)new Vector3f((float)aabb.minX, (float)aabb.maxY, (float)aabb.maxZ), (Vector3fc)new Vector3f((float)aabb.minX, (float)aabb.minY, (float)aabb.maxZ), (Vector3fc)new Vector3f((float)aabb.maxX, (float)aabb.minY, (float)aabb.minZ), (Vector3fc)new Vector3f((float)aabb.maxX, (float)aabb.maxY, (float)aabb.minZ), (Vector3fc)new Vector3f((float)aabb.maxX, (float)aabb.maxY, (float)aabb.maxZ), (Vector3fc)new Vector3f((float)aabb.maxX, (float)aabb.minY, (float)aabb.maxZ), color);
    }

    public static void renderCubeOutline(Vector3fc v0, Vector3fc v1, Vector3fc v2, Vector3fc v3, Vector3fc v4, Vector3fc v5, Vector3fc v6, Vector3fc v7, Vector3fc color) {
        DebugRenderHelper.renderLine(List.of(Pair.of((Object)v0, (Object)false), Pair.of((Object)v1, (Object)false), Pair.of((Object)v2, (Object)false), Pair.of((Object)v3, (Object)false), Pair.of((Object)v0, (Object)false), Pair.of((Object)v4, (Object)false), Pair.of((Object)v5, (Object)false), Pair.of((Object)v6, (Object)false), Pair.of((Object)v7, (Object)false), Pair.of((Object)v4, (Object)false), Pair.of((Object)v1, (Object)true), Pair.of((Object)v5, (Object)false), Pair.of((Object)v2, (Object)true), Pair.of((Object)v6, (Object)false), Pair.of((Object)v3, (Object)true), Pair.of((Object)v7, (Object)false)), color);
    }
}

