/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.Xloader;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.EntityRenderDispatcherVRExtension;
import org.vivecraft.client_vr.gameplay.trackers.BowTracker;
import org.vivecraft.client_vr.gameplay.trackers.ClimbTracker;
import org.vivecraft.client_vr.gameplay.trackers.SwingTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.VRArmRenderer;
import org.vivecraft.client_vr.render.VivecraftItemRendering;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={ItemInHandRenderer.class}, priority=999)
public abstract class ItemInHandRendererVRMixin {
    @Unique
    private static final RenderType VIVECRAFT$MAP_BACKGROUND_NO_CULL = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png"), (boolean)false);
    @Unique
    private static final RenderType VIVECRAFT$MAP_BACKGROUND_CHECKERBOARD_NO_CULL = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png"), (boolean)false);
    @Unique
    private static final RenderType VIVECRAFT$MAP_BACKGROUND_NO_CULL_TEXT = VRRenderTypes.textNoCull(ResourceLocation.withDefaultNamespace((String)"textures/map/map_background.png"));
    @Unique
    private static final RenderType VIVECRAFT$MAP_BACKGROUND_CHECKERBOARD_NO_CULL_TEXT = VRRenderTypes.textNoCull(ResourceLocation.withDefaultNamespace((String)"textures/map/map_background_checkerboard.png"));
    @Final
    @Shadow
    private Minecraft minecraft;
    @Final
    @Shadow
    private EntityRenderDispatcher entityRenderDispatcher;
    @Shadow
    private float oMainHandHeight;
    @Shadow
    private float mainHandHeight;
    @Shadow
    private float oOffHandHeight;
    @Shadow
    private float offHandHeight;
    @Shadow
    @Final
    private MapRenderState mapRenderState;
    @Shadow
    @Final
    private static RenderType MAP_BACKGROUND;
    @Unique
    private boolean vivecraft$didLogModelError = false;

    @Shadow
    public abstract void renderItem(LivingEntity var1, ItemStack var2, ItemDisplayContext var3, PoseStack var4, MultiBufferSource var5, int var6);

    @Shadow
    protected abstract void renderMap(PoseStack var1, MultiBufferSource var2, int var3, ItemStack var4);

    @Shadow
    protected abstract void renderPlayerArm(PoseStack var1, MultiBufferSource var2, int var3, float var4, float var5, HumanoidArm var6);

    @Inject(method={"renderPlayerArm(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IFFLnet/minecraft/world/entity/HumanoidArm;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$overrideArm(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float equippedProgress, float swingProgress, HumanoidArm side, CallbackInfo ci) {
        if (VRState.VR_RUNNING) {
            this.vivecraft$vrPlayerArm(poseStack, buffer, combinedLight, swingProgress, side);
            ci.cancel();
        }
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$overrideArmItem(AbstractClientPlayer player, float partialTick, float pitch, InteractionHand hand, float swingProgress, ItemStack itemStack, float equippedProgress, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, CallbackInfo ci) {
        if (VRState.VR_RUNNING) {
            this.vivecraft$vrRenderArmWithItem(player, partialTick, hand, swingProgress, itemStack, poseStack, buffer, combinedLight);
            ci.cancel();
        }
    }

    @Inject(method={"renderMap(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;get(Lnet/minecraft/core/component/DataComponentType;)Ljava/lang/Object;")}, cancellable=true)
    private void vivecraft$overrideMapShaders(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemStack stack, CallbackInfo ci) {
        if (VRState.VR_RUNNING && ShadersHelper.isShaderActive()) {
            MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
            MapItemSavedData mapData = MapItem.getSavedData((MapId)mapId, (Level)this.minecraft.level);
            VertexConsumer consumer = buffer.getBuffer(mapData == null ? VIVECRAFT$MAP_BACKGROUND_NO_CULL : VIVECRAFT$MAP_BACKGROUND_CHECKERBOARD_NO_CULL);
            Matrix4f matrix = poseStack.last().pose();
            Vector3f normal = matrix.transformDirection(0.0f, 0.0f, 1.0f, new Vector3f());
            consumer.addVertex(matrix, -7.0f, 135.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
            consumer.addVertex(matrix, 135.0f, 135.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
            consumer.addVertex(matrix, 135.0f, -7.0f, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
            consumer.addVertex(matrix, -7.0f, -7.0f, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
            if (mapData != null) {
                MapRenderer mapRenderer = this.minecraft.getMapRenderer();
                mapRenderer.extractRenderState(mapId, mapData, this.mapRenderState);
                mapRenderer.render(this.mapRenderState, poseStack, buffer, false, packedLight);
            }
            ci.cancel();
        }
    }

    @ModifyArg(method={"renderMap(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;"))
    private RenderType vivecraft$overrideMapVanilla(RenderType renderType) {
        if (VRState.VR_RUNNING) {
            return renderType == MAP_BACKGROUND ? VIVECRAFT$MAP_BACKGROUND_NO_CULL_TEXT : VIVECRAFT$MAP_BACKGROUND_CHECKERBOARD_NO_CULL_TEXT;
        }
        return renderType;
    }

    @Unique
    private void vivecraft$vrRenderArmWithItem(AbstractClientPlayer player, float partialTick, InteractionHand hand, float swingProgress, ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        boolean renderArm;
        HumanoidArm side;
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        boolean mainHand = hand == InteractionHand.MAIN_HAND;
        HumanoidArm humanoidArm = side = mainHand ? player.getMainArm() : player.getMainArm().getOpposite();
        if (dh.vrSettings.reverseHands) {
            side = side.getOpposite();
        }
        float equippedProgress = this.vivecraft$getEquipProgress(hand, partialTick);
        poseStack.pushPose();
        boolean bl = renderArm = dh.currentPass != RenderPass.THIRD || dh.vrSettings.mixedRealityRenderHands;
        if (RenderPass.isFirstPerson(dh.currentPass)) {
            renderArm &= dh.vrSettings.showPlayerHands;
        }
        if (dh.currentPass == RenderPass.CAMERA) {
            renderArm = false;
        }
        if (BowTracker.isBow(itemStack) && dh.bowTracker.isActive((LocalPlayer)player)) {
            renderArm = false;
        }
        if (TelescopeTracker.isTelescope(itemStack) && (hand == InteractionHand.OFF_HAND && dh.currentPass == RenderPass.SCOPEL || hand == InteractionHand.MAIN_HAND && dh.currentPass == RenderPass.SCOPER)) {
            renderArm = false;
        }
        if (RenderPass.isFirstPerson(dh.currentPass) && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.COMPLETE) {
            renderArm = false;
        }
        if (renderArm && !player.isInvisible()) {
            this.renderPlayerArm(poseStack, buffer, combinedLight, equippedProgress, swingProgress, side);
        }
        if (!itemStack.isEmpty()) {
            ItemDisplayContext itemDisplayContext;
            boolean isBow;
            PatchedDataComponentMap patched;
            poseStack.pushPose();
            if (player.swingingArm == hand) {
                this.vivecraft$transformFirstPersonVR(poseStack, side, swingProgress);
            }
            VivecraftItemRendering.VivecraftItemTransformType transformType = VivecraftItemRendering.getTransformType(itemStack, player);
            boolean useLeftHandModelinLeftHand = false;
            DataComponentMap dataComponentMap = itemStack.getComponents();
            boolean hasItemOverride = dataComponentMap instanceof PatchedDataComponentMap && (patched = (PatchedDataComponentMap)dataComponentMap).hasNonDefault(DataComponents.ITEM_MODEL);
            boolean hasCMD = (hasItemOverride || itemStack.has(DataComponents.CUSTOM_MODEL_DATA)) && transformType != VivecraftItemRendering.VivecraftItemTransformType.CROSSBOW && transformType != VivecraftItemRendering.VivecraftItemTransformType.SPEAR && transformType != VivecraftItemRendering.VivecraftItemTransformType.SHIELD;
            boolean bl2 = isBow = BowTracker.isBow(itemStack) && dh.bowTracker.isActive((LocalPlayer)player);
            if (ClimbTracker.isClaws(itemStack) || !isBow && (ClientNetworking.isThirdPersonItems() || hasCMD && ClientNetworking.isThirdPersonItemsCustom())) {
                if (dh.vrSettings.reverseHands) {
                    mainHand = !mainHand;
                }
                useLeftHandModelinLeftHand = true;
                VivecraftItemRendering.applyThirdPersonItemTransforms(poseStack, transformType, mainHand, player, equippedProgress, partialTick, itemStack, hand);
                itemDisplayContext = mainHand || !useLeftHandModelinLeftHand ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            } else {
                VivecraftItemRendering.applyFirstPersonItemTransforms(poseStack, transformType, mainHand, player, equippedProgress, partialTick, itemStack, hand);
                ItemDisplayContext itemDisplayContext2 = itemDisplayContext = mainHand || !useLeftHandModelinLeftHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            }
            if (transformType == VivecraftItemRendering.VivecraftItemTransformType.MAP) {
                this.renderMap(poseStack, buffer, combinedLight, itemStack);
            } else if (transformType == VivecraftItemRendering.VivecraftItemTransformType.TELESCOPE) {
                if (dh.currentPass != RenderPass.SCOPEL && dh.currentPass != RenderPass.SCOPER) {
                    poseStack.pushPose();
                    this.renderItem((LivingEntity)player, itemStack, itemDisplayContext, poseStack, buffer, combinedLight);
                    if (ClientNetworking.isThirdPersonItems()) {
                        poseStack.translate(0.0f, 0.219f, 0.0f);
                    } else {
                        poseStack.translate(0.0f, 0.344f, 0.0f);
                    }
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                    if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                        OptifineHelper.endEntities();
                    }
                    VREffectsHelper.drawScopeFB(poseStack, hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
                        OptifineHelper.beginEntities();
                    }
                    poseStack.popPose();
                }
            } else {
                this.renderItem((LivingEntity)player, itemStack, itemDisplayContext, poseStack, buffer, combinedLight);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    @Unique
    private float vivecraft$getEquipProgress(InteractionHand hand, float partialTick) {
        return hand == InteractionHand.MAIN_HAND ? 1.0f - Mth.lerp((float)partialTick, (float)this.oMainHandHeight, (float)this.mainHandHeight) : 1.0f - Mth.lerp((float)partialTick, (float)this.oOffHandHeight, (float)this.offHandHeight);
    }

    @Unique
    private void vivecraft$vrPlayerArm(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, float swingProgress, HumanoidArm side) {
        LocalPlayer player = this.minecraft.player;
        boolean rightHand = side == HumanoidArm.RIGHT;
        boolean mainHand = side == (ClientDataHolderVR.getInstance().vrSettings.reverseHands ? HumanoidArm.LEFT : HumanoidArm.RIGHT);
        float offsetDirection = rightHand ? 1.0f : -1.0f;
        VRArmRenderer vrArmRenderer = ((EntityRenderDispatcherVRExtension)this.entityRenderDispatcher).vivecraft$getArmSkinMap().get(player.getSkin().model().id());
        if (vrArmRenderer == null) {
            if (!this.vivecraft$didLogModelError) {
                VRSettings.LOGGER.error("Vivecraft: Some mod broke player model reloading. Possible culprit 'Stfu' loaded: {}", (Object)Xloader.isModLoaded("stfu"));
                this.vivecraft$didLogModelError = true;
            }
            return;
        }
        poseStack.pushPose();
        if (player.swingingArm == InteractionHand.MAIN_HAND && mainHand) {
            this.vivecraft$transformFirstPersonVR(poseStack, side, swingProgress);
        }
        if (player.swingingArm == InteractionHand.OFF_HAND && !mainHand) {
            this.vivecraft$transformFirstPersonVR(poseStack, side, swingProgress);
        }
        poseStack.scale(0.4f, 0.4f, 0.4f);
        boolean slim = player.getSkin().model().id().equals("slim");
        poseStack.translate((slim ? -0.34375f : -0.375f) * offsetDirection, 0.0f, 0.75f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        vrArmRenderer.armAlpha = SwingTracker.getItemFade(player, ItemStack.EMPTY);
        ResourceLocation skin = player.getSkin().texture();
        if (rightHand) {
            vrArmRenderer.renderRightHand(poseStack, buffer, combinedLight, skin, true);
        } else {
            vrArmRenderer.renderLeftHand(poseStack, buffer, combinedLight, skin, true);
        }
        poseStack.popPose();
    }

    @Unique
    private void vivecraft$transformFirstPersonVR(PoseStack poseStack, HumanoidArm side, float swingProgress) {
        if (swingProgress == 0.0f) {
            return;
        }
        switch (ClientDataHolderVR.getInstance().swingType) {
            case ATTACK: {
                float forwardRotation = swingProgress > 0.5f ? Mth.sin((float)(swingProgress * (float)Math.PI + (float)Math.PI)) : Mth.sin((float)(swingProgress * 3.0f * (float)Math.PI));
                poseStack.translate(0.0f, 0.0f, 0.2f);
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(forwardRotation * 30.0f));
                poseStack.translate(0.0f, 0.0f, -0.2f);
                break;
            }
            case INTERACT: {
                float sideRotation = swingProgress > 0.5f ? Mth.sin((float)(swingProgress * (float)Math.PI + (float)Math.PI)) : Mth.sin((float)(swingProgress * 3.0f * (float)Math.PI));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((side == HumanoidArm.RIGHT ? -1.0f : 1.0f) * sideRotation * 45.0f));
                break;
            }
            case USE: {
                float forwardMovement = swingProgress > 0.25f ? Mth.sin((float)(swingProgress / 2.0f * (float)Math.PI + (float)Math.PI)) : Mth.sin((float)(swingProgress * 2.0f * (float)Math.PI));
                poseStack.translate(0.0f, 0.0f, -(1.0f + forwardMovement) * 0.1f);
            }
        }
    }
}

