/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import org.lwjgl.openvr.InputOriginInfo;
import org.lwjgl.openvr.InputPoseActionData;
import org.lwjgl.openvr.InputSkeletalActionData;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRBoneTransform;
import org.lwjgl.openvr.VRSkeletalSummaryData;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRInput {
    protected VRInput() {
        throw new UnsupportedOperationException();
    }

    public static int nVRInput_SetActionManifestPath(long pchActionManifestPath) {
        long __functionAddress = OpenVR.VRInput.SetActionManifestPath;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)pchActionManifestPath, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_SetActionManifestPath(@NativeType(value="char const *") ByteBuffer pchActionManifestPath) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchActionManifestPath);
        }
        return VRInput.nVRInput_SetActionManifestPath(MemoryUtil.memAddress((ByteBuffer)pchActionManifestPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_SetActionManifestPath(@NativeType(value="char const *") CharSequence pchActionManifestPath) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchActionManifestPath, true);
            long pchActionManifestPathEncoded = stack.getPointerAddress();
            int n = VRInput.nVRInput_SetActionManifestPath(pchActionManifestPathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_GetActionSetHandle(long pchActionSetName, long pHandle) {
        long __functionAddress = OpenVR.VRInput.GetActionSetHandle;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchActionSetName, (long)pHandle, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionSetHandle(@NativeType(value="char const *") ByteBuffer pchActionSetName, @NativeType(value="VRActionSetHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchActionSetName);
            Checks.check((Buffer)pHandle, (int)1);
        }
        return VRInput.nVRInput_GetActionSetHandle(MemoryUtil.memAddress((ByteBuffer)pchActionSetName), MemoryUtil.memAddress((LongBuffer)pHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionSetHandle(@NativeType(value="char const *") CharSequence pchActionSetName, @NativeType(value="VRActionSetHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchActionSetName, true);
            long pchActionSetNameEncoded = stack.getPointerAddress();
            int n = VRInput.nVRInput_GetActionSetHandle(pchActionSetNameEncoded, MemoryUtil.memAddress((LongBuffer)pHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_GetActionHandle(long pchActionName, long pHandle) {
        long __functionAddress = OpenVR.VRInput.GetActionHandle;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchActionName, (long)pHandle, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionHandle(@NativeType(value="char const *") ByteBuffer pchActionName, @NativeType(value="VRActionHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchActionName);
            Checks.check((Buffer)pHandle, (int)1);
        }
        return VRInput.nVRInput_GetActionHandle(MemoryUtil.memAddress((ByteBuffer)pchActionName), MemoryUtil.memAddress((LongBuffer)pHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionHandle(@NativeType(value="char const *") CharSequence pchActionName, @NativeType(value="VRActionHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchActionName, true);
            long pchActionNameEncoded = stack.getPointerAddress();
            int n = VRInput.nVRInput_GetActionHandle(pchActionNameEncoded, MemoryUtil.memAddress((LongBuffer)pHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_GetInputSourceHandle(long pchInputSourcePath, long pHandle) {
        long __functionAddress = OpenVR.VRInput.GetInputSourceHandle;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchInputSourcePath, (long)pHandle, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetInputSourceHandle(@NativeType(value="char const *") ByteBuffer pchInputSourcePath, @NativeType(value="VRInputValueHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchInputSourcePath);
            Checks.check((Buffer)pHandle, (int)1);
        }
        return VRInput.nVRInput_GetInputSourceHandle(MemoryUtil.memAddress((ByteBuffer)pchInputSourcePath), MemoryUtil.memAddress((LongBuffer)pHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRInputError")
    public static int VRInput_GetInputSourceHandle(@NativeType(value="char const *") CharSequence pchInputSourcePath, @NativeType(value="VRInputValueHandle_t *") LongBuffer pHandle) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pHandle, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchInputSourcePath, true);
            long pchInputSourcePathEncoded = stack.getPointerAddress();
            int n = VRInput.nVRInput_GetInputSourceHandle(pchInputSourcePathEncoded, MemoryUtil.memAddress((LongBuffer)pHandle));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRInput_UpdateActionState(long pSets, int unSizeOfVRSelectedActionSet_t, int unSetCount) {
        long __functionAddress = OpenVR.VRInput.UpdateActionState;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)pSets, (int)unSizeOfVRSelectedActionSet_t, (int)unSetCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_UpdateActionState(@NativeType(value="VRActiveActionSet_t *") VRActiveActionSet.Buffer pSets, @NativeType(value="uint32_t") int unSizeOfVRSelectedActionSet_t) {
        return VRInput.nVRInput_UpdateActionState(pSets.address(), unSizeOfVRSelectedActionSet_t, pSets.remaining());
    }

    public static int nVRInput_GetDigitalActionData(long action, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetDigitalActionData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPJI((long)action, (long)pActionData, (int)unActionDataSize, (long)ulRestrictToDevice, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetDigitalActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputDigitalActionData_t *") InputDigitalActionData pActionData, @NativeType(value="uint32_t") int unActionDataSize, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetDigitalActionData(action, pActionData.address(), unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetDigitalActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputDigitalActionData_t *") InputDigitalActionData pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetDigitalActionData(action, pActionData.address(), InputDigitalActionData.SIZEOF, ulRestrictToDevice);
    }

    public static int nVRInput_GetAnalogActionData(long action, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetAnalogActionData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPJI((long)action, (long)pActionData, (int)unActionDataSize, (long)ulRestrictToDevice, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetAnalogActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputAnalogActionData_t *") InputAnalogActionData pActionData, @NativeType(value="uint32_t") int unActionDataSize, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetAnalogActionData(action, pActionData.address(), unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetAnalogActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputAnalogActionData_t *") InputAnalogActionData pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetAnalogActionData(action, pActionData.address(), InputAnalogActionData.SIZEOF, ulRestrictToDevice);
    }

    public static int nVRInput_GetPoseActionData(long action, int eOrigin, float fPredictedSecondsFromNow, long pActionData, int unActionDataSize, long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.GetPoseActionData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPJI((long)action, (int)eOrigin, (float)fPredictedSecondsFromNow, (long)pActionData, (int)unActionDataSize, (long)ulRestrictToDevice, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetPoseActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, float fPredictedSecondsFromNow, @NativeType(value="InputPoseActionData_t *") InputPoseActionData pActionData, @NativeType(value="uint32_t") int unActionDataSize, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetPoseActionData(action, eOrigin, fPredictedSecondsFromNow, pActionData.address(), unActionDataSize, ulRestrictToDevice);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetPoseActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="ETrackingUniverseOrigin") int eOrigin, float fPredictedSecondsFromNow, @NativeType(value="InputPoseActionData_t *") InputPoseActionData pActionData, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        return VRInput.nVRInput_GetPoseActionData(action, eOrigin, fPredictedSecondsFromNow, pActionData.address(), InputPoseActionData.SIZEOF, ulRestrictToDevice);
    }

    public static int nVRInput_GetSkeletalActionData(long action, long pActionData, int unActionDataSize) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalActionData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (long)pActionData, (int)unActionDataSize, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputSkeletalActionData_t *") InputSkeletalActionData pActionData, @NativeType(value="uint32_t") int unActionDataSize) {
        return VRInput.nVRInput_GetSkeletalActionData(action, pActionData.address(), unActionDataSize);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalActionData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="InputSkeletalActionData_t *") InputSkeletalActionData pActionData) {
        return VRInput.nVRInput_GetSkeletalActionData(action, pActionData.address(), InputSkeletalActionData.SIZEOF);
    }

    public static int nVRInput_GetBoneCount(long action, long pBoneCount) {
        long __functionAddress = OpenVR.VRInput.GetBoneCount;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (long)pBoneCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetBoneCount(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="uint32_t *") IntBuffer pBoneCount) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pBoneCount, (int)1);
        }
        return VRInput.nVRInput_GetBoneCount(action, MemoryUtil.memAddress((IntBuffer)pBoneCount));
    }

    public static int nVRInput_GetBoneHierarchy(long action, long pParentIndices, int unIndexArrayCount) {
        long __functionAddress = OpenVR.VRInput.GetBoneHierarchy;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (long)pParentIndices, (int)unIndexArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetBoneHierarchy(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="BoneIndex_t *") IntBuffer pParentIndices) {
        return VRInput.nVRInput_GetBoneHierarchy(action, MemoryUtil.memAddress((IntBuffer)pParentIndices), pParentIndices.remaining());
    }

    public static int nVRInput_GetBoneName(long action, int nBoneIndex, long pchBoneName, int unNameBufferSize) {
        long __functionAddress = OpenVR.VRInput.GetBoneName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (int)nBoneIndex, (long)pchBoneName, (int)unNameBufferSize, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetBoneName(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="BoneIndex_t") int nBoneIndex, @NativeType(value="char *") ByteBuffer pchBoneName) {
        return VRInput.nVRInput_GetBoneName(action, nBoneIndex, MemoryUtil.memAddress((ByteBuffer)pchBoneName), pchBoneName.remaining());
    }

    public static int nVRInput_GetSkeletalReferenceTransforms(long action, int eTransformSpace, int eReferencePose, long pTransformArray, int unTransformArrayCount) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalReferenceTransforms;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (int)eTransformSpace, (int)eReferencePose, (long)pTransformArray, (int)unTransformArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalReferenceTransforms(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="EVRSkeletalTransformSpace") int eTransformSpace, @NativeType(value="EVRSkeletalReferencePose") int eReferencePose, @NativeType(value="VRBoneTransform_t *") VRBoneTransform.Buffer pTransformArray) {
        return VRInput.nVRInput_GetSkeletalReferenceTransforms(action, eTransformSpace, eReferencePose, pTransformArray.address(), pTransformArray.remaining());
    }

    public static int nVRInput_GetSkeletalTrackingLevel(long action, long pSkeletalTrackingLevel) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalTrackingLevel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (long)pSkeletalTrackingLevel, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalTrackingLevel(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="EVRSkeletalTrackingLevel *") IntBuffer pSkeletalTrackingLevel) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSkeletalTrackingLevel, (int)1);
        }
        return VRInput.nVRInput_GetSkeletalTrackingLevel(action, MemoryUtil.memAddress((IntBuffer)pSkeletalTrackingLevel));
    }

    public static int nVRInput_GetSkeletalBoneData(long action, int eTransformSpace, int eMotionRange, long pTransformArray, int unTransformArrayCount) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalBoneData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (int)eTransformSpace, (int)eMotionRange, (long)pTransformArray, (int)unTransformArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalBoneData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="EVRSkeletalTransformSpace") int eTransformSpace, @NativeType(value="EVRSkeletalMotionRange") int eMotionRange, @NativeType(value="VRBoneTransform_t *") VRBoneTransform.Buffer pTransformArray) {
        return VRInput.nVRInput_GetSkeletalBoneData(action, eTransformSpace, eMotionRange, pTransformArray.address(), pTransformArray.remaining());
    }

    public static int nVRInput_GetSkeletalSummaryData(long action, long pSkeletalSummaryData) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalSummaryData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)action, (long)pSkeletalSummaryData, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalSummaryData(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="VRSkeletalSummaryData_t *") VRSkeletalSummaryData pSkeletalSummaryData) {
        return VRInput.nVRInput_GetSkeletalSummaryData(action, pSkeletalSummaryData.address());
    }

    public static int nVRInput_GetSkeletalBoneDataCompressed(long action, int eMotionRange, long pvCompressedData, int unCompressedSize, long punRequiredCompressedSize) {
        long __functionAddress = OpenVR.VRInput.GetSkeletalBoneDataCompressed;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPPI((long)action, (int)eMotionRange, (long)pvCompressedData, (int)unCompressedSize, (long)punRequiredCompressedSize, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetSkeletalBoneDataCompressed(@NativeType(value="VRActionHandle_t") long action, @NativeType(value="EVRSkeletalMotionRange") int eMotionRange, @Nullable @NativeType(value="void *") ByteBuffer pvCompressedData, @Nullable @NativeType(value="uint32_t *") IntBuffer punRequiredCompressedSize) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)punRequiredCompressedSize, (int)1);
        }
        return VRInput.nVRInput_GetSkeletalBoneDataCompressed(action, eMotionRange, MemoryUtil.memAddressSafe((ByteBuffer)pvCompressedData), Checks.remainingSafe((Buffer)pvCompressedData), MemoryUtil.memAddressSafe((IntBuffer)punRequiredCompressedSize));
    }

    public static int nVRInput_DecompressSkeletalBoneData(long pvCompressedBuffer, int unCompressedBufferSize, int eTransformSpace, long pTransformArray, int unTransformArrayCount) {
        long __functionAddress = OpenVR.VRInput.DecompressSkeletalBoneData;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pvCompressedBuffer, (int)unCompressedBufferSize, (int)eTransformSpace, (long)pTransformArray, (int)unTransformArrayCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_DecompressSkeletalBoneData(@NativeType(value="void *") ByteBuffer pvCompressedBuffer, @NativeType(value="EVRSkeletalTransformSpace") int eTransformSpace, @NativeType(value="VRBoneTransform_t *") VRBoneTransform.Buffer pTransformArray) {
        return VRInput.nVRInput_DecompressSkeletalBoneData(MemoryUtil.memAddress((ByteBuffer)pvCompressedBuffer), pvCompressedBuffer.remaining(), eTransformSpace, pTransformArray.address(), pTransformArray.remaining());
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_TriggerHapticVibrationAction(@NativeType(value="VRActionHandle_t") long action, float fStartSecondsFromNow, float fDurationSeconds, float fFrequency, float fAmplitude, @NativeType(value="VRInputValueHandle_t") long ulRestrictToDevice) {
        long __functionAddress = OpenVR.VRInput.TriggerHapticVibrationAction;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJJI((long)action, (float)fStartSecondsFromNow, (float)fDurationSeconds, (float)fFrequency, (float)fAmplitude, (long)ulRestrictToDevice, (long)__functionAddress);
    }

    public static int nVRInput_GetActionOrigins(long actionSetHandle, long digitalActionHandle, long originsOut, int originOutCount) {
        long __functionAddress = OpenVR.VRInput.GetActionOrigins;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJJPI((long)actionSetHandle, (long)digitalActionHandle, (long)originsOut, (int)originOutCount, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetActionOrigins(@NativeType(value="VRActionSetHandle_t") long actionSetHandle, @NativeType(value="VRActionHandle_t") long digitalActionHandle, @NativeType(value="VRInputValueHandle_t *") LongBuffer originsOut) {
        return VRInput.nVRInput_GetActionOrigins(actionSetHandle, digitalActionHandle, MemoryUtil.memAddress((LongBuffer)originsOut), originsOut.remaining());
    }

    public static int nVRInput_GetOriginLocalizedName(long origin, long pchNameArray, int unNameArraySize, int unStringSectionsToInclude) {
        long __functionAddress = OpenVR.VRInput.GetOriginLocalizedName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)origin, (long)pchNameArray, (int)unNameArraySize, (int)unStringSectionsToInclude, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetOriginLocalizedName(@NativeType(value="VRInputValueHandle_t") long origin, @NativeType(value="char *") ByteBuffer pchNameArray, @NativeType(value="int32_t") int unStringSectionsToInclude) {
        return VRInput.nVRInput_GetOriginLocalizedName(origin, MemoryUtil.memAddress((ByteBuffer)pchNameArray), pchNameArray.remaining(), unStringSectionsToInclude);
    }

    public static int nVRInput_GetOriginTrackedDeviceInfo(long origin, long pOriginInfo, int unOriginInfoSize) {
        long __functionAddress = OpenVR.VRInput.GetOriginTrackedDeviceInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)origin, (long)pOriginInfo, (int)unOriginInfoSize, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetOriginTrackedDeviceInfo(@NativeType(value="VRInputValueHandle_t") long origin, @NativeType(value="InputOriginInfo_t *") InputOriginInfo pOriginInfo, @NativeType(value="uint32_t") int unOriginInfoSize) {
        return VRInput.nVRInput_GetOriginTrackedDeviceInfo(origin, pOriginInfo.address(), unOriginInfoSize);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_GetOriginTrackedDeviceInfo(@NativeType(value="VRInputValueHandle_t") long origin, @NativeType(value="InputOriginInfo_t *") InputOriginInfo pOriginInfo) {
        return VRInput.nVRInput_GetOriginTrackedDeviceInfo(origin, pOriginInfo.address(), InputOriginInfo.SIZEOF);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_ShowActionOrigins(@NativeType(value="VRActionSetHandle_t") long actionSetHandle, @NativeType(value="VRActionHandle_t") long ulActionHandle) {
        long __functionAddress = OpenVR.VRInput.ShowActionOrigins;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJJI((long)actionSetHandle, (long)ulActionHandle, (long)__functionAddress);
    }

    public static int nVRInput_ShowBindingsForActionSet(long pSets, int unSizeOfVRSelectedActionSet_t, int unSetCount, long originToHighlight) {
        long __functionAddress = OpenVR.VRInput.ShowBindingsForActionSet;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJI((long)pSets, (int)unSizeOfVRSelectedActionSet_t, (int)unSetCount, (long)originToHighlight, (long)__functionAddress);
    }

    @NativeType(value="EVRInputError")
    public static int VRInput_ShowBindingsForActionSet(@NativeType(value="VRActiveActionSet_t *") VRActiveActionSet.Buffer pSets, @NativeType(value="uint32_t") int unSizeOfVRSelectedActionSet_t, @NativeType(value="VRInputValueHandle_t") long originToHighlight) {
        return VRInput.nVRInput_ShowBindingsForActionSet(pSets.address(), unSizeOfVRSelectedActionSet_t, pSets.remaining(), originToHighlight);
    }
}

