/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;

public abstract class GuiOrderedListEditorScreen<T>
extends GuiListEditorScreen<T> {
    public GuiOrderedListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<T>> valuesSupplier, Runnable loadDefaults, Consumer<List<T>> save) {
        super(title, lastScreen, fixedEntryCount, valuesSupplier, loadDefaults, save);
        this.searchable = false;
    }

    private void moveEntry(int from, int offset, boolean remove) {
        Object value = this.elements.get(from);
        this.elements.remove(from);
        if (!remove) {
            this.elements.add(Mth.m_14045_((int)(from + offset), (int)0, (int)this.elements.size()), value);
        }
        this.reinit = true;
    }

    protected class OrderedEntry<T>
    extends GuiListEditorScreen.ValueEntry<T> {
        protected final T value;
        private final int index;
        private final Button upButton;
        private final Button downButton;
        private final Button removeButton;

        public OrderedEntry(Component name, T value, int index) {
            super(name, null);
            this.value = value;
            this.index = index;
            this.upButton = new Button(0, 0, 20, 20, (Component)new TextComponent("\u2191"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, -1, false));
            this.downButton = new Button(0, 0, 20, 20, (Component)new TextComponent("\u2193"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, 1, false));
            this.removeButton = new Button(0, 0, 20, 20, (Component)new TextComponent("-"), button -> GuiOrderedListEditorScreen.this.moveEntry(index, 0, true));
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.m_6311_(poseStack, index, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            int n = top + height / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int textY = n - 9 / 2 + 2;
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.name, (int)left, (int)textY, (int)this.textColor());
            this.upButton.f_93623_ = this.isActive() && this.index != 0;
            this.downButton.f_93623_ = this.isActive() && this.index != GuiOrderedListEditorScreen.this.elements.size() - 1;
            this.removeButton.f_93623_ = this.isActive();
            int i = 0;
            for (GuiEventListener child : this.m_6702_()) {
                Button b = (Button)child;
                b.f_93620_ = left + width - (2 - i) * 22 - 20;
                b.f_93621_ = top;
                b.m_6305_(poseStack, mouseX, mouseY, partialTick);
                ++i;
            }
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.upButton, (Object)this.downButton, (Object)this.removeButton);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.upButton, (Object)this.downButton, (Object)this.removeButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.upButton.f_93623_ = active;
            this.downButton.f_93623_ = active;
            this.removeButton.f_93623_ = active;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }
}

