/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;
import org.vivecraft.client_vr.render.helpers.GuiHelper;

public class GuiStringListEditorScreen
extends GuiListEditorScreen<String> {
    public GuiStringListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<String>> valuesSupplier, Runnable loadDefaults, Consumer<List<String>> save) {
        super(title, lastScreen, fixedEntryCount, valuesSupplier, loadDefaults, save);
        this.searchable = false;
    }

    @Override
    protected void addNewValue() {
        super.addNewValue();
        this.elements.add("");
    }

    @Override
    protected GuiListEditorScreen.ValueEntry<String> toEntry(String value, int index) {
        EditBox box = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 350, 20, (Component)new TextComponent(value));
        box.m_94199_(1000);
        box.m_94144_(value);
        box.m_94151_(s -> this.elements.set(index, s));
        return new StringValueEntry(TextComponent.f_131282_, box, button -> {
            this.elements.remove(index);
            this.reinit = true;
        }, !this.fixedEntryCount);
    }

    private static class StringValueEntry
    extends GuiListEditorScreen.ValueEntry<String> {
        private final EditBox editBox;
        private final Button deleteButton;

        public StringValueEntry(Component name, EditBox editBox, Button.OnPress deleteAction, boolean deletable) {
            super(name, null);
            this.editBox = editBox;
            this.deleteButton = new Button(0, 0, 20, 20, (Component)new TextComponent(deletable ? "-" : "X"), deletable ? deleteAction : b -> this.editBox.m_94144_(""), (button, poseStack, x, y) -> GuiHelper.renderOnTooltip(button, poseStack, x, y, (Component)new TranslatableComponent("selectWorld.delete")));
        }

        @Override
        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.m_94214_(left);
            this.editBox.f_93621_ = top;
            this.editBox.m_93674_(width - 20);
            this.editBox.m_6305_(poseStack, mouseX, mouseY, partialTick);
            this.deleteButton.f_93620_ = left + width - 20;
            this.deleteButton.f_93621_ = top;
            this.deleteButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.m_7222_() == this.editBox && keyCode == 262 && this.editBox.m_94155_().length() == this.editBox.m_94207_()) {
                return false;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.editBox.f_93623_ = active;
            this.deleteButton.f_93623_ = active;
        }

        @Override
        public String getValue() {
            return this.editBox.m_94155_();
        }
    }
}

