/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;
import org.vivecraft.client.gui.framework.screens.GuiOrderedListEditorScreen;
import org.vivecraft.client.gui.framework.screens.GuiSelectionListScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.settings.VRSettings;

public class GuiActiveKeyboardLayoutSelector
extends GuiOrderedListEditorScreen<VRSettings.KeyboardLayout> {
    public GuiActiveKeyboardLayoutSelector(Screen lastScreen) {
        super((Component)new TranslatableComponent("vivecraft.options.screen.activekeyboardlayouts"), lastScreen, false, () -> Arrays.stream(ClientDataHolderVR.getInstance().vrSettings.keyboardLayoutOrder).map(l -> ClientDataHolderVR.getInstance().vrSettings.keyboardLayouts.get(l)).toList(), () -> {
            VRSettings vrSettings = ClientDataHolderVR.getInstance().vrSettings;
            vrSettings.currentKeyboardLayout = 0;
            vrSettings.keyboardLayoutOrder = new String[]{"custom", "en_us"};
            vrSettings.saveOptions();
        }, keyboardLayouts -> {
            VRSettings vrSettings = ClientDataHolderVR.getInstance().vrSettings;
            vrSettings.currentKeyboardLayout = 0;
            vrSettings.keyboardLayoutOrder = (String[])keyboardLayouts.stream().map(VRSettings.KeyboardLayout::id).toArray(String[]::new);
            vrSettings.saveOptions();
        });
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        KeyboardHandler.reinitKeyboard();
    }

    @Override
    protected void addNewValue() {
        this.f_96541_.m_91152_(GuiActiveKeyboardLayoutSelector.getSelectionScreen(this, layout -> this.elements.stream().noneMatch(e -> e.id().equals(layout.id())), layout -> {
            super.addNewValue();
            this.elements.add(layout);
        }, false));
    }

    @Override
    protected GuiListEditorScreen.ValueEntry<VRSettings.KeyboardLayout> toEntry(VRSettings.KeyboardLayout value, int index) {
        return new KeyboardEntry(value, index);
    }

    public static GuiSelectionListScreen<VRSettings.KeyboardLayout> getSelectionScreen(Screen parent, Predicate<VRSettings.KeyboardLayout> filter, Consumer<VRSettings.KeyboardLayout> consumer, boolean hasReset) {
        return new GuiSelectionListScreen<VRSettings.KeyboardLayout>((Component)new TranslatableComponent("vivecraft.options.screen.keyboardlayoutselection"), parent, () -> ClientDataHolderVR.getInstance().vrSettings.keyboardLayouts.values().stream().filter(filter).sorted(Comparator.comparing(key -> GuiActiveKeyboardLayoutSelector.getLangComponent(key).getString())).toList(), GuiActiveKeyboardLayoutSelector::getLangComponent, null, consumer, hasReset, true, null);
    }

    private static Component getLangComponent(VRSettings.KeyboardLayout layout) {
        LanguageInfo info = Minecraft.m_91087_().m_91102_().m_118984_().stream().filter(l -> l.getCode().equals(layout.id())).findFirst().orElse(null);
        return info != null ? new TextComponent(info.toString()) : layout.fallbackName();
    }

    private class KeyboardEntry
    extends GuiOrderedListEditorScreen.OrderedEntry<VRSettings.KeyboardLayout> {
        public KeyboardEntry(VRSettings.KeyboardLayout layout, int index) {
            super(GuiActiveKeyboardLayoutSelector.getLangComponent(layout), layout, index);
        }
    }
}

