/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.render.HMDLayer;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.render.armor.VRArmorLayer;
import org.vivecraft.client.render.armor.VRArmorModel_WithArms;
import org.vivecraft.client.render.armor.VRArmorModel_WithArmsLegs;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRPlayerRenderer
extends PlayerRenderer {
    private static final LayerDefinition VR_LAYER_DEF = LayerDefinition.m_171565_((MeshDefinition)VRPlayerModel.createMesh(CubeDeformation.f_171458_, false), (int)64, (int)64);
    private static final LayerDefinition VR_LAYER_DEF_SLIM = LayerDefinition.m_171565_((MeshDefinition)VRPlayerModel.createMesh(CubeDeformation.f_171458_, true), (int)64, (int)64);
    private static LayerDefinition VR_LAYER_DEF_ARMS;
    private static LayerDefinition VR_LAYER_DEF_ARMS_SLIM;
    private static LayerDefinition VR_LAYER_DEF_ARMS_LEGS;
    private static LayerDefinition VR_LAYER_DEF_ARMS_LEGS_SLIM;

    public static void createLayers() {
        VR_LAYER_DEF_ARMS = LayerDefinition.m_171565_((MeshDefinition)VRPlayerModel_WithArms.createMesh(CubeDeformation.f_171458_, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_SLIM = LayerDefinition.m_171565_((MeshDefinition)VRPlayerModel_WithArms.createMesh(CubeDeformation.f_171458_, true), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS = LayerDefinition.m_171565_((MeshDefinition)VRPlayerModel_WithArmsLegs.createMesh(CubeDeformation.f_171458_, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS_SLIM = LayerDefinition.m_171565_((MeshDefinition)VRPlayerModel_WithArmsLegs.createMesh(CubeDeformation.f_171458_, true), (int)64, (int)64);
    }

    public VRPlayerRenderer(EntityRendererProvider.Context context, boolean slim, ModelType type) {
        super(context, slim);
        this.f_115290_ = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ModelType.VANILLA -> new VRPlayerModel(slim ? VR_LAYER_DEF_SLIM.m_171564_() : VR_LAYER_DEF.m_171564_(), slim);
            case ModelType.SPLIT_ARMS -> new VRPlayerModel_WithArms(slim ? VR_LAYER_DEF_ARMS_SLIM.m_171564_() : VR_LAYER_DEF_ARMS.m_171564_(), slim);
            case ModelType.SPLIT_ARMS_LEGS -> new VRPlayerModel_WithArmsLegs(slim ? VR_LAYER_DEF_ARMS_LEGS_SLIM.m_171564_() : VR_LAYER_DEF_ARMS_LEGS.m_171564_(), slim);
        };
        this.m_115326_(new HMDLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)this));
        VRArmorLayer.createLayers();
        if (type != ModelType.VANILLA) {
            this.f_115291_.stream().filter(layer -> layer.getClass() == HumanoidArmorLayer.class).findFirst().ifPresent(this.f_115291_::remove);
            if (type == ModelType.SPLIT_ARMS) {
                this.m_115326_((RenderLayer)new VRArmorLayer(this, new VRArmorModel_WithArms(VRArmorLayer.VR_ARMOR_DEF_ARMS_INNER.m_171564_()), new VRArmorModel_WithArms(VRArmorLayer.VR_ARMOR_DEF_ARMS_OUTER.m_171564_())));
            } else {
                this.m_115326_((RenderLayer)new VRArmorLayer(this, new VRArmorModel_WithArmsLegs(VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS_INNER.m_171564_()), new VRArmorModel_WithArmsLegs(VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS_OUTER.m_171564_())));
            }
        }
    }

    public boolean hasLayerType(RenderLayer<?, ?> renderLayer) {
        return this.f_115291_.stream().anyMatch(layer -> {
            if (renderLayer.getClass() == HumanoidArmorLayer.class) {
                return layer.getClass() == renderLayer.getClass() || layer.getClass() == VRArmorLayer.class;
            }
            return layer.getClass() == renderLayer.getClass();
        });
    }

    public void m_7392_(AbstractClientPlayer player, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.m_142081_());
        if (rotInfo != null) {
            float scale = rotInfo.heightScale;
            if (VRState.VR_RUNNING && player == Minecraft.m_91087_().f_91074_ || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale) {
                scale *= rotInfo.worldScale / ScaleHelper.getEntityEyeHeightScale((LivingEntity)player, partialTick);
            }
            if (player.m_21209_()) {
                float offset = player.m_5686_(partialTick) / 90.0f * 0.2f;
                poseStack.m_85837_(0.0, (double)(rotInfo.headPos.y() + offset), 0.0);
            }
            poseStack.m_85841_(scale, scale, scale);
        }
        super.m_7392_(player, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public Vec3 m_7860_(AbstractClientPlayer player, float partialTick) {
        if (VREffectsHelper.isFirstPersonPlayer((Entity)player)) {
            return player.m_6067_() ? new Vec3(0.0, (double)(-0.125f * ClientDataHolderVR.getInstance().vrPlayer.worldScale), 0.0) : Vec3.f_82478_;
        }
        return player.m_6067_() ? new Vec3(0.0, -0.125, 0.0) : Vec3.f_82478_;
    }

    public void m_117818_(AbstractClientPlayer player) {
        super.m_117818_(player);
        ((PlayerModel)this.m_7200_()).f_102817_ = ((PlayerModel)this.m_7200_()).f_102817_ & !player.m_6067_();
        if (VREffectsHelper.isFirstPersonPlayer((Entity)player)) {
            if (ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA && ClientDataHolderVR.getInstance().cameraTracker.isQuickMode() && ClientDataHolderVR.getInstance().grabScreenShot) {
                this.hideHand(HumanoidArm.LEFT, true);
                this.hideHand(HumanoidArm.RIGHT, true);
            }
            if (VREffectsHelper.isFirstPersonEntityPass()) {
                ((PlayerModel)this.m_7200_()).f_102808_.f_104207_ = false;
                ((PlayerModel)this.m_7200_()).f_102809_.f_104207_ = false;
                if (ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE) {
                    this.hideHand(HumanoidArm.LEFT, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                    this.hideHand(HumanoidArm.RIGHT, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                } else {
                    boolean leftHanded = ClientDataHolderVR.getInstance().vrSettings.reverseHands;
                    if (ClientDataHolderVR.getInstance().menuHandOff) {
                        this.hideHand(leftHanded ? HumanoidArm.RIGHT : HumanoidArm.LEFT, false);
                    }
                    if (ClientDataHolderVR.getInstance().menuHandMain) {
                        this.hideHand(leftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT, false);
                    }
                }
            }
        }
    }

    private void hideHand(HumanoidArm arm, boolean completeArm) {
        EntityModel entityModel = this.m_7200_();
        if (entityModel instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)entityModel;
            if (arm == HumanoidArm.LEFT) {
                vrModel.hideLeftArm(completeArm);
            } else {
                vrModel.hideRightArm(completeArm);
            }
        } else if (arm == HumanoidArm.LEFT) {
            ((PlayerModel)this.m_7200_()).f_102812_.f_104207_ = false;
            ((PlayerModel)this.m_7200_()).f_103374_.f_104207_ = false;
        } else {
            ((PlayerModel)this.m_7200_()).f_102811_.f_104207_ = false;
            ((PlayerModel)this.m_7200_()).f_103375_.f_104207_ = false;
        }
    }

    protected void m_7523_(AbstractClientPlayer player, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        if (ClientDataHolderVR.getInstance().currentPass != RenderPass.GUI && ClientVRPlayers.getInstance().isVRPlayer((Entity)player)) {
            if (player == Minecraft.m_91087_().f_91074_) {
                rotationYaw = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYaw();
            } else {
                ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.m_142081_());
                rotationYaw = 57.295776f * rotInfo.getBodyYawRad();
            }
        }
        super.m_7523_(player, poseStack, ageInTicks, rotationYaw, partialTick);
    }

    static {
        VRPlayerRenderer.createLayers();
    }

    public static enum ModelType {
        VANILLA,
        SPLIT_ARMS,
        SPLIT_ARMS_LEGS;

    }
}

