/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.Xplat;
import org.vivecraft.api.client.InteractModule;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class BlockInteractionModule
implements InteractModule {
    private static final ResourceLocation ID = new ResourceLocation("vivecraft", "block_interact");
    private final Minecraft mc;
    private final ClientDataHolderVR dh;
    public final BlockHitResult[] inBlockHit = new BlockHitResult[2];
    public final boolean[] bukkit = new boolean[2];
    private HashSet<Class<?>> rightClickable = null;

    public BlockInteractionModule(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 1500;
    }

    @Override
    public void reset(LocalPlayer player, InteractionHand hand) {
        this.inBlockHit[hand.ordinal()] = null;
        this.bukkit[hand.ordinal()] = false;
    }

    @Override
    public boolean isActive(LocalPlayer player, InteractionHand hand, Vec3 handPosition) {
        if (this.rightClickable == null) {
            this.rightClickable = new HashSet();
            String name = Xplat.getUseMethodName();
            for (Object object : Registry.f_122824_) {
                Class<?> oclass = object.getClass();
                this.addIfClassHasMethod(name, oclass);
                this.addIfClassHasMethod(name, oclass.getSuperclass());
            }
            this.rightClickable.remove(Block.class);
            this.rightClickable.remove(BlockBehaviour.class);
            this.rightClickable.remove(BlockBehaviour.BlockStateBase.class);
        }
        if (this.dh.vrSettings.realisticBlockInteractEnabled) {
            BlockHitResult hit;
            Vec3 hmdPos = this.dh.vrPlayer.vrdata_world_pre.getHeadPivot();
            BlockPos blockpos = new BlockPos(handPosition);
            BlockState blockstate = player.f_19853_.m_8055_(blockpos);
            this.inBlockHit[hand.ordinal()] = hit = blockstate.m_60808_((BlockGetter)player.f_19853_, blockpos).m_83220_(hmdPos, handPosition, blockpos);
            if (hit != null && (this.rightClickable.contains(blockstate.m_60734_().getClass()) || this.rightClickable.contains(blockstate.m_60734_().getClass().getSuperclass()))) {
                return true;
            }
            if (player.m_21120_(hand).m_41720_() == Items.f_42446_ && blockstate.m_60767_().m_76332_()) {
                this.bukkit[hand.ordinal()] = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onPress(LocalPlayer player, InteractionHand hand) {
        boolean success = false;
        if (this.inBlockHit[hand.ordinal()] != null) {
            ClientNetworking.sendActiveHand(hand, true);
            success = this.mc.f_91072_.m_105262_(player, player.f_108545_, hand, this.inBlockHit[hand.ordinal()]).m_19077_();
            ClientNetworking.resetActiveBodyPart();
        } else if (this.bukkit[hand.ordinal()]) {
            ClientNetworking.sendActiveHand(hand, true);
            success = this.mc.f_91072_.m_105235_((Player)player, player.f_19853_, hand).m_19077_();
            ClientNetworking.resetActiveBodyPart();
        }
        return success;
    }

    public boolean isActive(int controller) {
        return this.dh.interactTracker.isActiveModule(this, controller);
    }

    private void addIfClassHasMethod(String name, Class<?> oclass) {
        try {
            oclass.getDeclaredMethod(name, BlockState.class, Level.class, BlockPos.class, Player.class, BlockHitResult.class);
            this.rightClickable.add(oclass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

