/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRMovementStyle;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.data.ViveBlockTags;

public class TeleportTracker
implements Tracker {
    private float teleportEnergy;
    private Vec3 movementTeleportDestination = Vec3.f_82478_;
    private Direction movementTeleportDestinationSideHit;
    public double movementTeleportProgress;
    public double movementTeleportDistance;
    private int movementTeleportTimer = 0;
    private final Vec3[] movementTeleportArc = new Vec3[50];
    public int movementTeleportArcSteps = 0;
    public double lastTeleportArcDisplayOffset = 0.0;
    public VRMovementStyle vrMovementStyle;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public TeleportTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
        this.vrMovementStyle = new VRMovementStyle();
    }

    public float getTeleportEnergy() {
        return this.teleportEnergy;
    }

    public boolean isAiming() {
        return this.movementTeleportProgress > 0.0;
    }

    public Vec3 getDestination() {
        return this.movementTeleportDestination;
    }

    @Override
    public boolean isActive(LocalPlayer p) {
        if (p == null) {
            return false;
        }
        if (this.mc.f_91072_ == null) {
            return false;
        }
        if (!p.m_6084_()) {
            return false;
        }
        return !p.m_5803_();
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.movementTeleportDestination = Vec3.f_82478_;
        this.movementTeleportArcSteps = 0;
        this.movementTeleportProgress = 0.0;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        boolean seatedTeleport;
        Random random = new Random();
        if (this.teleportEnergy < 100.0f) {
            this.teleportEnergy += 1.0f;
        }
        boolean doTeleport = false;
        Vec3 destination = null;
        boolean bindingTeleport = VivecraftVRMod.INSTANCE.keyTeleport.m_90857_() && this.dh.vrPlayer.isTeleportEnabled();
        boolean bl = seatedTeleport = this.dh.vrSettings.seated && !this.dh.vrPlayer.getFreeMove() && (player.f_108618_.f_108567_ != 0.0f || player.f_108618_.f_108566_ != 0.0f);
        if ((bindingTeleport || seatedTeleport) && !player.m_20159_()) {
            destination = this.movementTeleportDestination;
            if (this.vrMovementStyle.teleportOnRelease || this.movementTeleportTimer >= 0 && (destination.f_82479_ != 0.0 || destination.f_82480_ != 0.0 || destination.f_82481_ != 0.0)) {
                if (this.movementTeleportTimer == 0 && this.vrMovementStyle.startTeleportingSound != null) {
                    player.m_5496_(this.vrMovementStyle.startTeleportingSound, this.vrMovementStyle.startTeleportingSoundVolume, 1.0f / (random.nextFloat() * 0.4f + 1.2f) + 0.5f);
                }
                ++this.movementTeleportTimer;
                if (this.movementTeleportTimer > 0) {
                    if (this.vrMovementStyle.teleportOnRelease) {
                        this.movementTeleportProgress = 1.0;
                    } else {
                        Vec3 playerPos = player.m_20182_();
                        double dist = destination.m_82554_(playerPos);
                        this.movementTeleportProgress = (double)this.movementTeleportTimer / (dist + 3.0);
                    }
                    if (destination.f_82479_ != 0.0 || destination.f_82480_ != 0.0 || destination.f_82481_ != 0.0) {
                        if (this.vrMovementStyle.destinationSparkles) {
                            // empty if block
                        }
                        if (this.vrMovementStyle.airSparkles) {
                            Vec3 eyeCenterPos = this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition();
                            if (!this.vrMovementStyle.teleportOnRelease) {
                                eyeCenterPos = player.m_20182_();
                            }
                            Vec3 motionDir = destination.m_82546_(eyeCenterPos).m_82541_();
                            Vec3 forward = player.m_20154_();
                            Vec3 right = forward.m_82537_(MathUtils.UP_D);
                            Vec3 up = right.m_82537_(forward);
                            for (int iParticle = 0; iParticle < 3; ++iParticle) {
                                double forwardDist = random.nextDouble() + 3.5;
                                double upDist = random.nextDouble() * 2.5;
                                double rightDist = random.nextDouble() * 4.0 - 2.0;
                                Vec3 sparkPos = new Vec3(eyeCenterPos.f_82479_ + forward.f_82479_ * forwardDist, eyeCenterPos.f_82480_ + forward.f_82480_ * forwardDist, eyeCenterPos.f_82481_ + forward.f_82481_ * forwardDist);
                                sparkPos = sparkPos.m_82520_(right.f_82479_ * rightDist, right.f_82480_ * rightDist, right.f_82481_ * rightDist);
                                sparkPos.m_82520_(up.f_82479_ * upDist, up.f_82480_ * upDist, up.f_82481_ * upDist);
                                double d = -0.6;
                            }
                        }
                    }
                } else if (!this.vrMovementStyle.teleportOnRelease) {
                    this.movementTeleportProgress = 0.0;
                }
                if (!this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                    doTeleport = true;
                }
            }
        } else {
            if (this.vrMovementStyle.teleportOnRelease && this.movementTeleportProgress >= 1.0) {
                destination = this.movementTeleportDestination;
                doTeleport = true;
            }
            this.movementTeleportTimer = 0;
            this.movementTeleportProgress = 0.0;
        }
        if (doTeleport && destination != null && (destination.f_82479_ != 0.0 || destination.f_82480_ != 0.0 || destination.f_82481_ != 0.0)) {
            this.movementTeleportDistance = destination.m_82554_(player.m_20182_());
            if (!this.dh.vrPlayer.isTeleportSupported()) {
                String command = "/tp " + destination.f_82479_ + " " + destination.f_82480_ + " " + destination.f_82481_;
                player.m_108739_(command);
            } else {
                if (ClientNetworking.SERVER_SUPPORTS_DIRECT_TELEPORT) {
                    ((PlayerExtension)player).vivecraft$setTeleported(true);
                }
                player.m_6027_(destination.f_82479_, destination.f_82480_, destination.f_82481_);
            }
            this.doTeleportCallback();
            if (this.movementTeleportDistance > 0.0 && this.vrMovementStyle.endTeleportingSound != null) {
                player.m_5496_(this.vrMovementStyle.endTeleportingSound, this.vrMovementStyle.endTeleportingSoundVolume, 1.0f);
            } else {
                ((PlayerExtension)player).vivecraft$stepSound(new BlockPos(destination), destination);
            }
        }
    }

    public void updateTeleportDestinations(LocalPlayer player) {
        this.mc.m_91307_().m_6180_("updateTeleportDestinations");
        if (this.vrMovementStyle.arcAiming) {
            this.movementTeleportDestination = Vec3.f_82478_;
            if (this.movementTeleportProgress > 0.0) {
                this.updateTeleportArc(player);
            }
        }
        this.mc.m_91307_().m_7238_();
    }

    private void updateTeleportArc(LocalPlayer player) {
        int controller = this.dh.vrSettings.seated ? 0 : 1;
        Vec3 start = RenderHelper.getControllerRenderPos(controller);
        VRData.VRDevicePose controllerWorld = this.dh.vrPlayer.vrdata_world_render.getController(controller);
        int maxSteps = 50;
        this.movementTeleportArc[0] = new Vec3(start.f_82479_, start.f_82480_, start.f_82481_);
        this.movementTeleportArcSteps = 1;
        float gravityAcceleration = 0.098f;
        Vector3f gravity = controllerWorld.getMatrix().rotateZ(controllerWorld.getRollRad()).transformDirection(MathUtils.DOWN, new Vector3f()).mul(0.098f);
        float speed = 0.5f;
        Vector3f velocity = controllerWorld.getDirection().mul(0.5f);
        Vec3 pos = new Vec3(start.f_82479_, start.f_82480_, start.f_82481_);
        for (int i = this.movementTeleportArcSteps; i < maxSteps && (float)(i * 4) <= this.teleportEnergy; ++i) {
            Vec3 newPos = new Vec3(pos.f_82479_ + (double)velocity.x, pos.f_82480_ + (double)velocity.y, pos.f_82481_ + (double)velocity.z);
            BlockHitResult blockhitresult = this.mc.f_91073_.m_45547_(new ClipContext(pos, newPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
            if (blockhitresult.m_6662_() != HitResult.Type.MISS) {
                boolean ok;
                this.movementTeleportArc[i] = blockhitresult.m_82450_();
                this.movementTeleportArcSteps = i + 1;
                this.checkAndSetTeleportDestination(player, start, blockhitresult);
                Vec3 diff = player.m_20182_().m_82546_(this.movementTeleportDestination);
                double yDiff = diff.f_82480_;
                this.movementTeleportDistance = diff.m_82553_();
                double xzDiff = Math.sqrt(diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_);
                boolean bl = ok = !player.m_6144_() || !(yDiff > 0.2);
                if (!player.m_150110_().f_35936_ && ClientNetworking.isLimitedSurvivalTeleport()) {
                    if (ClientNetworking.getTeleportDownLimit() > 0 && yDiff > (double)ClientNetworking.getTeleportDownLimit() + 0.2) {
                        ok = false;
                    } else if (ClientNetworking.getTeleportUpLimit() > 0 && -yDiff > (double)((float)ClientNetworking.getTeleportUpLimit() * ((PlayerExtension)player).vivecraft$getMuhJumpFactor()) + 0.2) {
                        ok = false;
                    } else if (ClientNetworking.getTeleportHorizLimit() > 0 && xzDiff > (double)((float)ClientNetworking.getTeleportHorizLimit() * ((PlayerExtension)player).vivecraft$getMuhSpeedFactor()) + 0.2) {
                        ok = false;
                    }
                }
                if (ok) break;
                this.movementTeleportDestination = Vec3.f_82478_;
                this.movementTeleportDistance = 0.0;
                break;
            }
            pos = new Vec3(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            this.movementTeleportArc[i] = new Vec3(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            this.movementTeleportArcSteps = i + 1;
            velocity = velocity.add((Vector3fc)gravity);
        }
    }

    private void doTeleportCallback() {
        this.dh.swingTracker.disableSwing = 3;
        if (ClientNetworking.isLimitedSurvivalTeleport()) {
            this.mc.f_91074_.m_36399_((float)(this.movementTeleportDistance / 16.0 * 1.2));
            if (this.mc.f_91072_.m_105289_() && this.vrMovementStyle.arcAiming) {
                this.teleportEnergy -= (float)this.movementTeleportDistance * 4.0f;
            }
        }
        this.mc.f_91074_.f_19789_ = 0.0f;
        this.movementTeleportTimer = -1;
    }

    private boolean checkAndSetTeleportDestination(LocalPlayer player, Vec3 start, BlockHitResult collision) {
        BlockPos blockpos = collision.m_82425_();
        BlockState blockState = player.f_19853_.m_8055_(blockpos);
        if (!this.mc.f_91073_.m_6425_(blockpos).m_76178_()) {
            Vec3 hitVec = new Vec3(collision.m_82450_().f_82479_, (double)blockpos.m_123342_(), collision.m_82450_().f_82481_);
            Vec3 offset = hitVec.m_82492_(player.m_20185_(), player.m_142469_().f_82289_, player.m_20189_());
            AABB aabb = player.m_142469_().m_82386_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            boolean emptySpotReq = this.mc.f_91073_.m_45756_((Entity)player, aabb);
            if (!emptySpotReq) {
                Vec3 center = Vec3.m_82539_((Vec3i)blockpos);
                offset = center.m_82492_(player.m_20185_(), player.m_142469_().f_82289_, player.m_20189_());
                aabb = player.m_142469_().m_82386_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                emptySpotReq = this.mc.f_91073_.m_45756_((Entity)player, aabb);
            }
            float ex = 0.0f;
            if (this.dh.vrSettings.seated) {
                ex = 0.5f;
            }
            if (emptySpotReq) {
                this.movementTeleportDestination = new Vec3(aabb.m_82399_().f_82479_, aabb.f_82289_ + (double)ex, aabb.m_82399_().f_82481_);
                this.movementTeleportDestinationSideHit = collision.m_82434_();
                return true;
            }
        } else if (collision.m_82434_() != Direction.UP) {
            if (blockState.m_60734_() instanceof LadderBlock || blockState.m_60734_() instanceof VineBlock || blockState.m_204336_(ViveBlockTags.VIVECRAFT_CLIMBABLE)) {
                Vec3 dest = new Vec3((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5);
                Block block = this.mc.f_91073_.m_8055_(blockpos.m_7495_()).m_60734_();
                if (block == blockState.m_60734_()) {
                    dest = dest.m_82520_(0.0, -1.0, 0.0);
                }
                this.movementTeleportDestination = dest.m_82490_(1.0);
                this.movementTeleportDestinationSideHit = collision.m_82434_();
                return true;
            }
            if (!player.m_150110_().f_35936_ && ClientNetworking.isLimitedSurvivalTeleport()) {
                return false;
            }
        }
        BlockPos hitBlock = collision.m_82425_().m_7495_();
        for (int i = 0; i < 2; ++i) {
            blockState = player.f_19853_.m_8055_(hitBlock);
            if (!blockState.m_60812_((BlockGetter)this.mc.f_91073_, hitBlock).m_83281_()) {
                boolean emptySpotReq;
                double height = blockState.m_60812_((BlockGetter)this.mc.f_91073_, hitBlock).m_83297_(Direction.Axis.Y);
                Vec3 hitVec = new Vec3(collision.m_82450_().f_82479_, (double)hitBlock.m_123342_() + height, collision.m_82450_().f_82481_);
                Vec3 offset = hitVec.m_82492_(player.m_20185_(), player.m_142469_().f_82289_, player.m_20189_());
                AABB aabb = player.m_142469_().m_82386_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                double ex = 0.0;
                if (blockState.m_60734_() == Blocks.f_50135_ || blockState.m_60734_() == Blocks.f_50719_) {
                    ex = 0.05;
                }
                boolean bl = emptySpotReq = this.mc.f_91073_.m_45756_((Entity)player, aabb) && !this.mc.f_91073_.m_45756_((Entity)player, aabb.m_82377_(0.0, 0.125 + ex, 0.0));
                if (!emptySpotReq) {
                    Vec3 center = Vec3.m_82514_((Vec3i)hitBlock, (double)height);
                    offset = center.m_82492_(player.m_20185_(), player.m_142469_().f_82289_, player.m_20189_());
                    aabb = player.m_142469_().m_82386_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                    boolean bl2 = emptySpotReq = this.mc.f_91073_.m_45756_((Entity)player, aabb) && !this.mc.f_91073_.m_45756_((Entity)player, aabb.m_82377_(0.0, 0.125 + ex, 0.0));
                }
                if (emptySpotReq) {
                    Vec3 dest = new Vec3(aabb.m_82399_().f_82479_, (double)hitBlock.m_123342_() + height, aabb.m_82399_().f_82481_);
                    this.movementTeleportDestination = dest.m_82490_(1.0);
                    return true;
                }
            }
            hitBlock = hitBlock.m_7494_();
        }
        return false;
    }

    public Vec3 getInterpolatedArcPosition(float progress) {
        if (this.movementTeleportArcSteps == 1 || progress <= 0.0f) {
            return new Vec3(this.movementTeleportArc[0].f_82479_, this.movementTeleportArc[0].f_82480_, this.movementTeleportArc[0].f_82481_);
        }
        if (progress >= 1.0f) {
            return new Vec3(this.movementTeleportArc[this.movementTeleportArcSteps - 1].f_82479_, this.movementTeleportArc[this.movementTeleportArcSteps - 1].f_82480_, this.movementTeleportArc[this.movementTeleportArcSteps - 1].f_82481_);
        }
        float stepFloat = progress * (float)(this.movementTeleportArcSteps - 1);
        int step = (int)Math.floor(stepFloat);
        double deltaX = this.movementTeleportArc[step + 1].f_82479_ - this.movementTeleportArc[step].f_82479_;
        double deltaY = this.movementTeleportArc[step + 1].f_82480_ - this.movementTeleportArc[step].f_82480_;
        double deltaZ = this.movementTeleportArc[step + 1].f_82481_ - this.movementTeleportArc[step].f_82481_;
        float stepProgress = stepFloat - (float)step;
        return new Vec3(this.movementTeleportArc[step].f_82479_ + deltaX * (double)stepProgress, this.movementTeleportArc[step].f_82480_ + deltaY * (double)stepProgress, this.movementTeleportArc[step].f_82481_ + deltaZ * (double)stepProgress);
    }
}

