/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.gui.screens.FBTCalibrationScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.provider.DeviceSource;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class DebugRenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.m_91087_();

    public static void renderDebug(PoseStack poseStack, float partialTick) {
        RenderSystem.m_69482_();
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderDeviceAxes) {
            DebugRenderHelper.renderDeviceAxes(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld());
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderVrPlayerAxes) {
            DebugRenderHelper.renderPlayerAxes(poseStack, partialTick);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderTrackerPositions || DebugRenderHelper.MC.f_91080_ instanceof FBTCalibrationScreen) {
            boolean showNames = true;
            Screen screen = DebugRenderHelper.MC.f_91080_;
            if (screen instanceof FBTCalibrationScreen) {
                FBTCalibrationScreen fbtScreen = (FBTCalibrationScreen)screen;
                showNames = fbtScreen.isCalibrated();
            }
            DebugRenderHelper.renderTackerPositions(poseStack, showNames);
        }
        if (DebugRenderHelper.DATA_HOLDER.vrSettings.renderGameplayTrackers) {
            DATA_HOLDER.getTrackers().stream().filter(t -> DebugRenderHelper.DATA_HOLDER.vrSettings.gameplayTrackerToRender.isEmpty() || t.getClass().getName().equals(DebugRenderHelper.DATA_HOLDER.vrSettings.gameplayTrackerToRender)).forEach(t -> {
                if (t instanceof DebugRenderTracker) {
                    DebugRenderTracker debugTracker = (DebugRenderTracker)t;
                    if (t.isActive(DebugRenderHelper.MC.f_91074_)) {
                        debugTracker.renderDebug(poseStack);
                    }
                }
            });
        }
    }

    public static void renderPlayerAxes(PoseStack poseStack, float partialTick) {
        if (DebugRenderHelper.MC.f_91074_ != null) {
            BufferBuilder bufferBuilder = null;
            Vec3 camPos = DebugRenderHelper.MC.f_91063_.m_109153_().m_90583_();
            for (Player p : DebugRenderHelper.MC.f_91074_.f_19853_.m_6907_()) {
                if (!ClientVRPlayers.getInstance().isVRPlayer((Entity)p)) continue;
                ClientVRPlayers.RotInfo info = ClientVRPlayers.getInstance().getRotationsForPlayer(p.m_142081_());
                if (bufferBuilder == null) {
                    RenderSystem.m_157427_(GameRenderer::m_172811_);
                    bufferBuilder = Tesselator.m_85913_().m_85915_();
                    bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
                }
                Vector3f playerPos = MathUtils.subtractToVector3f(p.m_20318_(partialTick), camPos);
                if (p == DebugRenderHelper.MC.f_91074_) {
                    playerPos = MathUtils.subtractToVector3f(((GameRendererExtension)DebugRenderHelper.MC.f_91063_).vivecraft$getRvePos(partialTick), camPos);
                }
                if (p != DebugRenderHelper.MC.f_91074_ || DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
                    DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.headPos, info.headRot, info.headQuat);
                }
                if (!info.seated) {
                    DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.mainHandPos, info.mainHandRot, info.mainHandQuat);
                    DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.offHandPos, info.offHandRot, info.offHandQuat);
                }
                if (info.fbtMode != FBTMode.ARMS_ONLY) {
                    DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.waistPos, info.waistQuat);
                    DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.rightFootPos, info.rightFootQuat);
                    DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.leftFootPos, info.leftFootQuat);
                }
                if (info.fbtMode != FBTMode.WITH_JOINTS) continue;
                DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.rightElbowPos, info.rightElbowQuat);
                DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.leftElbowPos, info.leftElbowQuat);
                DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.rightKneePos, info.rightKneeQuat);
                DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)playerPos, info.leftKneePos, info.leftKneeQuat);
            }
            if (bufferBuilder != null) {
                bufferBuilder.m_85721_();
                BufferUploader.m_85761_(bufferBuilder);
            }
        }
    }

    public static void renderDeviceAxes(PoseStack poseStack, VRData data) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        ArrayList<VRData.VRDevicePose> list = new ArrayList<VRData.VRDevicePose>();
        list.add(data.c2);
        if (DebugRenderHelper.DATA_HOLDER.currentPass == RenderPass.THIRD) {
            list.add(data.hmd);
        }
        if (DebugRenderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
            list.add(data.cam);
        }
        if (DebugRenderHelper.MC.f_91074_ != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.f_91074_.m_21205_()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t0);
        } else {
            list.add(DebugRenderHelper.MC.f_91074_ != null && DebugRenderHelper.MC.f_91074_.m_6144_() ? data.h0 : data.c0);
        }
        if (DebugRenderHelper.MC.f_91074_ != null && TelescopeTracker.isTelescope(DebugRenderHelper.MC.f_91074_.m_21206_()) && TelescopeTracker.isViewing(0)) {
            list.add(data.t1);
        } else {
            list.add(DebugRenderHelper.MC.f_91074_ != null && DebugRenderHelper.MC.f_91074_.m_6144_() ? data.h1 : data.c1);
        }
        if (data.fbtMode != FBTMode.ARMS_ONLY) {
            list.add(data.waist);
            list.add(data.foot_left);
            list.add(data.foot_right);
        }
        if (data.fbtMode == FBTMode.WITH_JOINTS) {
            list.add(data.elbow_left);
            list.add(data.knee_left);
            list.add(data.elbow_right);
            list.add(data.knee_right);
        }
        list.forEach(p -> DebugRenderHelper.addAxes(poseStack, (VertexConsumer)bufferBuilder, data, p));
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    private static void renderTackerPositions(PoseStack poseStack, boolean showNames) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        Vec3 camPos = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition();
        Quaternionf orientation = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Component[] labels = new Component[]{new TranslatableComponent("vivecraft.toasts.point_controller.right"), new TranslatableComponent("vivecraft.toasts.point_controller.left"), new TranslatableComponent("vivecraft.messages.tracker.camera"), new TranslatableComponent("vivecraft.messages.tracker.waist"), new TranslatableComponent("vivecraft.messages.tracker.rightFoot"), new TranslatableComponent("vivecraft.messages.tracker.leftFoot"), new TranslatableComponent("vivecraft.messages.tracker.rightElbow"), new TranslatableComponent("vivecraft.messages.tracker.leftElbow"), new TranslatableComponent("vivecraft.messages.tracker.rightKnee"), new TranslatableComponent("vivecraft.messages.tracker.leftKnee")};
        for (Triple<DeviceSource, Integer, Matrix4fc> tracker : MCVR.get().getTrackers()) {
            Vector3f pos = ((Matrix4fc)tracker.getRight()).getTranslation(new Vector3f());
            Vec3 trackerPos = VRPlayer.roomToWorldPos((Vector3fc)pos, data).m_82546_(camPos);
            pos.set((float)trackerPos.f_82479_, (float)trackerPos.f_82480_, (float)trackerPos.f_82481_);
            if (showNames) {
                if ((Integer)tracker.getMiddle() >= 0) {
                    DebugRenderHelper.addNamedCube(poseStack, (Vector3fc)pos, orientation, (Component)new TranslatableComponent("vivecraft.formatting.name_value", new Object[]{new TextComponent(((DeviceSource)tracker.getLeft()).source.toString()), labels[(Integer)tracker.getMiddle()]}), 0.05f, MathUtils.DARK_GRAY);
                    continue;
                }
                DebugRenderHelper.addNamedCube(poseStack, (Vector3fc)pos, orientation, (Component)new TranslatableComponent("vivecraft.formatting.name_value", new Object[]{new TextComponent(((DeviceSource)tracker.getLeft()).source.toString() + ((DeviceSource)tracker.getLeft()).deviceIndex), new TranslatableComponent("vivecraft.messages.tracker.unknown")}), 0.05f, MathUtils.DARK_GRAY);
                continue;
            }
            DebugRenderHelper.renderCube(poseStack, (Vector3fc)pos, 0.05f, MathUtils.DARK_GRAY);
        }
        MC.m_91269_().m_110104_().m_173043_();
    }

    public static void renderLocalAxes(PoseStack poseStack) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Vector3f position = new Vector3f();
        DebugRenderHelper.addLine(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)position, MathUtils.BACK, MathUtils.BLUE);
        DebugRenderHelper.addLine(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)position, MathUtils.UP, MathUtils.GREEN);
        DebugRenderHelper.addLine(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)position, MathUtils.RIGHT, MathUtils.RED);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    private static void addAxes(PoseStack poseStack, VertexConsumer consumer, VRData data, VRData.VRDevicePose pose) {
        Vector3f position = MathUtils.subtractToVector3f(pose.getPosition(), data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = pose.getDirection().mul(scale);
        Vector3f up = pose.getCustomVector(MathUtils.UP).mul(scale);
        Vector3f right = pose.getCustomVector(MathUtils.RIGHT).mul(scale);
        DebugRenderHelper.addLine(poseStack, consumer, (Vector3fc)position, (Vector3fc)forward, MathUtils.BLUE);
        DebugRenderHelper.addLine(poseStack, consumer, (Vector3fc)position, (Vector3fc)up, MathUtils.GREEN);
        DebugRenderHelper.addLine(poseStack, consumer, (Vector3fc)position, (Vector3fc)right, MathUtils.RED);
    }

    private static void addAxes(PoseStack poseStack, VertexConsumer consumer, Vector3fc playerPos, Vector3fc devicePos, Quaternionfc rot) {
        DebugRenderHelper.addAxes(poseStack, consumer, playerPos, devicePos, (Vector3fc)rot.transform(MathUtils.BACK, new Vector3f()), rot);
    }

    private static void addAxes(PoseStack poseStack, VertexConsumer consumer, Vector3fc playerPos, Vector3fc devicePos, Vector3fc dir, Quaternionfc rot) {
        Vector3f position = playerPos.add(devicePos, new Vector3f());
        float scale = 0.25f * DebugRenderHelper.DATA_HOLDER.vrPlayer.worldScale;
        Vector3f forward = dir.mul(scale, new Vector3f());
        Vector3f up = rot.transform(MathUtils.UP, new Vector3f()).mul(scale);
        Vector3f right = rot.transform(MathUtils.RIGHT, new Vector3f()).mul(scale);
        DebugRenderHelper.addLine(poseStack, consumer, (Vector3fc)position, (Vector3fc)forward, MathUtils.BLUE);
        DebugRenderHelper.addLine(poseStack, consumer, (Vector3fc)position, (Vector3fc)up, MathUtils.GREEN);
        DebugRenderHelper.addLine(poseStack, consumer, (Vector3fc)position, (Vector3fc)right, MathUtils.RED);
    }

    private static void addLine(PoseStack poseStack, VertexConsumer consumer, Vector3fc position, Vector3fc dir, Vector3fc color) {
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), position.x(), position.y(), position.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), position.x(), position.y(), position.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
        consumer.m_85982_(poseStack.m_85850_().m_85861_(), position.x() + dir.x(), position.y() + dir.y(), position.z() + dir.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
    }

    public static void renderLine(PoseStack poseStack, Vector3fc color, Vector3fc ... points) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (Vector3fc point : points) {
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), point.x(), point.y(), point.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderLine(PoseStack poseStack, List<Pair<Vector3fc, Boolean>> points, Vector3fc color) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Pair<Vector3fc, Boolean> prev = null;
        for (Pair<Vector3fc, Boolean> point : points) {
            if (((Boolean)point.getRight()).booleanValue() && prev != null) {
                bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), ((Vector3fc)prev.getLeft()).x(), ((Vector3fc)prev.getLeft()).y(), ((Vector3fc)prev.getLeft()).z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
                bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), ((Vector3fc)point.getLeft()).x(), ((Vector3fc)point.getLeft()).y(), ((Vector3fc)point.getLeft()).z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            }
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), ((Vector3fc)point.getLeft()).x(), ((Vector3fc)point.getLeft()).y(), ((Vector3fc)point.getLeft()).z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            prev = point;
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderLine(PoseStack poseStack, Vector3fc color, Vec3 camPos, Iterable<Vec3> points) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        for (Vec3 point : points) {
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), (float)(point.m_7096_() - camPos.m_7096_()), (float)(point.m_7098_() - camPos.m_7098_()), (float)(point.m_7094_() - camPos.m_7094_())).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    private static void addNamedCube(PoseStack poseStack, Vector3fc cubePos, Quaternionf rot, Component label, float size, Vector3fc color) {
        DebugRenderHelper.renderCube(poseStack, cubePos, size, color);
        if (label != null) {
            DebugRenderHelper.renderTextAtRelativePosition(poseStack, cubePos.x(), cubePos.y(), cubePos.z(), rot, label);
        }
    }

    public static void renderTextAtDevice(PoseStack poseStack, int device, String text) {
        DebugRenderHelper.renderTextAtPosition(poseStack, DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld().getDevice(device).getPosition(), text);
    }

    public static void renderTextAtPosition(PoseStack poseStack, Vec3 position, String text) {
        VRData data = DebugRenderHelper.DATA_HOLDER.vrPlayer.getVRDataWorld();
        Vec3 camPos = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getPosition();
        Quaternionf rot = data.getEye(DebugRenderHelper.DATA_HOLDER.currentPass).getMatrix().getNormalizedRotation(new Quaternionf()).rotateY((float)Math.PI);
        Vector3f pos = MathUtils.subtractToVector3f(position, camPos);
        DebugRenderHelper.renderTextAtRelativePosition(poseStack, pos.x, pos.y, pos.z, rot, text);
    }

    public static void renderTextAtRelativePosition(PoseStack poseStack, float x, float y, float z, Quaternionf rot, String text) {
        DebugRenderHelper.renderTextAtRelativePosition(poseStack, x, y, z, rot, (Component)new TextComponent(text));
    }

    public static void renderTextAtRelativePosition(PoseStack poseStack, float x, float y, float z, Quaternionf rot, Component text) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)(y + 0.05f), (double)z);
        poseStack.m_85845_(MathUtils.toMcQuat((Quaternionfc)rot));
        poseStack.m_85841_(-0.005f, -0.005f, 0.005f);
        Font font = DebugRenderHelper.MC.f_91062_;
        float f = (float)DebugRenderHelper.MC.f_91062_.m_92852_((FormattedText)text) * -0.5f;
        Objects.requireNonNull(DebugRenderHelper.MC.f_91062_);
        font.m_92841_(text, f, (float)(-9), -1, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)MC.m_91269_().m_110104_(), false, 0, 0xF000F0);
        poseStack.m_85849_();
    }

    public static void renderCube(PoseStack poseStack, Vector3fc position, float size, Vector3fc color) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        ShadersHelper.bindTexture(RenderHelper.WHITE_TEXTURE);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Vec3i iColor = new Vec3i((int)(color.x() * 255.0f), (int)(color.y() * 255.0f), (int)(color.z() * 255.0f));
        Vec3 start = new Vec3((double)position.x(), (double)position.y(), (double)position.z()).m_82549_(MathUtils.FORWARD_D.m_82490_((double)(size * 0.5f)));
        Vec3 end = new Vec3((double)position.x(), (double)position.y(), (double)position.z()).m_82549_(MathUtils.BACK_D.m_82490_((double)(size * 0.5f)));
        RenderHelper.renderBox((VertexConsumer)bufferBuilder, start, end, size, size, iColor, (byte)-1, poseStack);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void addCircle(PoseStack poseStack, VertexConsumer vertexConsumer, Vector3fc center, Vector3fc forward, float radius, Vector3fc color) {
        Vector3f offset = MathUtils.getPerpendicularVec(forward).mul(radius);
        vertexConsumer.m_85982_(poseStack.m_85850_().m_85861_(), center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
        for (int i = 0; i <= 20; ++i) {
            vertexConsumer.m_85982_(poseStack.m_85850_().m_85861_(), center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            if (i == 20) continue;
            offset.rotateAxis(0.31415927f, forward.x(), forward.y(), forward.z());
        }
        vertexConsumer.m_85982_(poseStack.m_85850_().m_85861_(), center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
    }

    public static void renderCircle(PoseStack poseStack, Vector3fc center, Vector3fc forward, float radius, Vector3fc color) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, center, forward, radius, color);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderSphere(PoseStack poseStack, Vector3fc center, float radius, Vector3fc color) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, center, MathUtils.LEFT, radius, color);
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, center, MathUtils.FORWARD, radius, color);
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, center, MathUtils.UP, radius, color);
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderCone(PoseStack poseStack, Vector3fc tip, Vector3fc dir, float angle, float length, Vector3fc color) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Vector3f center = dir.normalize(new Vector3f()).mul(length).add(tip);
        float radius = length * (float)Math.tan(Math.toRadians(angle));
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)center, dir, radius, color);
        Vector3f offset = MathUtils.getPerpendicularVec(dir).mul(radius);
        for (int i = 0; i < 2; ++i) {
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), center.x() + offset.x(), center.y() + offset.y(), center.z() + offset.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), tip.x(), tip.y(), tip.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), center.x() - offset.x(), center.y() - offset.y(), center.z() - offset.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), center.x() - offset.x(), center.y() - offset.y(), center.z() - offset.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            offset.rotateAxis(1.5707964f, dir.x(), dir.y(), dir.z());
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderCylinder(PoseStack poseStack, Vector3fc bottom, Vector3fc topDir, float radius, Vector3fc color) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        Vector3f dir = topDir.normalize(new Vector3f());
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, bottom, (Vector3fc)dir, radius, color);
        DebugRenderHelper.addCircle(poseStack, (VertexConsumer)bufferBuilder, (Vector3fc)bottom.add(topDir, new Vector3f()), (Vector3fc)dir, radius, color);
        Vector3f offset = MathUtils.getPerpendicularVec(topDir).mul(radius);
        for (int i = 0; i < 4; ++i) {
            Vector3f bot = bottom.add((Vector3fc)offset, new Vector3f());
            Vector3f top = bot.add(topDir, new Vector3f());
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), bot.x(), bot.y(), bot.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), bot.x(), bot.y(), bot.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), top.x(), top.y(), top.z()).m_85950_(color.x(), color.y(), color.z(), 1.0f).m_5752_();
            bufferBuilder.m_85982_(poseStack.m_85850_().m_85861_(), top.x(), top.y(), top.z()).m_85950_(color.x(), color.y(), color.z(), 0.0f).m_5752_();
            offset.rotateAxis(1.5707964f, dir.x(), dir.y(), dir.z());
        }
        bufferBuilder.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
    }

    public static void renderAABB(PoseStack poseStack, AABB aabb, Vector3fc color) {
        DebugRenderHelper.renderCubeOutline(poseStack, (Vector3fc)new Vector3f((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82290_), (Vector3fc)new Vector3f((float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82290_), (Vector3fc)new Vector3f((float)aabb.f_82288_, (float)aabb.f_82292_, (float)aabb.f_82293_), (Vector3fc)new Vector3f((float)aabb.f_82288_, (float)aabb.f_82289_, (float)aabb.f_82293_), (Vector3fc)new Vector3f((float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82290_), (Vector3fc)new Vector3f((float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82290_), (Vector3fc)new Vector3f((float)aabb.f_82291_, (float)aabb.f_82292_, (float)aabb.f_82293_), (Vector3fc)new Vector3f((float)aabb.f_82291_, (float)aabb.f_82289_, (float)aabb.f_82293_), color);
    }

    public static void renderCubeOutline(PoseStack poseStack, Vector3fc v0, Vector3fc v1, Vector3fc v2, Vector3fc v3, Vector3fc v4, Vector3fc v5, Vector3fc v6, Vector3fc v7, Vector3fc color) {
        DebugRenderHelper.renderLine(poseStack, List.of(Pair.of((Object)v0, (Object)false), Pair.of((Object)v1, (Object)false), Pair.of((Object)v2, (Object)false), Pair.of((Object)v3, (Object)false), Pair.of((Object)v0, (Object)false), Pair.of((Object)v4, (Object)false), Pair.of((Object)v5, (Object)false), Pair.of((Object)v6, (Object)false), Pair.of((Object)v7, (Object)false), Pair.of((Object)v4, (Object)false), Pair.of((Object)v1, (Object)true), Pair.of((Object)v5, (Object)false), Pair.of((Object)v2, (Object)true), Pair.of((Object)v6, (Object)false), Pair.of((Object)v3, (Object)true), Pair.of((Object)v7, (Object)false)), color);
    }
}

