/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.Xevents;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.MethodHolder;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.WindowExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.render.XRCamera;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.helpers.VRArmHelper;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.immersiveportals.ImmersivePortalsHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererVRMixin
implements ResourceManagerReloadListener,
AutoCloseable,
GameRendererExtension {
    @Unique
    private static final ClientDataHolderVR vivecraft$DATA_HOLDER = ClientDataHolderVR.getInstance();
    @Unique
    private static final float vivecraft$MIN_CLIP_DISTANCE = 0.02f;
    @Unique
    private Vec3 vivecraft$crossVec;
    @Unique
    private Matrix4f vivecraft$thirdPassProjectionMatrix = new Matrix4f();
    @Unique
    private boolean vivecraft$inwater;
    @Unique
    private float vivecraft$inBlock = 0.0f;
    @Unique
    private double vivecraft$rveX;
    @Unique
    private double vivecraft$rveY;
    @Unique
    private double vivecraft$rveZ;
    @Unique
    private double vivecraft$rvelastX;
    @Unique
    private double vivecraft$rvelastY;
    @Unique
    private double vivecraft$rvelastZ;
    @Unique
    private double vivecraft$rveprevX;
    @Unique
    private double vivecraft$rveprevY;
    @Unique
    private double vivecraft$rveprevZ;
    @Unique
    private float vivecraft$rveyaw;
    @Unique
    private float vivecraft$rvepitch;
    @Unique
    private float vivecraft$rvelastyaw;
    @Unique
    private float vivecraft$rvelastpitch;
    @Unique
    private float vivecraft$rveHeight;
    @Unique
    private boolean vivecraft$cached;
    @Shadow
    @Final
    private Minecraft f_109059_;
    @Shadow
    private float f_109066_;
    @Shadow
    private float f_109067_;
    @Shadow
    @Final
    private Camera f_109054_;
    @Unique
    private boolean vivecraft$shouldDrawScreen = false;
    @Unique
    private boolean vivecraft$shouldDrawGui = false;

    @Shadow
    public abstract Matrix4f m_172716_(double var1);

    @Shadow
    protected abstract double m_109141_(Camera var1, float var2, boolean var3);

    @Shadow
    public abstract void m_109111_(Matrix4f var1);

    @Redirect(method={"<init>"}, at=@At(value="NEW", target="net/minecraft/client/Camera"))
    private Camera vivecraft$replaceCamera() {
        return new XRCamera();
    }

    @Inject(method={"shutdownEffect", "checkEntityPostEffect", "cycleEffect", "loadEffect"}, at={@At(value="HEAD")})
    private void vivecraft$shutdownVREffects(CallbackInfo ci) {
        if (VRState.VR_INITIALIZED) {
            RenderPassManager.setVanillaRenderPass();
        }
    }

    @WrapMethod(method={"pick"})
    private void vivecraft$vrPick(float partialTick, Operation<Void> original) {
        if (VRState.VR_RUNNING) {
            if (this.f_109059_.f_91080_ != null && this.f_109059_.f_91077_ != null) {
                return;
            }
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render == null || this.f_109059_.m_91288_() == null) {
                this.f_109059_.f_91077_ = this.f_109059_.f_91074_ != null ? BlockHitResult.m_82426_((Vec3)this.f_109059_.f_91074_.m_20182_(), (Direction)this.f_109059_.f_91074_.m_6350_(), (BlockPos)this.f_109059_.f_91074_.m_142538_()) : BlockHitResult.m_82426_((Vec3)Vec3.f_82478_, (Direction)Direction.UP, (BlockPos)BlockPos.f_121853_);
                return;
            }
            AABB originalBB = this.f_109059_.m_91288_().m_142469_();
            this.vivecraft$cacheRVEPos(this.f_109059_.m_91288_());
            this.vivecraft$setupRVEAtDevice(GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render.getAim());
            this.f_109059_.m_91288_().m_20011_(originalBB.m_82386_(this.f_109059_.m_91288_().m_20185_() - this.vivecraft$rveX, this.f_109059_.m_91288_().m_20186_() - this.vivecraft$rveY, this.f_109059_.m_91288_().m_20189_() - this.vivecraft$rveZ));
            original.call(new Object[]{Float.valueOf(partialTick)});
            this.vivecraft$restoreRVEPos(this.f_109059_.m_91288_());
            this.f_109059_.m_91288_().m_20011_(originalBB);
        } else {
            original.call(new Object[]{Float.valueOf(partialTick)});
        }
    }

    @ModifyArg(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;pick(DFZ)Lnet/minecraft/world/phys/HitResult;"), index=0)
    private double vivecraft$getCrossVec(double hitDistance) {
        if (VRState.VR_RUNNING) {
            this.vivecraft$crossVec = GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.AimedPointAtDistance(GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render.getAim(), hitDistance);
        }
        return hitDistance;
    }

    @ModifyArg(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"))
    private Predicate<Entity> vivecraft$dontHitRiddenEntity(Predicate<Entity> filter) {
        if (VRState.VR_RUNNING) {
            return filter.and(entity -> entity != Minecraft.m_91087_().m_91288_().m_20202_());
        }
        return filter;
    }

    @Inject(method={"tickFov"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$noFOVChangeInVR(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            this.f_109066_ = 1.0f;
            this.f_109067_ = 1.0f;
            ci.cancel();
        }
    }

    @Inject(method={"getFov"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$fixedFOV(CallbackInfoReturnable<Double> cir) {
        if (this.f_109059_.f_91073_ == null || MethodHolder.isInMenuRoom()) {
            cir.setReturnValue((Object)this.f_109059_.f_91066_.f_92068_);
        }
    }

    @WrapOperation(method={"getProjectionMatrix"}, at={@At(value="INVOKE", target="Lcom/mojang/math/Matrix4f;perspective(DFFF)Lcom/mojang/math/Matrix4f;")})
    private Matrix4f vivecraft$customProjectionMatrix(double fovy, float aspect, float zNear, float zFar, Operation<Matrix4f> original) {
        if (!RenderPassType.isVanilla()) {
            zNear = 0.02f;
            if (MethodHolder.isInMenuRoom()) {
                zFar = Math.max(zFar, 1024.0f);
            }
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.LEFT || GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.RIGHT) {
                return GameRendererVRMixin.vivecraft$DATA_HOLDER.vrRenderer.getCachedProjectionMatrix(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass.ordinal(), zNear, zFar);
            }
            aspect = switch (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass) {
                case RenderPass.THIRD, RenderPass.CENTER -> {
                    if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
                        yield GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityAspectRatio;
                    }
                    if (ShadersHelper.needsSameSizeBuffers()) {
                        WindowExtension window = (WindowExtension)this.f_109059_.m_91268_();
                        yield (float)window.vivecraft$getActualScreenWidth() / (float)window.vivecraft$getActualScreenHeight();
                    }
                    yield aspect;
                }
                case RenderPass.CAMERA -> (float)GameRendererVRMixin.vivecraft$DATA_HOLDER.vrRenderer.cameraFramebuffer.f_83917_ / (float)GameRendererVRMixin.vivecraft$DATA_HOLDER.vrRenderer.cameraFramebuffer.f_83918_;
                case RenderPass.SCOPEL, RenderPass.SCOPER -> 1.0f;
                default -> aspect;
            };
            fovy = switch (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass) {
                case RenderPass.THIRD -> GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityFov;
                case RenderPass.CAMERA -> GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.handCameraFov;
                case RenderPass.SCOPEL, RenderPass.SCOPER -> 8.75;
                default -> fovy;
            };
        }
        Matrix4f proj = (Matrix4f)original.call(new Object[]{fovy, Float.valueOf(aspect), Float.valueOf(zNear), Float.valueOf(zFar)});
        if (VRState.VR_RUNNING && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.THIRD) {
            this.vivecraft$thirdPassProjectionMatrix = proj;
        }
        return proj;
    }

    @Inject(method={"shouldRenderBlockOutline"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$shouldDrawBlockOutline(CallbackInfoReturnable<Boolean> cir) {
        if (!RenderPassType.isVanilla()) {
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.blockModule.isActive(0)) {
                cir.setReturnValue((Object)false);
            } else if (GameRendererVRMixin.vivecraft$DATA_HOLDER.teleportTracker.isAiming() || GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.renderBlockOutlineMode == VRSettings.RenderPointerElement.NEVER) {
                cir.setReturnValue((Object)false);
            } else if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.renderBlockOutlineMode == VRSettings.RenderPointerElement.ALWAYS) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V")})
    private void vivecraft$renderFaceOverlay(GameRenderer instance, float partialTick, long finishTimeNano, PoseStack poseStack, Operation<Void> original) {
        original.call(new Object[]{instance, Float.valueOf(partialTick), finishTimeNano, poseStack});
        if (!RenderPassType.isVanilla() && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.THIRD && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.CAMERA) {
            VREffectsHelper.renderFaceOverlay(partialTick, poseStack);
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/GameRenderer;effectActive:Z")})
    private boolean vivecraft$noEffectInThird(boolean effectActive) {
        return effectActive && GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.THIRD;
    }

    @Override
    @Unique
    public void vivecraft$setShouldDrawScreen(boolean shouldDrawScreen) {
        this.vivecraft$shouldDrawScreen = shouldDrawScreen;
    }

    @Override
    @Unique
    public void vivecraft$setShouldDrawGui(boolean shouldDrawGui) {
        this.vivecraft$shouldDrawGui = shouldDrawGui;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getWindow()Lcom/mojang/blaze3d/platform/Window;", ordinal=6)}, cancellable=true)
    private void vivecraft$mainMenu(float partialTick, long nanoTime, boolean renderLevel, CallbackInfo ci) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (!renderLevel && this.vivecraft$shouldDrawScreen) {
            this.vivecraft$shouldDrawScreen = false;
            if (this.vivecraft$shouldDrawGui) {
                this.f_109059_.m_91307_().m_6180_("vanillaGuiSetup");
            }
            return;
        }
        if (!renderLevel || this.f_109059_.f_91073_ == null || MethodHolder.isInMenuRoom()) {
            if (!renderLevel || this.f_109059_.f_91073_ == null) {
                this.f_109059_.m_91307_().m_6180_("MainMenu");
            } else {
                this.f_109059_.m_91307_().m_6182_("MainMenu");
            }
            GL11.glDisable((int)2960);
            PoseStack poseStack = new PoseStack();
            RenderHelper.applyVRModelView(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass, poseStack);
            this.vivecraft$resetProjectionMatrix(partialTick);
            VREffectsHelper.renderGuiLayer(partialTick, true, poseStack);
            DebugRenderHelper.renderDebug(poseStack, partialTick);
            if (KeyboardHandler.SHOWING) {
                if (GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.physicalKeyboard) {
                    VREffectsHelper.renderPhysicalKeyboard(partialTick, poseStack);
                } else {
                    VREffectsHelper.render2D(partialTick, KeyboardHandler.FRAMEBUFFER, (Vector3fc)KeyboardHandler.POS_ROOM, KeyboardHandler.ROTATION_ROOM, GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.menuAlwaysFollowFace && MethodHolder.isInMenuRoom(), poseStack);
                }
            }
            if (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.CAMERA && (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass != RenderPass.THIRD || GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityRenderHands)) {
                VRArmHelper.renderVRHands(partialTick, true, true, true, true, poseStack);
            }
        }
        this.f_109059_.m_91307_().m_7238_();
        ci.cancel();
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;getWindow()Lcom/mojang/blaze3d/platform/Window;", shift=At.Shift.AFTER, ordinal=6), ordinal=0, argsOnly=true)
    private boolean vivecraft$renderGui(boolean renderLevel) {
        return RenderPassType.isVanilla() ? renderLevel : this.vivecraft$shouldDrawGui;
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;renderItemActivationAnimation(IIF)V")})
    private boolean vivecraft$noItemActivationAnimationOnGUI(GameRenderer instance, int width, int height, float partialTicks) {
        return RenderPassType.isVanilla();
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;render(Lcom/mojang/blaze3d/vertex/PoseStack;F)V")})
    private boolean vivecraft$noGUIWithViewOnly(Gui instance, PoseStack poseStack, float partialTick) {
        return RenderPassType.isVanilla() || !GameRendererVRMixin.vivecraft$DATA_HOLDER.viewOnly;
    }

    @Inject(method={"takeAutoScreenshot"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$noScreenshotInMenu(CallbackInfo ci) {
        if (VRState.VR_RUNNING && MethodHolder.isInMenuRoom()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderConfusionOverlay"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$cancelConfusionOverlayOnGUI(CallbackInfo ci) {
        if (GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass == RenderPass.GUI) {
            ci.cancel();
        }
    }

    @Inject(method={"bobHurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$cancelBobHurt(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            ci.cancel();
        }
    }

    @Inject(method={"bobView"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$cancelBobView(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"renderItemActivationAnimation"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(DDD)V")})
    private void vivecraft$noTranslateItemInVR(PoseStack instance, double x, double y, double z, Operation<Void> original) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{instance, x, y, z});
        }
    }

    @WrapOperation(method={"renderItemActivationAnimation"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;scale(FFF)V")})
    private void vivecraft$noScaleItem(PoseStack poseStack, float x, float y, float z, Operation<Void> original, @Local(ordinal=5) float progress) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{poseStack, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)});
        } else {
            float sinProgress = Mth.m_14031_((float)progress) * 0.5f;
            poseStack.m_85837_(0.0, 0.0, (double)(sinProgress - 1.0f));
            RenderPass pass = GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass;
            if (pass == RenderPass.THIRD) {
                sinProgress *= GameRendererVRMixin.vivecraft$DATA_HOLDER.vrSettings.mixedRealityFov / 70.0f;
            } else if (pass == RenderPass.CENTER) {
                sinProgress *= (float)Minecraft.m_91087_().f_91066_.f_92068_ / 70.0f;
            } else if (pass == RenderPass.LEFT || pass == RenderPass.RIGHT) {
                VRData data = GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.getVRDataWorld();
                Vector3f offset = MathUtils.subtractToVector3f(data.getEye(pass).getPosition(), data.hmd.getPosition());
                data.hmd.getMatrix().invert().transformPosition(offset);
                poseStack.m_85837_((double)(-offset.x), (double)(-offset.y), (double)(-offset.z));
            }
            original.call(new Object[]{poseStack, Float.valueOf(sinProgress), Float.valueOf(sinProgress), Float.valueOf(sinProgress)});
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;pick(F)V")})
    private void vivecraft$onlyOnePick(GameRenderer instance, float partialTick, Operation<Void> original) {
        if (RenderPassType.isVanilla()) {
            original.call(new Object[]{instance, Float.valueOf(partialTick)});
            return;
        }
        if (!(!GameRendererVRMixin.vivecraft$DATA_HOLDER.isFirstPass || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
            original.call(new Object[]{instance, Float.valueOf(partialTick)});
            if (this.f_109059_.f_91077_ != null && this.f_109059_.f_91077_.m_6662_() != HitResult.Type.MISS) {
                this.vivecraft$crossVec = this.f_109059_.f_91077_.m_82450_();
            }
            if (this.f_109059_.f_91080_ == null) {
                GameRendererVRMixin.vivecraft$DATA_HOLDER.teleportTracker.updateTeleportDestinations(this.f_109059_.f_91074_);
            }
        }
        this.vivecraft$cacheRVEPos(this.f_109059_.m_91288_());
        this.vivecraft$setupRVE();
        this.vivecraft$setupOverlayStatus();
    }

    @ModifyVariable(method={"renderLevel"}, at=@At(value="STORE"))
    private int vivecraft$reduceNauseaSpeed(int oldVal) {
        if (!RenderPassType.isVanilla()) {
            return oldVal / 5;
        }
        return oldVal;
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;lerp(FFF)F")})
    private float vivecraft$reduceNauseaAffect(float delta, float start, float end, Operation<Float> original) {
        if (!RenderPassType.isVanilla()) {
            return ((Float)original.call(new Object[]{Float.valueOf(delta), Float.valueOf(start), Float.valueOf(end)})).floatValue() * 0.4f;
        }
        return ((Float)original.call(new Object[]{Float.valueOf(delta), Float.valueOf(start), Float.valueOf(end)})).floatValue();
    }

    @ModifyExpressionValue(method={"renderLevel"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/GameRenderer;renderHand:Z")})
    private boolean vivecraft$noHandsInVR(boolean renderHand) {
        return renderHand && RenderPassType.isVanilla();
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void vivecraft$disableStencil(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            VREffectsHelper.disableStencilTest();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="TAIL")})
    private void vivecraft$restoreRVE(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            this.vivecraft$restoreRVEPos(this.f_109059_.m_91288_());
        }
    }

    @Override
    @Unique
    public void vivecraft$setupRVE() {
        this.vivecraft$setupRVEAtDevice(GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass));
    }

    @Unique
    private void vivecraft$setupRVEAtDevice(VRData.VRDevicePose eyePose) {
        if (!(!this.vivecraft$cached || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
            Vec3 eye = eyePose.getPosition();
            Entity entity = this.f_109059_.m_91288_();
            entity.m_20343_(eye.f_82479_, eye.f_82480_, eye.f_82481_);
            entity.f_19790_ = eye.f_82479_;
            entity.f_19791_ = eye.f_82480_;
            entity.f_19792_ = eye.f_82481_;
            entity.f_19854_ = eye.f_82479_;
            entity.f_19855_ = eye.f_82480_;
            entity.f_19856_ = eye.f_82481_;
            entity.m_146926_(-eyePose.getPitch());
            entity.f_19860_ = entity.m_146909_();
            entity.m_146922_(eyePose.getYaw());
            entity.f_19859_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.f_20885_ = entity.m_146908_();
                livingEntity.f_20886_ = entity.m_146908_();
            }
            entity.f_19816_ = 1.0E-4f;
        }
    }

    @Override
    @Unique
    public void vivecraft$cacheRVEPos(Entity entity) {
        if (!(this.f_109059_.m_91288_() == null || this.vivecraft$cached || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
            this.vivecraft$rveX = entity.m_20185_();
            this.vivecraft$rveY = entity.m_20186_();
            this.vivecraft$rveZ = entity.m_20189_();
            this.vivecraft$rvelastX = entity.f_19790_;
            this.vivecraft$rvelastY = entity.f_19791_;
            this.vivecraft$rvelastZ = entity.f_19792_;
            this.vivecraft$rveprevX = entity.f_19854_;
            this.vivecraft$rveprevY = entity.f_19855_;
            this.vivecraft$rveprevZ = entity.f_19856_;
            this.vivecraft$rvepitch = entity.m_146909_();
            this.vivecraft$rvelastpitch = entity.f_19860_;
            this.vivecraft$rveHeight = entity.m_20192_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.vivecraft$rveyaw = livingEntity.f_20885_;
                this.vivecraft$rvelastyaw = livingEntity.f_20886_;
            } else {
                this.vivecraft$rveyaw = entity.m_146908_();
                this.vivecraft$rvelastyaw = entity.f_19859_;
            }
            this.vivecraft$cached = true;
        }
    }

    @Override
    @Unique
    public void vivecraft$restoreRVEPos(Entity entity) {
        if (!(entity == null || ImmersivePortalsHelper.isLoaded() && ImmersivePortalsHelper.isRenderingPortal())) {
            entity.m_20343_(this.vivecraft$rveX, this.vivecraft$rveY, this.vivecraft$rveZ);
            entity.f_19790_ = this.vivecraft$rvelastX;
            entity.f_19791_ = this.vivecraft$rvelastY;
            entity.f_19792_ = this.vivecraft$rvelastZ;
            entity.f_19854_ = this.vivecraft$rveprevX;
            entity.f_19855_ = this.vivecraft$rveprevY;
            entity.f_19856_ = this.vivecraft$rveprevZ;
            entity.m_146926_(this.vivecraft$rvepitch);
            entity.f_19860_ = this.vivecraft$rvelastpitch;
            entity.m_146922_(this.vivecraft$rveyaw);
            entity.f_19859_ = this.vivecraft$rvelastyaw;
            entity.f_19816_ = this.vivecraft$rveHeight;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.f_20885_ = this.vivecraft$rveyaw;
                livingEntity.f_20886_ = this.vivecraft$rvelastyaw;
            }
            this.vivecraft$cached = false;
        }
    }

    @Override
    @Unique
    public double vivecraft$getRveY() {
        return this.vivecraft$rveY;
    }

    @Override
    @Unique
    public Vec3 vivecraft$getRvePos(float partialTick) {
        return new Vec3(Mth.m_14139_((double)partialTick, (double)this.vivecraft$rvelastX, (double)this.vivecraft$rveX), Mth.m_14139_((double)partialTick, (double)this.vivecraft$rvelastY, (double)this.vivecraft$rveY), Mth.m_14139_((double)partialTick, (double)this.vivecraft$rvelastZ, (double)this.vivecraft$rveZ));
    }

    @Unique
    private void vivecraft$setupOverlayStatus() {
        this.vivecraft$inBlock = 0.0f;
        this.vivecraft$inwater = false;
        if (!this.f_109059_.f_91074_.m_5833_() && !MethodHolder.isInMenuRoom() && this.f_109059_.f_91074_.m_6084_()) {
            Vec3 cameraPos = GameRendererVRMixin.vivecraft$DATA_HOLDER.vrPlayer.getVRDataWorld().getEye(GameRendererVRMixin.vivecraft$DATA_HOLDER.currentPass).getPosition();
            Triple<Float, BlockState, BlockPos> triple = VREffectsHelper.getNearOpaqueBlock(cameraPos, 0.02f);
            this.vivecraft$inBlock = triple != null && !Xevents.renderBlockOverlay((Player)this.f_109059_.f_91074_, new PoseStack(), (BlockState)triple.getMiddle(), (BlockPos)triple.getRight()) ? ((Float)triple.getLeft()).floatValue() : 0.0f;
            this.vivecraft$inwater = this.f_109059_.f_91074_.m_204029_(FluidTags.f_13131_) && !Xevents.renderWaterOverlay((Player)this.f_109059_.f_91074_, new PoseStack());
        }
    }

    @Override
    @Unique
    public boolean vivecraft$isInWater() {
        return this.vivecraft$inwater;
    }

    @Override
    @Unique
    public float vivecraft$isInBlock() {
        return this.vivecraft$inBlock;
    }

    @Override
    @Unique
    public Vec3 vivecraft$getCrossVec() {
        return this.vivecraft$crossVec;
    }

    @Override
    @Unique
    public float vivecraft$getMinClipDistance() {
        return 0.02f;
    }

    @Override
    @Unique
    public Matrix4f vivecraft$getThirdPassProjectionMatrix() {
        return this.vivecraft$thirdPassProjectionMatrix;
    }

    @Override
    @Unique
    public void vivecraft$resetProjectionMatrix(float partialTick) {
        this.m_109111_(this.m_172716_(this.m_109141_(this.f_109054_, partialTick, true)));
    }
}

