/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.server;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.IllegalFormatException;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.Xplat;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.common.network.packet.s2c.DamageDirectionPayloadS2C;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.mixin.world.entity.PlayerMixin;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends PlayerMixin {
    @Shadow
    @Final
    public MinecraftServer f_8924_;
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    @Unique
    private ItemStack vivecraft$roomscaleShieldItem;
    @Unique
    private InteractionHand vivecraft$roomscaleShieldHand;

    protected ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"initInventoryMenu"}, at={@At(value="TAIL")})
    private void vivecraft$addItemEasterEgg(CallbackInfo ci) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (((Boolean)ServerConfig.VR_FUN.get()).booleanValue() && serverVivePlayer != null && serverVivePlayer.isVR() && this.f_19796_.nextInt(40) == 3) {
            ItemStack easterEggItem;
            if (this.f_19796_.nextInt(2) == 1) {
                easterEggItem = new ItemStack((ItemLike)Items.f_42687_);
                easterEggItem.m_41714_((Component)new TextComponent("EAT ME"));
            } else {
                easterEggItem = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                easterEggItem.m_41714_((Component)new TextComponent("DRINK ME"));
            }
            easterEggItem.m_41784_().m_128405_("HideFlags", 32);
            if (this.m_150109_().m_36054_(easterEggItem)) {
                this.f_36095_.m_38946_();
            }
        }
    }

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;tick()V", shift=At.Shift.AFTER)})
    private void vivecraft$overridePose(CallbackInfo ci) {
        ServerVRPlayers.overridePose((ServerPlayer)this);
    }

    @Override
    protected int vivecraft$modifySweepParticleSpawnPos(ServerLevel instance, ParticleOptions type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed, Operation<Integer> original) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 aim = serverVivePlayer.getAimDir(false);
            float yaw = (float)Math.atan2(-aim.f_82479_, aim.f_82481_);
            xOffset = -Mth.m_14031_((float)yaw);
            zOffset = Mth.m_14089_((float)yaw);
            Vec3 pos = serverVivePlayer.getAimPos(false);
            return (Integer)original.call(new Object[]{instance, type, pos.f_82479_ + xOffset, pos.f_82480_, pos.f_82481_ + zOffset, particleCount, xOffset, yOffset, zOffset, speed});
        }
        return (Integer)original.call(new Object[]{instance, type, posX, posY, posZ, particleCount, xOffset, yOffset, zOffset, speed});
    }

    @Override
    protected float vivecraft$damageModifier(float damage) {
        ServerVivePlayer vivePlayer;
        if (((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue() && (Double)ServerConfig.BOOTS_ARMOR_DAMAGE.get() > 0.0 && (vivePlayer = this.vivecraft$getVivePlayer()).isVR() && vivePlayer.activeBodyPart.isFoot() && !this.m_6844_(EquipmentSlot.FEET).m_41619_()) {
            float addedDamage = 0.0f;
            for (AttributeModifier modifier : this.m_6844_(EquipmentSlot.FEET).m_41720_().m_7167_(EquipmentSlot.FEET).get((Object)Attributes.f_22284_)) {
                float amount = (float)modifier.m_22218_();
                switch (modifier.m_22217_()) {
                    case ADDITION: {
                        addedDamage += amount;
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        addedDamage += amount * addedDamage;
                    }
                }
            }
            return damage + addedDamage * ((Double)ServerConfig.BOOTS_ARMOR_DAMAGE.get()).floatValue();
        }
        return damage;
    }

    @Override
    protected boolean vivecraft$roomscaleShieldBlockingItem(boolean isBlocking, DamageSource damageSource, LocalBooleanRef roomscaleBlocked) {
        this.vivecraft$roomscaleShieldItem = null;
        this.vivecraft$roomscaleShieldHand = null;
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (((Boolean)ServerConfig.ALLOW_ROOMSCALE_SHIELD_BLOCKING.get()).booleanValue() && !isBlocking && damageSource.m_7270_() != null && serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 dmgPos = damageSource.m_7270_();
            boolean isProjectile = false;
            Entity entity = damageSource.m_7640_();
            if (entity != null && dmgPos == entity.m_20182_()) {
                isProjectile = entity instanceof Projectile;
                dmgPos = entity.m_142469_().m_82399_().m_82546_(entity.m_20184_().m_82541_());
            }
            for (int i = 0; i < 2; ++i) {
                InteractionHand hand = InteractionHand.values()[i];
                ItemStack stack = this.m_6844_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                if (stack == null || stack.m_41720_().m_6164_(stack) != UseAnim.BLOCK || this.m_36335_().m_41519_(stack.m_41720_())) continue;
                Vector3fc sideDir = serverVivePlayer.isLeftHanded() ? (hand == InteractionHand.MAIN_HAND ? MathUtils.RIGHT : MathUtils.LEFT) : (hand == InteractionHand.MAIN_HAND ? MathUtils.LEFT : MathUtils.RIGHT);
                Vec3 shieldDir = serverVivePlayer.getBodyPartVectorCustom(VRBodyPart.fromInteractionHand(hand), sideDir);
                double angle = 0.0;
                if (isProjectile) {
                    dmgDir = dmgPos.m_82546_(serverVivePlayer.getBodyPartPos(VRBodyPart.fromInteractionHand(hand))).m_82541_();
                    angle = shieldDir.m_82526_(dmgDir);
                } else {
                    dmgDir = dmgPos.m_82546_(this.m_20182_());
                    dmgDir = new Vec3(dmgDir.f_82479_, 0.0, dmgDir.f_82481_).m_82541_();
                    Vec3 shieldHor = new Vec3(shieldDir.f_82479_, 0.0, shieldDir.f_82481_).m_82541_();
                    angle = shieldHor.m_82526_(dmgDir);
                }
                if (!(angle > 0.5)) continue;
                roomscaleBlocked.set(true);
                this.vivecraft$roomscaleShieldItem = stack;
                this.vivecraft$roomscaleShieldHand = hand;
                return true;
            }
        }
        return isBlocking;
    }

    @Override
    protected void vivecraft$roomscaleShieldItemDamage(float damageAmount, Operation<Void> original) {
        if (((Boolean)ServerConfig.ALLOW_ROOMSCALE_SHIELD_BLOCKING.get()).booleanValue() && this.vivecraft$roomscaleShieldItem != null) {
            ItemStack backup = this.f_20935_;
            this.f_20935_ = this.vivecraft$roomscaleShieldItem;
            original.call(new Object[]{Float.valueOf(damageAmount)});
            this.f_20935_ = backup;
            this.vivecraft$roomscaleShieldItem = null;
            this.vivecraft$roomscaleShieldHand = null;
        } else {
            original.call(new Object[]{Float.valueOf(damageAmount)});
        }
    }

    @Override
    protected InteractionHand vivecraft$roomscaleShieldHand(InteractionHand original) {
        return (Boolean)ServerConfig.ALLOW_ROOMSCALE_SHIELD_BLOCKING.get() != false && this.vivecraft$roomscaleShieldHand != null ? this.vivecraft$roomscaleShieldHand : original;
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$noAttackWhileBlocking(Entity target, CallbackInfo ci) {
        ServerVivePlayer vivePlayer = this.vivecraft$getVivePlayer();
        if (!((Boolean)ServerConfig.ALLOW_ATTACKS_WHILE_BLOCKING.get()).booleanValue() && vivePlayer != null && vivePlayer.isVR() && this.m_21254_()) {
            ci.cancel();
        }
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    private void vivecraft$dropVive(ItemStack droppedItem, boolean dropAround, boolean includeThrowerName, CallbackInfoReturnable<ItemEntity> cir, @Local ItemEntity item) {
        ServerVivePlayer serverVivePlayer = this.vivecraft$getVivePlayer();
        if (!dropAround && serverVivePlayer != null && serverVivePlayer.isVR()) {
            Vec3 pos = serverVivePlayer.getAimPos(false);
            Vec3 aim = serverVivePlayer.getAimDir(false);
            float speed = 0.3f;
            item.m_20334_(aim.f_82479_ * (double)0.3f, aim.f_82480_ * (double)0.3f, aim.f_82481_ * (double)0.3f);
            item.m_6034_(pos.f_82479_ + item.m_20184_().f_82479_, pos.f_82480_ + item.m_20184_().f_82480_, pos.f_82481_ + item.m_20184_().f_82481_);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$checkCanGetHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = source.m_7639_();
        ServerPlayer other = null;
        if (entity instanceof ServerPlayer) {
            other = (ServerPlayer)entity;
        } else if (entity instanceof AbstractArrow && ((AbstractArrow)entity).m_37282_() instanceof ServerPlayer) {
            other = (ServerPlayer)((AbstractArrow)entity).m_37282_();
        }
        if (other != null) {
            ServerVivePlayer otherVive = ServerVRPlayers.getVivePlayer(other);
            ServerVivePlayer thisVive = this.vivecraft$getVivePlayer();
            if (otherVive == null) {
                otherVive = new ServerVivePlayer(other);
            }
            if (thisVive == null) {
                thisVive = new ServerVivePlayer((ServerPlayer)this);
            }
            boolean blockedDamage = false;
            String blockedDamageCase = "";
            if (!otherVive.isVR() && thisVive.isVR() && thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_SEATEDVR_VS_NONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs seated VR damage";
                }
            } else if (!otherVive.isVR() && thisVive.isVR() && !thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_NONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated() || thisVive.isVR() && thisVive.isSeated() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_SEATEDVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled seated VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && !otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated()) {
                if (!((Boolean)ServerConfig.PVP_VR_VS_VR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled standing VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && thisVive.isSeated() && !((Boolean)ServerConfig.PVP_SEATEDVR_VS_SEATEDVR.get()).booleanValue()) {
                blockedDamage = true;
                blockedDamageCase = "canceled seated VR vs seated VR damage";
            }
            if (blockedDamage) {
                if (((Boolean)ServerConfig.PVP_NOTIFY_BLOCKED_DAMAGE.get()).booleanValue()) {
                    other.m_9146_((Component)new TextComponent(blockedDamageCase), ChatType.SYSTEM, Util.f_137441_);
                }
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")})
    private void vivecraft$sendDamageDir(CallbackInfoReturnable<Boolean> cir, @Local(argsOnly=true) DamageSource damageSource) {
        ServerVivePlayer vivePlayer;
        if (cir.getReturnValueZ() && (vivePlayer = this.vivecraft$getVivePlayer()) != null && vivePlayer.isVR() && vivePlayer.wantsDamageDirection) {
            this.f_8906_.m_141995_(Xplat.getS2CPacket(new DamageDirectionPayloadS2C(Utils.getDirFromDamageSource(damageSource, this))));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void vivecraft$customDeathMessage(DamageSource damageSource, CallbackInfo ci) {
        if (((Boolean)ServerConfig.MESSAGES_ENABLED.get()).booleanValue()) {
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer((ServerPlayer)this);
            String message = "";
            String entity = "";
            if (damageSource.m_7639_() != null) {
                entity = damageSource.m_7639_().m_7755_().m_6879_().getString();
                message = vivePlayer == null ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_DEATH_BY_MOB_SEATED.get() : (String)ServerConfig.MESSAGES_DEATH_BY_MOB_VR.get()));
            }
            if (message.isEmpty()) {
                message = vivePlayer == null ? (String)ServerConfig.MESSAGES_DEATH_VANILLA.get() : (!vivePlayer.isVR() ? (String)ServerConfig.MESSAGES_DEATH_NONVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.MESSAGES_DEATH_SEATED.get() : (String)ServerConfig.MESSAGES_DEATH_VR.get()));
            }
            if (!message.isEmpty()) {
                try {
                    this.f_8924_.m_6846_().m_11264_((Component)new TextComponent(message.formatted(this.m_7755_().getString(), entity)), ChatType.SYSTEM, Util.f_137441_);
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Vivecraft: Death message '{}' has errors:", (Object)message, (Object)e);
                }
            }
        }
    }

    @Unique
    private ServerVivePlayer vivecraft$getVivePlayer() {
        return ServerVRPlayers.getVivePlayer((ServerPlayer)this);
    }
}

