/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct Texture_t")
public class Texture
extends Struct<Texture>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;

    protected Texture(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected Texture create(long address, @Nullable ByteBuffer container) {
        return new Texture(address, container);
    }

    public Texture(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), Texture.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return Texture.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return Texture.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return Texture.neColorSpace(this.address());
    }

    public Texture handle(@NativeType(value="void *") long value) {
        Texture.nhandle(this.address(), value);
        return this;
    }

    public Texture eType(@NativeType(value="ETextureType") int value) {
        Texture.neType(this.address(), value);
        return this;
    }

    public Texture eColorSpace(@NativeType(value="EColorSpace") int value) {
        Texture.neColorSpace(this.address(), value);
        return this;
    }

    public Texture set(long handle, int eType, int eColorSpace) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        return this;
    }

    public Texture set(Texture src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static Texture malloc() {
        return new Texture(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static Texture calloc() {
        return new Texture(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static Texture create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new Texture(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static Texture create(long address) {
        return new Texture(address, null);
    }

    @Nullable
    public static Texture createSafe(long address) {
        return address == 0L ? null : new Texture(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)Texture.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = Texture.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static Texture mallocStack() {
        return Texture.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static Texture callocStack() {
        return Texture.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static Texture mallocStack(MemoryStack stack) {
        return Texture.malloc(stack);
    }

    @Deprecated
    public static Texture callocStack(MemoryStack stack) {
        return Texture.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return Texture.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return Texture.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return Texture.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return Texture.calloc(capacity, stack);
    }

    public static Texture malloc(MemoryStack stack) {
        return new Texture(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static Texture calloc(MemoryStack stack) {
        return new Texture(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static int neType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETYPE);
    }

    public static int neColorSpace(long struct) {
        return UNSAFE.getInt(null, struct + (long)ECOLORSPACE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void neType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETYPE, value);
    }

    public static void neColorSpace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ECOLORSPACE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
    }

    static {
        Struct.Layout layout = Texture.__struct((Struct.Member[])new Struct.Member[]{Texture.__member((int)POINTER_SIZE), Texture.__member((int)4), Texture.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<Texture, Buffer>
    implements NativeResource {
        private static final Texture ELEMENT_FACTORY = Texture.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Texture getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return Texture.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return Texture.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return Texture.neColorSpace(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            Texture.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            Texture.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            Texture.neColorSpace(this.address(), value);
            return this;
        }
    }
}

