/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gui;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.TwoHandedScreen;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;

public class GuiRadial
extends TwoHandedScreen {
    private boolean isShift = false;
    String[] arr;

    public void init() {
        this.arr = this.dh.vrSettings.vrRadialItems;
        String[] altSet = this.dh.vrSettings.vrRadialItemsAlt;
        this.clearWidgets();
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        if (this.isShift) {
            this.arr = altSet;
        }
        int i = 0;
        while (i < this.dh.vrSettings.vrRadialButtons && i < this.arr.length) {
            String current = this.arr[i];
            int index = i++;
            Arrays.stream(this.minecraft.options.keyMappings).filter(keymapping -> keymapping.getName().equalsIgnoreCase(current)).findFirst().ifPresent(keymapping -> {
                String label = I18n.get((String)keymapping.getName(), (Object[])new Object[0]);
                this.addRenderableWidget((GuiEventListener)GuiRadial.createButton(label, p -> {
                    VRInputAction vrinputaction = MCVR.get().getInputAction(this.arr[index]);
                    if (vrinputaction != null) {
                        vrinputaction.pressBinding();
                        vrinputaction.unpressBinding(2);
                    }
                }, index, centerX, centerY));
            });
        }
    }

    public void setShift(boolean shift) {
        if (shift != this.isShift) {
            this.isShift = shift;
            this.init();
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, 0, 0, partialTick);
    }

    public static Button createButton(String label, Button.OnPress action, int index, int centerX, int centerY) {
        int buttonWidthMin = 120;
        int numButtons = ClientDataHolderVR.getInstance().vrSettings.vrRadialButtons;
        float dist = (float)numButtons * (numButtons >= 14 ? 5.0f : 5.5f);
        int buttonWidth = Math.max(buttonWidthMin, Minecraft.getInstance().font.width(label) + 4);
        float distX = (float)(numButtons * 4) + (float)buttonWidth * 0.5f;
        float btnIndex = (float)(index < numButtons / 2 ? index : numButtons - index) / (float)(numButtons / 2);
        int y = (int)(2.0f * dist * btnIndex - dist);
        int x = (int)((double)distX * Math.sqrt(1.0f - (float)(y * y) / (dist * dist)));
        if (Math.abs(y) > 20) {
            x = (int)((float)x * 0.87f);
        }
        if (index != 0 && index != numButtons / 2) {
            x = Math.max(buttonWidth / 2, x);
        }
        return new Button.Builder((Component)Component.translatable((String)label), action).size(buttonWidth, 20).pos(centerX + (x *= index > numButtons / 2 ? -1 : 1) - buttonWidth / 2, centerY + y - 10).build();
    }
}

