/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_276;
import net.minecraft.class_6367;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;

public class MultiPassTextureTarget
extends class_6367 {
    private boolean isVanilla = false;
    private RenderPass passOverride = null;
    private class_276 last = null;
    @Nullable
    private final EnumMap<RenderPass, class_6367> vrTargets;
    private final class_6367 vanilla;

    public MultiPassTextureTarget(String name, int width, int height, boolean useDepth) {
        super(name, width, height, useDepth);
        super.method_1238();
        this.vrTargets = new EnumMap(RenderPass.class);
        this.isVanilla = true;
        this.vanilla = new class_6367(name, width, height, useDepth);
        this.isVanilla = false;
        for (RenderPass pass : RenderPass.values()) {
            WorldRenderPass worldPass = WorldRenderPass.getByRenderPass(pass);
            if (worldPass == null) continue;
            class_276 original = worldPass.target;
            this.vrTargets.put(pass, new class_6367(name + " " + String.valueOf((Object)pass), original.field_1482, original.field_1481, useDepth));
        }
        this.setLast(this.vanilla);
    }

    public void method_1234(int width, int height) {
        if (this.vrTargets == null) {
            super.method_1234(width, height);
            return;
        }
        this.isVanilla = true;
        this.vanilla.method_1234(width, height);
        this.isVanilla = false;
        for (Map.Entry<RenderPass, class_6367> entry : this.vrTargets.entrySet()) {
            WorldRenderPass pass = WorldRenderPass.getByRenderPass(entry.getKey());
            if (pass == null) continue;
            this.passOverride = entry.getKey();
            entry.getValue().method_1234(pass.target.field_1482, pass.target.field_1481);
            this.passOverride = null;
        }
    }

    public void method_1238() {
        if (this.vrTargets == null) {
            super.method_1238();
            return;
        }
        this.callOnAllTargets(class_276::method_1238);
    }

    public void method_29329(class_276 otherTarget) {
        if (this.vrTargets == null) {
            super.method_29329(otherTarget);
            return;
        }
        this.callOnTarget(r -> r.method_29329(otherTarget));
    }

    public void method_1231(int width, int height) {
        if (this.vrTargets == null) {
            super.method_1231(width, height);
            return;
        }
        this.callOnTarget(r -> r.method_1231(width, height));
    }

    public void method_58226(FilterMode filterMode) {
        if (this.vrTargets == null) {
            super.method_58226(filterMode);
            return;
        }
        this.callOnTarget(r -> r.method_58226(filterMode));
    }

    public void method_1237() {
        if (this.vrTargets == null) {
            super.method_1237();
            return;
        }
        this.callOnTarget(class_276::method_1237);
    }

    public void method_68445(GpuTexture gpuTexture) {
        if (this.vrTargets == null) {
            super.method_68445(gpuTexture);
            return;
        }
        this.callOnTarget(r -> r.method_68445(gpuTexture));
    }

    public GpuTexture method_30277() {
        if (this.vrTargets == null) {
            return super.method_30277();
        }
        return this.callOnTargetRet(class_276::method_30277);
    }

    public GpuTexture method_30278() {
        if (this.vrTargets == null) {
            return super.method_30278();
        }
        return this.callOnTargetRet(class_276::method_30278);
    }

    private void callOnAllTargets(Consumer<class_6367> consumer) {
        this.isVanilla = true;
        consumer.accept(this.vanilla);
        this.isVanilla = false;
        for (Map.Entry<RenderPass, class_6367> entry : this.vrTargets.entrySet()) {
            this.passOverride = entry.getKey();
            consumer.accept(entry.getValue());
            this.passOverride = null;
        }
    }

    private void callOnTarget(Consumer<class_6367> consumer) {
        class_6367 current = this.getCurrent();
        if (current != this.last) {
            this.setLast(current);
        }
        consumer.accept(current);
    }

    private <T> T callOnTargetRet(Function<class_6367, T> function) {
        class_6367 current = this.getCurrent();
        if (current != this.last) {
            this.setLast(current);
        }
        return function.apply(current);
    }

    private class_6367 getCurrent() {
        if (this.isVanilla || RenderPassType.isVanilla()) {
            return this.vanilla;
        }
        return this.vrTargets.get((Object)(this.passOverride != null ? this.passOverride : ClientDataHolderVR.getInstance().currentPass));
    }

    private void setLast(class_6367 current) {
        this.last = current;
        this.field_1482 = current.field_1482;
        this.field_1481 = current.field_1481;
        this.field_1480 = current.field_1480;
        this.field_1477 = current.field_1477;
        this.field_1483 = current.field_1483;
    }
}

