/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.class_1268;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.ItemInUseTracker;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.common.utils.MathUtils;

public class EatingTracker
implements ItemInUseTracker,
DebugRenderTracker {
    private static final float MOUTH_TO_EYE_DISTANCE = 0.0f;
    private static final float THRESHOLD = 0.25f;
    private static final long EAT_TIME = 2100L;
    private final Vector3f[] foodPos = new Vector3f[2];
    private final boolean[] eating = new boolean[2];
    private long eatStart;
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public EatingTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(class_746 player) {
        if (ClientDataHolderVR.getInstance().vrSettings.seated) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (player.method_6113()) {
            return false;
        }
        if (this.dh.bowTracker.isActive(player)) {
            return false;
        }
        return this.isEatable(player.method_6047()) || this.isEatable(player.method_6079());
    }

    private boolean isEatable(class_1799 stack) {
        if (stack != null) {
            class_1839 anim = stack.method_7976();
            return anim == class_1839.field_8950 || anim == class_1839.field_8946 || anim == class_1839.field_39058;
        }
        return false;
    }

    @Override
    public boolean itemInUse(class_746 player) {
        return this.eating[0] || this.eating[1];
    }

    @Override
    public void inactiveProcess(class_746 player) {
        this.eating[0] = false;
        this.eating[1] = false;
        this.foodPos[0] = null;
        this.foodPos[1] = null;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(class_746 player) {
        VRData room_pre = this.dh.vrPlayer.vrdata_room_pre;
        Vector3f hmdPos = room_pre.hmd.getPositionF();
        Vector3f mouthPos = room_pre.hmd.getCustomVector((Vector3fc)new Vector3f(0.0f, -0.0f, 0.0f)).add((Vector3fc)hmdPos);
        for (int c = 0; c < 2; ++c) {
            class_1799 itemstack;
            class_1799 class_17992 = itemstack = c == 0 ? player.method_6047() : player.method_6079();
            if (!this.isEatable(itemstack)) {
                this.foodPos[c] = null;
                continue;
            }
            this.foodPos[c] = this.dh.vr.controllerHistory[c].averagePosition(0.333).add((Vector3fc)room_pre.getController(c).getDirection().mul(0.2f));
            if (mouthPos.distance((Vector3fc)this.foodPos[c]) < 0.25f) {
                long k;
                int crunchiness = 0;
                if (itemstack.method_7976() == class_1839.field_8946) {
                    if (room_pre.getController((int)c).getCustomVector((Vector3fc)MathUtils.UP).y > 0.0f) {
                        this.eating[c] = false;
                        continue;
                    }
                } else if (itemstack.method_7976() == class_1839.field_8950) {
                    crunchiness = 2;
                } else {
                    if (itemstack.method_7976() != class_1839.field_39058) continue;
                    crunchiness = 1;
                }
                if (!this.eating[c] && this.mc.field_1761.method_2919((class_1657)player, c == 0 ? class_1268.field_5808 : class_1268.field_5810).method_23665()) {
                    this.mc.field_1773.field_4012.method_3215(c == 0 ? class_1268.field_5808 : class_1268.field_5810);
                    this.eating[c] = true;
                    this.eatStart = class_156.method_658();
                }
                if (this.eating[c] && (k = (long)player.method_6014()) > 0L && k % 5L <= (long)crunchiness) {
                    this.dh.vr.triggerHapticPulse(c, 700);
                }
                if (class_156.method_658() - this.eatStart <= 2100L) continue;
                this.eating[c] = false;
                continue;
            }
            this.eating[c] = false;
        }
    }

    @Override
    public void renderDebug(class_4587 poseStack) {
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        class_243 cam = world.getEye(this.dh.currentPass).getPosition();
        for (int c = 0; c < 2; ++c) {
            if (this.foodPos[c] == null) continue;
            Vector3f food = MathUtils.subtractToVector3f(VRPlayer.roomToWorldPos((Vector3fc)this.foodPos[c], world), cam);
            DebugRenderHelper.renderCube(poseStack, (Vector3fc)food, 0.05f * world.worldScale, this.eating[c] ? MathUtils.GREEN : MathUtils.RED);
            DebugRenderHelper.renderSphere(poseStack, (Vector3fc)food, 0.25f * world.worldScale, this.eating[c] ? MathUtils.GREEN : MathUtils.RED);
        }
    }
}

