/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1744;
import net.minecraft.class_1758;
import net.minecraft.class_1766;
import net.minecraft.class_1786;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_2195;
import net.minecraft.class_2302;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2399;
import net.minecraft.class_2428;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_8162;
import net.minecraft.class_8170;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.Xplat;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.Vector3fHistory;
import org.vivecraft.client_vr.gameplay.trackers.DebugRenderTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.data.ViveBlockTags;
import org.vivecraft.data.ViveItemTags;
import org.vivecraft.mod_compat_vr.bettercombat.BetterCombatHelper;
import org.vivecraft.mod_compat_vr.epicfight.EpicFightHelper;

public class SwingTracker
implements DebugRenderTracker {
    private static final int[] CONTROLLER_AND_FEET = new int[]{0, 1, 4, 5};
    private static final VRBodyPart[] BODYPARTS = new VRBodyPart[]{VRBodyPart.MAIN_HAND, VRBodyPart.OFF_HAND, VRBodyPart.RIGHT_FOOT, VRBodyPart.LEFT_FOOT};
    private static final float SPEED_THRESH = 3.0f;
    public int disableSwing = 3;
    private final Quaternionf[] lastHandRot = new Quaternionf[4];
    private final class_243[] lastHandPos = new class_243[4];
    private final List<class_243>[] miningPoints = new List[4];
    private final boolean[] lastWeaponSolid = new boolean[4];
    private final List<class_1297>[] lastHitEntities = new List[]{Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()};
    private final class_243[] miningPoint = new class_243[4];
    private final class_243[] attackingPoint = new class_243[4];
    private final class_243[] weaponTip = new class_243[4];
    private final Vector3fHistory[] tipHistory = new Vector3fHistory[]{new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory(), new Vector3fHistory()};
    private final boolean[] canAct = new boolean[4];
    private final class_238[] lastAttackAABB = new class_238[4];
    private final class_243[] lastBlockHit = new class_243[4];
    private final int[] lastMiningPointHit = new int[4];
    private final LinkedList<Pair<class_243, Vector3fc>>[] previousMiningPoints = new LinkedList[]{new LinkedList(), new LinkedList(), new LinkedList(), new LinkedList()};
    private final class_310 mc;
    private final ClientDataHolderVR dh;

    public SwingTracker(class_310 mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(class_746 player) {
        if (this.disableSwing > 0) {
            --this.disableSwing;
            return false;
        }
        if (this.mc.field_1761 == null) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (!player.method_5805()) {
            return false;
        }
        if (player.method_6113()) {
            return false;
        }
        if (this.mc.field_1755 != null) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.OFF) {
            return false;
        }
        if (this.dh.vrSettings.weaponCollision == VRSettings.WeaponCollision.AUTO && player.method_7337()) {
            return false;
        }
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (this.dh.vrSettings.vrFreeMoveMode == VRSettings.FreeMove.RUN_IN_PLACE && player.field_6250 > 0.0f) {
            return false;
        }
        if (player.method_6039() && !ClientNetworking.SERVER_ALLOWS_ATTACKING_WHILE_BLOCKING) {
            return false;
        }
        return !this.dh.jumpTracker.isjumping();
    }

    public static boolean isTool(class_1799 itemStack) {
        return SwingTracker.isToolItem(itemStack.method_7909()) || itemStack.method_31573(ViveItemTags.VIVECRAFT_TOOLS) || itemStack.method_31573(class_3489.field_42614) || itemStack.method_31573(class_3489.field_42612) || itemStack.method_31573(class_3489.field_42615) || itemStack.method_31573(class_3489.field_42613);
    }

    private static boolean isToolItem(class_1792 item) {
        return item instanceof class_1766 || item instanceof class_1744 || item instanceof class_1787 || item instanceof class_1758 || item instanceof class_1820 || item == class_1802.field_8606 || item == class_1802.field_8894 || item == class_1802.field_8648 || item == class_1802.field_8810 || item == class_1802.field_8530 || item == class_1802.field_8600 || item == class_1802.field_8688 || item instanceof class_1786 || item instanceof class_8162;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void inactiveProcess(class_746 player) {
        for (int i = 0; i < 4; ++i) {
            this.lastHandPos[i] = null;
            this.attackingPoint[i] = null;
            this.weaponTip[i] = null;
            this.miningPoints[i] = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void activeProcess(class_746 player) {
        float speedTreshhold = 3.0f;
        if (player.method_7337()) {
            speedTreshhold *= 1.5f;
        }
        this.mc.method_16011().method_15396("updateSwingAttack");
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        for (int i = 0; i < trackers; ++i) {
            class_3965 blockhitresult;
            boolean isHand;
            int c = CONTROLLER_AND_FEET[i];
            boolean bl = isHand = i < 2;
            if (isHand && this.dh.climbTracker.isGrabbingLadder(c)) continue;
            class_243 handPos = this.dh.vrPlayer.vrdata_world_pre.getDevice(c).getPosition();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(c).getCustomVector(MathUtils.BACK);
            class_1799 itemstack = player.method_5998(c == 1 ? class_1268.field_5810 : class_1268.field_5808);
            class_1792 item = itemstack.method_7909();
            boolean isTool = false;
            boolean isSword = false;
            if (this.dh.vrSettings.onlySwordCollision && !(item instanceof class_1829) && !itemstack.method_31573(ViveItemTags.VIVECRAFT_SWORDS)) continue;
            if (!(item instanceof class_1829 || itemstack.method_31573(ViveItemTags.VIVECRAFT_SWORDS) || item instanceof class_1835 || itemstack.method_31573(ViveItemTags.VIVECRAFT_SPEARS))) {
                if (SwingTracker.isTool(itemstack)) {
                    isTool = true;
                }
            } else {
                isSword = true;
                isTool = true;
            }
            float weaponLength = 0.0f;
            float entityReachAdd = 0.3f;
            if (isHand) {
                double playerEntityReach = Xplat.getItemEntityReach(3.0, itemstack, c == 0 ? class_1304.field_6173 : class_1304.field_6171);
                if (BetterCombatHelper.isLoaded()) {
                    playerEntityReach = BetterCombatHelper.getItemRange(playerEntityReach, itemstack);
                }
                playerEntityReach = Math.min(playerEntityReach, 6.0) - 0.5;
                if (isSword) {
                    weaponLength = 0.6f;
                    entityReachAdd = (float)playerEntityReach - weaponLength;
                } else if (isTool) {
                    weaponLength = 0.35f;
                    entityReachAdd = (float)playerEntityReach * 0.62f - weaponLength;
                } else if (!itemstack.method_7960()) {
                    weaponLength = 0.1f;
                    entityReachAdd = (float)playerEntityReach * 0.16f - weaponLength;
                }
            }
            class_243 prevMiningPoint = this.miningPoint[i];
            Vector3f weaponEnd = handDirection.mul(weaponLength *= this.dh.vrPlayer.vrdata_world_pre.worldScale, new Vector3f());
            this.miningPoint[i] = handPos.method_1031((double)weaponEnd.x, (double)weaponEnd.y, (double)weaponEnd.z);
            Vector3f tip = this.dh.vrPlayer.vrdata_room_pre.getDevice(c).getPositionF().add((Vector3fc)this.dh.vrPlayer.vrdata_room_pre.getHand(c).getCustomVector(MathUtils.BACK).mul(0.3f));
            this.tipHistory[i].add((Vector3fc)tip);
            float speed = this.tipHistory[i].averageSpeed(0.33);
            boolean inAnEntity = false;
            this.canAct[i] = speed > speedTreshhold && !this.lastWeaponSolid[i];
            boolean entityAct = this.canAct[i];
            if (entityAct && (blockhitresult = this.mc.field_1687.method_17742(new class_3959(this.dh.vrPlayer.vrdata_world_pre.hmd.getPosition(), handPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724))).method_17783() != class_239.class_240.field_1333) {
                entityAct = false;
            }
            class_243 lastAttackPoint = this.attackingPoint[i];
            class_243 lastWeaponTip = this.weaponTip[i];
            this.attackingPoint[i] = this.constrain(handPos, this.miningPoint[i]);
            Vector3f weaponEntityEnd = handDirection.mul(weaponLength + entityReachAdd, new Vector3f());
            this.weaponTip[i] = handPos.method_1031((double)weaponEntityEnd.x, (double)weaponEntityEnd.y, (double)weaponEntityEnd.z);
            this.weaponTip[i] = this.constrain(handPos, this.weaponTip[i]);
            class_238 weaponBB = new class_238(handPos, this.attackingPoint[i]);
            class_238 weaponTipBB = new class_238(handPos, this.weaponTip[i]);
            if (lastAttackPoint != null) {
                weaponBB = Utils.includePoint(weaponBB, lastAttackPoint);
            }
            if (lastWeaponTip != null) {
                weaponTipBB = Utils.includePoint(weaponTipBB, lastWeaponTip);
            }
            this.lastAttackAABB[i] = weaponTipBB;
            List<Object> mobs = this.mc.field_1687.method_8335((class_1297)this.mc.field_1724, weaponTipBB);
            if (this.dh.vrSettings.reducedPlayerReach) {
                mobs.removeIf(e -> e instanceof class_1657);
                List players = this.mc.field_1687.method_8335((class_1297)this.mc.field_1724, weaponBB);
                players.removeIf(e -> !(e instanceof class_1657));
                mobs.addAll(players);
            }
            for (class_1297 class_12972 : mobs) {
                if (!class_12972.method_5863() || class_12972 == this.mc.method_1560().method_5854() || this.lastHitEntities[i].contains(class_12972)) continue;
                if (entityAct) {
                    if (!EpicFightHelper.isLoaded() || !EpicFightHelper.attack()) {
                        ClientNetworking.sendActiveBodyPart(BODYPARTS[i], true);
                        this.mc.field_1761.method_2918((class_1657)player, class_12972);
                    } else {
                        entityAct = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 1000);
                    this.lastWeaponSolid[i] = true;
                }
                inAnEntity = true;
            }
            this.lastHitEntities[i] = speed > speedTreshhold ? mobs : Collections.emptyList();
            int n = i;
            this.canAct[n] = this.canAct[n] & !inAnEntity;
            if (isHand && this.dh.climbTracker.isClimbeyClimb() && (!isTool || c == 0 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) || c == 1 && VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT))) {
                this.lastHandPos[i] = null;
                this.lastHandRot[i] = null;
                continue;
            }
            class_3965 blockHit = null;
            Object var28_31 = null;
            this.lastMiningPointHit[i] = 0;
            Quaternionf weaponRotation = new Quaternionf().setFromNormalized((Matrix4fc)this.dh.vrPlayer.vrdata_world_pre.getHand(c).getMatrix());
            if (this.canAct[i]) {
                this.miningPoints[i] = new ArrayList<class_243>();
                if (this.lastHandPos[i] != null && prevMiningPoint != null) {
                    float dot = Math.abs(weaponRotation.dot(this.lastHandRot[i]));
                    float angle = 2.0f * (float)Math.acos(dot);
                    float subdivisions = class_3532.method_15375((float)(angle / (float)Math.PI * 8.0f));
                    Quaternionf temp = new Quaternionf();
                    Vector3f lerpHandDir = new Vector3f();
                    this.miningPoints[i].add(prevMiningPoint);
                    int s = 1;
                    while ((float)s < subdivisions) {
                        float lerp = (float)s / subdivisions;
                        this.lastHandRot[i].slerp((Quaternionfc)weaponRotation, lerp, temp);
                        class_243 lerpHand = MathUtils.vecDLerp(this.lastHandPos[i], handPos, lerp);
                        temp.transform(0.0f, 0.0f, -weaponLength, lerpHandDir);
                        this.miningPoints[i].add(lerpHand.method_1031((double)lerpHandDir.x, (double)lerpHandDir.y, (double)lerpHandDir.z));
                        ++s;
                    }
                } else {
                    this.miningPoints[i].add(this.miningPoint[i]);
                }
                this.miningPoints[i].add(this.miningPoint[i]);
                for (int p = 1; p < this.miningPoints[i].size(); ++p) {
                    class_243 endPos;
                    class_243 startPos = this.miningPoints[i].get(p - 1);
                    if (startPos.method_1020(endPos = this.miningPoints[i].get(p)).method_1027() < 1.0E-7) {
                        endPos = endPos.method_1031(0.001, 0.001, 0.001);
                    }
                    blockHit = this.mc.field_1687.method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
                    class_2680 class_26802 = this.mc.field_1687.method_8320(blockHit.method_17777());
                    ClientNetworking.BODY_PART_CLIENT_OVERRIDE = BODYPARTS[i];
                    boolean mineableByItem = this.dh.vrSettings.swordBlockCollision && (itemstack.method_7951(class_26802) || class_26802.method_26165((class_1657)player, (class_1922)player.method_37908(), blockHit.method_17777()) == 1.0f);
                    ClientNetworking.BODY_PART_CLIENT_OVERRIDE = null;
                    boolean protectedBlock = this.dh.vrSettings.realisticClimbEnabled && (class_26802.method_26204() instanceof class_2399 || class_26802.method_26204() instanceof class_2541 || class_26802.method_26164(ViveBlockTags.VIVECRAFT_CLIMBABLE));
                    this.lastMiningPointHit[i] = p;
                    if (isSword && !mineableByItem || protectedBlock) {
                        blockHit = null;
                        Object var28_34 = null;
                        continue;
                    }
                    if (blockHit.method_17783() == class_239.class_240.field_1332) break;
                }
            }
            this.lastHandPos[i] = handPos;
            this.lastHandRot[i] = weaponRotation;
            if (blockHit != null && blockHit.method_17783() == class_239.class_240.field_1332 && !blockHit.method_17781() && this.canAct[i]) {
                void var28_32;
                this.lastWeaponSolid[i] = true;
                this.lastBlockHit[i] = blockHit.method_17784();
                int totalHits = 3;
                if (!this.dh.vrSettings.doorHitting || !this.isOpenable((class_2680)var28_32, blockHit.method_17780()) || this.mc.field_1761.method_2896(player, c == 1 ? class_1268.field_5810 : class_1268.field_5808, blockHit) == class_1269.field_5811) {
                    if (isHand && (item instanceof class_1794 || itemstack.method_31573(ViveItemTags.VIVECRAFT_HOES) || itemstack.method_31573(ViveItemTags.VIVECRAFT_SCYTHES)) && (var28_32.method_26204() instanceof class_2302 || var28_32.method_26204() instanceof class_2513 || var28_32.method_26204() instanceof class_2195 || var28_32.method_26164(ViveBlockTags.VIVECRAFT_CROPS) || item.method_7884(new class_1838((class_1657)player, c == 0 ? class_1268.field_5808 : class_1268.field_5810, blockHit)).method_23666())) {
                        boolean useSuccessful = this.mc.field_1761.method_2896(player, i == 0 ? class_1268.field_5808 : class_1268.field_5810, blockHit).method_23666();
                        if (itemstack.method_31573(ViveItemTags.VIVECRAFT_SCYTHES) && !useSuccessful) {
                            this.mc.field_1761.method_2919((class_1657)player, c == 0 ? class_1268.field_5808 : class_1268.field_5810);
                        }
                    } else if (isHand && item instanceof class_8162) {
                        ((class_8162)item).method_49184(player.method_37908(), blockHit, (class_2680)var28_32, player.method_5828(0.0f), c == 0 ? player.method_6068() : player.method_6068().method_5928());
                        player.method_37908().method_45447((class_1657)player, blockHit.method_17777(), var28_32.method_26204() instanceof class_8170 ? ((class_8170)var28_32.method_26204()).method_49811() : class_3417.field_43155, class_3419.field_15245);
                        this.mc.field_1761.method_2896(player, c == 0 ? class_1268.field_5808 : class_1268.field_5810, blockHit);
                    } else if (var28_32.method_26204() instanceof class_2428 || var28_32.method_26164(ViveBlockTags.VIVECRAFT_MUSIC_BLOCKS)) {
                        this.mc.field_1761.method_2902(blockHit.method_17777(), blockHit.method_17780());
                    } else {
                        totalHits = (int)((float)totalHits + Math.min(speed - speedTreshhold, 4.0f));
                        ClientNetworking.sendActiveBodyPart(BODYPARTS[i], true);
                        this.mc.field_1761.method_2910(blockHit.method_17777(), blockHit.method_17780());
                        if (this.getIsHittingBlock()) {
                            for (int hit = 0; hit < totalHits; ++hit) {
                                if (this.mc.field_1761.method_2902(blockHit.method_17777(), blockHit.method_17780())) {
                                    this.mc.field_1713.method_3054(blockHit.method_17777(), blockHit.method_17780());
                                }
                                this.clearBlockHitDelay();
                                if (!this.getIsHittingBlock()) break;
                            }
                            this.mc.field_1761.field_3716 = 0;
                        }
                        this.dh.vrPlayer.blockDust(blockHit.method_17784().field_1352, blockHit.method_17784().field_1351, blockHit.method_17784().field_1350, 3 * totalHits, blockHit.method_17777(), (class_2680)var28_32, 0.6f, 1.0f);
                    }
                }
                this.dh.vr.triggerHapticPulse(c, 250 * totalHits);
                continue;
            }
            this.lastWeaponSolid[i] = false;
        }
        ClientNetworking.resetActiveBodyPart();
        this.mc.method_16011().method_15407();
    }

    private boolean getIsHittingBlock() {
        return this.mc.field_1761.method_2923();
    }

    private void clearBlockHitDelay() {
    }

    private class_243 constrain(class_243 start, class_243 end) {
        class_3965 blockhitresult = this.mc.field_1687.method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724));
        return blockhitresult.method_17783() == class_239.class_240.field_1332 ? blockhitresult.method_17784() : end;
    }

    private boolean isOpenable(class_2680 state, class_2350 direction) {
        if (state.method_26164(class_3481.field_15495) || state.method_26204() instanceof class_2323) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2323.field_10938);
            boolean open = (Boolean)state.method_11654((class_2769)class_2323.field_10945);
            class_2750 hinge = (class_2750)state.method_11654((class_2769)class_2323.field_10941);
            if (!open) {
                return facing == direction.method_10153();
            }
            return switch (direction) {
                case class_2350.field_11035 -> {
                    if (facing == class_2350.field_11039 && hinge == class_2750.field_12588 || facing == class_2350.field_11034 && hinge == class_2750.field_12586) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11043 -> {
                    if (facing == class_2350.field_11034 && hinge == class_2750.field_12588 || facing == class_2350.field_11039 && hinge == class_2750.field_12586) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11034 -> {
                    if (facing == class_2350.field_11035 && hinge == class_2750.field_12588 || facing == class_2350.field_11043 && hinge == class_2750.field_12586) {
                        yield true;
                    }
                    yield false;
                }
                case class_2350.field_11039 -> {
                    if (facing == class_2350.field_11043 && hinge == class_2750.field_12588 || facing == class_2350.field_11035 && hinge == class_2750.field_12586) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        if (state.method_26164(class_3481.field_15487) || state.method_26204() instanceof class_2533) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2533.field_11177);
            boolean open = (Boolean)state.method_11654((class_2769)class_2533.field_11631);
            return !open && direction == class_2350.field_11033 || open && direction.method_10153() == facing;
        }
        if (state.method_26164(class_3481.field_25147) || state.method_26204() instanceof class_2349) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2349.field_11177);
            boolean open = (Boolean)state.method_11654((class_2769)class_2349.field_11026);
            return !open && direction.method_10166() == facing.method_10166();
        }
        return false;
    }

    public static float getItemFade(class_746 player, class_1799 itemStack) {
        float fade = player.method_7261(0.0f) * 0.75f + 0.25f;
        if (player.method_5715()) {
            fade = 0.75f;
        }
        if (ClientDataHolderVR.getInstance().swingTracker.lastWeaponSolid[ClientDataHolderVR.getInstance().isMainHand ? 0 : 1]) {
            fade -= 0.25f;
        }
        if (itemStack != class_1799.field_8037) {
            if (player.method_6039() && player.method_6030() != itemStack) {
                fade -= 0.25f;
            }
            if (itemStack.method_7909() == class_1802.field_8255 && !player.method_6039()) {
                fade -= 0.25f;
            }
        }
        if ((double)fade < 0.1) {
            fade = 0.1f;
        }
        if (fade > 1.0f) {
            fade = 1.0f;
        }
        return fade;
    }

    @Override
    public void renderDebug(class_4587 poseStack) {
        int trackers = 2;
        if (this.dh.vrSettings.feetCollision && this.dh.vrPlayer.vrdata_world_pre.fbtMode != FBTMode.ARMS_ONLY) {
            trackers = 4;
        }
        VRData world = this.dh.vrPlayer.getVRDataWorld();
        class_243 camWorld = world.getEye(this.dh.currentPass).getPosition();
        class_243 cam = camWorld.method_1019(this.dh.vrPlayer.vrdata_world_pre.origin).method_1020(world.origin);
        for (int i = 0; i < trackers; ++i) {
            Vector3fc failColor;
            Vector3fc vector3fc = failColor = this.tipHistory[i].averageSpeed(0.33) > 3.0f * (this.mc.field_1724.method_7337() ? 1.5f : 1.0f) ? MathUtils.ORANGE : MathUtils.RED;
            if (this.miningPoints[i] != null || this.miningPoint[i] != null) {
                Object color;
                if (this.previousMiningPoints[i].isEmpty() || !((class_243)this.previousMiningPoints[i].getLast().getLeft()).equals((Object)this.miningPoint[i])) {
                    if (this.miningPoints[i] != null && this.canAct[i]) {
                        for (int p = 1; p < this.miningPoints[i].size(); ++p) {
                            Object object = color = p <= this.lastMiningPointHit[i] ? MathUtils.GREEN : MathUtils.LIGHT_GRAY;
                            if (p < this.miningPoints[i].size() - 1) {
                                color = color.mul(0.5f, new Vector3f());
                            }
                            this.previousMiningPoints[i].addLast((Pair<class_243, Vector3fc>)Pair.of((Object)this.miningPoints[i].get(p), (Object)color));
                        }
                    } else {
                        this.previousMiningPoints[i].addLast((Pair<class_243, Vector3fc>)Pair.of((Object)this.miningPoint[i], (Object)(this.canAct[i] ? MathUtils.GREEN : failColor)));
                    }
                    while (this.previousMiningPoints[i].size() > 20) {
                        this.previousMiningPoints[i].removeFirst();
                    }
                }
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.miningPoint[i], cam), 0.025f, this.canAct[i] ? MathUtils.GREEN : failColor);
                if (!this.previousMiningPoints[i].isEmpty()) {
                    Pair prev = null;
                    color = this.previousMiningPoints[i].iterator();
                    while (color.hasNext()) {
                        Pair p = (Pair)color.next();
                        DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f((class_243)p.getLeft(), cam), 0.0125f, (Vector3fc)p.getRight());
                        if (prev != null) {
                            DebugRenderHelper.renderLine(poseStack, (Vector3fc)p.getRight(), new Vector3fc[]{MathUtils.subtractToVector3f((class_243)prev.getLeft(), cam), MathUtils.subtractToVector3f((class_243)p.getLeft(), cam)});
                        }
                        prev = p;
                    }
                }
            }
            if (this.lastBlockHit[i] != null) {
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.lastBlockHit[i], camWorld), 0.025f, MathUtils.GREEN);
            }
            if (this.lastAttackAABB[i] != null) {
                DebugRenderHelper.renderAABB(poseStack, this.lastAttackAABB[i].method_989(-cam.field_1352, -cam.field_1351, -cam.field_1350), this.lastHitEntities[i].isEmpty() ? failColor : MathUtils.GREEN);
            }
            if (this.weaponTip[i] != null) {
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(this.weaponTip[i], cam), 0.025f, this.lastHitEntities[i].isEmpty() ? failColor : MathUtils.GREEN);
            }
            for (class_1297 entity : this.lastHitEntities[i]) {
                DebugRenderHelper.renderCube(poseStack, (Vector3fc)MathUtils.subtractToVector3f(entity.method_5829().method_1005(), camWorld), (float)entity.method_5829().method_995() / 2.0f, MathUtils.GREEN);
            }
        }
    }
}

