/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_970;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client.ClientVRPlayers;
import org.vivecraft.client.render.HMDLayer;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.VRPlayerModel_WithArms;
import org.vivecraft.client.render.VRPlayerModel_WithArmsLegs;
import org.vivecraft.client.render.armor.VRArmorLayer;
import org.vivecraft.client.render.armor.VRArmorModel_WithArms;
import org.vivecraft.client.render.armor.VRArmorModel_WithArmsLegs;
import org.vivecraft.client.utils.ScaleHelper;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRPlayerRenderer
extends class_1007 {
    private static final class_5607 VR_LAYER_DEF = class_5607.method_32110((class_5609)VRPlayerModel.createMesh(class_5605.field_27715, false), (int)64, (int)64);
    private static final class_5607 VR_LAYER_DEF_SLIM = class_5607.method_32110((class_5609)VRPlayerModel.createMesh(class_5605.field_27715, true), (int)64, (int)64);
    private static class_5607 VR_LAYER_DEF_ARMS;
    private static class_5607 VR_LAYER_DEF_ARMS_SLIM;
    private static class_5607 VR_LAYER_DEF_ARMS_LEGS;
    private static class_5607 VR_LAYER_DEF_ARMS_LEGS_SLIM;

    public static void createLayers() {
        VR_LAYER_DEF_ARMS = class_5607.method_32110((class_5609)VRPlayerModel_WithArms.createMesh(class_5605.field_27715, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_SLIM = class_5607.method_32110((class_5609)VRPlayerModel_WithArms.createMesh(class_5605.field_27715, true), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS = class_5607.method_32110((class_5609)VRPlayerModel_WithArmsLegs.createMesh(class_5605.field_27715, false), (int)64, (int)64);
        VR_LAYER_DEF_ARMS_LEGS_SLIM = class_5607.method_32110((class_5609)VRPlayerModel_WithArmsLegs.createMesh(class_5605.field_27715, true), (int)64, (int)64);
    }

    public VRPlayerRenderer(class_5617.class_5618 context, boolean slim, ModelType type) {
        super(context, slim);
        this.field_4737 = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ModelType.VANILLA -> new VRPlayerModel(slim ? VR_LAYER_DEF_SLIM.method_32109() : VR_LAYER_DEF.method_32109(), slim);
            case ModelType.SPLIT_ARMS -> new VRPlayerModel_WithArms(slim ? VR_LAYER_DEF_ARMS_SLIM.method_32109() : VR_LAYER_DEF_ARMS.method_32109(), slim);
            case ModelType.SPLIT_ARMS_LEGS -> new VRPlayerModel_WithArmsLegs(slim ? VR_LAYER_DEF_ARMS_LEGS_SLIM.method_32109() : VR_LAYER_DEF_ARMS_LEGS.method_32109(), slim);
        };
        this.method_4046(new HMDLayer((class_3883<class_742, class_591<class_742>>)this));
        VRArmorLayer.createLayers();
        if (type != ModelType.VANILLA) {
            this.field_4738.stream().filter(layer -> layer.getClass() == class_970.class).findFirst().ifPresent(this.field_4738::remove);
            if (type == ModelType.SPLIT_ARMS) {
                this.method_4046((class_3887)new VRArmorLayer(this, new VRArmorModel_WithArms(VRArmorLayer.VR_ARMOR_DEF_ARMS_INNER.method_32109()), new VRArmorModel_WithArms(VRArmorLayer.VR_ARMOR_DEF_ARMS_OUTER.method_32109())));
            } else {
                this.method_4046((class_3887)new VRArmorLayer(this, new VRArmorModel_WithArmsLegs(VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS_INNER.method_32109()), new VRArmorModel_WithArmsLegs(VRArmorLayer.VR_ARMOR_DEF_ARMS_LEGS_OUTER.method_32109())));
            }
        }
    }

    public boolean hasLayerType(class_3887<?, ?> renderLayer) {
        return this.field_4738.stream().anyMatch(layer -> {
            if (renderLayer.getClass() == class_970.class) {
                return layer.getClass() == renderLayer.getClass() || layer.getClass() == VRArmorLayer.class;
            }
            return layer.getClass() == renderLayer.getClass();
        });
    }

    public void method_4215(class_742 player, float entityYaw, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.method_5667());
        if (rotInfo != null) {
            float scale = rotInfo.heightScale;
            if (VRState.VR_RUNNING && player == class_310.method_1551().field_1724 || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale) {
                scale *= rotInfo.worldScale / ScaleHelper.getEntityEyeHeightScale((class_1309)player, partialTick);
            }
            if (player.method_6123()) {
                float offset = player.method_5695(partialTick) / 90.0f * 0.2f;
                poseStack.method_22904(0.0, (double)(rotInfo.headPos.y() + offset), 0.0);
            }
            poseStack.method_22905(scale, scale, scale);
        }
        super.method_4215(player, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.method_22909();
    }

    public class_243 method_23206(class_742 player, float partialTick) {
        if (VREffectsHelper.isFirstPersonPlayer((class_1297)player)) {
            return player.method_20232() ? new class_243(0.0, (double)(-0.125f * ClientDataHolderVR.getInstance().vrPlayer.worldScale), 0.0) : class_243.field_1353;
        }
        return player.method_20232() ? new class_243(0.0, -0.125, 0.0) : class_243.field_1353;
    }

    public void method_4218(class_742 player) {
        super.method_4218(player);
        ((class_591)this.method_4038()).field_3400 = ((class_591)this.method_4038()).field_3400 & !player.method_20232();
        if (VREffectsHelper.isFirstPersonPlayer((class_1297)player)) {
            if (ClientDataHolderVR.getInstance().currentPass == RenderPass.CAMERA && ClientDataHolderVR.getInstance().cameraTracker.isQuickMode() && ClientDataHolderVR.getInstance().grabScreenShot) {
                this.hideHand(class_1306.field_6182, true);
                this.hideHand(class_1306.field_6183, true);
            }
            if (VREffectsHelper.isFirstPersonEntityPass()) {
                ((class_591)this.method_4038()).field_3398.field_3665 = false;
                ((class_591)this.method_4038()).field_3394.field_3665 = false;
                if (ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.COMPLETE) {
                    this.hideHand(class_1306.field_6182, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                    this.hideHand(class_1306.field_6183, ClientDataHolderVR.getInstance().vrSettings.modelArmsMode == VRSettings.ModelArmsMode.OFF);
                } else {
                    boolean leftHanded = ClientDataHolderVR.getInstance().vrSettings.reverseHands;
                    if (ClientDataHolderVR.getInstance().menuHandOff) {
                        this.hideHand(leftHanded ? class_1306.field_6183 : class_1306.field_6182, false);
                    }
                    if (ClientDataHolderVR.getInstance().menuHandMain) {
                        this.hideHand(leftHanded ? class_1306.field_6182 : class_1306.field_6183, false);
                    }
                }
            }
        }
    }

    private void hideHand(class_1306 arm, boolean completeArm) {
        class_583 class_5832 = this.method_4038();
        if (class_5832 instanceof VRPlayerModel) {
            VRPlayerModel vrModel = (VRPlayerModel)class_5832;
            if (arm == class_1306.field_6182) {
                vrModel.hideLeftArm(completeArm);
            } else {
                vrModel.hideRightArm(completeArm);
            }
        } else if (arm == class_1306.field_6182) {
            ((class_591)this.method_4038()).field_27433.field_3665 = false;
            ((class_591)this.method_4038()).field_3484.field_3665 = false;
        } else {
            ((class_591)this.method_4038()).field_3401.field_3665 = false;
            ((class_591)this.method_4038()).field_3486.field_3665 = false;
        }
    }

    protected void method_4212(class_742 player, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        if (ClientDataHolderVR.getInstance().currentPass != RenderPass.GUI && ClientVRPlayers.getInstance().isVRPlayer((class_1297)player)) {
            if (player == class_310.method_1551().field_1724) {
                rotationYaw = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld().getBodyYaw();
            } else {
                ClientVRPlayers.RotInfo rotInfo = ClientVRPlayers.getInstance().getRotationsForPlayer(player.method_5667());
                rotationYaw = 57.295776f * rotInfo.getBodyYawRad();
            }
        }
        super.method_4212(player, poseStack, ageInTicks, rotationYaw, partialTick);
    }

    static {
        VRPlayerRenderer.createLayers();
    }

    public static enum ModelType {
        VANILLA,
        SPLIT_ARMS,
        SPLIT_ARMS_LEGS;

    }
}

