/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.PlayerExtension;
import org.vivecraft.client_vr.gameplay.VRPlayer;
import org.vivecraft.client_vr.gameplay.trackers.JumpTracker;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.common.network.packet.c2s.ClimbingPayloadC2S;
import org.vivecraft.data.ViveBlockTags;
import org.vivecraft.server.config.enums.ClimbeyBlockmode;

public class ClimbTracker
implements Tracker {
    public static final ResourceLocation CLAWS_MODEL = ResourceLocation.fromNamespaceAndPath((String)"vivecraft", (String)"climb_claws");
    public Set<Block> blocklist = new HashSet<Block>();
    public ClimbeyBlockmode serverBlockmode = ClimbeyBlockmode.DISABLED;
    public boolean forceActivate = false;
    public int latchStartController = -1;
    public Vec3[] latchStart = new Vec3[]{Vec3.ZERO, Vec3.ZERO};
    public Vector3f[] latchStart_room = new Vector3f[]{new Vector3f(), new Vector3f()};
    public Vec3[] latchStartBody = new Vec3[]{Vec3.ZERO, Vec3.ZERO};
    private boolean gravityOverride = false;
    private boolean wantJump = false;
    private final boolean[] latched = new boolean[2];
    private final boolean[] wasInBlock = new boolean[2];
    private final boolean[] wasButton = new boolean[2];
    private final boolean[] wasLatched = new boolean[2];
    private final AABB[] box = new AABB[2];
    private final AABB[] latchBox = new AABB[2];
    private final boolean[] inBlock = new boolean[2];
    private final Direction[] grabDirection = new Direction[2];
    private final AABB northBB = new AABB(0.1, 0.0, 0.9, 0.9, 1.0, 1.1);
    private final AABB southBB = new AABB(0.1, 0.0, -0.1, 0.9, 1.0, 0.1);
    private final AABB westBB = new AABB(0.9, 0.0, 0.1, 1.1, 1.0, 0.9);
    private final AABB eastBB = new AABB(-0.1, 0.0, 0.1, 0.1, 1.0, 0.9);
    private final AABB upBB = new AABB(0.0, 0.9, 0.0, 1.0, 1.1, 1.0);
    private final AABB fullBB = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private final Random rand = new Random();
    private boolean unsetFlag;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public ClimbTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    public boolean isGrabbingLadder() {
        return this.latched[0] || this.latched[1];
    }

    public boolean wasGrabbingLadder() {
        return this.wasLatched[0] || this.latched[1];
    }

    public boolean isGrabbingLadder(int controller) {
        return this.latched[controller];
    }

    public boolean wasGrabbingLadder(int controller) {
        return this.wasLatched[controller];
    }

    public boolean isClimbeyClimb() {
        return this.isActive(this.mc.player) && ClimbTracker.hasClimbeyClimbEquipped((Player)this.mc.player);
    }

    public static boolean hasClimbeyClimbEquipped(Player player) {
        return ClientNetworking.SERVER_ALLOWS_CLIMBEY && (ClimbTracker.isClaws(player.getMainHandItem()) || ClimbTracker.isClaws(player.getOffhandItem()));
    }

    public static boolean isClaws(ItemStack itemStack) {
        TranslatableContents translatableContent;
        ComponentContents componentContents;
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        if (!itemStack.has(DataComponents.CUSTOM_NAME)) {
            return false;
        }
        if (itemStack.getItem() != Items.SHEARS) {
            return false;
        }
        if (!itemStack.has(DataComponents.UNBREAKABLE)) {
            return false;
        }
        return itemStack.getHoverName().getString().equals("Climb Claws") || (componentContents = itemStack.getHoverName().getContents()) instanceof TranslatableContents && (translatableContent = (TranslatableContents)componentContents).getKey().equals("vivecraft.item.climbclaws");
    }

    private static boolean canStand(BlockPos blockPos, LocalPlayer player) {
        VoxelShape blockShape = player.level().getBlockState(blockPos).getCollisionShape((BlockGetter)player.level(), blockPos);
        if (blockShape.isEmpty() || blockShape.bounds().maxY != 0.0) {
            BlockPos above = blockPos.above();
            VoxelShape aboveBlockShape = player.level().getBlockState(above).getCollisionShape((BlockGetter)player.level(), above);
            if (aboveBlockShape.isEmpty() || aboveBlockShape.bounds().maxY > 0.0) {
                return false;
            }
            BlockPos above2 = above.above();
            VoxelShape above2BlockShape = player.level().getBlockState(above2).getCollisionShape((BlockGetter)player.level(), above2);
            return above2BlockShape.isEmpty() || above2BlockShape.bounds().maxY <= 0.0;
        }
        return false;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrPlayer.getFreeMove() && !this.dh.vrSettings.simulateFalling) {
            return false;
        }
        if (!this.dh.vrSettings.realisticClimbEnabled) {
            return false;
        }
        if (player == null && !player.isAlive()) {
            return false;
        }
        if (this.mc.gameMode == null) {
            return false;
        }
        if (player.isPassenger()) {
            return false;
        }
        return ClimbTracker.hasClimbeyClimbEquipped((Player)player) || player.zza == 0.0f && player.xxa == 0.0f;
    }

    @Override
    public void idleProcess(LocalPlayer player) {
        if (!this.isActive(player)) {
            this.wasLatched[0] = false;
            this.wasLatched[1] = false;
        }
        if (this.wasGrabbingLadder() && !this.isGrabbingLadder()) {
            this.forceActivate = true;
        } else if (player.onGround() || player.getAbilities().flying) {
            this.forceActivate = false;
        }
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.RIGHT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inBlock[0] || this.forceActivate));
        this.dh.vr.getInputAction(VivecraftVRMod.INSTANCE.keyClimbeyGrab).setEnabled(ControllerType.LEFT, this.isClimbeyClimb() && (this.isGrabbingLadder() || this.inBlock[1] || this.forceActivate));
    }

    @Override
    public void inactiveProcess(LocalPlayer player) {
        this.latchStartController = -1;
        this.latched[0] = false;
        this.latched[1] = false;
        player.setNoGravity(false);
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        int c;
        boolean[] button = new boolean[2];
        boolean[] allowed = new boolean[2];
        Vec3[] controllerPos = new Vec3[2];
        boolean nope = false;
        boolean grabbed = false;
        boolean jump = false;
        boolean ladder = false;
        for (c = 0; c < 2; ++c) {
            controllerPos[c] = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition();
            Vector3f controllerDir = this.dh.vrPlayer.vrdata_world_pre.getController(c).getDirection();
            this.inBlock[c] = false;
            BlockPos blockPos = BlockPos.containing((Position)controllerPos[c]);
            BlockState blockState = this.mc.level.getBlockState(blockPos);
            Block block = blockState.getBlock();
            VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)this.mc.level, blockPos);
            this.box[c] = voxelShape.isEmpty() ? null : voxelShape.bounds();
            if (!this.dh.climbTracker.isClimbeyClimb()) {
                BlockPos blockPos2;
                Object blockState2;
                Block block2;
                boolean ok;
                Vec3 controllerPosNear = this.dh.vrPlayer.vrdata_world_pre.getController(c).getPosition().subtract((double)(controllerDir.x * 0.2f), (double)(controllerDir.y * 0.2f), (double)(controllerDir.z * 0.2f));
                AABB controllerBB = new AABB(controllerPos[c], controllerPosNear);
                ladder = true;
                boolean bl = ok = block instanceof LadderBlock || this.isClimbableTrapdoor((Level)this.mc.level, blockPos, blockState) || block instanceof VineBlock || blockState.is(ViveBlockTags.VIVECRAFT_CLIMBABLE);
                if (!ok && ((block2 = (blockState2 = this.mc.level.getBlockState(blockPos2 = BlockPos.containing((Position)controllerPosNear))).getBlock()) instanceof LadderBlock || this.isClimbableTrapdoor((Level)this.mc.level, blockPos2, (BlockState)blockState2) || block2 instanceof VineBlock || blockState2.is(ViveBlockTags.VIVECRAFT_CLIMBABLE))) {
                    blockPos = blockPos2;
                    blockState = blockState2;
                    block = block2;
                    controllerPos[c] = controllerPosNear;
                    VoxelShape voxelShape2 = blockState2.getCollisionShape((BlockGetter)this.mc.level, blockPos2);
                    if (voxelShape2.isEmpty()) {
                        this.box[c] = null;
                    } else {
                        ok = true;
                        this.box[c] = voxelShape2.bounds();
                    }
                }
                if (ok) {
                    ArrayList<AABB> BBs = new ArrayList<AABB>();
                    if (block instanceof LadderBlock || block instanceof HorizontalDirectionalBlock) {
                        switch ((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)) {
                            case EAST: {
                                BBs.add(this.eastBB);
                                break;
                            }
                            case NORTH: {
                                BBs.add(this.northBB);
                                break;
                            }
                            case SOUTH: {
                                BBs.add(this.southBB);
                                break;
                            }
                            case WEST: {
                                BBs.add(this.westBB);
                                break;
                            }
                            default: {
                                ok = false;
                            }
                        }
                    }
                    if (block instanceof VineBlock) {
                        this.box[c] = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                        if (((Boolean)blockState.getValue((Property)VineBlock.NORTH)).booleanValue() && this.mc.level.getBlockState(blockPos.north()).canOcclude()) {
                            BBs.add(this.southBB);
                        }
                        if (((Boolean)blockState.getValue((Property)VineBlock.EAST)).booleanValue() && this.mc.level.getBlockState(blockPos.east()).canOcclude()) {
                            BBs.add(this.westBB);
                        }
                        if (((Boolean)blockState.getValue((Property)VineBlock.SOUTH)).booleanValue() && this.mc.level.getBlockState(blockPos.south()).canOcclude()) {
                            BBs.add(this.northBB);
                        }
                        if (((Boolean)blockState.getValue((Property)VineBlock.WEST)).booleanValue() && this.mc.level.getBlockState(blockPos.west()).canOcclude()) {
                            BBs.add(this.eastBB);
                        }
                    }
                    this.inBlock[c] = false;
                    if (ok) {
                        blockState2 = BBs.iterator();
                        while (blockState2.hasNext()) {
                            AABB aabb2 = (AABB)blockState2.next();
                            if (!controllerBB.intersects(aabb2.move(blockPos))) continue;
                            this.inBlock[c] = true;
                            if (aabb2 == this.northBB) {
                                this.grabDirection[c] = Direction.NORTH;
                            } else if (aabb2 == this.southBB) {
                                this.grabDirection[c] = Direction.SOUTH;
                            } else if (aabb2 == this.eastBB) {
                                this.grabDirection[c] = Direction.EAST;
                            } else if (aabb2 == this.westBB) {
                                this.grabDirection[c] = Direction.WEST;
                            }
                            break;
                        }
                    }
                } else {
                    Vec3 handToLatch = this.latchStart[c].subtract(controllerPos[c]);
                    if (handToLatch.length() > 0.5) {
                        this.inBlock[c] = false;
                    } else {
                        BlockPos latchBlockPos = BlockPos.containing((Position)this.latchStart[c]);
                        BlockState latchBlockState = this.mc.level.getBlockState(latchBlockPos);
                        this.inBlock[c] = this.wasInBlock[c] && latchBlockState.getBlock() instanceof LadderBlock || latchBlockState.getBlock() instanceof VineBlock || latchBlockState.is(ViveBlockTags.VIVECRAFT_CLIMBABLE);
                    }
                }
                button[c] = this.inBlock[c];
                allowed[c] = this.inBlock[c];
            } else {
                Vec3 handToLatch;
                if (this.mc.player.onGround()) {
                    this.mc.player.setOnGround(!this.latched[0] && !this.latched[1]);
                }
                button[c] = c == 0 ? VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.RIGHT) : VivecraftVRMod.INSTANCE.keyClimbeyGrab.isDown(ControllerType.LEFT);
                boolean bl = this.inBlock[c] = this.box[c] != null && this.box[c].move(blockPos).contains(controllerPos[c]);
                if (!this.inBlock[c] && (handToLatch = this.latchStart[c].subtract(controllerPos[c])).length() > 0.5) {
                    button[c] = false;
                }
                allowed[c] = this.allowed(blockState);
            }
            this.wasLatched[c] = this.latched[c];
            if (!button[c] && this.latched[c]) {
                this.latched[c] = false;
                if (c == 0) {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                } else {
                    VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
                }
                jump = true;
            }
            if (!this.latched[c] && !nope && allowed[c]) {
                if (!this.wasInBlock[c] && this.inBlock[c]) {
                    this.dh.vr.triggerHapticPulse(c, 750);
                }
                if (!this.wasInBlock[c] && this.inBlock[c] && button[c] || !this.wasButton[c] && button[c] && this.inBlock[c]) {
                    grabbed = true;
                    this.wantJump = false;
                    this.latchStart[c] = controllerPos[c];
                    this.latchStart_room[c] = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPositionF();
                    this.latchStartBody[c] = player.position();
                    this.latchStartController = c;
                    this.latchBox[c] = this.box[c];
                    this.latched[c] = true;
                    if (c == 0) {
                        this.latched[1] = false;
                        nope = true;
                    } else {
                        this.latched[0] = false;
                    }
                    this.dh.vr.triggerHapticPulse(c, 2000);
                    ((PlayerExtension)this.mc.player).vivecraft$stepSound(blockPos, this.latchStart[c]);
                    if (!ladder) {
                        this.dh.vrPlayer.blockDust(this.latchStart[c].x, this.latchStart[c].y, this.latchStart[c].z, 5, blockPos, blockState, 0.1f, 0.2f);
                    }
                }
            }
            this.wasButton[c] = button[c];
            this.wasInBlock[c] = this.inBlock[c];
        }
        if (!this.latched[0] && !this.latched[1]) {
            for (c = 0; c < 2; ++c) {
                if (!this.inBlock[c] || !button[c] || !allowed[c]) continue;
                grabbed = true;
                this.latchStart[c] = controllerPos[c];
                this.latchStart_room[c] = this.dh.vrPlayer.vrdata_room_pre.getController(c).getPositionF();
                this.latchStartBody[c] = player.position();
                this.latchStartController = c;
                this.latched[c] = true;
                this.latchBox[c] = this.box[c];
                this.wantJump = false;
                this.dh.vr.triggerHapticPulse(c, 2000);
                if (ladder) continue;
                BlockPos blockPos = BlockPos.containing((Position)this.latchStart[c]);
                BlockState blockState = this.mc.level.getBlockState(blockPos);
                this.dh.vrPlayer.blockDust(this.latchStart[c].x, this.latchStart[c].y, this.latchStart[c].z, 5, blockPos, blockState, 0.1f, 0.2f);
            }
        }
        if (!this.wantJump && !ladder) {
            this.wantJump = VivecraftVRMod.INSTANCE.keyClimbeyJump.isDown() && JumpTracker.hasClimbeyJumpEquipped((Player)player);
        }
        jump &= this.wantJump;
        if ((this.latched[0] || this.latched[1]) && !this.gravityOverride) {
            this.unsetFlag = true;
            player.setNoGravity(true);
            this.gravityOverride = true;
        }
        if (!this.latched[0] && !this.latched[1] && this.gravityOverride) {
            player.setNoGravity(false);
            this.gravityOverride = false;
        }
        if (!(this.latched[0] || this.latched[1] || jump)) {
            if (player.onGround() && this.unsetFlag) {
                this.unsetFlag = false;
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.RIGHT);
                VivecraftVRMod.INSTANCE.keyClimbeyGrab.unpressKey(ControllerType.LEFT);
            }
            this.latchStartController = -1;
            return;
        }
        if ((this.latched[0] || this.latched[1]) && this.rand.nextInt(20) == 10) {
            this.mc.player.causeFoodExhaustion(0.1f);
            if (!ladder) {
                BlockPos blockPos = BlockPos.containing((Position)this.latchStart[this.latchStartController]);
                BlockState blockState = this.mc.level.getBlockState(blockPos);
                this.dh.vrPlayer.blockDust(this.latchStart[this.latchStartController].x, this.latchStart[this.latchStartController].y, this.latchStart[this.latchStartController].z, 1, blockPos, blockState, 0.1f, 0.2f);
            }
        }
        Vec3 now = this.dh.vrPlayer.vrdata_world_pre.getController(this.latchStartController).getPosition();
        Vec3 start = VRPlayer.roomToWorldPos((Vector3fc)this.latchStart_room[this.latchStartController], this.dh.vrPlayer.vrdata_world_pre);
        Vec3 delta = now.subtract(start);
        this.latchStart_room[this.latchStartController] = this.dh.vrPlayer.vrdata_room_pre.getController(this.latchStartController).getPositionF();
        if (this.wantJump) {
            this.dh.vr.triggerHapticPulse(this.latchStartController, 200);
        }
        if (!jump) {
            if (grabbed) {
                player.setDeltaMovement(0.0, 0.0, 0.0);
            } else {
                player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
            }
            player.fallDistance = 0.0f;
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            double newX = x;
            double newY = y - delta.y;
            double newZ = z;
            BlockPos blockPos = BlockPos.containing((Position)this.latchStart[this.latchStartController]);
            if (!ladder) {
                newX = x - delta.x;
                newZ = z - delta.z;
            } else {
                Direction dir = this.grabDirection[this.latchStartController];
                if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                    newX = x - delta.x;
                    newZ = (float)blockPos.getZ() + 0.5f;
                    newZ += (1.0 - Math.min((double)this.dh.vrPlayer.worldScale, 1.0)) * (dir == Direction.NORTH ? 0.5 : -0.5);
                } else if (dir == Direction.EAST || dir == Direction.WEST) {
                    newZ = z - delta.z;
                    newX = (float)blockPos.getX() + 0.5f;
                    newX += (1.0 - Math.min((double)this.dh.vrPlayer.worldScale, 1.0)) * (dir == Direction.WEST ? 0.5 : -0.5);
                }
            }
            double hmd = this.dh.vrPlayer.vrdata_room_pre.getHeadPivot().y;
            double controller = this.dh.vrPlayer.vrdata_room_pre.getController((int)this.latchStartController).getPosition().y;
            if (!this.wantJump && this.latchBox[this.latchStartController] != null && controller <= hmd / 2.0 && this.latchStart[this.latchStartController].y > this.latchBox[this.latchStartController].maxY * 0.8 + (double)blockPos.getY()) {
                Vector3f horizontalDir = this.dh.vrPlayer.vrdata_world_pre.hmd.getDirection();
                horizontalDir.y = 0.0f;
                horizontalDir.normalize().mul(0.1f);
                boolean ok = this.mc.level.noCollision((Entity)player, player.getBoundingBox().move((double)horizontalDir.x, this.latchBox[this.latchStartController].maxY + (double)blockPos.getY() - player.getY(), (double)horizontalDir.z));
                if (ok) {
                    newX = player.getX() + (double)horizontalDir.x;
                    newY = this.latchBox[this.latchStartController].maxY + (double)blockPos.getY();
                    newZ = player.getZ() + (double)horizontalDir.z;
                    this.latchStartController = -1;
                    this.latched[0] = false;
                    this.latched[1] = false;
                    this.wasInBlock[0] = false;
                    this.wasInBlock[1] = false;
                    player.setNoGravity(false);
                }
            }
            boolean free = false;
            for (int i = 0; i < 8; ++i) {
                double ax = newX;
                double ay = newY;
                double az = newZ;
                switch (i) {
                    case 2: {
                        ay = y;
                        break;
                    }
                    case 3: {
                        az = z;
                        break;
                    }
                    case 4: {
                        ax = x;
                        break;
                    }
                    case 5: {
                        ax = x;
                        az = z;
                        break;
                    }
                    case 6: {
                        ax = x;
                        ay = y;
                        break;
                    }
                    case 7: {
                        ay = y;
                        az = z;
                        break;
                    }
                }
                player.setPos(ax, ay, az);
                AABB bb = player.getBoundingBox();
                free = this.mc.level.noCollision((Entity)player, bb);
                if (!free) continue;
                if (i <= 1) break;
                this.dh.vr.triggerHapticPulse(0, 100);
                this.dh.vr.triggerHapticPulse(1, 100);
                break;
            }
            if (!free) {
                player.setPos(x, y, z);
                this.dh.vr.triggerHapticPulse(0, 100);
                this.dh.vr.triggerHapticPulse(1, 100);
            }
            ClientNetworking.sendServerPacket(new ClimbingPayloadC2S());
        } else {
            this.wantJump = false;
            Vec3 p1 = player.position().subtract(delta);
            Vector3f movement = this.dh.vr.controllerHistory[this.latchStartController].netMovement(0.3);
            float speed = this.dh.vr.controllerHistory[this.latchStartController].averageSpeed(0.3f);
            movement.mul(0.66f * speed);
            float limit = 0.66f;
            if (movement.length() > 0.66f) {
                movement.mul(0.66f / movement.length());
            }
            if (player.hasEffect(MobEffects.JUMP)) {
                movement.mul((float)player.getEffect(MobEffects.JUMP).getAmplifier() + 1.5f);
            }
            movement.rotateY(this.dh.vrPlayer.vrdata_world_pre.rotation_radians);
            player.setDeltaMovement((double)(-movement.x), (double)(-movement.y), (double)(-movement.z));
            player.xOld = p1.x;
            player.yOld = p1.y;
            player.zOld = p1.z;
            p1 = p1.add(player.getDeltaMovement().x, player.getDeltaMovement().y, player.getDeltaMovement().z);
            player.setPos(p1.x, p1.y, p1.z);
            this.dh.vrPlayer.snapRoomOriginToPlayerEntity((Entity)player, false, false);
            this.mc.player.causeFoodExhaustion(0.3f);
        }
    }

    private boolean isClimbableTrapdoor(Level level, BlockPos blockPos, BlockState blockState) {
        if (blockState.getBlock() instanceof TrapDoorBlock && ((Boolean)blockState.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
            BlockState blockStateBelow = level.getBlockState(blockPos.below());
            return blockStateBelow.is(Blocks.LADDER) && blockStateBelow.getValue((Property)LadderBlock.FACING) == blockState.getValue((Property)TrapDoorBlock.FACING);
        }
        return false;
    }

    private boolean allowed(BlockState bs) {
        return switch (this.serverBlockmode) {
            default -> throw new MatchException(null, null);
            case ClimbeyBlockmode.DISABLED -> true;
            case ClimbeyBlockmode.WHITELIST -> this.blocklist.contains(bs.getBlock());
            case ClimbeyBlockmode.BLACKLIST -> !this.blocklist.contains(bs.getBlock());
        };
    }
}

