/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.trackers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.Tracker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.utils.MathUtils;

public class SwimTracker
implements Tracker {
    private static final float FRICTION = 0.9f;
    private static final float RISE_SPEED = 0.005f;
    private static final float SWIM_SPEED = 1.3f;
    private Vector3f motion = new Vector3f();
    private double lastDist;
    private final Minecraft mc;
    private final ClientDataHolderVR dh;

    public SwimTracker(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public boolean isActive(LocalPlayer player) {
        if (this.dh.vrSettings.seated) {
            return false;
        }
        if (!this.dh.vrSettings.realisticSwimEnabled) {
            return false;
        }
        if (this.mc.screen != null) {
            return false;
        }
        if (player == null || !player.isAlive()) {
            return false;
        }
        if (this.mc.gameMode == null) {
            return false;
        }
        if (!player.isInWater() && !player.isInLava()) {
            return false;
        }
        return player.zza == 0.0f && player.xxa == 0.0f;
    }

    @Override
    public Tracker.ProcessType processType() {
        return Tracker.ProcessType.PER_TICK;
    }

    @Override
    public void activeProcess(LocalPlayer player) {
        Vec3 controllerR = this.dh.vrPlayer.vrdata_world_pre.getController(0).getPosition();
        Vec3 controllerL = this.dh.vrPlayer.vrdata_world_pre.getController(1).getPosition();
        Vec3 middle = controllerL.subtract(controllerR).scale(0.5).add(controllerR);
        Vec3 hmdPos = this.dh.vrPlayer.vrdata_world_pre.getHeadPivot().subtract(0.0, 0.3, 0.0);
        Vector3f moveDir = MathUtils.subtractToVector3f(middle, hmdPos).normalize().add((Vector3fc)this.dh.vrPlayer.vrdata_world_pre.hmd.getDirection()).mul(0.5f);
        Vector3f controllerDir = this.dh.vrPlayer.vrdata_world_pre.getController(0).getCustomVector(MathUtils.BACK).add((Vector3fc)this.dh.vrPlayer.vrdata_world_pre.getController(1).getCustomVector(MathUtils.BACK)).mul(0.5f);
        float dirFactor = controllerDir.add((Vector3fc)moveDir).length() * 0.5f;
        double distance = hmdPos.distanceTo(middle);
        double distDelta = this.lastDist - distance;
        if (distDelta > 0.0) {
            Vector3f velocity = moveDir.mul((float)distDelta * 1.3f * dirFactor).mul(0.15f);
            this.motion = this.motion.add((Vector3fc)velocity);
        }
        this.lastDist = distance;
        player.setSwimming((double)this.motion.length() > 0.3);
        player.setSprinting((double)this.motion.length() > 1.0);
        player.push((double)this.motion.x, (double)this.motion.y, (double)this.motion.z);
        this.motion = this.motion.mul(0.9f);
    }
}

