/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.vivecraft.client_vr.provider.ControllerType;

public class VRArmRenderer
extends PlayerRenderer {
    public float armAlpha = 1.0f;

    public VRArmRenderer(EntityRendererProvider.Context context, boolean useSlimModel) {
        super(context, useSlimModel);
    }

    public void renderRightHand(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, ResourceLocation resourceLocation, boolean sleeve) {
        this.renderHand(ControllerType.RIGHT, poseStack, buffer, combinedLight, resourceLocation, ((PlayerModel)this.model).rightArm, sleeve);
    }

    public void renderLeftHand(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, ResourceLocation resourceLocation, boolean sleeve) {
        this.renderHand(ControllerType.LEFT, poseStack, buffer, combinedLight, resourceLocation, ((PlayerModel)this.model).leftArm, sleeve);
    }

    private void renderHand(ControllerType side, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, ResourceLocation resourceLocation, ModelPart rendererArm, boolean sleeve) {
        PlayerModel playermodel = (PlayerModel)this.getModel();
        RenderSystem.enableBlend();
        RenderSystem.enableCull();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        rendererArm.resetPose();
        rendererArm.visible = true;
        playermodel.leftSleeve.visible = sleeve;
        playermodel.rightSleeve.visible = sleeve;
        rendererArm.render(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)resourceLocation)), combinedLight, OverlayTexture.NO_OVERLAY, ARGB.white((float)this.armAlpha));
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

