/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity.projectile;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;
import org.vivecraft.server.config.enums.HeadshotIndicator;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity {
    @Shadow
    private double baseDamage;

    public AbstractArrowMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void vivecraft$startPos(CallbackInfo ci, @Local(argsOnly=true) LivingEntity owner) {
        ServerPlayer player;
        ServerVivePlayer serverVivePlayer;
        if (owner instanceof ServerPlayer && (serverVivePlayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)owner)) != null && serverVivePlayer.isVR()) {
            this.setPos(serverVivePlayer.getAimPos(true));
        }
    }

    @Inject(method={"onHitEntity(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="HEAD")})
    private void vivecraft$damageMultiplier(EntityHitResult entityHitResult, CallbackInfo ci) {
        Entity entity = ((Projectile)this).getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            ServerVivePlayer serverVivePlayer = ServerVRPlayers.getVivePlayer(owner);
            double multiplier = 1.0;
            Vec3 hitPos = this.vivecraft$isHeadshot(entityHitResult);
            if (hitPos != null) {
                multiplier = serverVivePlayer != null && serverVivePlayer.isVR() ? (serverVivePlayer.isSeated() ? ((Double)ServerConfig.BOW_SEATED_HEADSHOT_MULTIPLIER.get()).doubleValue() : ((Double)ServerConfig.BOW_STANDING_HEADSHOT_MULTIPLIER.get()).doubleValue()) : (Double)ServerConfig.BOW_VANILLA_HEADSHOT_MULTIPLIER.get();
                if (multiplier > 1.0 && ServerConfig.BOW_HEADSHOT_INDICATOR.get() != HeadshotIndicator.NONE) {
                    if (ServerConfig.BOW_HEADSHOT_INDICATOR.get() != HeadshotIndicator.AUDIO) {
                        ((ServerLevel)this.level()).sendParticles(owner, (ParticleOptions)ParticleTypes.CRIT, true, true, hitPos.x, hitPos.y, hitPos.z, 5, -this.getDeltaMovement().x, -this.getDeltaMovement().y, -this.getDeltaMovement().z, 0.1);
                    }
                    if (ServerConfig.BOW_HEADSHOT_INDICATOR.get() != HeadshotIndicator.VISUAL) {
                        owner.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.ITEM_BREAK), SoundSource.PLAYERS, owner.getX(), owner.getY(), owner.getZ(), 0.7f, 0.5f, owner.level().random.nextLong()));
                    }
                }
            }
            if (serverVivePlayer != null && serverVivePlayer.isVR()) {
                multiplier = serverVivePlayer.isSeated() ? Math.max(multiplier, (Double)ServerConfig.BOW_SEATED_MULTIPLIER.get()) : Math.max(multiplier, (Double)ServerConfig.BOW_STANDING_MULTIPLIER.get());
            }
            this.baseDamage *= multiplier;
        }
    }

    @Unique
    private Vec3 vivecraft$isHeadshot(EntityHitResult hit) {
        AABB headBox = Utils.getEntityHeadHitbox(hit.getEntity(), 0.3);
        if (headBox != null) {
            Vec3 originalHitPos = hit.getEntity().getBoundingBox().clip(this.position(), this.position().add(this.getDeltaMovement().scale(2.0))).orElse(this.position().add(this.getDeltaMovement()));
            return headBox.clip(this.position(), originalHitPos).orElse(headBox.contains(this.position()) ? this.position() : null);
        }
        return null;
    }
}

