/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRIOBuffer {
    protected VRIOBuffer() {
        throw new UnsupportedOperationException();
    }

    public static int nVRIOBuffer_Open(long pchPath, int mode, int unElementSize, int unElements, long pulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.Open;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchPath, (int)mode, (int)unElementSize, (int)unElements, (long)pulBuffer, (long)__functionAddress);
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Open(@NativeType(value="char const *") ByteBuffer pchPath, @NativeType(value="EIOBufferMode") int mode, @NativeType(value="uint32_t") int unElementSize, @NativeType(value="uint32_t") int unElements, @NativeType(value="IOBufferHandle_t *") LongBuffer pulBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchPath);
            Checks.check((Buffer)pulBuffer, (int)1);
        }
        return VRIOBuffer.nVRIOBuffer_Open(MemoryUtil.memAddress((ByteBuffer)pchPath), mode, unElementSize, unElements, MemoryUtil.memAddress((LongBuffer)pulBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Open(@NativeType(value="char const *") CharSequence pchPath, @NativeType(value="EIOBufferMode") int mode, @NativeType(value="uint32_t") int unElementSize, @NativeType(value="uint32_t") int unElements, @NativeType(value="IOBufferHandle_t *") LongBuffer pulBuffer) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pulBuffer, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchPath, true);
            long pchPathEncoded = stack.getPointerAddress();
            int n = VRIOBuffer.nVRIOBuffer_Open(pchPathEncoded, mode, unElementSize, unElements, MemoryUtil.memAddress((LongBuffer)pulBuffer));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Close(@NativeType(value="IOBufferHandle_t") long ulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.Close;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJI((long)ulBuffer, (long)__functionAddress);
    }

    public static int nVRIOBuffer_Read(long ulBuffer, long pDst, int unBytes, long punRead) {
        long __functionAddress = OpenVR.VRIOBuffer.Read;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPPI((long)ulBuffer, (long)pDst, (int)unBytes, (long)punRead, (long)__functionAddress);
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Read(@NativeType(value="IOBufferHandle_t") long ulBuffer, @NativeType(value="void *") ByteBuffer pDst, @NativeType(value="uint32_t *") IntBuffer punRead) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)punRead, (int)1);
        }
        return VRIOBuffer.nVRIOBuffer_Read(ulBuffer, MemoryUtil.memAddress((ByteBuffer)pDst), pDst.remaining(), MemoryUtil.memAddress((IntBuffer)punRead));
    }

    public static int nVRIOBuffer_Write(long ulBuffer, long pSrc, int unBytes) {
        long __functionAddress = OpenVR.VRIOBuffer.Write;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJPI((long)ulBuffer, (long)pSrc, (int)unBytes, (long)__functionAddress);
    }

    @NativeType(value="EIOBufferError")
    public static int VRIOBuffer_Write(@NativeType(value="IOBufferHandle_t") long ulBuffer, @NativeType(value="void *") ByteBuffer pSrc) {
        return VRIOBuffer.nVRIOBuffer_Write(ulBuffer, MemoryUtil.memAddress((ByteBuffer)pSrc), pSrc.remaining());
    }

    @NativeType(value="PropertyContainerHandle_t")
    public static long VRIOBuffer_PropertyContainer(@NativeType(value="IOBufferHandle_t") long ulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.PropertyContainer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJJ((long)ulBuffer, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRIOBuffer_HasReaders(@NativeType(value="IOBufferHandle_t") long ulBuffer) {
        long __functionAddress = OpenVR.VRIOBuffer.HasReaders;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callJZ((long)ulBuffer, (long)__functionAddress);
    }
}

