/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.pip;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.vivecraft.client.gui.pip.state.GuiFBTPlayerState;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;

public class GuiFBTPlayerRenderer
extends PictureInPictureRenderer<GuiFBTPlayerState> {
    private static final Vec3i COLOR_INACTIVE = new Vec3i(128, 64, 64);
    private static final Vec3i COLOR_ACTIVE = new Vec3i(64, 128, 64);
    private static final byte ALPHA = -56;

    public GuiFBTPlayerRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    public Class<GuiFBTPlayerState> getRenderStateClass() {
        return GuiFBTPlayerState.class;
    }

    protected void renderToTexture(GuiFBTPlayerState fbtState, PoseStack poseStack) {
        poseStack.pushPose();
        poseStack.translate(-0.5, -32.0, 0.0);
        poseStack.scale(4.0f, -4.0f, 4.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI + fbtState.yRot()));
        RenderType renderType = VRRenderTypes.quads(true);
        VertexConsumer consumer = this.bufferSource.getBuffer(renderType);
        Vec3i color = fbtState.leftReady() && fbtState.rightReady() ? COLOR_ACTIVE : COLOR_INACTIVE;
        RenderHelper.renderBox(consumer, new Vec3(2.0, 0.0, 0.0), new Vec3(2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack.last().pose());
        RenderHelper.renderBox(consumer, new Vec3(-2.0, 0.0, 0.0), new Vec3(-2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack.last().pose());
        RenderHelper.renderBox(consumer, new Vec3(0.0, 12.0, 0.0), new Vec3(0.0, 24.0, 0.0), 8.0f, 4.0f, color, (byte)-56, poseStack.last().pose());
        RenderHelper.renderBox(consumer, new Vec3(0.0, 24.0, 0.0), new Vec3(0.0, 32.0, 0.0), 8.0f, 8.0f, color, (byte)-56, poseStack.last().pose());
        RenderHelper.renderBox(consumer, new Vec3(6.0, 22.0, 0.0).subtract((double)(fbtState.left().x() * 2.0f), (double)(fbtState.left().y() * 2.0f), (double)(fbtState.left().z() * 2.0f)), new Vec3(6.0, 22.0, 0.0).add((double)(fbtState.left().x() * 10.0f), (double)(fbtState.left().y() * 10.0f), (double)(fbtState.left().z() * 10.0f)), 4.0f, 4.0f, fbtState.leftReady() ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack.last().pose());
        RenderHelper.renderBox(consumer, new Vec3(-6.0, 22.0, 0.0).subtract((double)(fbtState.right().x() * 2.0f), (double)(fbtState.right().y() * 2.0f), (double)(fbtState.right().z() * 2.0f)), new Vec3(-6.0, 22.0, 0.0).add((double)(fbtState.right().x() * 10.0f), (double)(fbtState.right().y() * 10.0f), (double)(fbtState.right().z() * 10.0f)), 4.0f, 4.0f, fbtState.rightReady() ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack.last().pose());
        this.bufferSource.endBatch(renderType);
        poseStack.popPose();
    }

    protected String getTextureLabel() {
        return "fbt player";
    }
}

