/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.trackers.TelescopeTracker;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.render.helpers.GuiRenderHelper;
import org.vivecraft.client_vr.render.helpers.opengl.OpenGLHelper;
import org.vivecraft.client_vr.render.rendertypes.VRRenderTypes;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class RenderHelper {
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static final Minecraft MC = Minecraft.getInstance();
    public static final ResourceLocation WHITE_TEXTURE = ResourceLocation.parse((String)"vivecraft:textures/white.png");
    public static final ResourceLocation BLACK_TEXTURE = ResourceLocation.parse((String)"vivecraft:textures/black.png");

    public static GpuTextureView getGpuTexture(ResourceLocation resourceLocation) {
        return MC.getTextureManager().getTexture(resourceLocation).getTextureView();
    }

    public static Matrix4f getVRModelView(RenderPass renderPass) {
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getMatrix().transpose();
    }

    public static void applyVRModelView(RenderPass renderPass, PoseStack poseStack) {
        Matrix4f modelView = RenderHelper.getVRModelView(renderPass);
        poseStack.last().pose().mul((Matrix4fc)modelView);
        poseStack.last().normal().mul((Matrix3fc)new Matrix3f((Matrix4fc)modelView));
    }

    public static void applyVRModelView(RenderPass renderPass, Matrix4f matrix) {
        Matrix4f modelView = RenderHelper.getVRModelView(renderPass);
        matrix.mul((Matrix4fc)modelView);
    }

    public static void applyStereo(RenderPass renderPass, PoseStack poseStack) {
        if (renderPass == RenderPass.LEFT || renderPass == RenderPass.RIGHT) {
            Vec3 eye = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(renderPass).getPosition().subtract(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition());
            poseStack.translate(-eye.x, -eye.y, -eye.z);
        }
    }

    public static Vec3 getControllerRenderPos(int c) {
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && c < 2) {
            int mainHand = InteractionHand.MAIN_HAND.ordinal();
            if (RenderHelper.DATA_HOLDER.vrSettings.reverseHands) {
                c = 1 - c;
                mainHand = InteractionHand.OFF_HAND.ordinal();
            }
            if (RenderHelper.MC.player != null && RenderHelper.MC.level != null && TelescopeTracker.isTelescope(RenderHelper.MC.player.getUseItem()) && TelescopeTracker.isTelescope(c == mainHand ? RenderHelper.MC.player.getMainHandItem() : RenderHelper.MC.player.getOffhandItem())) {
                VRData.VRDevicePose eye = c == 0 ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye0 : RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.eye1;
                Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection().mul(0.2f * RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale);
                return eye.getPosition().add((double)dir.x, (double)dir.y, (double)dir.z);
            }
            float worldScale = RenderHelper.MC.player != null && RenderHelper.MC.level != null ? RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale : 1.0f;
            Vector3f dir = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getDirection();
            dir.rotateY((float)Math.PI / 180 * (c == 0 ? -35.0f : 35.0f));
            dir.y = 0.0f;
            dir.normalize();
            return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getPosition().add((double)dir.x * 0.3 * (double)worldScale, -0.4 * (double)worldScale, (double)dir.z * 0.3 * (double)worldScale);
        }
        return RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getPosition();
    }

    public static void setupRenderingAtController(int c, Matrix4f matrix) {
        Vec3 aimSource = RenderHelper.getControllerRenderPos(c);
        aimSource = aimSource.subtract(RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getEye(RenderHelper.DATA_HOLDER.currentPass).getPosition());
        matrix.translate((float)aimSource.x, (float)aimSource.y, (float)aimSource.z);
        float sc = RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.worldScale;
        if (RenderHelper.DATA_HOLDER.vrSettings.seated && RenderHelper.MC.player != null && RenderHelper.MC.level != null && TelescopeTracker.isTelescope(RenderHelper.MC.player.getUseItem()) && TelescopeTracker.isTelescope(c == 0 ? RenderHelper.MC.player.getMainHandItem() : RenderHelper.MC.player.getOffhandItem())) {
            matrix.mul((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.hmd.getMatrix().invert().transpose());
            matrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            matrix.translate((c == (RenderHelper.DATA_HOLDER.vrSettings.reverseHands ? 1 : 0) ? 0.075f : -0.075f) * sc, -0.025f * sc, 0.0325f * sc);
        } else {
            matrix.mul((Matrix4fc)RenderHelper.DATA_HOLDER.vrPlayer.vrdata_world_render.getController(c).getMatrix().invert().transpose());
        }
        matrix.scale(sc, sc, sc);
    }

    public static void drawScreen(Screen screen, boolean maxGuiScale) {
        double guiScale = maxGuiScale ? (double)GuiHandler.GUI_SCALE_FACTOR_MAX : (double)MC.getWindow().getGuiScale();
        int backupGuiScale = GuiHandler.GUI_SCALE_FACTOR;
        GuiHandler.GUI_SCALE_FACTOR = (int)guiScale;
        GuiRenderHelper.renderScreen(screen);
        GuiHandler.GUI_SCALE_FACTOR = backupGuiScale;
        if (RenderHelper.DATA_HOLDER.vrSettings.guiMipmaps) {
            OpenGLHelper.genMipmaps(RenderHelper.MC.mainRenderTarget.getColorTexture());
        }
    }

    public static void drawMouseMenuQuad(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        float size = 15.0f * Math.max(ClientDataHolderVR.getInstance().vrSettings.menuCrosshairScale, 1.0f / (float)MC.getWindow().getGuiScale());
        guiGraphics.blitSprite(VRShaders.CROSSHAIR_MENU, Gui.CROSSHAIR_SPRITE, (int)((float)mouseX - size * 0.5f + 1.0f), (int)((float)mouseY - size * 0.5f + 1.0f), (int)size, (int)size);
    }

    public static void drawVRConnectingMessage() {
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(MC.getMainRenderTarget().getDepthTexture(), 1.0);
        GuiGraphics guiGraphics = GuiRenderHelper.getGuiGraphics();
        int width = 200;
        List formattedChars = RenderHelper.MC.font.split((FormattedText)Component.translatable((String)"vivecraft.messages.connectingtoruntime"), width - 10);
        int height = formattedChars.size() * 8 + Math.max(formattedChars.size() - 1, 0) * 4 + 10;
        int x = guiGraphics.guiWidth() / 2 - width / 2;
        int y = guiGraphics.guiHeight() / 2 - height / 2;
        guiGraphics.fill(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), 0x40000000);
        guiGraphics.fill(x, y, x + width, y + height, -16777216);
        guiGraphics.renderOutline(x, y, width, height, -1);
        for (int line = 0; line < formattedChars.size(); ++line) {
            guiGraphics.drawCenteredString(RenderHelper.MC.font, (FormattedCharSequence)formattedChars.get(line), guiGraphics.guiWidth() / 2, y + 5 + line * 12, -1);
        }
        GuiRenderHelper.finish();
    }

    public static void drawSizedQuad(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix, RenderTarget source) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        RenderType renderType = VRRenderTypes.guiTextureAlways(source.getColorTextureView());
        VertexConsumer consumer = MC.renderBuffers().bufferSource().getBuffer(renderType);
        consumer.addVertex(matrix, -sizeX, -sizeY, 0.0f).setUv(0.0f, 0.0f).setColor(color[0], color[1], color[2], color[3]);
        consumer.addVertex(matrix, sizeX, -sizeY, 0.0f).setUv(1.0f, 0.0f).setColor(color[0], color[1], color[2], color[3]);
        consumer.addVertex(matrix, sizeX, sizeY, 0.0f).setUv(1.0f, 1.0f).setColor(color[0], color[1], color[2], color[3]);
        consumer.addVertex(matrix, -sizeX, sizeY, 0.0f).setUv(0.0f, 1.0f).setColor(color[0], color[1], color[2], color[3]);
        MC.renderBuffers().bufferSource().endBatch(renderType);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, Matrix4f matrix, RenderType renderType, boolean flipY) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, packedLight, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, matrix, renderType, flipY);
    }

    public static void drawSizedQuadFullbright(float displayWidth, float displayHeight, float size, float[] color, Matrix4f matrix, RenderType renderType) {
        RenderHelper.drawSizedQuadWithLightmap(displayWidth, displayHeight, size, 0xF000F0, color, matrix, renderType, false);
    }

    public static void drawSizedQuadWithLightmap(float displayWidth, float displayHeight, float size, int packedLight, float[] color, Matrix4f matrix, RenderType renderType, boolean flipY) {
        float sizeX = size * 0.5f;
        float sizeY = sizeX * displayHeight / displayWidth;
        Vector3f normal = new Matrix3f((Matrix4fc)matrix).transform(new Vector3f(0.0f, 0.0f, 1.0f)).normalize();
        VertexConsumer consumer = MC.renderBuffers().bufferSource().getBuffer(renderType);
        consumer.addVertex(matrix, -sizeX, -sizeY, 0.0f).setColor(color[0], color[1], color[2], color[3]).setUv(0.0f, flipY ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
        consumer.addVertex(matrix, sizeX, -sizeY, 0.0f).setColor(color[0], color[1], color[2], color[3]).setUv(1.0f, flipY ? 1.0f : 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
        consumer.addVertex(matrix, sizeX, sizeY, 0.0f).setColor(color[0], color[1], color[2], color[3]).setUv(1.0f, flipY ? 0.0f : 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
        consumer.addVertex(matrix, -sizeX, sizeY, 0.0f).setColor(color[0], color[1], color[2], color[3]).setUv(0.0f, flipY ? 0.0f : 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(normal.x, normal.y, normal.z);
        MC.renderBuffers().bufferSource().endBatch(renderType);
    }

    public static void renderFlatQuad(Vec3 pos, float width, float height, float yaw, int r, int g, int b, int a, Matrix4f matrix, boolean depthAlways) {
        RenderType renderType = VRRenderTypes.quads(depthAlways);
        VertexConsumer consumer = MC.renderBuffers().bufferSource().getBuffer(renderType);
        Vec3 offset = new Vec3((double)(width * 0.5f), 0.0, (double)(height * 0.5f)).yRot((float)Math.PI / 180 * -yaw);
        ShadersHelper.bindTexture(WHITE_TEXTURE);
        consumer.addVertex(matrix, (float)(pos.x + offset.x), (float)pos.y, (float)(pos.z + offset.z)).setColor(r, g, b, a);
        consumer.addVertex(matrix, (float)(pos.x + offset.x), (float)pos.y, (float)(pos.z - offset.z)).setColor(r, g, b, a);
        consumer.addVertex(matrix, (float)(pos.x - offset.x), (float)pos.y, (float)(pos.z - offset.z)).setColor(r, g, b, a);
        consumer.addVertex(matrix, (float)(pos.x - offset.x), (float)pos.y, (float)(pos.z + offset.z)).setColor(r, g, b, a);
        MC.renderBuffers().bufferSource().endBatch(renderType);
    }

    public static void renderBox(VertexConsumer consumer, Vec3 start, Vec3 end, float xSize, float ySize, Vec3i color, byte alpha, Matrix4f matrix) {
        RenderHelper.renderBox(consumer, start, end, -xSize * 0.5f, xSize * 0.5f, -ySize * 0.5f, ySize * 0.5f, color, alpha, matrix);
    }

    public static void renderBox(VertexConsumer consumer, Vec3 start, Vec3 end, float minX, float maxX, float minY, float maxY, Vec3i color, byte alpha, Matrix4f matrix) {
        Vec3 forward = start.subtract(end).normalize();
        Vec3 right = forward.cross(MathUtils.UP_D);
        right = right.lengthSqr() == 0.0 ? MathUtils.LEFT_D : right.normalize();
        Vec3 up = right.cross(forward);
        Vec3 left = right.scale((double)minX);
        right = right.scale((double)maxX);
        Vec3 down = up.scale((double)minY);
        up = up.scale((double)maxY);
        Vec3 backRightBottom = start.add(right.x + down.x, right.y + down.y, right.z + down.z);
        Vec3 backRightTop = start.add(right.x + up.x, right.y + up.y, right.z + up.z);
        Vec3 backLeftBottom = start.add(left.x + down.x, left.y + down.y, left.z + down.z);
        Vec3 backLeftTop = start.add(left.x + up.x, left.y + up.y, left.z + up.z);
        Vec3 frontRightBottom = end.add(right.x + down.x, right.y + down.y, right.z + down.z);
        Vec3 frontRightTop = end.add(right.x + up.x, right.y + up.y, right.z + up.z);
        Vec3 frontLeftBottom = end.add(left.x + down.x, left.y + down.y, left.z + down.z);
        Vec3 frontLeftTop = end.add(left.x + up.x, left.y + up.y, left.z + up.z);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightTop, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backLeftBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, backRightBottom, color, alpha);
        RenderHelper.addVertex(consumer, matrix, frontRightBottom, color, alpha);
    }

    private static void addVertex(VertexConsumer consumer, Matrix4f matrix, Vec3 pos, Vec3i color, int alpha) {
        consumer.addVertex(matrix, (float)pos.x, (float)pos.y, (float)pos.z).setColor(color.getX(), color.getY(), color.getZ(), alpha);
    }

    public static String checkGLError(String errorSection) {
        int error = GlStateManager._getError();
        if (error != 0) {
            String errorString = switch (error) {
                case 1280 -> "invalid enum";
                case 1281 -> "invalid value";
                case 1282 -> "invalid operation";
                case 1283 -> "stack overflow";
                case 1284 -> "stack underflow";
                case 1285 -> "out of memory";
                case 1286 -> "framebuffer is not complete";
                default -> "unknown error";
            };
            VRSettings.LOGGER.error("Vivecraft: ########## GL ERROR ##########");
            VRSettings.LOGGER.error("Vivecraft: @ {}", (Object)errorSection);
            VRSettings.LOGGER.error("Vivecraft: {}: {}", (Object)error, (Object)errorString);
            return errorString;
        }
        return "";
    }
}

