/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRVulkanTextureData_t")
public class VRVulkanTextureData
extends Struct<VRVulkanTextureData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_NIMAGE;
    public static final int M_PDEVICE;
    public static final int M_PPHYSICALDEVICE;
    public static final int M_PINSTANCE;
    public static final int M_PQUEUE;
    public static final int M_NQUEUEFAMILYINDEX;
    public static final int M_NWIDTH;
    public static final int M_NHEIGHT;
    public static final int M_NFORMAT;
    public static final int M_NSAMPLECOUNT;

    protected VRVulkanTextureData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VRVulkanTextureData create(long address, @Nullable ByteBuffer container) {
        return new VRVulkanTextureData(address, container);
    }

    public VRVulkanTextureData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRVulkanTextureData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint64_t")
    public long m_nImage() {
        return VRVulkanTextureData.nm_nImage(this.address());
    }

    @NativeType(value="VkDevice_T *")
    public long m_pDevice() {
        return VRVulkanTextureData.nm_pDevice(this.address());
    }

    @NativeType(value="VkPhysicalDevice_T *")
    public long m_pPhysicalDevice() {
        return VRVulkanTextureData.nm_pPhysicalDevice(this.address());
    }

    @NativeType(value="VkInstance_T *")
    public long m_pInstance() {
        return VRVulkanTextureData.nm_pInstance(this.address());
    }

    @NativeType(value="VkQueue_T *")
    public long m_pQueue() {
        return VRVulkanTextureData.nm_pQueue(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nQueueFamilyIndex() {
        return VRVulkanTextureData.nm_nQueueFamilyIndex(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nWidth() {
        return VRVulkanTextureData.nm_nWidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nHeight() {
        return VRVulkanTextureData.nm_nHeight(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nFormat() {
        return VRVulkanTextureData.nm_nFormat(this.address());
    }

    @NativeType(value="uint32_t")
    public int m_nSampleCount() {
        return VRVulkanTextureData.nm_nSampleCount(this.address());
    }

    public VRVulkanTextureData m_nImage(@NativeType(value="uint64_t") long value) {
        VRVulkanTextureData.nm_nImage(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_pDevice(@NativeType(value="VkDevice_T *") long value) {
        VRVulkanTextureData.nm_pDevice(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_pPhysicalDevice(@NativeType(value="VkPhysicalDevice_T *") long value) {
        VRVulkanTextureData.nm_pPhysicalDevice(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_pInstance(@NativeType(value="VkInstance_T *") long value) {
        VRVulkanTextureData.nm_pInstance(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_pQueue(@NativeType(value="VkQueue_T *") long value) {
        VRVulkanTextureData.nm_pQueue(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_nQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VRVulkanTextureData.nm_nQueueFamilyIndex(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_nWidth(@NativeType(value="uint32_t") int value) {
        VRVulkanTextureData.nm_nWidth(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_nHeight(@NativeType(value="uint32_t") int value) {
        VRVulkanTextureData.nm_nHeight(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_nFormat(@NativeType(value="uint32_t") int value) {
        VRVulkanTextureData.nm_nFormat(this.address(), value);
        return this;
    }

    public VRVulkanTextureData m_nSampleCount(@NativeType(value="uint32_t") int value) {
        VRVulkanTextureData.nm_nSampleCount(this.address(), value);
        return this;
    }

    public VRVulkanTextureData set(long m_nImage, long m_pDevice, long m_pPhysicalDevice, long m_pInstance, long m_pQueue, int m_nQueueFamilyIndex, int m_nWidth, int m_nHeight, int m_nFormat, int m_nSampleCount) {
        this.m_nImage(m_nImage);
        this.m_pDevice(m_pDevice);
        this.m_pPhysicalDevice(m_pPhysicalDevice);
        this.m_pInstance(m_pInstance);
        this.m_pQueue(m_pQueue);
        this.m_nQueueFamilyIndex(m_nQueueFamilyIndex);
        this.m_nWidth(m_nWidth);
        this.m_nHeight(m_nHeight);
        this.m_nFormat(m_nFormat);
        this.m_nSampleCount(m_nSampleCount);
        return this;
    }

    public VRVulkanTextureData set(VRVulkanTextureData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRVulkanTextureData malloc() {
        return new VRVulkanTextureData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VRVulkanTextureData calloc() {
        return new VRVulkanTextureData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VRVulkanTextureData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VRVulkanTextureData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VRVulkanTextureData create(long address) {
        return new VRVulkanTextureData(address, null);
    }

    @Nullable
    public static VRVulkanTextureData createSafe(long address) {
        return address == 0L ? null : new VRVulkanTextureData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VRVulkanTextureData.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRVulkanTextureData.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRVulkanTextureData mallocStack() {
        return VRVulkanTextureData.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRVulkanTextureData callocStack() {
        return VRVulkanTextureData.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRVulkanTextureData mallocStack(MemoryStack stack) {
        return VRVulkanTextureData.malloc(stack);
    }

    @Deprecated
    public static VRVulkanTextureData callocStack(MemoryStack stack) {
        return VRVulkanTextureData.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRVulkanTextureData.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRVulkanTextureData.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRVulkanTextureData.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRVulkanTextureData.calloc(capacity, stack);
    }

    public static VRVulkanTextureData malloc(MemoryStack stack) {
        return new VRVulkanTextureData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRVulkanTextureData calloc(MemoryStack stack) {
        return new VRVulkanTextureData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nm_nImage(long struct) {
        return UNSAFE.getLong(null, struct + (long)M_NIMAGE);
    }

    public static long nm_pDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PDEVICE));
    }

    public static long nm_pPhysicalDevice(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PPHYSICALDEVICE));
    }

    public static long nm_pInstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PINSTANCE));
    }

    public static long nm_pQueue(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)M_PQUEUE));
    }

    public static int nm_nQueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NQUEUEFAMILYINDEX);
    }

    public static int nm_nWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NWIDTH);
    }

    public static int nm_nHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NHEIGHT);
    }

    public static int nm_nFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NFORMAT);
    }

    public static int nm_nSampleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_NSAMPLECOUNT);
    }

    public static void nm_nImage(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)M_NIMAGE, value);
    }

    public static void nm_pDevice(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PDEVICE), (long)Checks.check((long)value));
    }

    public static void nm_pPhysicalDevice(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PPHYSICALDEVICE), (long)Checks.check((long)value));
    }

    public static void nm_pInstance(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PINSTANCE), (long)Checks.check((long)value));
    }

    public static void nm_pQueue(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_PQUEUE), (long)Checks.check((long)value));
    }

    public static void nm_nQueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NQUEUEFAMILYINDEX, value);
    }

    public static void nm_nWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NWIDTH, value);
    }

    public static void nm_nHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NHEIGHT, value);
    }

    public static void nm_nFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NFORMAT, value);
    }

    public static void nm_nSampleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_NSAMPLECOUNT, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PPHYSICALDEVICE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PINSTANCE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_PQUEUE)));
    }

    static {
        Struct.Layout layout = VRVulkanTextureData.__struct((Struct.Member[])new Struct.Member[]{VRVulkanTextureData.__member((int)8), VRVulkanTextureData.__member((int)POINTER_SIZE), VRVulkanTextureData.__member((int)POINTER_SIZE), VRVulkanTextureData.__member((int)POINTER_SIZE), VRVulkanTextureData.__member((int)POINTER_SIZE), VRVulkanTextureData.__member((int)4), VRVulkanTextureData.__member((int)4), VRVulkanTextureData.__member((int)4), VRVulkanTextureData.__member((int)4), VRVulkanTextureData.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_NIMAGE = layout.offsetof(0);
        M_PDEVICE = layout.offsetof(1);
        M_PPHYSICALDEVICE = layout.offsetof(2);
        M_PINSTANCE = layout.offsetof(3);
        M_PQUEUE = layout.offsetof(4);
        M_NQUEUEFAMILYINDEX = layout.offsetof(5);
        M_NWIDTH = layout.offsetof(6);
        M_NHEIGHT = layout.offsetof(7);
        M_NFORMAT = layout.offsetof(8);
        M_NSAMPLECOUNT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VRVulkanTextureData, Buffer>
    implements NativeResource {
        private static final VRVulkanTextureData ELEMENT_FACTORY = VRVulkanTextureData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VRVulkanTextureData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint64_t")
        public long m_nImage() {
            return VRVulkanTextureData.nm_nImage(this.address());
        }

        @NativeType(value="VkDevice_T *")
        public long m_pDevice() {
            return VRVulkanTextureData.nm_pDevice(this.address());
        }

        @NativeType(value="VkPhysicalDevice_T *")
        public long m_pPhysicalDevice() {
            return VRVulkanTextureData.nm_pPhysicalDevice(this.address());
        }

        @NativeType(value="VkInstance_T *")
        public long m_pInstance() {
            return VRVulkanTextureData.nm_pInstance(this.address());
        }

        @NativeType(value="VkQueue_T *")
        public long m_pQueue() {
            return VRVulkanTextureData.nm_pQueue(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nQueueFamilyIndex() {
            return VRVulkanTextureData.nm_nQueueFamilyIndex(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nWidth() {
            return VRVulkanTextureData.nm_nWidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nHeight() {
            return VRVulkanTextureData.nm_nHeight(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nFormat() {
            return VRVulkanTextureData.nm_nFormat(this.address());
        }

        @NativeType(value="uint32_t")
        public int m_nSampleCount() {
            return VRVulkanTextureData.nm_nSampleCount(this.address());
        }

        public Buffer m_nImage(@NativeType(value="uint64_t") long value) {
            VRVulkanTextureData.nm_nImage(this.address(), value);
            return this;
        }

        public Buffer m_pDevice(@NativeType(value="VkDevice_T *") long value) {
            VRVulkanTextureData.nm_pDevice(this.address(), value);
            return this;
        }

        public Buffer m_pPhysicalDevice(@NativeType(value="VkPhysicalDevice_T *") long value) {
            VRVulkanTextureData.nm_pPhysicalDevice(this.address(), value);
            return this;
        }

        public Buffer m_pInstance(@NativeType(value="VkInstance_T *") long value) {
            VRVulkanTextureData.nm_pInstance(this.address(), value);
            return this;
        }

        public Buffer m_pQueue(@NativeType(value="VkQueue_T *") long value) {
            VRVulkanTextureData.nm_pQueue(this.address(), value);
            return this;
        }

        public Buffer m_nQueueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VRVulkanTextureData.nm_nQueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer m_nWidth(@NativeType(value="uint32_t") int value) {
            VRVulkanTextureData.nm_nWidth(this.address(), value);
            return this;
        }

        public Buffer m_nHeight(@NativeType(value="uint32_t") int value) {
            VRVulkanTextureData.nm_nHeight(this.address(), value);
            return this;
        }

        public Buffer m_nFormat(@NativeType(value="uint32_t") int value) {
            VRVulkanTextureData.nm_nFormat(this.address(), value);
            return this;
        }

        public Buffer m_nSampleCount(@NativeType(value="uint32_t") int value) {
            VRVulkanTextureData.nm_nSampleCount(this.address(), value);
            return this;
        }
    }
}

