/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.settings;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.vivecraft.client.gui.framework.screens.GuiSelectionListScreen;
import org.vivecraft.client.gui.framework.widgets.SilentButton;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;

public class GuiChatNotificationSelection
extends GuiSelectionListScreen<ResourceLocation> {
    private static SoundInstance ACTIVE_SOUND;
    private static AbstractWidget ACTIVE_BUTTON;

    public GuiChatNotificationSelection(Screen lastScreen) {
        super((Component)Component.translatable((String)"vivecraft.options.CHAT_NOTIFICATION_SOUND"), lastScreen, () -> BuiltInRegistries.SOUND_EVENT.keySet().stream().sorted().toList(), ClientUtils::getNameFromSoundEvent, resourceLocation -> "", resourceLocation -> {
            if (resourceLocation != null) {
                ClientDataHolderVR.getInstance().vrSettings.chatNotificationSound = resourceLocation.getPath();
            } else {
                ClientDataHolderVR.getInstance().vrSettings.loadDefault(VRSettings.VrOptions.CHAT_NOTIFICATION_SOUND);
            }
            ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        }, true, true, resourceLocation -> new SilentButton((Component)Component.literal((String)"\u266b"), b -> {
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(resourceLocation);
            if (soundEvent != null) {
                GuiChatNotificationSelection.startSound(soundEvent, (AbstractWidget)b);
            }
        }, 20, 20));
    }

    public void tick() {
        if (ACTIVE_SOUND != null && !this.minecraft.getSoundManager().isActive(ACTIVE_SOUND)) {
            GuiChatNotificationSelection.stopSound();
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        Minecraft.getInstance().getSoundManager().stop(ACTIVE_SOUND);
        ACTIVE_SOUND = null;
    }

    private static void stopSound() {
        Minecraft.getInstance().getSoundManager().stop(ACTIVE_SOUND);
        ACTIVE_BUTTON.setMessage((Component)Component.literal((String)"\u266b"));
        ACTIVE_SOUND = null;
        ACTIVE_BUTTON = null;
    }

    private static void startSound(SoundEvent soundEvent, AbstractWidget abstractWidget) {
        if (ACTIVE_SOUND != null) {
            GuiChatNotificationSelection.stopSound();
        }
        ACTIVE_SOUND = SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)1.0f, (float)1.0f);
        Minecraft.getInstance().getSoundManager().play(ACTIVE_SOUND);
        ACTIVE_BUTTON = abstractWidget;
        ACTIVE_BUTTON.setMessage((Component)Component.literal((String)"\u266b").withStyle(ChatFormatting.GREEN));
    }
}

