/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.render.VRPlayerModel;
import org.vivecraft.client.render.models.HandModel;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.settings.VRSettings;

public class VRPlayerModel_WithArms<T extends LivingEntity>
extends VRPlayerModel<T>
implements HandModel {
    public static final int LOWER_EXTENSION = 2;
    public static final int UPPER_EXTENSION = 3;
    public ModelPart leftHand;
    public ModelPart rightHand;
    public ModelPart leftHandSleeve;
    public ModelPart rightHandSleeve;
    private final Vector3f jointOffset = new Vector3f();

    public VRPlayerModel_WithArms(ModelPart root, boolean isSlim) {
        super(root, isSlim);
        this.leftHandSleeve = root.getChild("left_hand_sleeve");
        this.rightHandSleeve = root.getChild("right_hand_sleeve");
        this.leftHand = root.getChild("left_hand");
        this.rightHand = root.getChild("right_hand");
        ModelUtils.textureHack(this.leftArm, this.leftHand);
        ModelUtils.textureHack(this.rightArm, this.rightHand);
        ModelUtils.textureHack(this.leftSleeve, this.leftHandSleeve);
        ModelUtils.textureHack(this.rightSleeve, this.rightHandSleeve);
    }

    public static MeshDefinition createMesh(CubeDeformation cubeDeformation, boolean slim) {
        float lowerShrinkage;
        MeshDefinition meshDefinition = VRPlayerModel.createMesh(cubeDeformation, slim);
        PartDefinition partDefinition = meshDefinition.getRoot();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 3 : 0;
        int lowerExtension = connected ? 2 : 0;
        float f = lowerShrinkage = connected ? -0.05f : 0.0f;
        if (slim) {
            partDefinition.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(32, 55 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)5.5f, (float)12.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("left_hand_sleeve", CubeListBuilder.create().texOffs(48, 55 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.offset((float)5.5f, (float)12.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.5f, (float)12.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_hand_sleeve", CubeListBuilder.create().texOffs(40, 39 - lowerExtension).addBox(-1.5f, -5.0f - (float)lowerExtension, -2.0f, 3.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.offset((float)-5.5f, (float)12.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        } else {
            partDefinition.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(32, 55 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("left_hand_sleeve", CubeListBuilder.create().texOffs(48, 55 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_hand_sleeve", CubeListBuilder.create().texOffs(40, 39 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(0.25f + lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
            partDefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation.extend(0.25f)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        }
        return meshDefinition;
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.leftHand, (Object)this.rightHand, (Object)this.leftHandSleeve, (Object)this.rightHandSleeve));
    }

    @Override
    public void setupAnim(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart mainShoulder;
        super.setupAnim(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.rotInfo == null) {
            return;
        }
        ModelPart offHand = this.rotInfo.leftHanded ? this.rightHand : this.leftHand;
        ModelPart mainHand = this.rotInfo.leftHanded ? this.leftHand : this.rightHand;
        ModelPart offShoulder = this.rotInfo.leftHanded ? this.rightArm : this.leftArm;
        ModelPart modelPart = mainShoulder = this.rotInfo.leftHanded ? this.leftArm : this.rightArm;
        if (this.rotInfo.offHandPos.distanceSquared(this.rotInfo.mainHandPos) > 0.0f) {
            boolean useWorldScale;
            float offset = (this.slim ? 0.5f : 1.0f) * this.armScale * (this.rotInfo.leftHanded ? -1.0f : 1.0f);
            boolean bl = useWorldScale = this.isMainPlayer || ClientDataHolderVR.getInstance().vrSettings.applyPlayerWorldscale;
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((LivingEntity)player, mainShoulder, mainHand, this.rotInfo.mainHandPos, this.rotInfo.mainHandQuat, -offset, this.rotInfo.rightElbowPos, true, this.mainArm, useWorldScale);
            } else {
                this.positionSplitLimb((LivingEntity)player, mainShoulder, mainHand, this.rotInfo.mainHandPos, this.rotInfo.mainHandQuat, 0.0f, -offset, this.rotInfo.rightElbowPos, true, this.mainArm, useWorldScale);
            }
            if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected) {
                this.positionConnectedLimb((LivingEntity)player, offShoulder, offHand, this.rotInfo.offHandPos, this.rotInfo.offHandQuat, offset, this.rotInfo.leftElbowPos, true, this.mainArm.getOpposite(), useWorldScale);
            } else {
                this.positionSplitLimb((LivingEntity)player, offShoulder, offHand, this.rotInfo.offHandPos, this.rotInfo.offHandQuat, 0.0f, offset, this.rotInfo.leftElbowPos, true, this.mainArm.getOpposite(), useWorldScale);
            }
            if (this.isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                this.tempM.rotateLocalX(this.xRot);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.set3x3((Matrix3fc)this.tempM);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateX(-1.5707964f);
                GuiHandler.GUI_ROTATION_PLAYER_MODEL.rotateLocalY(-this.bodyYaw - (float)Math.PI);
                ModelUtils.modelToWorld(player, offHand.x, offHand.y, offHand.z, this.rotInfo, this.bodyYaw, true, true, this.tempV);
                GuiHandler.GUI_POS_PLAYER_MODEL = player.getPosition(ClientUtils.getCurrentPartialTick()).add((double)this.tempV.x, (double)this.tempV.y, (double)this.tempV.z);
            }
        } else {
            float offset = this.slim ? this.armScale * 0.5f : this.armScale;
            this.tempV.set(-offset, 10.0f, 0.0f).rotateZ(mainShoulder.zRot).rotateY(mainShoulder.yRot).rotateX(mainShoulder.xRot);
            mainHand.copyFrom(mainShoulder);
            mainHand.x += this.tempV.x;
            mainHand.y += this.tempV.y;
            mainHand.z += this.tempV.z;
            this.tempV.set(offset, 10.0f, 0.0f).rotateZ(offShoulder.zRot).rotateY(offShoulder.yRot).rotateX(offShoulder.xRot);
            offHand.copyFrom(offShoulder);
            offHand.x += this.tempV.x;
            offHand.y += this.tempV.y;
            offHand.z += this.tempV.z;
            if (this.isMainPlayer && ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && ClientDataHolderVR.getInstance().vrSettings.modelArmsMode != VRSettings.ModelArmsMode.OFF) {
                GuiHandler.GUI_POS_PLAYER_MODEL = Vec3.ZERO;
            }
        }
        this.rightHand.xScale = this.rightHand.zScale = this.armScale;
        this.leftHand.zScale = this.rightHand.zScale;
        this.leftHand.xScale = this.rightHand.zScale;
        if (this.layAmount > 0.0f) {
            ModelUtils.applySwimRotationOffset(player, this.xRot, this.tempV, this.tempV2, new ModelPart[]{this.leftArm, this.rightArm, this.leftHand, this.rightHand});
        }
        if (player.isAutoSpinAttack()) {
            VRPlayerModel_WithArms.spinOffset(this.leftArm, this.rightArm, this.leftHand, this.rightHand);
        }
        this.leftHandSleeve.copyFrom(this.leftHand);
        this.rightHandSleeve.copyFrom(this.rightHand);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.leftHandSleeve.visible &= this.leftSleeve.visible;
        this.rightHandSleeve.visible &= this.rightSleeve.visible;
    }

    protected void positionSplitLimb(LivingEntity player, ModelPart upper, ModelPart lower, Vector3fc lowerPos, Quaternionfc lowerRot, float lowerXRot, float lowerXOffset, Vector3fc jointPos, boolean jointDown, HumanoidArm arm, boolean useWorldScale) {
        ModelUtils.worldToModel(player, lowerPos, this.rotInfo, this.bodyYaw, useWorldScale, this.tempV);
        lower.setPos(this.tempV.x, this.tempV.y, this.tempV.z);
        ModelUtils.estimateJointDir(upper, lower, lowerRot, this.bodyYaw, jointDown, jointPos, player, this.rotInfo, useWorldScale, this.tempV2, this.tempV);
        ModelUtils.estimateJoint(upper.x, upper.y, upper.z, lower.x, lower.y, lower.z, (Vector3fc)this.tempV2, 12.0f, this.tempV);
        if (jointDown) {
            this.tempV2.mul(-1.0f);
        }
        this.jointOffset.set(lower.x - upper.x, lower.y - upper.y, lower.z - upper.z);
        this.jointOffset.cross((Vector3fc)this.tempV2).normalize().mul(lowerXOffset * 0.5f);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointModelAtModelWithUp(upper, this.tempV.x, this.tempV.y, this.tempV.z, (Vector3fc)this.tempV2, this.tempV, this.tempM);
        this.tempM.rotateLocalX(-this.xRot);
        ModelUtils.setRotation(upper, (Matrix3fc)this.tempM, this.tempV);
        ModelUtils.toModelDir(this.bodyYaw, lowerRot, this.tempM);
        if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && arm != null && this.attackArm == arm) {
            ModelUtils.swingAnimation(lower, arm, -3.0f, this.attackTime, this.isMainPlayer, this.tempM, this.tempV, this.tempV2);
        }
        this.tempM.rotateLocalX(-this.xRot + lowerXRot);
        ModelUtils.setRotation(lower, (Matrix3fc)this.tempM, this.tempV);
    }

    protected void positionConnectedLimb(LivingEntity player, ModelPart upper, ModelPart lower, Vector3fc lowerPos, Quaternionfc lowerRot, float lowerXOffset, Vector3fc jointPos, boolean jointDown, HumanoidArm arm, boolean useWorldScale) {
        ModelUtils.worldToModel(player, lowerPos, this.rotInfo, this.bodyYaw, useWorldScale, this.tempV);
        float armLength = 10.0f;
        if (arm != null) {
            this.tempV.normalize(this.tempV2);
            armLength += 2.0f * this.tempV2.z * this.tempV2.z;
        }
        this.tempV.sub(upper.x, upper.y, upper.z, this.tempV2);
        float length = this.tempV2.length();
        upper.y -= 2.0f * Math.min(1.0f, length / armLength) * Math.max(0.0f, -this.tempV2.y / length);
        if (ClientDataHolderVR.getInstance().vrSettings.playerLimbsLimit && length > armLength) {
            this.tempV.sub(upper.x, upper.y, upper.z);
            this.tempV.normalize().mul(armLength);
            this.tempV.add(upper.x, upper.y, upper.z);
        }
        lower.setPos(this.tempV.x, this.tempV.y, this.tempV.z);
        ModelUtils.estimateJointDir(upper, lower, lowerRot, this.bodyYaw, jointDown, jointPos, player, this.rotInfo, useWorldScale, this.tempV2, this.tempV);
        ModelUtils.estimateJoint(upper.x, upper.y, upper.z, lower.x, lower.y, lower.z, (Vector3fc)this.tempV2, armLength, this.tempV);
        if (jointDown) {
            this.tempV2.mul(-1.0f);
        }
        float jointX = this.tempV.x;
        float jointY = this.tempV.y;
        float jointZ = this.tempV.z;
        this.jointOffset.set(lower.x - upper.x, lower.y - upper.y, lower.z - upper.z);
        this.jointOffset.cross((Vector3fc)this.tempV2).normalize().mul(lowerXOffset * 0.5f);
        this.tempV.set(jointX - upper.x, jointY - upper.y, jointZ - upper.z);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointAtModel((Vector3fc)this.tempV, (Vector3fc)this.tempV2, this.tempM);
        this.tempM.rotateLocalX(-this.xRot);
        ModelUtils.setRotation(upper, (Matrix3fc)this.tempM, this.tempV);
        this.tempV.set(lower.x - jointX, lower.y - jointY, lower.z - jointZ);
        this.tempV.add((Vector3fc)this.jointOffset);
        ModelUtils.pointAtModel((Vector3fc)this.tempV, (Vector3fc)this.tempV2, this.tempM);
        if (ClientDataHolderVR.getInstance().vrSettings.playerArmAnim && arm != null && this.attackArm == arm) {
            ModelUtils.swingAnimation(lower, arm, -armLength * 0.5f, this.attackTime, this.isMainPlayer, this.tempM, this.tempV, this.tempV2);
        }
        this.tempM.rotateLocalX(-this.xRot);
        ModelUtils.setRotation(lower, (Matrix3fc)this.tempM, this.tempV);
    }

    public void copyPropertiesTo(HumanoidModel<T> model) {
        super.copyPropertiesTo(model);
        if (model instanceof HandModel) {
            HandModel handModel = (HandModel)model;
            handModel.getLeftHand().copyFrom(this.leftHand);
            handModel.getRightHand().copyFrom(this.rightHand);
        }
    }

    public void setAllVisible(boolean visible) {
        super.setAllVisible(visible);
        this.leftHand.visible = visible;
        this.rightHand.visible = visible;
        this.leftHandSleeve.visible = visible;
        this.rightHandSleeve.visible = visible;
    }

    @Override
    public ModelPart getLeftHand() {
        return this.leftHand;
    }

    @Override
    public ModelPart getRightHand() {
        return this.rightHand;
    }

    @Override
    public void hideLeftArm(boolean completeArm) {
        this.leftHand.visible = false;
        this.leftHandSleeve.visible = false;
        if (completeArm) {
            super.hideLeftArm(false);
        }
    }

    @Override
    public void hideRightArm(boolean onlyHand) {
        this.rightHand.visible = false;
        this.rightHandSleeve.visible = false;
        if (onlyHand) {
            super.hideRightArm(false);
        }
    }

    protected ModelPart getArm(HumanoidArm side) {
        return side == HumanoidArm.RIGHT ? this.rightHand : this.leftHand;
    }

    @Override
    public void translateToHand(HumanoidArm side, PoseStack poseStack) {
        this.getArm(side).translateAndRotate(poseStack);
        poseStack.translate(side == HumanoidArm.LEFT ? -0.0625f : 0.0625f, -0.65f, 0.0f);
        this.doAttackAnim(side, poseStack);
    }
}

