/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.vivecraft.api.client.InteractModule;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.common.utils.MathUtils;

public class EntityInteractionModule
implements InteractModule {
    private static final ResourceLocation ID = new ResourceLocation("vivecraft", "entity_interact");
    private final Minecraft mc;
    private final ClientDataHolderVR dh;
    private final EntityHitResult[] inEntityHit = new EntityHitResult[2];

    public EntityInteractionModule(Minecraft mc, ClientDataHolderVR dh) {
        this.mc = mc;
        this.dh = dh;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void reset(LocalPlayer player, InteractionHand hand) {
        this.inEntityHit[hand.ordinal()] = null;
    }

    @Override
    public boolean isActive(LocalPlayer player, InteractionHand hand, Vec3 handPosition) {
        if (this.dh.vrSettings.realisticEntityInteractEnabled) {
            Vec3 hmdPos = this.dh.vrPlayer.vrdata_world_pre.getHeadPivot();
            Vector3f handDirection = this.dh.vrPlayer.vrdata_world_pre.getHand(hand.ordinal()).getCustomVector(MathUtils.BACK);
            Vec3 extWeapon = new Vec3(handPosition.x + (double)(handDirection.x * -0.1f), handPosition.y + (double)(handDirection.y * -0.1f), handPosition.z + (double)(handDirection.z * -0.1f));
            AABB weaponBB = new AABB(handPosition, extWeapon);
            this.inEntityHit[hand.ordinal()] = ProjectileUtil.getEntityHitResult((Entity)this.mc.getCameraEntity(), (Vec3)hmdPos, (Vec3)handPosition, (AABB)weaponBB, e -> !e.isSpectator() && e.isPickable() && e != this.mc.getCameraEntity().getVehicle(), (double)0.0);
            return this.inEntityHit[hand.ordinal()] != null;
        }
        return false;
    }

    @Override
    public boolean onPress(LocalPlayer player, InteractionHand hand) {
        return this.mc.gameMode.interactAt((Player)player, this.inEntityHit[hand.ordinal()].getEntity(), this.inEntityHit[hand.ordinal()], hand).consumesAction() || this.mc.gameMode.interact((Player)player, this.inEntityHit[hand.ordinal()].getEntity(), hand).consumesAction();
    }
}

