/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_TextureMap_t")
public class RenderModelTextureMap
extends Struct<RenderModelTextureMap>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UNWIDTH;
    public static final int UNHEIGHT;
    public static final int RUBTEXTUREMAPDATA;
    public static final int FORMAT;
    public static final int UNMIPLEVELS;

    protected RenderModelTextureMap(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected RenderModelTextureMap create(long address, @Nullable ByteBuffer container) {
        return new RenderModelTextureMap(address, container);
    }

    public RenderModelTextureMap(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RenderModelTextureMap.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short unWidth() {
        return RenderModelTextureMap.nunWidth(this.address());
    }

    @NativeType(value="uint16_t")
    public short unHeight() {
        return RenderModelTextureMap.nunHeight(this.address());
    }

    @NativeType(value="uint8_t const *")
    public ByteBuffer rubTextureMapData(int capacity) {
        return RenderModelTextureMap.nrubTextureMapData(this.address(), capacity);
    }

    @NativeType(value="EVRRenderModelTextureFormat")
    public int format() {
        return RenderModelTextureMap.nformat(this.address());
    }

    @NativeType(value="uint16_t")
    public short unMipLevels() {
        return RenderModelTextureMap.nunMipLevels(this.address());
    }

    public static RenderModelTextureMap malloc() {
        return new RenderModelTextureMap(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static RenderModelTextureMap calloc() {
        return new RenderModelTextureMap(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static RenderModelTextureMap create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new RenderModelTextureMap(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static RenderModelTextureMap create(long address) {
        return new RenderModelTextureMap(address, null);
    }

    @Nullable
    public static RenderModelTextureMap createSafe(long address) {
        return address == 0L ? null : new RenderModelTextureMap(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)RenderModelTextureMap.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RenderModelTextureMap.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static RenderModelTextureMap mallocStack() {
        return RenderModelTextureMap.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RenderModelTextureMap callocStack() {
        return RenderModelTextureMap.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RenderModelTextureMap mallocStack(MemoryStack stack) {
        return RenderModelTextureMap.malloc(stack);
    }

    @Deprecated
    public static RenderModelTextureMap callocStack(MemoryStack stack) {
        return RenderModelTextureMap.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return RenderModelTextureMap.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return RenderModelTextureMap.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RenderModelTextureMap.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RenderModelTextureMap.calloc(capacity, stack);
    }

    public static RenderModelTextureMap malloc(MemoryStack stack) {
        return new RenderModelTextureMap(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RenderModelTextureMap calloc(MemoryStack stack) {
        return new RenderModelTextureMap(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nunWidth(long struct) {
        return UNSAFE.getShort(null, struct + (long)UNWIDTH);
    }

    public static short nunHeight(long struct) {
        return UNSAFE.getShort(null, struct + (long)UNHEIGHT);
    }

    public static ByteBuffer nrubTextureMapData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)RUBTEXTUREMAPDATA)), (int)capacity);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static short nunMipLevels(long struct) {
        return UNSAFE.getShort(null, struct + (long)UNMIPLEVELS);
    }

    static {
        Struct.Layout layout = RenderModelTextureMap.__struct((int)(Platform.get() == Platform.LINUX || Platform.get() == Platform.MACOSX ? 4 : DEFAULT_PACK_ALIGNMENT), (int)0, (Struct.Member[])new Struct.Member[]{RenderModelTextureMap.__member((int)2), RenderModelTextureMap.__member((int)2), RenderModelTextureMap.__member((int)POINTER_SIZE), RenderModelTextureMap.__member((int)4), RenderModelTextureMap.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UNWIDTH = layout.offsetof(0);
        UNHEIGHT = layout.offsetof(1);
        RUBTEXTUREMAPDATA = layout.offsetof(2);
        FORMAT = layout.offsetof(3);
        UNMIPLEVELS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<RenderModelTextureMap, Buffer>
    implements NativeResource {
        private static final RenderModelTextureMap ELEMENT_FACTORY = RenderModelTextureMap.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected RenderModelTextureMap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t")
        public short unWidth() {
            return RenderModelTextureMap.nunWidth(this.address());
        }

        @NativeType(value="uint16_t")
        public short unHeight() {
            return RenderModelTextureMap.nunHeight(this.address());
        }

        @NativeType(value="uint8_t const *")
        public ByteBuffer rubTextureMapData(int capacity) {
            return RenderModelTextureMap.nrubTextureMapData(this.address(), capacity);
        }

        @NativeType(value="EVRRenderModelTextureFormat")
        public int format() {
            return RenderModelTextureMap.nformat(this.address());
        }

        @NativeType(value="uint16_t")
        public short unMipLevels() {
            return RenderModelTextureMap.nunMipLevels(this.address());
        }
    }
}

