/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FakeBlockAccess
implements LevelReader {
    private final int version;
    private final long seed;
    private final DimensionType dimensionType;
    private final boolean isFlat;
    private final BlockState[] blocks;
    private final byte[] skylightmap;
    private final byte[] blocklightmap;
    private final Biome[] biomemap;
    private final short[][] heightmap;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private float ground;
    public float effectiveGround;
    private final float rotation;
    private final boolean rain;
    private final boolean thunder;
    private final BiomeManager biomeManager;
    private final DimensionSpecialEffects dimensionInfo;

    public FakeBlockAccess(int version, long seed, BlockState[] blocks, byte[] skylightmap, byte[] blocklightmap, Biome[] biomemap, short[][] heightmap, int xSize, int ySize, int zSize, int ground, DimensionType dimensionType, boolean isFlat, float rotation, boolean rain, boolean thunder) {
        this.version = version;
        this.seed = seed;
        this.blocks = blocks;
        this.skylightmap = skylightmap;
        this.blocklightmap = blocklightmap;
        this.biomemap = biomemap;
        this.heightmap = heightmap;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.ground = ground - dimensionType.minY();
        this.dimensionType = dimensionType;
        this.isFlat = isFlat;
        this.rotation = rotation;
        this.rain = rain;
        this.thunder = thunder;
        this.biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)this, BiomeManager.obfuscateSeed((long)seed));
        this.dimensionInfo = DimensionSpecialEffects.forType((DimensionType)dimensionType);
        BlockPos pos = new BlockPos(0, (int)this.ground, 0);
        BlockState standing = blocks[this.encodeCoords(pos)];
        this.ground += (float)Math.max(standing.getCollisionShape((BlockGetter)this, pos).max(Direction.Axis.Y), 0.0);
        this.effectiveGround = this.ground;
    }

    private int encodeCoords(int x, int z) {
        return z * this.xSize + x;
    }

    private int encodeCoords(int x, int y, int z) {
        return ((y + (int)this.effectiveGround) * this.zSize + (z + this.zSize / 2)) * this.xSize + (x + this.xSize / 2);
    }

    private int encodeCoords(BlockPos pos) {
        return this.encodeCoords(pos.getX(), pos.getY(), pos.getZ());
    }

    private boolean checkCoords(int x, int y, int z) {
        return x >= -this.xSize / 2 && y >= -((int)this.effectiveGround) && z >= -this.zSize / 2 && x < this.xSize / 2 && y < this.ySize - (int)this.effectiveGround && z < this.zSize / 2;
    }

    private boolean checkCoords(BlockPos pos) {
        return this.checkCoords(pos.getX(), pos.getY(), pos.getZ());
    }

    public float getGround() {
        return this.effectiveGround;
    }

    public void setGroundOffset(float offset) {
        this.effectiveGround = this.ground + offset;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public long getSeed() {
        return this.seed;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean getRain() {
        return this.rain;
    }

    public boolean getThunder() {
        return this.thunder;
    }

    public DimensionType dimensionType() {
        return this.dimensionType;
    }

    public DimensionSpecialEffects getDimensionReaderInfo() {
        return this.dimensionInfo;
    }

    public double getVoidFogYFactor() {
        return this.isFlat ? 1.0 : 0.03125;
    }

    public double getHorizon() {
        return this.isFlat ? (double)(-this.effectiveGround) : 63.0 - (double)this.effectiveGround + (double)this.getMinY();
    }

    public BlockState getBlockState(BlockPos pos) {
        if (!this.checkCoords(pos)) {
            return Blocks.BEDROCK.defaultBlockState();
        }
        BlockState state = this.blocks[this.encodeCoords(pos)];
        return state != null ? state : Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        return null;
    }

    public int getBlockTint(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        int i = (Integer)Minecraft.getInstance().options.biomeBlendRadius().get();
        if (i == 0) {
            return colorResolverIn.getColor((Biome)this.getBiome(blockPosIn).value(), (double)blockPosIn.getX(), (double)blockPosIn.getZ());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int i1 = 0;
        Cursor3D cursor3D = new Cursor3D(blockPosIn.getX() - i, blockPosIn.getY(), blockPosIn.getZ() - i, blockPosIn.getX() + i, blockPosIn.getY(), blockPosIn.getZ() + i);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.advance()) {
            blockPos.set(cursor3D.nextX(), cursor3D.nextY(), cursor3D.nextZ());
            int j1 = colorResolverIn.getColor((Biome)this.getBiome((BlockPos)blockPos).value(), (double)blockPos.getX(), (double)blockPos.getZ());
            k += (j1 & 0xFF0000) >> 16;
            l += (j1 & 0xFF00) >> 8;
            i1 += j1 & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | i1 / j & 0xFF;
    }

    public int getBrightness(LightLayer type, BlockPos pos) {
        if (!this.checkCoords(pos)) {
            return 0;
        }
        if (type == LightLayer.SKY) {
            return this.dimensionType.hasSkyLight() ? this.skylightmap[this.encodeCoords(pos)] : 0;
        }
        return type == LightLayer.BLOCK ? this.blocklightmap[this.encodeCoords(pos)] : 0;
    }

    public int getRawBrightness(BlockPos pos, int amount) {
        if (!this.checkCoords(pos.getX(), 0, pos.getZ())) {
            return 0;
        }
        if (pos.getY() < 0) {
            return 0;
        }
        if (pos.getY() >= 256) {
            int light = 15 - amount;
            if (light < 0) {
                light = 0;
            }
            return light;
        }
        int light = (this.dimensionType.hasSkyLight() ? this.skylightmap[this.encodeCoords(pos)] : 0) - amount;
        int blockLight = this.blocklightmap[this.encodeCoords(pos)];
        if (blockLight > light) {
            light = blockLight;
        }
        return light;
    }

    public float getShade(Direction face, boolean shade) {
        boolean flag = this.dimensionInfo.constantAmbientLight();
        if (!shade) {
            return flag ? 0.9f : 1.0f;
        }
        return switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if (flag) {
                    yield 0.9f;
                }
                yield 0.5f;
            }
            case Direction.UP -> {
                if (flag) {
                    yield 0.9f;
                }
                yield 1.0f;
            }
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
        };
    }

    public boolean hasChunk(int x, int z) {
        return this.checkCoords(x * 16, 0, z * 16);
    }

    public ChunkAccess getChunk(int x, int z, ChunkStatus requiredStatus, boolean nonnull) {
        return null;
    }

    public int getHeight(Heightmap.Types heightmapType, int x, int z) {
        if (heightmapType == Heightmap.Types.MOTION_BLOCKING) {
            return this.getHeightBlocking(x, z);
        }
        return 0;
    }

    public int getHeightBlocking(int x, int z) {
        return this.heightmap[x + this.xSize / 2][z + this.zSize / 2] - (int)this.effectiveGround;
    }

    public BlockPos getHeightmapPos(Heightmap.Types heightmapType, BlockPos pos) {
        return BlockPos.ZERO;
    }

    public int getSkyDarken() {
        return 0;
    }

    public WorldBorder getWorldBorder() {
        return new WorldBorder();
    }

    public boolean isUnobstructed(Entity entityIn, VoxelShape shape) {
        return false;
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity entityIn, AABB aabb) {
        return Collections.emptyList();
    }

    public boolean isEmptyBlock(BlockPos pos) {
        return this.getBlockState(pos).isAir();
    }

    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        int xMoved = x + this.xSize / 8;
        int yMoved = y + (int)this.effectiveGround / 4;
        int zMoved = z + this.zSize / 8;
        if (!this.checkCoords(x * 4, y * 4, z * 4)) {
            xMoved = Mth.clamp((int)xMoved, (int)0, (int)(this.xSize / 4 - 1));
            yMoved = Mth.clamp((int)yMoved, (int)0, (int)((this.ySize - (int)this.effectiveGround) / 4 - 1));
            zMoved = Mth.clamp((int)zMoved, (int)0, (int)(this.zSize / 4 - 1));
        }
        return Holder.direct((Object)this.biomemap[(yMoved * (this.zSize / 4) + zMoved) * (this.xSize / 4) + xMoved]);
    }

    public int getDirectSignal(BlockPos pos, Direction direction) {
        return 0;
    }

    public boolean isClientSide() {
        return false;
    }

    public int getSeaLevel() {
        return (int)(63.0f - this.effectiveGround + (float)this.getMinY());
    }

    public LevelLightEngine getLightEngine() {
        return null;
    }

    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return null;
    }

    public RegistryAccess registryAccess() {
        return null;
    }

    public FeatureFlagSet enabledFeatures() {
        return null;
    }
}

