/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client.gui.screens;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.client.gui.screens.UpdateScreen;
import org.vivecraft.client.utils.UpdateChecker;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;

@Mixin(value={TitleScreen.class})
public abstract class TitleScreenMixin
extends Screen {
    @Unique
    private Button vivecraft$vrModeButton;
    @Unique
    private Button vivecraft$updateButton;

    protected TitleScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"createNormalMenuOptions(II)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/TitleScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;", shift=At.Shift.AFTER, ordinal=1)})
    private void vivecraft$initFullGame(CallbackInfoReturnable<Integer> cir) {
        this.vivecraft$addVRModeButton();
    }

    @Inject(method={"createDemoMenuOptions(II)I"}, at={@At(value="TAIL")})
    private void vivecraft$initDemo(CallbackInfoReturnable<Integer> cir) {
        this.vivecraft$addVRModeButton();
    }

    @Unique
    private void vivecraft$addVRModeButton() {
        this.vivecraft$vrModeButton = new Button.Builder((Component)Component.translatable((String)"vivecraft.gui.vr", (Object[])new Object[]{VRState.VR_ENABLED ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF}), button -> {
            ClientDataHolderVR.getInstance().vrSettings.vrEnabled = VRState.VR_ENABLED = !VRState.VR_ENABLED;
            ClientDataHolderVR.getInstance().vrSettings.saveOptions();
            button.setMessage((Component)Component.translatable((String)"vivecraft.gui.vr", (Object[])new Object[]{VRState.VR_ENABLED ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF}));
        }).size(56, 20).pos(this.width / 2 + 104, this.height / 4 + 72).tooltip(Tooltip.create((Component)Component.translatable((String)"vivecraft.options.VR_ENABLED.tooltip"))).build();
        this.vivecraft$vrModeButton.visible = ClientDataHolderVR.getInstance().vrSettings.vrToggleButtonEnabled;
        this.addRenderableWidget((GuiEventListener)this.vivecraft$vrModeButton);
        this.vivecraft$updateButton = new Button.Builder((Component)Component.translatable((String)"vivecraft.gui.update"), button -> this.minecraft.setScreen((Screen)new UpdateScreen())).size(56, 20).pos(this.width / 2 + 104, this.height / 4 + 96).build();
        this.vivecraft$updateButton.visible = UpdateChecker.HAS_UPDATE;
        this.addRenderableWidget((GuiEventListener)this.vivecraft$updateButton);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    private void vivecraft$renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.vivecraft$updateButton != null) {
            this.vivecraft$updateButton.visible = UpdateChecker.HAS_UPDATE;
        }
        if (VRState.VR_INITIALIZED && !VRState.VR_RUNNING) {
            MutableComponent hotswitchMessage = Component.translatable((String)"vivecraft.messages.vrhotswitchinginfo");
            guiGraphics.renderTooltip(this.font, this.font.split((FormattedText)hotswitchMessage, 280), this.width / 2 - 140 - 12, 17);
        }
    }

    @Inject(method={"renderPanorama(Lnet/minecraft/client/gui/GuiGraphics;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$maybeNoPanorama(CallbackInfo ci) {
        if (VRState.VR_RUNNING && (ClientDataHolderVR.getInstance().menuWorldRenderer.isReady() || ClientDataHolderVR.getInstance().vrSettings.menuWorldFallbackPanorama)) {
            ci.cancel();
        }
    }
}

