/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.function.Consumer;
import java.util.function.Function;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_xr.render_pass.RenderPassType;

public class MultiPassRenderTarget
extends RenderTarget {
    private final RenderTarget mainTarget;
    private final Function<RenderPass, RenderTarget> vrTargets;

    public MultiPassRenderTarget(RenderTarget mainTarget, Function<RenderPass, RenderTarget> vrTargets) {
        super(mainTarget.useDepth);
        this.mainTarget = mainTarget;
        this.vrTargets = vrTargets;
        this.width = mainTarget.width;
        this.height = mainTarget.height;
        this.viewWidth = mainTarget.viewWidth;
        this.viewHeight = mainTarget.viewHeight;
        this.frameBufferId = mainTarget.frameBufferId;
        this.filterMode = mainTarget.filterMode;
    }

    public void resize(int width, int height, boolean clearError) {
        this.callOnTarget(r -> r.resize(width, height, clearError));
    }

    public void destroyBuffers() {
        this.callOnAllTargets(RenderTarget::destroyBuffers);
    }

    public void copyDepthFrom(RenderTarget otherTarget) {
        this.callOnTarget(r -> r.copyDepthFrom(otherTarget));
    }

    public void createBuffers(int width, int height, boolean clearError) {
        this.callOnTarget(r -> r.createBuffers(width, height, clearError));
    }

    public void setFilterMode(int filterMode) {
        this.callOnTarget(r -> r.setFilterMode(filterMode));
    }

    public void checkStatus() {
        this.callOnTarget(RenderTarget::checkStatus);
    }

    public void bindRead() {
        this.callOnTarget(RenderTarget::bindRead);
    }

    public void unbindRead() {
        this.callOnTarget(RenderTarget::unbindRead);
    }

    public void bindWrite(boolean setViewport) {
        this.callOnTarget(r -> r.bindWrite(setViewport));
    }

    public void unbindWrite() {
        this.callOnTarget(RenderTarget::unbindWrite);
    }

    public void setClearColor(float red, float green, float blue, float alpha) {
        this.callOnTarget(r -> r.setClearColor(red, green, blue, alpha));
    }

    public void blitToScreen(int width, int height) {
        this.callOnTarget(r -> r.blitToScreen(width, height));
    }

    public void blitToScreen(int width, int height, boolean disableBlend) {
        this.callOnTarget(r -> r.blitToScreen(width, height, disableBlend));
    }

    public void clear(boolean clearError) {
        this.callOnTarget(r -> r.clear(clearError));
    }

    public int getColorTextureId() {
        return this.callOnTargetRet(RenderTarget::getColorTextureId);
    }

    public int getDepthTextureId() {
        return this.callOnTargetRet(RenderTarget::getDepthTextureId);
    }

    private void callOnTarget(Consumer<RenderTarget> consumer) {
        consumer.accept(this.getCurrent());
    }

    private <T> T callOnTargetRet(Function<RenderTarget, T> function) {
        return function.apply(this.getCurrent());
    }

    private void callOnAllTargets(Consumer<RenderTarget> consumer) {
        consumer.accept(this.mainTarget);
        for (RenderPass pass : RenderPass.values()) {
            RenderTarget target = this.vrTargets.apply(pass);
            if (target == null) continue;
            consumer.accept(target);
        }
    }

    private RenderTarget getCurrent() {
        if (RenderPassType.isVanilla()) {
            return this.mainTarget;
        }
        RenderTarget target = this.vrTargets.apply(ClientDataHolderVR.getInstance().currentPass);
        return target != null ? target : this.mainTarget;
    }
}

