/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.common.api_impl.data;

import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRBodyPartData;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.common.api_impl.data.VRBodyPartDataImpl;

public record VRPoseImpl(VRBodyPartData hmd, VRBodyPartData c0, VRBodyPartData c1, VRBodyPartData rightFoot, VRBodyPartData leftFoot, VRBodyPartData waist, VRBodyPartData rightKnee, VRBodyPartData leftKnee, VRBodyPartData rightElbow, VRBodyPartData leftElbow, boolean isSeated, boolean isLeftHanded, FBTMode fbtMode) implements VRPose
{
    @Override
    @Nullable
    public VRBodyPartData getBodyPartData(VRBodyPart vrBodyPart) {
        if (vrBodyPart == null) {
            throw new IllegalArgumentException("Cannot get a null body part's data!");
        }
        return switch (vrBodyPart) {
            default -> throw new IncompatibleClassChangeError();
            case VRBodyPart.HEAD -> this.hmd;
            case VRBodyPart.MAIN_HAND -> this.c0;
            case VRBodyPart.OFF_HAND -> this.c1;
            case VRBodyPart.RIGHT_FOOT -> this.rightFoot;
            case VRBodyPart.LEFT_FOOT -> this.leftFoot;
            case VRBodyPart.WAIST -> this.waist;
            case VRBodyPart.RIGHT_KNEE -> this.rightKnee;
            case VRBodyPart.LEFT_KNEE -> this.leftKnee;
            case VRBodyPart.RIGHT_ELBOW -> this.rightElbow;
            case VRBodyPart.LEFT_ELBOW -> this.leftElbow;
        };
    }

    @Override
    public FBTMode getFBTMode() {
        return this.fbtMode;
    }

    public VRPoseImpl relativeToPosition(Vec3 position) {
        return new VRPoseImpl(this.relativeToPosition(this.hmd, position), this.relativeToPosition(this.c0, position), this.relativeToPosition(this.c1, position), this.relativeToPosition(this.rightFoot, position), this.relativeToPosition(this.leftFoot, position), this.relativeToPosition(this.waist, position), this.relativeToPosition(this.rightKnee, position), this.relativeToPosition(this.leftKnee, position), this.relativeToPosition(this.rightElbow, position), this.relativeToPosition(this.leftElbow, position), this.isSeated, this.isLeftHanded, this.fbtMode);
    }

    private VRBodyPartData relativeToPosition(VRBodyPartData vrBodyPartData, Vec3 position) {
        if (vrBodyPartData == null) {
            return null;
        }
        return new VRBodyPartDataImpl(vrBodyPartData.getPos().subtract(position), vrBodyPartData.getDir(), vrBodyPartData.getRotation());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("VRPose:\nHMD: ").append(this.hmd).append("\nmain hand: ").append(this.c0).append("\noffhand: ").append(this.c1);
        if (this.fbtMode != FBTMode.ARMS_ONLY) {
            sb.append("\nright foot: ").append(this.rightFoot).append("\nleft foot: ").append(this.leftFoot).append("\nwaist: ").append(this.waist);
        }
        if (this.fbtMode == FBTMode.WITH_JOINTS) {
            sb.append("\nright knee: ").append(this.rightKnee).append("\nleft knee: ").append(this.leftKnee).append("\nright elbow: ").append(this.rightElbow).append("\nleft elbow: ").append(this.leftElbow);
        }
        sb.append("\nseated: ").append(this.isSeated).append(", leftHanded: ").append(this.isLeftHanded).append(", fbtMode: ").append((Object)this.fbtMode);
        return sb.toString();
    }
}

