/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.renderer;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.extensions.LevelRendererExtension;
import org.vivecraft.client_vr.gameplay.interact_modules.BlockInteractionModule;
import org.vivecraft.client_vr.render.helpers.VREffectsHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassManager;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

@Mixin(value={LevelRenderer.class}, priority=999)
public abstract class LevelRendererVRMixin
implements ResourceManagerReloadListener,
AutoCloseable,
LevelRendererExtension {
    @Unique
    @Nullable
    private RenderTarget vivecraft$alphaSortVROccludedFramebuffer;
    @Unique
    @Nullable
    private RenderTarget vivecraft$alphaSortVRUnoccludedFramebuffer;
    @Unique
    @Nullable
    private RenderTarget vivecraft$alphaSortVRHandsFramebuffer;
    @Unique
    private boolean vivecraft$interactOutline;
    @Unique
    private Entity vivecraft$renderedEntity;
    @Final
    @Shadow
    private Minecraft minecraft;
    @Shadow
    private ClientLevel level;
    @Shadow
    private PostChain transparencyChain;
    @Final
    @Shadow
    private RenderBuffers renderBuffers;

    @Shadow
    protected abstract void renderHitOutline(PoseStack var1, VertexConsumer var2, Entity var3, double var4, double var6, double var8, BlockPos var10, BlockState var11);

    @ModifyArg(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I", ordinal=0))
    private double vivecraft$rainX(double x, @Share(value="centerPos") LocalRef<Vec3> centerPos) {
        if (!(RenderPassType.isVanilla() || ClientDataHolderVR.getInstance().currentPass != RenderPass.LEFT && ClientDataHolderVR.getInstance().currentPass != RenderPass.RIGHT)) {
            centerPos.set((Object)ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_render.getEye(RenderPass.CENTER).getPosition());
            return ((Vec3)centerPos.get()).x;
        }
        return x;
    }

    @ModifyArg(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I", ordinal=1))
    private double vivecraft$rainY(double y, @Share(value="centerPos") LocalRef<Vec3> centerPos) {
        return centerPos.get() != null ? ((Vec3)centerPos.get()).y : y;
    }

    @ModifyArg(method={"renderSnowAndRain(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I", ordinal=2))
    private double vivecraft$rainZ(double z, @Share(value="centerPos") LocalRef<Vec3> centerPos) {
        return centerPos.get() != null ? ((Vec3)centerPos.get()).z : z;
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"}, at={@At(value="TAIL")})
    private void vivecraft$reinitVR(ResourceManager resourceManager, CallbackInfo ci) {
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vrRenderer.reinitFrameBuffersMaybe("Resource Reload");
        }
    }

    @WrapOperation(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;pollLightUpdates()V")})
    private void vivecraft$onePollLightUpdates(ClientLevel instance, Operation<Void> original) {
        if (RenderPassType.isVanilla() || ClientDataHolderVR.getInstance().isFirstPass) {
            original.call(new Object[]{instance});
        }
    }

    @WrapOperation(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/lighting/LevelLightEngine;runLightUpdates()I")})
    private int vivecraft$oneLightingUpdates(LevelLightEngine instance, Operation<Integer> original) {
        if (RenderPassType.isVanilla() || ClientDataHolderVR.getInstance().isFirstPass) {
            return (Integer)original.call(new Object[]{instance});
        }
        return 0;
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;getRenderDistance()F")})
    private void vivecraft$stencil(CallbackInfo ci) {
        if (!RenderPassType.isVanilla()) {
            this.minecraft.getProfiler().popPush("stencil");
            VREffectsHelper.drawEyeStencil();
        }
    }

    @ModifyExpressionValue(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;shouldRender(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/client/renderer/culling/Frustum;DDD)Z")})
    private boolean vivecraft$dontCullPlayer(boolean doRender, @Local Entity entity) {
        return doRender || ClientDataHolderVR.getInstance().vrSettings.shouldRenderSelf && entity == Minecraft.getInstance().player;
    }

    @ModifyExpressionValue(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSleeping()Z")})
    private boolean vivecraft$noPlayerWhenSleeping(boolean isSleeping) {
        return isSleeping && RenderPassType.isVanilla();
    }

    @Inject(method={"renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"}, at={@At(value="HEAD")})
    private void vivecraft$storeEntityAndRestorePos(CallbackInfo ci, @Local(argsOnly=true) Entity entity, @Share(value="capturedEntity") LocalRef<Entity> capturedEntity) {
        if (!RenderPassType.isVanilla() && entity == this.minecraft.getCameraEntity()) {
            capturedEntity.set((Object)entity);
            ((GameRendererExtension)this.minecraft.gameRenderer).vivecraft$restoreRVEPos((Entity)capturedEntity.get());
        }
        this.vivecraft$renderedEntity = entity;
    }

    @Inject(method={"renderEntity(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;)V"}, at={@At(value="TAIL")})
    private void vivecraft$clearEntityAndSetupPos(CallbackInfo ci, @Local(argsOnly=true) Entity entity, @Share(value="capturedEntity") LocalRef<Entity> capturedEntity) {
        if (capturedEntity.get() != null) {
            ((GameRendererExtension)this.minecraft.gameRenderer).vivecraft$cacheRVEPos((Entity)capturedEntity.get());
            ((GameRendererExtension)this.minecraft.gameRenderer).vivecraft$setupRVE();
        }
        this.vivecraft$renderedEntity = null;
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;hitResult:Lnet/minecraft/world/phys/HitResult;", ordinal=1)})
    private void vivecraft$interactOutline(CallbackInfo ci, @Local(argsOnly=true) Camera camera, @Local(argsOnly=true) PoseStack poseStack) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        this.level.getProfiler().popPush("interact outline");
        this.vivecraft$interactOutline = true;
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            OptifineHelper.beginOutlineShader();
        }
        BlockInteractionModule blockModule = ClientDataHolderVR.getInstance().blockModule;
        for (int c = 0; c < 2; ++c) {
            if (!blockModule.isActive(c)) continue;
            BlockPos blockpos = blockModule.inBlockHit[c] != null ? blockModule.inBlockHit[c].getBlockPos() : BlockPos.containing((Position)ClientDataHolderVR.getInstance().vrPlayer.vrdata_world_render.getController(c).getPosition());
            BlockState blockstate = this.level.getBlockState(blockpos);
            this.renderHitOutline(poseStack, this.renderBuffers.bufferSource().getBuffer(RenderType.lines()), camera.getEntity(), camera.getPosition().x, camera.getPosition().y, camera.getPosition().z, blockpos, blockstate);
        }
        if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isShaderActive()) {
            this.renderBuffers.bufferSource().endBatch(RenderType.lines());
            OptifineHelper.endOutlineShader();
        }
        this.vivecraft$interactOutline = false;
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V", ordinal=0, shift=At.Shift.AFTER)})
    private void vivecraft$renderVrStuffPart1(CallbackInfo ci, @Local(argsOnly=true) PoseStack poseStack, @Local(argsOnly=true) float partialTick, @Share(value="guiRendered") LocalBooleanRef guiRendered) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (this.transparencyChain != null) {
            VREffectsHelper.renderVRFabulous(partialTick, (LevelRenderer)this, poseStack);
        } else {
            VREffectsHelper.renderVrFast(partialTick, false, poseStack);
            if (ShadersHelper.isShaderActive() && ClientDataHolderVR.getInstance().vrSettings.shaderGUIRender == VRSettings.ShaderGUIRender.BEFORE_TRANSLUCENT_SOLID) {
                VREffectsHelper.renderVrFast(partialTick, true, poseStack);
                guiRendered.set(true);
            }
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", ordinal=3)})
    private void vivecraft$renderVrStuffPart2(CallbackInfo ci, @Local(argsOnly=true) PoseStack poseStack, @Local(argsOnly=true) float partialTick, @Share(value="guiRendered") LocalBooleanRef guiRendered) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (!(this.transparencyChain != null || ShadersHelper.isShaderActive() && ClientDataHolderVR.getInstance().vrSettings.shaderGUIRender != VRSettings.ShaderGUIRender.AFTER_TRANSLUCENT)) {
            VREffectsHelper.renderVrFast(partialTick, true, poseStack);
            guiRendered.set(true);
        }
    }

    @Inject(method={"renderLevel(Lcom/mojang/blaze3d/vertex/PoseStack;FJZLnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lorg/joml/Matrix4f;)V"}, at={@At(value="RETURN")})
    private void vivecraft$renderVrStuffFinal(CallbackInfo ci, @Local(argsOnly=true) PoseStack poseStack, @Local(argsOnly=true) float partialTick, @Share(value="guiRendered") LocalBooleanRef guiRendered) {
        if (RenderPassType.isVanilla()) {
            return;
        }
        if (!guiRendered.get() && this.transparencyChain == null) {
            VREffectsHelper.renderVrFast(partialTick, true, poseStack);
        }
    }

    @WrapOperation(method={"renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;renderShape(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/phys/shapes/VoxelShape;DDDFFFF)V")})
    private void vivecraft$interactHitBox(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha, Operation<Void> original) {
        if (this.vivecraft$interactOutline) {
            original.call(new Object[]{poseStack, consumer, shape, x, y, z, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(alpha)});
        } else {
            original.call(new Object[]{poseStack, consumer, shape, x, y, z, Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(alpha)});
        }
    }

    @Inject(method={"levelEvent(ILnet/minecraft/core/BlockPos;I)V"}, at={@At(value="HEAD")})
    private void vivecraft$shakeOnSound(int type, BlockPos pos, int data, CallbackInfo ci) {
        boolean playerNearAndVR;
        boolean bl = playerNearAndVR = VRState.VR_RUNNING && this.minecraft.player != null && this.minecraft.player.isAlive() && this.minecraft.player.blockPosition().distSqr((Vec3i)pos) < 25.0;
        if (playerNearAndVR) {
            switch (type) {
                case 1019: 
                case 1020: 
                case 1021: {
                    ClientDataHolderVR.getInstance().vr.triggerHapticPulse(0, 750);
                    ClientDataHolderVR.getInstance().vr.triggerHapticPulse(1, 750);
                    break;
                }
                case 1030: {
                    ClientDataHolderVR.getInstance().vr.triggerHapticPulse(0, 500);
                    break;
                }
                case 1031: {
                    ClientDataHolderVR.getInstance().vr.triggerHapticPulse(0, 1250);
                    ClientDataHolderVR.getInstance().vr.triggerHapticPulse(1, 1250);
                }
            }
        }
    }

    @Inject(method={"initOutline()V", "initTransparency()V"}, at={@At(value="HEAD")})
    private void vivecraft$ensureVanillaPass(CallbackInfo ci) {
        if (VRState.VR_RUNNING) {
            RenderPassManager.setVanillaRenderPass();
        }
    }

    @WrapOperation(method={"initTransparency()V"}, at={@At(value="NEW", target="Lnet/minecraft/resources/ResourceLocation;")})
    private ResourceLocation vivecraft$vrTransparency(String location, Operation<ResourceLocation> original) {
        if (VRState.VR_INITIALIZED) {
            return (ResourceLocation)original.call(new Object[]{"shaders/post/vrtransparency.json"});
        }
        return (ResourceLocation)original.call(new Object[]{location});
    }

    @Inject(method={"initTransparency()V"}, at={@At(value="TAIL")})
    private void vivecraft$getVRTargets(CallbackInfo ci) {
        if (VRState.VR_INITIALIZED && this.transparencyChain != null) {
            this.vivecraft$alphaSortVRHandsFramebuffer = this.transparencyChain.getTempTarget("vrhands");
            this.vivecraft$alphaSortVROccludedFramebuffer = this.transparencyChain.getTempTarget("vroccluded");
            this.vivecraft$alphaSortVRUnoccludedFramebuffer = this.transparencyChain.getTempTarget("vrunoccluded");
        }
    }

    @Inject(method={"deinitTransparency()V"}, at={@At(value="TAIL")})
    private void vivecraft$removeVRTargets(CallbackInfo ci) {
        this.vivecraft$alphaSortVRHandsFramebuffer = null;
        this.vivecraft$alphaSortVROccludedFramebuffer = null;
        this.vivecraft$alphaSortVRUnoccludedFramebuffer = null;
    }

    @Override
    @Unique
    public Entity vivecraft$getRenderedEntity() {
        return this.vivecraft$renderedEntity;
    }

    @Override
    @Unique
    public RenderTarget vivecraft$getAlphaSortVROccludedFramebuffer() {
        return this.vivecraft$alphaSortVROccludedFramebuffer;
    }

    @Override
    @Unique
    public RenderTarget vivecraft$getAlphaSortVRUnoccludedFramebuffer() {
        return this.vivecraft$alphaSortVRUnoccludedFramebuffer;
    }

    @Override
    @Unique
    public RenderTarget vivecraft$getAlphaSortVRHandsFramebuffer() {
        return this.vivecraft$alphaSortVRHandsFramebuffer;
    }
}

