/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.neoforge;

import com.mojang.blaze3d.pipeline.RenderTarget;
import java.util.Collection;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.vivecraft.Xplat;
import org.vivecraft.common.network.packet.c2s.VivecraftPayloadC2S;
import org.vivecraft.common.network.packet.s2c.VivecraftPayloadS2C;
import org.vivecraft.neoforge.packet.VivecraftPayloadBiDir;

public class XplatImpl
implements Xplat {
    public static boolean enableRenderTargetStencil(RenderTarget renderTarget) {
        renderTarget.enableStencil();
        return true;
    }

    public static String getUseMethodName() {
        return "use";
    }

    public static TextureAtlasSprite[] getFluidTextures(BlockAndTintGetter level, BlockPos pos, FluidState fluidStateIn) {
        return FluidSpriteCache.getFluidSprites((BlockAndTintGetter)level, (BlockPos)pos, (FluidState)fluidStateIn);
    }

    public static Biome.ClimateSettings getBiomeClimateSettings(Biome biome) {
        return biome.getModifiedClimateSettings();
    }

    public static BiomeSpecialEffects getBiomeEffects(Biome biome) {
        return biome.getModifiedSpecialEffects();
    }

    public static double getItemEntityReach(double baseRange, ItemStack itemStack, EquipmentSlot slot) {
        Collection attributes = itemStack.getAttributeModifiers(slot).get((Object)((Attribute)NeoForgeMod.ENTITY_REACH.value()));
        for (AttributeModifier a : attributes) {
            if (a.getOperation() != AttributeModifier.Operation.ADDITION) continue;
            baseRange += a.getAmount();
        }
        double totalRange = baseRange;
        for (AttributeModifier a : attributes) {
            if (a.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            totalRange += baseRange * a.getAmount();
        }
        for (AttributeModifier a : attributes) {
            if (a.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            totalRange *= 1.0 + a.getAmount();
        }
        return totalRange;
    }

    public static Packet<?> getC2SPacket(VivecraftPayloadC2S payload) {
        return new ServerboundCustomPayloadPacket((CustomPacketPayload)new VivecraftPayloadBiDir(payload));
    }

    public static Packet<?> getS2CPacket(VivecraftPayloadS2C payload) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new VivecraftPayloadBiDir(payload));
    }

    public static boolean hasKeyModifier(KeyMapping keyMapping) {
        return keyMapping.getKeyModifier() != KeyModifier.NONE;
    }

    public static int getKeyModifier(KeyMapping keyMapping) {
        return switch (keyMapping.getKeyModifier()) {
            case KeyModifier.SHIFT -> 1;
            case KeyModifier.ALT -> 4;
            case KeyModifier.CONTROL -> 2;
            default -> 0;
        };
    }

    public static int getKeyModifierKey(KeyMapping keyMapping) {
        return switch (keyMapping.getKeyModifier()) {
            case KeyModifier.SHIFT -> 340;
            case KeyModifier.ALT -> 346;
            case KeyModifier.CONTROL -> 341;
            default -> -1;
        };
    }

    public static boolean isFakePlayer(ServerPlayer player) {
        return player instanceof FakePlayer;
    }
}

