/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct PathRead_t")
public class PathRead
extends Struct<PathRead>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ULPATH;
    public static final int PVBUFFER;
    public static final int UNBUFFERSIZE;
    public static final int UNTAG;
    public static final int UNREQUIREDBUFFERSIZE;
    public static final int EERROR;
    public static final int PSZPATH;

    protected PathRead(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected PathRead create(long address, @Nullable ByteBuffer container) {
        return new PathRead(address, container);
    }

    public PathRead(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), PathRead.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="PathHandle_t")
    public long ulPath() {
        return PathRead.nulPath(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pvBuffer() {
        return PathRead.npvBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int unBufferSize() {
        return PathRead.nunBufferSize(this.address());
    }

    @NativeType(value="PropertyTypeTag_t")
    public int unTag() {
        return PathRead.nunTag(this.address());
    }

    @NativeType(value="uint32_t")
    public int unRequiredBufferSize() {
        return PathRead.nunRequiredBufferSize(this.address());
    }

    @NativeType(value="ETrackedPropertyError")
    public int eError() {
        return PathRead.neError(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer pszPath() {
        return PathRead.npszPath(this.address());
    }

    @NativeType(value="char *")
    public String pszPathString() {
        return PathRead.npszPathString(this.address());
    }

    public PathRead ulPath(@NativeType(value="PathHandle_t") long value) {
        PathRead.nulPath(this.address(), value);
        return this;
    }

    public PathRead pvBuffer(@NativeType(value="void *") ByteBuffer value) {
        PathRead.npvBuffer(this.address(), value);
        return this;
    }

    public PathRead unTag(@NativeType(value="PropertyTypeTag_t") int value) {
        PathRead.nunTag(this.address(), value);
        return this;
    }

    public PathRead unRequiredBufferSize(@NativeType(value="uint32_t") int value) {
        PathRead.nunRequiredBufferSize(this.address(), value);
        return this;
    }

    public PathRead eError(@NativeType(value="ETrackedPropertyError") int value) {
        PathRead.neError(this.address(), value);
        return this;
    }

    public PathRead pszPath(@NativeType(value="char *") ByteBuffer value) {
        PathRead.npszPath(this.address(), value);
        return this;
    }

    public PathRead set(long ulPath, ByteBuffer pvBuffer, int unTag, int unRequiredBufferSize, int eError, ByteBuffer pszPath) {
        this.ulPath(ulPath);
        this.pvBuffer(pvBuffer);
        this.unTag(unTag);
        this.unRequiredBufferSize(unRequiredBufferSize);
        this.eError(eError);
        this.pszPath(pszPath);
        return this;
    }

    public PathRead set(PathRead src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static PathRead malloc() {
        return new PathRead(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static PathRead calloc() {
        return new PathRead(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static PathRead create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new PathRead(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static PathRead create(long address) {
        return new PathRead(address, null);
    }

    @Nullable
    public static PathRead createSafe(long address) {
        return address == 0L ? null : new PathRead(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)PathRead.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = PathRead.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static PathRead malloc(MemoryStack stack) {
        return new PathRead(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static PathRead calloc(MemoryStack stack) {
        return new PathRead(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nulPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)ULPATH);
    }

    public static ByteBuffer npvBuffer(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)), (int)PathRead.nunBufferSize(struct));
    }

    public static int nunBufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNBUFFERSIZE);
    }

    public static int nunTag(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNTAG);
    }

    public static int nunRequiredBufferSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNREQUIREDBUFFERSIZE);
    }

    public static int neError(long struct) {
        return UNSAFE.getInt(null, struct + (long)EERROR);
    }

    public static ByteBuffer npszPath(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PSZPATH)));
    }

    public static String npszPathString(long struct) {
        return MemoryUtil.memASCII((long)MemoryUtil.memGetAddress((long)(struct + (long)PSZPATH)));
    }

    public static void nulPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ULPATH, value);
    }

    public static void npvBuffer(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVBUFFER), (long)MemoryUtil.memAddress((ByteBuffer)value));
        PathRead.nunBufferSize(struct, value.remaining());
    }

    public static void nunBufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNBUFFERSIZE, value);
    }

    public static void nunTag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNTAG, value);
    }

    public static void nunRequiredBufferSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)UNREQUIREDBUFFERSIZE, value);
    }

    public static void neError(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EERROR, value);
    }

    public static void npszPath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PSZPATH), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVBUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSZPATH)));
    }

    static {
        Struct.Layout layout = PathRead.__struct((Struct.Member[])new Struct.Member[]{PathRead.__member((int)8), PathRead.__member((int)POINTER_SIZE), PathRead.__member((int)4), PathRead.__member((int)4), PathRead.__member((int)4), PathRead.__member((int)4), PathRead.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ULPATH = layout.offsetof(0);
        PVBUFFER = layout.offsetof(1);
        UNBUFFERSIZE = layout.offsetof(2);
        UNTAG = layout.offsetof(3);
        UNREQUIREDBUFFERSIZE = layout.offsetof(4);
        EERROR = layout.offsetof(5);
        PSZPATH = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<PathRead, Buffer>
    implements NativeResource {
        private static final PathRead ELEMENT_FACTORY = PathRead.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected PathRead getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="PathHandle_t")
        public long ulPath() {
            return PathRead.nulPath(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pvBuffer() {
            return PathRead.npvBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int unBufferSize() {
            return PathRead.nunBufferSize(this.address());
        }

        @NativeType(value="PropertyTypeTag_t")
        public int unTag() {
            return PathRead.nunTag(this.address());
        }

        @NativeType(value="uint32_t")
        public int unRequiredBufferSize() {
            return PathRead.nunRequiredBufferSize(this.address());
        }

        @NativeType(value="ETrackedPropertyError")
        public int eError() {
            return PathRead.neError(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer pszPath() {
            return PathRead.npszPath(this.address());
        }

        @NativeType(value="char *")
        public String pszPathString() {
            return PathRead.npszPathString(this.address());
        }

        public Buffer ulPath(@NativeType(value="PathHandle_t") long value) {
            PathRead.nulPath(this.address(), value);
            return this;
        }

        public Buffer pvBuffer(@NativeType(value="void *") ByteBuffer value) {
            PathRead.npvBuffer(this.address(), value);
            return this;
        }

        public Buffer unTag(@NativeType(value="PropertyTypeTag_t") int value) {
            PathRead.nunTag(this.address(), value);
            return this;
        }

        public Buffer unRequiredBufferSize(@NativeType(value="uint32_t") int value) {
            PathRead.nunRequiredBufferSize(this.address(), value);
            return this;
        }

        public Buffer eError(@NativeType(value="ETrackedPropertyError") int value) {
            PathRead.neError(this.address(), value);
            return this;
        }

        public Buffer pszPath(@NativeType(value="char *") ByteBuffer value) {
            PathRead.npszPath(this.address(), value);
            return this;
        }
    }
}

