/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.data.FBTMode;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.api.data.VRPose;
import org.vivecraft.client.extensions.SparkParticleExtension;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client.utils.ModelUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.common.api_impl.VRAPIImpl;
import org.vivecraft.common.api_impl.data.VRBodyPartDataImpl;
import org.vivecraft.common.api_impl.data.VRPoseImpl;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.utils.MathUtils;

public class ClientVRPlayers {
    private static ClientVRPlayers INSTANCE;
    private final Minecraft mc;
    private final Map<UUID, RotInfo> vivePlayers = new HashMap<UUID, RotInfo>();
    private final Map<UUID, RotInfo> vivePlayersLast = new HashMap<UUID, RotInfo>();
    private final Map<UUID, RotInfo> vivePlayersReceived = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Integer> donors = new HashMap<UUID, Integer>();
    private static long LOCAL_PLAYER_ROT_INFO_FRAME_INDEX;
    private static RotInfo LOCAL_PLAYER_ROT_INFO;
    private final Random rand = new Random();

    public static ClientVRPlayers getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientVRPlayers();
        }
        return INSTANCE;
    }

    public static void clear() {
        if (INSTANCE != null) {
            ClientVRPlayers.INSTANCE.vivePlayers.clear();
            ClientVRPlayers.INSTANCE.vivePlayersLast.clear();
            ClientVRPlayers.INSTANCE.vivePlayersReceived.clear();
        }
        LOCAL_PLAYER_ROT_INFO = null;
        LOCAL_PLAYER_ROT_INFO_FRAME_INDEX = -1L;
    }

    private ClientVRPlayers() {
        this.mc = Minecraft.getInstance();
    }

    public boolean isVRPlayer(Entity player) {
        return this.isVRPlayer(player.getUUID());
    }

    public boolean isVRPlayer(UUID uuid) {
        return this.vivePlayers.containsKey(uuid) || VRState.VR_RUNNING && this.mc.player != null && uuid.equals(this.mc.player.getUUID());
    }

    public boolean isVRAndSeated(UUID uuid) {
        return this.vivePlayers.containsKey(uuid) && this.vivePlayers.get((Object)uuid).seated || VRState.VR_RUNNING && this.mc.player != null && uuid.equals(this.mc.player.getUUID()) && ClientDataHolderVR.getInstance().vrSettings.seated;
    }

    public boolean isVRAndLeftHanded(UUID uuid) {
        return this.vivePlayers.containsKey(uuid) && this.vivePlayers.get((Object)uuid).leftHanded || VRState.VR_RUNNING && this.mc.player != null && uuid.equals(this.mc.player.getUUID()) && ClientDataHolderVR.getInstance().vrSettings.reverseHands;
    }

    public void disableVR(UUID player) {
        this.vivePlayers.remove(player);
        this.vivePlayersLast.remove(player);
        this.vivePlayersReceived.remove(player);
        VRAPIImpl.INSTANCE.clearPoseHistory(player, true);
    }

    public void update(UUID uuid, VrPlayerState vrPlayerState, float worldScale, float heightScale, boolean localPlayer) {
        Player otherPlayer;
        if (!localPlayer && this.mc.player.getUUID().equals(uuid) && ClientDataHolderVR.getInstance().vrSettings.mainPlayerDataSource != VRSettings.DataSource.SERVER) {
            return;
        }
        Vector3f hmdDir = vrPlayerState.hmd().orientation().transform(MathUtils.BACK, new Vector3f());
        Vector3f controller0Dir = vrPlayerState.mainHand().orientation().transform(MathUtils.BACK, new Vector3f());
        Vector3f controller1Dir = vrPlayerState.offHand().orientation().transform(MathUtils.BACK, new Vector3f());
        RotInfo rotInfo = new RotInfo();
        rotInfo.leftHanded = vrPlayerState.leftHanded();
        rotInfo.seated = vrPlayerState.seated();
        rotInfo.hmd = this.donors.getOrDefault(uuid, 0);
        rotInfo.offHandRot = controller1Dir;
        rotInfo.mainHandRot = controller0Dir;
        rotInfo.headRot = hmdDir;
        rotInfo.offHandPos = vrPlayerState.offHand().position();
        rotInfo.mainHandPos = vrPlayerState.mainHand().position();
        rotInfo.headPos = vrPlayerState.hmd().position();
        rotInfo.offHandQuat = vrPlayerState.offHand().orientation();
        rotInfo.mainHandQuat = vrPlayerState.mainHand().orientation();
        rotInfo.headQuat = vrPlayerState.hmd().orientation();
        rotInfo.worldScale = worldScale;
        if (heightScale < 0.5f) {
            heightScale = 0.5f;
        }
        if (heightScale > 1.5f) {
            heightScale = 1.5f;
        }
        rotInfo.heightScale = heightScale;
        if (rotInfo.seated) {
            rotInfo.heightScale = 1.0f;
        }
        rotInfo.fbtMode = vrPlayerState.fbtMode();
        if (rotInfo.fbtMode != FBTMode.ARMS_ONLY) {
            rotInfo.waistPos = vrPlayerState.waist().position();
            rotInfo.rightFootPos = vrPlayerState.rightFoot().position();
            rotInfo.leftFootPos = vrPlayerState.leftFoot().position();
            rotInfo.waistQuat = vrPlayerState.waist().orientation();
            rotInfo.rightFootQuat = vrPlayerState.rightFoot().orientation();
            rotInfo.leftFootQuat = vrPlayerState.leftFoot().orientation();
        }
        if (rotInfo.fbtMode == FBTMode.WITH_JOINTS) {
            rotInfo.rightKneePos = vrPlayerState.rightKnee().position();
            rotInfo.leftKneePos = vrPlayerState.leftKnee().position();
            rotInfo.rightElbowPos = vrPlayerState.rightElbow().position();
            rotInfo.leftElbowPos = vrPlayerState.leftElbow().position();
            rotInfo.rightKneeQuat = vrPlayerState.rightKnee().orientation();
            rotInfo.leftKneeQuat = vrPlayerState.leftKnee().orientation();
            rotInfo.rightElbowQuat = vrPlayerState.rightElbow().orientation();
            rotInfo.leftElbowQuat = vrPlayerState.leftElbow().orientation();
        }
        if (!localPlayer && (otherPlayer = this.mc.level.getPlayerByUUID(uuid)) != null) {
            VRAPIImpl.INSTANCE.addPoseToHistory(uuid, rotInfo.asVRPose(otherPlayer.position()), otherPlayer.position(), true);
        }
        this.vivePlayersReceived.put(uuid, rotInfo);
    }

    public void update(UUID uuid, VrPlayerState vrPlayerState, float worldScale, float heightScale) {
        this.update(uuid, vrPlayerState, worldScale, heightScale, false);
    }

    public void tick() {
        this.vivePlayersLast.putAll(this.vivePlayers);
        this.vivePlayers.putAll(this.vivePlayersReceived);
        ClientLevel level = this.mc.level;
        if (level != null) {
            Iterator<UUID> iterator = this.vivePlayers.keySet().iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                if (level.getPlayerByUUID(uuid) != null) continue;
                iterator.remove();
                this.vivePlayersLast.remove(uuid);
                this.vivePlayersReceived.remove(uuid);
                VRAPIImpl.INSTANCE.clearPoseHistory(uuid, true);
            }
            if (!this.mc.isPaused()) {
                for (Player player : level.players()) {
                    Vector3f look;
                    if (this.donors.getOrDefault(player.getUUID(), 0) <= 3 || this.rand.nextInt(10) >= 4) continue;
                    RotInfo rotInfo = this.vivePlayers.get(player.getUUID());
                    float xzOffset = player.isShiftKeyDown() ? 6.0f : 0.0f;
                    float yOffset = player.isShiftKeyDown() ? 0.6f : 0.8f;
                    Vec3 pos = player.position();
                    if (rotInfo != null) {
                        look = MathUtils.FORWARD.rotateY(-rotInfo.getBodyYawRad(), new Vector3f());
                        if (player.isVisuallySwimming() && (player.isInWater() || rotInfo.fbtMode == FBTMode.ARMS_ONLY)) {
                            yOffset = 0.3f * rotInfo.heightScale;
                            xzOffset = 14.0f * rotInfo.heightScale;
                            if (player.isInWater()) {
                                pivot = rotInfo.headQuat.transform(0.0f, -0.2f, 0.1f, new Vector3f()).add(rotInfo.headPos);
                                pos = pos.add((double)pivot.x, (double)pivot.y, (double)pivot.z);
                            }
                        } else if (rotInfo.fbtMode != FBTMode.ARMS_ONLY) {
                            pos = pos.add((double)rotInfo.waistPos.x(), (double)rotInfo.waistPos.y(), (double)rotInfo.waistPos.z());
                            yOffset = 0.0f;
                        } else {
                            pivot = rotInfo.headQuat.transform(0.0f, -0.2f, 0.1f, new Vector3f()).add(rotInfo.headPos);
                            float bend = ModelUtils.getBendProgress(player.isAutoSpinAttack(), player.isCrouching(), player.isPassenger(), rotInfo, (Vector3fc)pivot);
                            if (ClientDataHolderVR.getInstance().vrSettings.playerModelType == VRSettings.PlayerModelType.SPLIT_ARMS_LEGS) {
                                yOffset = -0.7f * Mth.cos((float)(bend * 1.5707964f)) * rotInfo.heightScale;
                                xzOffset = bend * 14.0f * rotInfo.heightScale;
                            } else {
                                yOffset = -0.7f * Mth.cos((float)(bend * (float)Math.PI)) * rotInfo.heightScale;
                                xzOffset = 14.0f * rotInfo.heightScale * Mth.sin((float)(bend * (float)Math.PI));
                            }
                            pos = pos.add((double)pivot.x, (double)pivot.y, (double)pivot.z);
                        }
                    } else {
                        look = MathUtils.FORWARD.rotateY((float)(-Math.PI) / 180 * player.yBodyRot, new Vector3f());
                    }
                    look = look.mul(0.05f);
                    Particle particle = this.mc.particleEngine.createParticle((ParticleOptions)ParticleTypes.FIREWORK, pos.x - (double)(look.x * xzOffset) + (double)((this.rand.nextFloat() - 0.5f) * 0.02f), pos.y + (double)yOffset + (double)((this.rand.nextFloat() - 0.5f) * 0.02f), pos.z - (double)(look.z * xzOffset) + (double)((this.rand.nextFloat() - 0.5f) * 0.02f), (double)(-look.x + (this.rand.nextFloat() - 0.5f) * 0.01f), (double)((this.rand.nextFloat() - 0.05f) * 0.05f), (double)(-look.z + (this.rand.nextFloat() - 0.5f) * 0.01f));
                    if (particle == null) continue;
                    ((SimpleAnimatedParticle)particle).setColor(0.5f + this.rand.nextFloat() * 0.5f, 0.5f + this.rand.nextFloat() * 0.5f, 0.5f + this.rand.nextFloat() * 0.5f);
                    ((SparkParticleExtension)particle).vivecraft$setPlayerUUID(player.getUUID());
                }
            }
        }
    }

    public void setHMD(UUID uuid, int level) {
        this.donors.put(uuid, level);
    }

    public boolean hasHMD(UUID uuid) {
        return this.donors.containsKey(uuid);
    }

    public RotInfo getLatestRotationsForPlayer(UUID uuid) {
        return this.vivePlayers.containsKey(uuid) ? this.vivePlayers.get(uuid) : this.vivePlayersLast.get(uuid);
    }

    public RotInfo getRotationsForPlayer(UUID uuid) {
        float partialTick = ClientUtils.getCurrentPartialTick();
        if (VRState.VR_RUNNING && this.mc.player != null && uuid.equals(this.mc.player.getUUID()) && this.mc.getCameraEntity() == this.mc.player && ClientDataHolderVR.getInstance().vrSettings.mainPlayerDataSource == VRSettings.DataSource.REALTIME) {
            return ClientVRPlayers.getMainPlayerRotInfo((LivingEntity)this.mc.player, partialTick);
        }
        RotInfo newRotInfo = this.vivePlayers.get(uuid);
        if (newRotInfo != null && this.vivePlayersLast.containsKey(uuid)) {
            RotInfo lastRotInfo = this.vivePlayersLast.get(uuid);
            RotInfo lerpRotInfo = new RotInfo();
            lerpRotInfo.leftHanded = newRotInfo.leftHanded;
            lerpRotInfo.seated = newRotInfo.seated;
            lerpRotInfo.hmd = newRotInfo.hmd;
            lerpRotInfo.offHandPos = lastRotInfo.offHandPos.lerp(newRotInfo.offHandPos, partialTick, new Vector3f());
            lerpRotInfo.mainHandPos = lastRotInfo.mainHandPos.lerp(newRotInfo.mainHandPos, partialTick, new Vector3f());
            lerpRotInfo.headPos = lastRotInfo.headPos.lerp(newRotInfo.headPos, partialTick, new Vector3f());
            lerpRotInfo.offHandQuat = lastRotInfo.offHandQuat.nlerp(newRotInfo.offHandQuat, partialTick, new Quaternionf());
            lerpRotInfo.mainHandQuat = lastRotInfo.mainHandQuat.nlerp(newRotInfo.mainHandQuat, partialTick, new Quaternionf());
            lerpRotInfo.headQuat = lastRotInfo.headQuat.nlerp(newRotInfo.headQuat, partialTick, new Quaternionf());
            lerpRotInfo.offHandRot = lastRotInfo.offHandRot.lerp(newRotInfo.offHandRot, partialTick, new Vector3f());
            lerpRotInfo.mainHandRot = lastRotInfo.mainHandRot.lerp(newRotInfo.mainHandRot, partialTick, new Vector3f());
            lerpRotInfo.headRot = lastRotInfo.headRot.lerp(newRotInfo.headRot, partialTick, new Vector3f());
            lerpRotInfo.heightScale = newRotInfo.heightScale;
            lerpRotInfo.worldScale = newRotInfo.worldScale;
            lerpRotInfo.fbtMode = FBTMode.values()[Math.min(lastRotInfo.fbtMode.ordinal(), newRotInfo.fbtMode.ordinal())];
            if (lastRotInfo.fbtMode != FBTMode.ARMS_ONLY && newRotInfo.fbtMode != FBTMode.ARMS_ONLY) {
                lerpRotInfo.waistPos = lastRotInfo.waistPos.lerp(newRotInfo.waistPos, partialTick, new Vector3f());
                lerpRotInfo.rightFootPos = lastRotInfo.rightFootPos.lerp(newRotInfo.rightFootPos, partialTick, new Vector3f());
                lerpRotInfo.leftFootPos = lastRotInfo.leftFootPos.lerp(newRotInfo.leftFootPos, partialTick, new Vector3f());
                lerpRotInfo.waistQuat = lastRotInfo.waistQuat.nlerp(newRotInfo.waistQuat, partialTick, new Quaternionf());
                lerpRotInfo.rightFootQuat = lastRotInfo.rightFootQuat.nlerp(newRotInfo.rightFootQuat, partialTick, new Quaternionf());
                lerpRotInfo.leftFootQuat = lastRotInfo.leftFootQuat.nlerp(newRotInfo.leftFootQuat, partialTick, new Quaternionf());
                if (lastRotInfo.fbtMode == FBTMode.WITH_JOINTS && newRotInfo.fbtMode == FBTMode.WITH_JOINTS) {
                    lerpRotInfo.leftKneePos = lastRotInfo.leftKneePos.lerp(newRotInfo.leftKneePos, partialTick, new Vector3f());
                    lerpRotInfo.rightKneePos = lastRotInfo.rightKneePos.lerp(newRotInfo.rightKneePos, partialTick, new Vector3f());
                    lerpRotInfo.leftElbowPos = lastRotInfo.leftElbowPos.lerp(newRotInfo.leftElbowPos, partialTick, new Vector3f());
                    lerpRotInfo.rightElbowPos = lastRotInfo.rightElbowPos.lerp(newRotInfo.rightElbowPos, partialTick, new Vector3f());
                    lerpRotInfo.leftKneeQuat = lastRotInfo.leftKneeQuat.nlerp(newRotInfo.leftKneeQuat, partialTick, new Quaternionf());
                    lerpRotInfo.rightKneeQuat = lastRotInfo.rightKneeQuat.nlerp(newRotInfo.rightKneeQuat, partialTick, new Quaternionf());
                    lerpRotInfo.leftElbowQuat = lastRotInfo.leftElbowQuat.nlerp(newRotInfo.leftElbowQuat, partialTick, new Quaternionf());
                    lerpRotInfo.rightElbowQuat = lastRotInfo.rightElbowQuat.nlerp(newRotInfo.rightElbowQuat, partialTick, new Quaternionf());
                }
            }
            return lerpRotInfo;
        }
        return newRotInfo;
    }

    public static RotInfo getMainPlayerRotInfo(LivingEntity player, float partialTick) {
        if (LOCAL_PLAYER_ROT_INFO != null && ClientDataHolderVR.getInstance().frameIndex == LOCAL_PLAYER_ROT_INFO_FRAME_INDEX) {
            return LOCAL_PLAYER_ROT_INFO;
        }
        RotInfo rotInfo = new RotInfo();
        VRData data = ClientDataHolderVR.getInstance().vrPlayer.getVRDataWorld();
        rotInfo.seated = ClientDataHolderVR.getInstance().vrSettings.seated;
        rotInfo.leftHanded = ClientDataHolderVR.getInstance().vrSettings.reverseHands;
        rotInfo.fbtMode = data.fbtMode;
        rotInfo.hmd = ClientVRPlayers.INSTANCE.donors.getOrDefault(player.getUUID(), 0);
        rotInfo.heightScale = AutoCalibration.getPlayerHeight() / 1.52f;
        rotInfo.worldScale = ClientDataHolderVR.getInstance().vrPlayer.worldScale;
        LOCAL_PLAYER_ROT_INFO_FRAME_INDEX = ClientDataHolderVR.getInstance().frameIndex;
        LOCAL_PLAYER_ROT_INFO = rotInfo;
        rotInfo.offHandQuat = data.getController(1).getMatrix().getNormalizedRotation(new Quaternionf());
        rotInfo.mainHandQuat = data.getController(0).getMatrix().getNormalizedRotation(new Quaternionf());
        rotInfo.headQuat = data.hmd.getMatrix().getNormalizedRotation(new Quaternionf());
        rotInfo.offHandRot = rotInfo.offHandQuat.transform(MathUtils.BACK, new Vector3f());
        rotInfo.mainHandRot = rotInfo.mainHandQuat.transform(MathUtils.BACK, new Vector3f());
        rotInfo.headRot = rotInfo.headQuat.transform(MathUtils.BACK, new Vector3f());
        Vec3 pos = player == Minecraft.getInstance().player && !RenderPassType.isGuiOnly() ? ((GameRendererExtension)Minecraft.getInstance().gameRenderer).vivecraft$getRvePos(partialTick) : player.getPosition(partialTick);
        rotInfo.offHandPos = MathUtils.subtractToVector3f(RenderHelper.getControllerRenderPos(1), pos);
        rotInfo.mainHandPos = MathUtils.subtractToVector3f(RenderHelper.getControllerRenderPos(0), pos);
        rotInfo.headPos = MathUtils.subtractToVector3f(data.hmd.getPosition(), pos);
        if (data.fbtMode != FBTMode.ARMS_ONLY) {
            rotInfo.waistQuat = data.getDevice(3).getMatrix().getNormalizedRotation(new Quaternionf());
            rotInfo.rightFootQuat = data.getDevice(4).getMatrix().getNormalizedRotation(new Quaternionf());
            rotInfo.leftFootQuat = data.getDevice(5).getMatrix().getNormalizedRotation(new Quaternionf());
            rotInfo.waistPos = MathUtils.subtractToVector3f(data.getDevice(3).getPosition(), pos);
            rotInfo.rightFootPos = MathUtils.subtractToVector3f(data.getDevice(4).getPosition(), pos);
            rotInfo.leftFootPos = MathUtils.subtractToVector3f(data.getDevice(5).getPosition(), pos);
            if (data.fbtMode == FBTMode.WITH_JOINTS) {
                rotInfo.leftKneeQuat = data.getDevice(9).getMatrix().getNormalizedRotation(new Quaternionf());
                rotInfo.rightKneeQuat = data.getDevice(8).getMatrix().getNormalizedRotation(new Quaternionf());
                rotInfo.leftElbowQuat = data.getDevice(7).getMatrix().getNormalizedRotation(new Quaternionf());
                rotInfo.rightElbowQuat = data.getDevice(6).getMatrix().getNormalizedRotation(new Quaternionf());
                rotInfo.leftKneePos = MathUtils.subtractToVector3f(data.getDevice(9).getPosition(), pos);
                rotInfo.rightKneePos = MathUtils.subtractToVector3f(data.getDevice(8).getPosition(), pos);
                rotInfo.leftElbowPos = MathUtils.subtractToVector3f(data.getDevice(7).getPosition(), pos);
                rotInfo.rightElbowPos = MathUtils.subtractToVector3f(data.getDevice(6).getPosition(), pos);
            }
        }
        return rotInfo;
    }

    public static float getFacingYaw(RotInfo rotInfo) {
        Vector3f facingVec = ClientVRPlayers.getOrientVec(rotInfo.headQuat);
        return (float)Math.toDegrees(Math.atan2(facingVec.x, facingVec.z));
    }

    public static Vector3f getOrientVec(Quaternionfc quat) {
        Vector3f localFwd = quat.transform(MathUtils.BACK, new Vector3f());
        Vector3f localUp = quat.transform(MathUtils.UP, new Vector3f());
        Vector3f facingPlaneNormal = localFwd.cross((Vector3fc)localUp).normalize();
        return MathUtils.UP.cross((Vector3fc)facingPlaneNormal, new Vector3f()).normalize();
    }

    private static VRBodyPartDataImpl makeBodyPartData(Vector3fc pos, Vector3fc rot, Quaternionfc quat, Vec3 playerPos) {
        return new VRBodyPartDataImpl(MathUtils.toMcVec3(pos).add(playerPos), MathUtils.toMcVec3(rot), quat);
    }

    private static VRBodyPartDataImpl makeBodyPartData(Vector3fc pos, Quaternionfc quat, Vec3 playerPos, boolean partAvailable) {
        return partAvailable ? ClientVRPlayers.makeBodyPartData(pos, (Vector3fc)quat.transform(MathUtils.BACK, new Vector3f()), quat, playerPos) : null;
    }

    static {
        LOCAL_PLAYER_ROT_INFO_FRAME_INDEX = -1L;
    }

    public static class RotInfo {
        public boolean seated;
        public boolean leftHanded;
        public int hmd = 0;
        public Quaternionfc offHandQuat;
        public Quaternionfc mainHandQuat;
        public Quaternionfc headQuat;
        public Vector3fc offHandRot;
        public Vector3fc mainHandRot;
        public Vector3fc headRot;
        public Vector3fc offHandPos;
        public Vector3fc mainHandPos;
        public Vector3fc headPos;
        public float worldScale;
        public float heightScale;
        public FBTMode fbtMode;
        public Vector3fc waistPos;
        public Quaternionfc waistQuat;
        public Vector3fc rightFootPos;
        public Quaternionfc rightFootQuat;
        public Vector3fc leftFootPos;
        public Quaternionfc leftFootQuat;
        public Vector3fc rightKneePos;
        public Quaternionfc rightKneeQuat;
        public Vector3fc leftKneePos;
        public Quaternionfc leftKneeQuat;
        public Vector3fc rightElbowPos;
        public Quaternionfc rightElbowQuat;
        public Vector3fc leftElbowPos;
        public Quaternionfc leftElbowQuat;
        private VRPose vrPose;

        public float getBodyYawRad() {
            Vector3f dir = new Vector3f();
            if (this.seated || this.fbtMode == FBTMode.ARMS_ONLY && this.offHandPos.distanceSquared(this.mainHandPos) == 0.0f) {
                dir.set(this.headRot);
            } else if (this.fbtMode != FBTMode.ARMS_ONLY) {
                this.waistQuat.transform(MathUtils.BACK, dir).lerp(this.headRot, 0.5f);
            } else {
                return MathUtils.bodyYawRad(this.leftHanded ? this.offHandPos : this.mainHandPos, this.leftHanded ? this.mainHandPos : this.offHandPos, this.headRot);
            }
            return (float)Math.atan2(-dir.x, dir.z);
        }

        public VRPose asVRPose(Vec3 playerPos) {
            if (this.vrPose == null) {
                this.vrPose = new VRPoseImpl(ClientVRPlayers.makeBodyPartData(this.headPos, this.headRot, this.headQuat, playerPos), ClientVRPlayers.makeBodyPartData(this.mainHandPos, this.mainHandRot, this.mainHandQuat, playerPos), ClientVRPlayers.makeBodyPartData(this.offHandPos, this.offHandRot, this.offHandQuat, playerPos), ClientVRPlayers.makeBodyPartData(this.rightFootPos, this.rightFootQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.RIGHT_FOOT)), ClientVRPlayers.makeBodyPartData(this.leftFootPos, this.leftFootQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.LEFT_FOOT)), ClientVRPlayers.makeBodyPartData(this.waistPos, this.waistQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.WAIST)), ClientVRPlayers.makeBodyPartData(this.rightKneePos, this.rightKneeQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.RIGHT_KNEE)), ClientVRPlayers.makeBodyPartData(this.leftKneePos, this.leftKneeQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.LEFT_KNEE)), ClientVRPlayers.makeBodyPartData(this.rightElbowPos, this.rightElbowQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.RIGHT_ELBOW)), ClientVRPlayers.makeBodyPartData(this.leftElbowPos, this.leftElbowQuat, playerPos, this.fbtMode.bodyPartAvailable(VRBodyPart.LEFT_ELBOW)), this.seated, this.leftHanded, this.fbtMode);
            }
            return this.vrPose;
        }
    }
}

