/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.widgets;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.vivecraft.client.gui.framework.widgets.GuiVROptionSlider;
import org.vivecraft.client.gui.framework.widgets.TextOnlyButton;
import org.vivecraft.client.utils.StringSimilarity;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.TooltipUtil;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ConfigBuilder;

public class SettingsList
extends ContainerObjectSelectionList<BaseEntry> {
    private final List<BaseEntry> allEntries;
    private String activeFilter = "";
    private final Screen parent;

    public SettingsList(Screen parent, Minecraft minecraft, List<BaseEntry> entries, boolean searchable) {
        super(minecraft, parent.width, parent.height - (searchable ? 74 : 52), searchable ? 42 : 20, 20);
        this.parent = parent;
        entries = entries.stream().filter(Objects::nonNull).toList();
        this.allEntries = new ArrayList<BaseEntry>(entries);
        this.replaceEntriesFlatten(this.allEntries);
    }

    public void setActive(boolean active) {
        this.active = active;
        this.allEntries.forEach(entry -> entry.setParentActive(active));
    }

    private void replaceEntriesFlatten(List<BaseEntry> entries) {
        this.replaceEntriesFlatten(entries.stream());
    }

    private void replaceEntriesFlatten(Stream<BaseEntry> entries) {
        this.replaceEntries(entries.flatMap(entry -> entry.getEntries().stream()).toList());
    }

    public String getActiveFilter() {
        return this.activeFilter;
    }

    public void filter(String filter) {
        if (ClientDataHolderVR.getInstance().vrSettings.useFuzzySearch) {
            this.fuzzyFilter(filter);
        } else {
            this.exactFilter(filter);
        }
    }

    private void exactFilter(String filter) {
        if (!filter.trim().equals(this.activeFilter)) {
            this.setScrollAmount(0.0);
            this.activeFilter = filter.trim();
            String lowerCase = filter.trim().toLowerCase();
            this.replaceEntriesFlatten(this.allEntries.stream().filter((? super T entry) -> entry.filter(lowerCase)));
        }
    }

    private void fuzzyFilter(String filter) {
        if (filter.trim().isEmpty()) {
            this.replaceEntriesFlatten(this.allEntries);
        } else if (!filter.trim().equals(this.activeFilter)) {
            this.setScrollAmount(0.0);
            this.activeFilter = filter.trim();
            String lowerCase = filter.trim().toLowerCase();
            List<BaseEntry> entries = this.allEntries.stream().flatMap(child -> child.getEntries().stream()).filter((? super T entry) -> !(entry instanceof CategoryEntry)).map(entry -> Pair.of((Object)Float.valueOf(entry.search(lowerCase)), (Object)entry)).filter((? super T pair) -> ((Float)pair.getLeft()).floatValue() > 0.7f).sorted((a, b) -> ((Float)b.getLeft()).compareTo((Float)a.getLeft())).map(Pair::getRight).toList();
            this.replaceEntries(entries);
        }
    }

    public boolean isEntryVisible(BaseEntry entry) {
        int index = this.children().indexOf((Object)entry);
        return this.getRowTop(index) < this.getBottom() && this.getRowBottom(index) > this.getY();
    }

    protected int scrollBarX() {
        return this.getRowRight() + 2;
    }

    public int getRowWidth() {
        return Math.min(this.parent.width - 30, 350);
    }

    public int getRowLeft() {
        return this.getX() + this.width / 2 - this.getRowWidth() / 2 + 2;
    }

    public int getItemHeight() {
        return this.defaultEntryHeight;
    }

    public BaseEntry getHovered() {
        return (BaseEntry)super.getHovered();
    }

    public static BaseEntry ConfigToEntry(ConfigBuilder.ConfigValue<?> configValue) {
        ResettableEntry entry = new ResettableEntry((Component)Component.translatable((String)("vivecraft.serverSettings." + configValue.getPath())), configValue);
        ((BaseEntry)entry).setActive(Minecraft.getInstance().level == null || Minecraft.getInstance().isLocalServer());
        return entry;
    }

    public static BaseEntry vrOptionToEntry(VRSettings.VrOptions option) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        String optionString = "vivecraft.options." + option.name();
        WidgetEntry entry = dh.vrSettings.hasValue(option) ? new ResettableEntry((Component)Component.translatable((String)optionString), option) : new WidgetEntry((Component)Component.translatable((String)optionString), SettingsList.vrOptionToWidget(option, 145), () -> TooltipUtil.getClientConfigTooltip(option), null);
        if (dh.vrSettings.overrides.hasSetting(option) && dh.vrSettings.overrides.getSetting(option).isValueOverridden()) {
            ((BaseEntry)entry).setActive(false);
        }
        return entry;
    }

    private static AbstractWidget vrOptionToWidget(VRSettings.VrOptions option, int width) {
        ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
        GuiVROptionSlider widget = option.getEnumFloat() ? new GuiVROptionSlider(option.returnEnumOrdinal(), 0, 0, width, 20, option, true) : Button.builder((Component)Component.literal((String)dh.vrSettings.getButtonDisplayString(option, true)), button -> {
            dh.vrSettings.setOptionValue(option);
            button.setMessage((Component)Component.literal((String)dh.vrSettings.getButtonDisplayString(option, true)));
        }).size(width, 20).build();
        return widget;
    }

    public static abstract class BaseEntry
    extends ContainerObjectSelectionList.Entry<BaseEntry> {
        protected final Component name;
        private final Supplier<String> tooltip;
        private boolean active = true;
        private boolean parentActive = true;

        public BaseEntry(Component name, Supplier<String> tooltipSupplier) {
            this.name = name;
            this.tooltip = tooltipSupplier == null ? () -> "" : tooltipSupplier;
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.isFocused() && Minecraft.getInstance().getLastInputType().isKeyboard() || hovering && Minecraft.getInstance().getLastInputType().isMouse()) {
                guiGraphics.fill(this.getX(), this.getContentY(), this.getContentRight(), this.getContentY() + this.getHeight(), Integer.MIN_VALUE);
            }
        }

        public ComponentPath focusPathAtIndex(FocusNavigationEvent event, int index) {
            if (!this.isActive()) {
                return ComponentPath.leaf((GuiEventListener)this);
            }
            ComponentPath componentPath = null;
            for (int i = Math.min(index, this.children().size() - 1); componentPath == null && i >= 0; --i) {
                componentPath = ((GuiEventListener)this.children().get(i)).nextFocusPath(event);
            }
            return ComponentPath.path((ContainerEventHandler)this, componentPath);
        }

        protected int textColor() {
            return this.isActive() ? -1 : -6250336;
        }

        public boolean isActive() {
            return this.active && this.parentActive;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setParentActive(boolean active) {
            this.parentActive = active;
        }

        public boolean filter(String filter) {
            boolean match = false;
            ComponentContents componentContents = this.name.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents trans = (TranslatableContents)componentContents;
                match = trans.getKey().toLowerCase().contains(filter);
            }
            return match || this.name.getString().toLowerCase().contains(filter);
        }

        public float search(String search) {
            float matchKey = 0.0f;
            ComponentContents componentContents = this.name.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents trans = (TranslatableContents)componentContents;
                matchKey = StringSimilarity.partial_ratio(search, trans.getKey().toLowerCase()) * 0.9f;
            }
            float matchString = StringSimilarity.partial_ratio(search, this.name.getString().toLowerCase());
            return Math.max(matchString, matchKey);
        }

        public List<BaseEntry> getEntries() {
            return ImmutableList.of((Object)((Object)this));
        }

        public String getTooltip() {
            return this.tooltip.get();
        }
    }

    public static class ResettableEntry
    extends WidgetEntry {
        public static final int VALUE_BUTTON_WIDTH = 125;
        private final Button resetButton;
        private final BooleanSupplier canReset;

        public ResettableEntry(Component name, ConfigBuilder.ConfigValue<?> configValue) {
            this(name, configValue.getWidget(125, 20).get(), () -> TooltipUtil.getServerConfigTooltip(configValue.getPath(), true), null, () -> !configValue.isDefault(), () -> {
                configValue.reset();
                if (Minecraft.getInstance().hasSingleplayerServer()) {
                    configValue.onUpdate((MinecraftServer)Minecraft.getInstance().getSingleplayerServer());
                    ServerNetworking.sendUpdatePacketToAll((MinecraftServer)Minecraft.getInstance().getSingleplayerServer(), configValue);
                }
                return configValue.getWidget(125, 20).get();
            });
        }

        public ResettableEntry(Component name, VRSettings.VrOptions option) {
            this(name, SettingsList.vrOptionToWidget(option, 125), () -> TooltipUtil.getClientConfigTooltip(option), () -> {
                VRSettings.ServerOverrides overrides = ClientDataHolderVR.getInstance().vrSettings.overrides;
                return option.isChangeable() && (!overrides.hasSetting(option) || !overrides.getSetting(option).isValueOverridden());
            }, () -> !ClientDataHolderVR.getInstance().vrSettings.isDefault(option), () -> {
                ClientDataHolderVR.getInstance().vrSettings.loadDefault(option);
                return SettingsList.vrOptionToWidget(option, 125);
            });
        }

        private ResettableEntry(Component name, AbstractWidget widget, Supplier<String> tooltipSupplier, BooleanSupplier isActive, BooleanSupplier canReset, Supplier<AbstractWidget> resetAction) {
            super(name, widget, tooltipSupplier, isActive);
            this.canReset = canReset;
            this.resetButton = Button.builder((Component)Component.literal((String)"X"), button -> {
                this.valueWidget = (AbstractWidget)resetAction.get();
            }).tooltip(Tooltip.create((Component)Component.translatable((String)"controls.reset"))).bounds(0, 0, 20, 20).build();
            this.resetButton.setTooltipDelay(Duration.ofMillis(-1L));
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.renderContent(guiGraphics, mouseX, mouseY, hovering, partialTick);
            this.resetButton.setX(this.getContentRight() - 20);
            this.resetButton.setY(this.getContentY());
            this.resetButton.active = this.isActive() && this.valueWidget.active && this.canReset.getAsBoolean();
            this.resetButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.valueWidget, (Object)this.resetButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.resetButton.active = active;
        }
    }

    public static class WidgetEntry
    extends BaseEntry {
        public static final int VALUE_BUTTON_WIDTH = 145;
        protected final BooleanSupplier widgetActive;
        protected AbstractWidget valueWidget;

        public WidgetEntry(Component name, AbstractWidget valueWidget, Supplier<String> tooltipSupplier, BooleanSupplier widgetActive) {
            super(name, tooltipSupplier);
            this.valueWidget = valueWidget;
            this.widgetActive = widgetActive == null ? () -> true : widgetActive;
        }

        public WidgetEntry(Component name, AbstractWidget valueWidget, Supplier<String> tooltipSupplier) {
            this(name, valueWidget, tooltipSupplier, null);
        }

        public WidgetEntry(Component name, AbstractWidget valueWidget) {
            this(name, valueWidget, null, null);
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.renderContent(guiGraphics, mouseX, mouseY, hovering, partialTick);
            int textWidth = Minecraft.getInstance().font.width((FormattedText)this.name);
            int n = this.getY() + this.getHeight() / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            int textY = n - 9 / 2 + 2;
            if (textWidth < this.getContentWidth() - 145) {
                guiGraphics.drawString(Minecraft.getInstance().font, this.name, this.getContentX(), textY, this.textColor());
            } else {
                Font font = Minecraft.getInstance().font;
                int n2 = this.getContentX();
                int n3 = this.getContentRight() - 145 - 5;
                Objects.requireNonNull(Minecraft.getInstance().font);
                SettingsList.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.name, (int)n2, (int)textY, (int)n3, (int)(textY + 9 - 1), (int)this.textColor());
            }
            this.valueWidget.setX(this.getContentRight() - 145);
            this.valueWidget.setY(this.getContentY());
            this.valueWidget.active = this.widgetActive.getAsBoolean() && this.isActive();
            this.valueWidget.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.valueWidget);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.valueWidget.active = active;
        }
    }

    public static class CategoryEntry
    extends BaseEntry {
        private final int width;

        public CategoryEntry(Component name) {
            super(name, null);
            this.width = Minecraft.getInstance().font.width((FormattedText)this.name);
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            Font font = Minecraft.getInstance().font;
            int n = Minecraft.getInstance().screen.width / 2 - this.width / 2;
            int n2 = this.getContentBottom();
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, this.name, n, n2 - 9 - 1, this.textColor());
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent event) {
            return null;
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput narrationElementOutput) {
                    narrationElementOutput.add(NarratedElementType.TITLE, name);
                }
            });
        }
    }

    public static class ScreenEntry
    extends WidgetEntry {
        public ScreenEntry(String langKey, Function<Screen, Screen> screenFunction) {
            super((Component)Component.translatable((String)langKey), (AbstractWidget)Button.builder((Component)Component.translatable((String)langKey), b -> Minecraft.getInstance().setScreen((Screen)screenFunction.apply(Minecraft.getInstance().screen))).size(145, 20).build(), () -> I18n.exists((String)(langKey + ".tooltip")) ? I18n.get((String)(langKey + ".tooltip"), (Object[])new Object[0]) : "");
        }
    }

    public static class SelectableEntry
    extends BaseEntry {
        private final AbstractWidget mainWidget;
        private final AbstractWidget optionalWidget;

        public SelectableEntry(Component name, AbstractWidget optionalWidget, Runnable callback) {
            super(name, null);
            this.mainWidget = new TextOnlyButton(name, button -> callback.run());
            this.optionalWidget = optionalWidget;
        }

        @Override
        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovering, float partialTick) {
            super.renderContent(guiGraphics, mouseX, mouseY, hovering, partialTick);
            this.mainWidget.setX(this.getContentX());
            this.mainWidget.setY(this.getContentY());
            this.mainWidget.setWidth(this.optionalWidget == null ? this.getContentWidth() : this.getContentWidth() - 10 - this.optionalWidget.getWidth());
            this.mainWidget.render(guiGraphics, mouseX, mouseY, partialTick);
            if (this.optionalWidget != null) {
                this.optionalWidget.setX(this.getContentRight() - this.optionalWidget.getWidth());
                this.optionalWidget.setY(this.getContentY());
                this.optionalWidget.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public List<? extends GuiEventListener> children() {
            return this.optionalWidget != null ? ImmutableList.of((Object)this.mainWidget, (Object)this.optionalWidget) : ImmutableList.of((Object)this.mainWidget);
        }

        public List<? extends NarratableEntry> narratables() {
            return this.optionalWidget != null ? ImmutableList.of((Object)this.mainWidget, (Object)this.optionalWidget) : ImmutableList.of((Object)this.mainWidget);
        }

        @Override
        public void setActive(boolean active) {
            this.mainWidget.active = active;
            if (this.optionalWidget != null) {
                this.optionalWidget.active = active;
            }
        }
    }

    public static class GroupedEntry
    extends CategoryEntry {
        private final ArrayList<BaseEntry> allChildren = new ArrayList();
        private final ArrayList<BaseEntry> activeChildren = new ArrayList();

        public GroupedEntry(Component name) {
            super(name);
        }

        public void add(BaseEntry entry) {
            this.allChildren.add(entry);
            this.activeChildren.add(entry);
        }

        @Override
        public boolean filter(String filter) {
            this.activeChildren.clear();
            if (super.filter(filter)) {
                this.activeChildren.addAll(this.allChildren);
            } else {
                this.activeChildren.addAll(this.allChildren.stream().filter((? super T entry) -> entry.filter(filter)).toList());
            }
            return !this.activeChildren.isEmpty();
        }

        @Override
        public List<BaseEntry> getEntries() {
            return Stream.concat(Stream.of(this), this.activeChildren.stream().flatMap(child -> child.getEntries().stream())).toList();
        }

        @Override
        public void setParentActive(boolean active) {
            super.setParentActive(active);
            this.allChildren.forEach(child -> child.setParentActive(active));
        }
    }
}

