/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.render.armor;

import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class VRArmorModel_WithArms {
    public static ArmorModelSet<MeshDefinition> createArmorMeshSet(CubeDeformation inner, CubeDeformation outer) {
        ArmorModelSet armorSet = PlayerModel.createArmorMeshSet((CubeDeformation)inner, (CubeDeformation)outer).map(mesh -> {
            PartDefinition root = mesh.getRoot();
            root.addOrReplaceChild("left_hand", CubeListBuilder.create(), PartPose.ZERO);
            root.addOrReplaceChild("right_hand", CubeListBuilder.create(), PartPose.ZERO);
            return mesh;
        });
        VRArmorModel_WithArms.addVRParts((MeshDefinition)armorSet.chest(), outer);
        return armorSet.map(mesh -> {
            PartDefinition root = mesh.getRoot();
            root.getChild("left_arm").addOrReplaceChild("left_sleeve", CubeListBuilder.create(), PartPose.ZERO);
            root.getChild("right_arm").addOrReplaceChild("right_sleeve", CubeListBuilder.create(), PartPose.ZERO);
            root.getChild("left_hand").addOrReplaceChild("left_hand_sleeve", CubeListBuilder.create(), PartPose.ZERO);
            root.getChild("right_hand").addOrReplaceChild("right_hand_sleeve", CubeListBuilder.create(), PartPose.ZERO);
            return mesh;
        });
    }

    protected static void addVRParts(MeshDefinition meshDefinition, CubeDeformation cubeDeformation) {
        PartDefinition root = meshDefinition.getRoot();
        boolean connected = ClientDataHolderVR.getInstance().vrSettings.playerLimbsConnected;
        int upperExtension = connected ? 3 : 0;
        int lowerExtension = connected ? 2 : 0;
        float lowerShrinkage = connected ? -0.05f : 0.0f;
        root.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        root.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(40, 23 - lowerExtension).addBox(-2.0f, -5.0f - (float)lowerExtension, -2.0f, 4.0f, 5.0f + (float)lowerExtension, 4.0f, cubeDeformation.extend(lowerShrinkage)), PartPose.offset((float)-5.0f, (float)2.5f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 5.0f + (float)upperExtension, 4.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
    }
}

