/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_xr.render_pass.RenderPassType;
import org.vivecraft.client_xr.render_pass.WorldRenderPass;

public class MultiPassTextureTarget
extends TextureTarget {
    private boolean isVanilla = false;
    private RenderPass passOverride = null;
    private RenderTarget last = null;
    @Nullable
    private final EnumMap<RenderPass, TextureTarget> vrTargets;
    private final TextureTarget vanilla;

    public MultiPassTextureTarget(String name, int width, int height, boolean useDepth) {
        super(name, width, height, useDepth);
        super.destroyBuffers();
        this.vrTargets = new EnumMap(RenderPass.class);
        this.isVanilla = true;
        this.vanilla = new TextureTarget(name, width, height, useDepth);
        this.isVanilla = false;
        for (RenderPass pass : RenderPass.values()) {
            WorldRenderPass worldPass = WorldRenderPass.getByRenderPass(pass);
            if (worldPass == null) continue;
            RenderTarget original = worldPass.target;
            this.vrTargets.put(pass, new TextureTarget(name + " " + String.valueOf((Object)pass), original.width, original.height, useDepth));
        }
        this.setLast(this.vanilla);
    }

    public void resize(int width, int height) {
        if (this.vrTargets == null) {
            super.resize(width, height);
            return;
        }
        this.isVanilla = true;
        this.vanilla.resize(width, height);
        this.isVanilla = false;
        for (Map.Entry<RenderPass, TextureTarget> entry : this.vrTargets.entrySet()) {
            WorldRenderPass pass = WorldRenderPass.getByRenderPass(entry.getKey());
            if (pass == null) continue;
            this.passOverride = entry.getKey();
            entry.getValue().resize(pass.target.width, pass.target.height);
            this.passOverride = null;
        }
    }

    public void destroyBuffers() {
        if (this.vrTargets == null) {
            super.destroyBuffers();
            return;
        }
        this.callOnAllTargets(RenderTarget::destroyBuffers);
    }

    public void copyDepthFrom(RenderTarget otherTarget) {
        if (this.vrTargets == null) {
            super.copyDepthFrom(otherTarget);
            return;
        }
        this.callOnTarget(r -> r.copyDepthFrom(otherTarget));
    }

    public void createBuffers(int width, int height) {
        if (this.vrTargets == null) {
            super.createBuffers(width, height);
            return;
        }
        this.callOnTarget(r -> r.createBuffers(width, height));
    }

    public void setFilterMode(FilterMode filterMode) {
        if (this.vrTargets == null) {
            super.setFilterMode(filterMode);
            return;
        }
        this.callOnTarget(r -> r.setFilterMode(filterMode));
    }

    public void blitToScreen() {
        if (this.vrTargets == null) {
            super.blitToScreen();
            return;
        }
        this.callOnTarget(RenderTarget::blitToScreen);
    }

    public void blitAndBlendToTexture(GpuTextureView gpuTextureView) {
        if (this.vrTargets == null) {
            super.blitAndBlendToTexture(gpuTextureView);
            return;
        }
        this.callOnTarget(r -> r.blitAndBlendToTexture(gpuTextureView));
    }

    public GpuTexture getColorTexture() {
        if (this.vrTargets == null) {
            return super.getColorTexture();
        }
        return this.callOnTargetRet(RenderTarget::getColorTexture);
    }

    public GpuTextureView getColorTextureView() {
        if (this.vrTargets == null) {
            return super.getColorTextureView();
        }
        return this.callOnTargetRet(RenderTarget::getColorTextureView);
    }

    public GpuTexture getDepthTexture() {
        if (this.vrTargets == null) {
            return super.getDepthTexture();
        }
        return this.callOnTargetRet(RenderTarget::getDepthTexture);
    }

    public GpuTextureView getDepthTextureView() {
        if (this.vrTargets == null) {
            return super.getDepthTextureView();
        }
        return this.callOnTargetRet(RenderTarget::getDepthTextureView);
    }

    private void callOnAllTargets(Consumer<TextureTarget> consumer) {
        this.isVanilla = true;
        consumer.accept(this.vanilla);
        this.isVanilla = false;
        for (Map.Entry<RenderPass, TextureTarget> entry : this.vrTargets.entrySet()) {
            this.passOverride = entry.getKey();
            consumer.accept(entry.getValue());
            this.passOverride = null;
        }
    }

    private void callOnTarget(Consumer<TextureTarget> consumer) {
        TextureTarget current = this.getCurrent();
        if (current != this.last) {
            this.setLast(current);
        }
        consumer.accept(current);
    }

    private <T> T callOnTargetRet(Function<TextureTarget, T> function) {
        TextureTarget current = this.getCurrent();
        if (current != this.last) {
            this.setLast(current);
        }
        return function.apply(current);
    }

    private TextureTarget getCurrent() {
        if (this.isVanilla || RenderPassType.isVanilla()) {
            return this.vanilla;
        }
        return this.vrTargets.get((Object)(this.passOverride != null ? this.passOverride : ClientDataHolderVR.getInstance().currentPass));
    }

    private void setLast(TextureTarget current) {
        this.last = current;
        this.width = current.width;
        this.height = current.height;
        this.filterMode = current.filterMode;
    }
}

