/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.vivecraft.api.data.VRBodyPart;
import org.vivecraft.client.network.ClientNetworking;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.common.network.NetworkVersion;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    private EntityEquipment equipment;

    @ModifyReturnValue(method={"getSelectedItem()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private ItemStack vivecraft$dualHandingItem(ItemStack original) {
        return this.vivecraft$activeItem(original);
    }

    @Inject(method={"setSelectedItem(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void vivecraft$setOffhand(ItemStack stack, CallbackInfoReturnable<ItemStack> cir) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue() && ServerVRPlayers.isVRPlayer(serverPlayer)) {
                ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                if (NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion) && vivePlayer.activeBodyPart == VRBodyPart.OFF_HAND) {
                    cir.setReturnValue((Object)this.equipment.set(EquipmentSlot.OFFHAND, stack));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Unique
    private ItemStack vivecraft$activeItem(ItemStack original) {
        VRBodyPart bodyPart;
        block7: {
            block6: {
                bodyPart = null;
                Player player = this.player;
                if (!(player instanceof ServerPlayer)) break block6;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!((Boolean)ServerConfig.DUAL_WIELDING.get()).booleanValue()) break block6;
                if (ServerVRPlayers.isVRPlayer(serverPlayer)) {
                    ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer(serverPlayer);
                    if (NetworkVersion.DUAL_WIELDING.accepts(vivePlayer.networkVersion)) {
                        bodyPart = vivePlayer.activeBodyPart;
                    }
                }
                break block7;
            }
            if (this.player.isLocalPlayer() && VRState.VR_RUNNING && ClientNetworking.SERVER_ALLOWS_DUAL_WIELDING) {
                bodyPart = ClientNetworking.getActiveBodyPart();
            }
        }
        if (bodyPart != null) {
            if (bodyPart == VRBodyPart.OFF_HAND) {
                return this.equipment.get(EquipmentSlot.OFFHAND);
            }
            if (bodyPart != VRBodyPart.MAIN_HAND && bodyPart != VRBodyPart.HEAD) {
                return ItemStack.EMPTY;
            }
        }
        return original;
    }
}

