/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.neoforge;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import org.vivecraft.Xloader;

public class XloaderImpl
implements Xloader {
    public static Xloader.ModLoader getModloader() {
        return Xloader.ModLoader.NEOFORGE;
    }

    public static boolean isModLoaded(String name) {
        return FMLLoader.getCurrent().getLoadingModList().getModFileById(name) != null;
    }

    public static String getModVersion() {
        if (Xloader.isModLoadedSuccess()) {
            return FMLLoader.getCurrent().getLoadingModList().getModFileById("vivecraft").versionString();
        }
        return "no version";
    }

    public static Path getConfigPath(String fileName) {
        return FMLPaths.CONFIGDIR.get().resolve(fileName);
    }

    public static InputStream getInJarFile(String sourcePath) throws IOException {
        return FMLLoader.getCurrent().getLoadingModList().getModFileById("vivecraft").getFile().getContents().openFile(sourcePath);
    }

    public static List<Path> getInJarFolderFiles(String folder) throws IOException {
        ArrayList<Path> paths = new ArrayList<Path>();
        Path target = Path.of(folder, new String[0]);
        FMLLoader.getCurrent().getLoadingModList().getModFileById("vivecraft").getFile().getContents().visitContent(folder, (relPath, resource) -> {
            Path file = Path.of(relPath, new String[0]);
            if (target.equals(file.getParent())) {
                paths.add(file);
            }
        });
        return paths;
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.getDist() == Dist.DEDICATED_SERVER;
    }
}

