/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.vivecraft.Xloader;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.server.config.ServerConfig;

public class UpdateChecker {
    public static boolean HAS_UPDATE = false;
    public static String CHANGELOG = "";
    public static String NEWEST_VERSION = "";

    public static boolean checkForUpdates() {
        char updateType;
        VRSettings.LOGGER.info("Vivecraft: Checking for Updates");
        if (Xloader.isDedicatedServer()) {
            updateType = ((String)ServerConfig.CHECK_FOR_UPDATE_TYPE.get()).charAt(0);
        } else {
            updateType = switch (ClientDataHolderVR.getInstance().vrSettings.updateType) {
                default -> throw new MatchException(null, null);
                case VRSettings.UpdateType.RELEASE -> 'r';
                case VRSettings.UpdateType.BETA -> 'b';
                case VRSettings.UpdateType.ALPHA -> 'a';
            };
        }
        try {
            String apiURL = "https://api.modrinth.com/v2/project/vivecraft/version?loaders=[%22" + Xloader.getModloader().name + "%22]&game_versions=[%221.21.5%22]";
            HttpURLConnection conn = (HttpURLConnection)new URL(apiURL).openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("Accept", "application/json,*/*");
            conn.connect();
            if (conn.getResponseCode() != 200) {
                VRSettings.LOGGER.error("Vivecraft: Error '{}' fetching updates", (Object)conn.getResponseCode());
                return false;
            }
            JsonElement j = JsonParser.parseString((String)UpdateChecker.inputStreamToString(conn.getInputStream()));
            LinkedList<Version> versions = new LinkedList<Version>();
            if (j.isJsonArray()) {
                for (JsonElement element : j.getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    JsonObject obj = element.getAsJsonObject();
                    versions.add(new Version(obj.get("name").getAsString(), obj.get("version_number").getAsString(), obj.get("changelog").getAsString()));
                }
            }
            Collections.sort(versions);
            String currentVersionNumber = Xloader.getModVersion() + "-" + Xloader.getModloader().name;
            Version current = new Version(currentVersionNumber, currentVersionNumber, "");
            if (current.alpha > 0 && updateType != 'a') {
                updateType = 'a';
            } else if (current.beta > 0 && updateType != 'a') {
                updateType = 'b';
            }
            for (Version v : versions) {
                if (!v.isVersionType(updateType) || current.compareTo(v) <= 0) continue;
                CHANGELOG = CHANGELOG + "\u00a7a" + v.fullVersion + "\u00a7r: \n" + v.changelog + "\n\n";
                if (NEWEST_VERSION.isEmpty()) {
                    NEWEST_VERSION = v.fullVersion;
                }
                HAS_UPDATE = true;
            }
            CHANGELOG = CHANGELOG.replaceAll("\\r", "");
            if (HAS_UPDATE) {
                VRSettings.LOGGER.info("Vivecraft update found: {}", (Object)NEWEST_VERSION);
            }
        }
        catch (IOException e) {
            VRSettings.LOGGER.error("Vivecraft: fetching available vivecraft updates: ", (Throwable)e);
        }
        return HAS_UPDATE;
    }

    private static String inputStreamToString(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
    }

    private static class Version
    implements Comparable<Version> {
        public String fullVersion;
        public String changelog;
        public int major;
        public int minor;
        public int patch;
        int alpha = 0;
        int beta = 0;
        boolean featureTest = false;

        public Version(String version, String version_number, String changelog) {
            this.fullVersion = version;
            this.changelog = changelog;
            String[] parts = version_number.split("-");
            int viveVersionIndex = parts.length - 2;
            if (!parts[viveVersionIndex].contains(".")) {
                viveVersionIndex = parts.length - 3;
                String testString = parts[parts.length - 2];
                if (testString.matches("a\\d+.*")) {
                    this.alpha = Integer.parseInt(testString.replaceAll("\\D+", ""));
                } else if (testString.matches("b\\d+.*")) {
                    this.beta = Integer.parseInt(testString.replaceAll("\\D+", ""));
                }
                if (!testString.replaceAll("^[ab]\\d+", "").isEmpty()) {
                    this.featureTest = true;
                }
            }
            String[] ints = parts[viveVersionIndex].split("\\.");
            this.major = Integer.parseInt(ints[0].replaceAll("\\D+", ""));
            this.minor = Integer.parseInt(ints[1].replaceAll("\\D+", ""));
            this.patch = Integer.parseInt(ints[2].replaceAll("\\D+", ""));
        }

        @Override
        public int compareTo(Version o) {
            long result = this.compareNumber() - o.compareNumber();
            if (result < 0L) {
                return 1;
            }
            if (result == 0L) {
                return 0;
            }
            return -1;
        }

        public boolean isVersionType(char versionType) {
            return switch (versionType) {
                case 'r' -> {
                    if (this.beta == 0 && this.alpha == 0 && !this.featureTest) {
                        yield true;
                    }
                    yield false;
                }
                case 'b' -> {
                    if (this.beta >= 0 && this.alpha == 0 && !this.featureTest) {
                        yield true;
                    }
                    yield false;
                }
                case 'a' -> {
                    if (this.alpha >= 0 && !this.featureTest) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        private long compareNumber() {
            return (this.featureTest ? 1L : 0L) + (long)this.alpha * 10L + (long)this.beta * 1000L + (this.alpha + this.beta == 0 ? 10000L : 0L) + (long)this.patch * 1000000L + (long)this.minor * 100000000L + (long)this.major * 10000000000L;
        }
    }
}

