/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.render.helpers;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalInt;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_9334;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.extensions.GameRendererExtension;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.render.MirrorNotification;
import org.vivecraft.client_vr.render.VRShaders;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;

public class ShaderHelper {
    private static final class_310 MC = class_310.method_1551();
    private static final ClientDataHolderVR DATA_HOLDER = ClientDataHolderVR.getInstance();
    private static float FOV_REDUCTION = 1.0f;
    private static float WATER_EFFECT;
    private static boolean WAS_IN_WATER;
    private static float PUMPKIN_EFFECT;
    private static float PORTAL_EFFECT;
    private static float RED;
    private static float BLACK;
    private static float BLUE;
    private static float TIME;
    private static GpuBuffer SCREEN_VBO;

    public static void renderFullscreenQuad(@NotNull RenderPipeline instance, @NotNull Consumer<com.mojang.blaze3d.systems.RenderPass> uniformSetter, @Nullable GpuTexture target) {
        if (instance.getVertexFormat() != class_290.field_1585) {
            throw new IllegalStateException("Vertex format needs to be 'POSITION_TEX'");
        }
        GpuBuffer quad = ShaderHelper.getFullscreenQuad();
        RenderSystem.class_5590 indexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer indexGpuBuffer = indexBuffer.method_68274(6);
        try (com.mojang.blaze3d.systems.RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(target != null ? target : MC.method_1522().method_30277(), OptionalInt.empty());){
            renderPass.setPipeline(instance);
            renderPass.setVertexBuffer(0, quad);
            uniformSetter.accept(renderPass);
            renderPass.setIndexBuffer(indexGpuBuffer, indexBuffer.method_31924());
            renderPass.drawIndexed(0, 6);
        }
    }

    private static GpuBuffer getFullscreenQuad() {
        if (SCREEN_VBO == null) {
            class_287 builder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1585);
            builder.method_22912(-1.0f, -1.0f, 0.0f).method_22913(0.0f, 0.0f);
            builder.method_22912(1.0f, -1.0f, 0.0f).method_22913(1.0f, 0.0f);
            builder.method_22912(1.0f, 1.0f, 0.0f).method_22913(1.0f, 1.0f);
            builder.method_22912(-1.0f, 1.0f, 0.0f).method_22913(0.0f, 1.0f);
            try (class_9801 meshData = builder.method_60800();){
                SCREEN_VBO = RenderSystem.getDevice().createBuffer(() -> "fullscreen vr vertex buffer", BufferType.VERTICES, BufferUsage.STATIC_WRITE, meshData.method_60818());
            }
        }
        return SCREEN_VBO;
    }

    public static void doVrPostProcess(RenderPass eye, class_276 source, class_276 target, float partialTick) {
        if (eye == RenderPass.LEFT) {
            RED = 0.0f;
            BLACK = 0.0f;
            BLUE = 0.0f;
            TIME = (float)class_156.method_658() / 1000.0f;
            PUMPKIN_EFFECT = 0.0f;
            PORTAL_EFFECT = 0.0f;
            if (ShaderHelper.MC.field_1724 != null && ShaderHelper.MC.field_1687 != null) {
                boolean isInWater = ((GameRendererExtension)ShaderHelper.MC.field_1773).vivecraft$isInWater();
                if (ShaderHelper.DATA_HOLDER.vrSettings.waterEffect && WAS_IN_WATER != isInWater) {
                    WATER_EFFECT = 2.3f;
                } else {
                    WATER_EFFECT = isInWater ? (WATER_EFFECT -= 0.008333334f) : (WATER_EFFECT -= 0.016666668f);
                    if (WATER_EFFECT < 0.0f) {
                        WATER_EFFECT = 0.0f;
                    }
                }
                WAS_IN_WATER = isInWater;
                if (IrisHelper.isLoaded() && !IrisHelper.hasWaterEffect()) {
                    WATER_EFFECT = 0.0f;
                }
                float portalTime = class_3532.method_16439((float)partialTick, (float)ShaderHelper.MC.field_1724.field_44912, (float)ShaderHelper.MC.field_1724.field_44911);
                PORTAL_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.portalEffect && portalTime > 0.0f ? portalTime : 0.0f;
                class_1799 itemstack = ShaderHelper.MC.field_1724.method_6118(class_1304.field_6169);
                PUMPKIN_EFFECT = ShaderHelper.DATA_HOLDER.vrSettings.pumpkinEffect && itemstack.method_7909() == class_2246.field_10147.method_8389() && !itemstack.method_57826(class_9334.field_49637) ? 1.0f : 0.0f;
                float hurtTimer = (float)ShaderHelper.MC.field_1724.field_6235 - partialTick;
                float healthPercent = 1.0f - ShaderHelper.MC.field_1724.method_6032() / ShaderHelper.MC.field_1724.method_6063();
                healthPercent = (healthPercent - 0.5f) * 0.75f;
                if (ShaderHelper.DATA_HOLDER.vrSettings.hitIndicator && hurtTimer > 0.0f) {
                    hurtTimer /= (float)ShaderHelper.MC.field_1724.field_6254;
                    RED = hurtTimer = healthPercent + class_3532.method_15374((float)(hurtTimer * hurtTimer * hurtTimer * hurtTimer * (float)Math.PI)) * 0.5f;
                } else if (ShaderHelper.DATA_HOLDER.vrSettings.lowHealthIndicator) {
                    RED = healthPercent * class_3532.method_15379((float)class_3532.method_15374((float)(2.5f * TIME / (1.0f - healthPercent + 0.1f))));
                    if (ShaderHelper.MC.field_1724.method_68878()) {
                        RED = 0.0f;
                    }
                }
                float freeze = ShaderHelper.MC.field_1724.method_32313();
                if (ShaderHelper.DATA_HOLDER.vrSettings.freezeEffect && freeze > 0.0f) {
                    BLUE = RED;
                    BLUE = Math.max(freeze / 2.0f, BLUE);
                    RED = 0.0f;
                }
                if (ShaderHelper.MC.field_1724.method_6113()) {
                    BLACK = 0.5f + 0.3f * (float)ShaderHelper.MC.field_1724.method_7297() * 0.01f;
                }
                if (ShaderHelper.DATA_HOLDER.vr.isWalkingAbout && BLACK < 0.8f) {
                    BLACK = 0.5f;
                }
                if (ShaderHelper.DATA_HOLDER.vrSettings.useFOVReduction && ShaderHelper.DATA_HOLDER.vrPlayer.getFreeMove()) {
                    FOV_REDUCTION = Math.abs(ShaderHelper.MC.field_1724.field_6250) > 0.0f || Math.abs(ShaderHelper.MC.field_1724.field_6212) > 0.0f ? (FOV_REDUCTION -= 0.05f) : (FOV_REDUCTION += 0.01f);
                    FOV_REDUCTION = class_3532.method_15363((float)FOV_REDUCTION, (float)ShaderHelper.DATA_HOLDER.vrSettings.fovReductionMin, (float)0.8f);
                } else {
                    FOV_REDUCTION = 1.0f;
                }
            } else {
                WATER_EFFECT = 0.0f;
                FOV_REDUCTION = 1.0f;
            }
        }
        ShaderHelper.renderFullscreenQuad(VRShaders.POST_PROCESSING_PIPELINE, renderPass -> {
            if (PUMPKIN_EFFECT > 0.0f) {
                renderPass.setUniform("circle_radius", new float[]{0.3f});
                renderPass.setUniform("border", new float[]{0.0f});
            } else {
                renderPass.setUniform("circle_radius", new float[]{FOV_REDUCTION});
                renderPass.setUniform("border", new float[]{0.06f});
            }
            renderPass.setUniform("circle_offset", new float[]{ShaderHelper.DATA_HOLDER.vrSettings.fovRedutioncOffset});
            renderPass.setUniform("redalpha", new float[]{RED});
            renderPass.setUniform("bluealpha", new float[]{BLUE});
            renderPass.setUniform("blackalpha", new float[]{BLACK});
            renderPass.setUniform("portaltime", new float[]{TIME});
            renderPass.setUniform("water", new float[]{WATER_EFFECT});
            renderPass.setUniform("portal", new float[]{PORTAL_EFFECT});
            renderPass.setUniform("pumpkin", new float[]{PUMPKIN_EFFECT});
            renderPass.setUniform("eye", new int[]{eye == RenderPass.LEFT ? 1 : -1});
            renderPass.bindSampler("Sampler0", source.method_30277());
        }, target.method_30277());
    }

    public static void drawMirror() {
        if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF && ShaderHelper.DATA_HOLDER.vr.isHMDTracking()) {
            MirrorNotification.notify("Mirror is OFF", true, 1000);
        } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY) {
            ShaderHelper.doMixedRealityMirror();
        } else if (!(ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode != VRSettings.MirrorMode.DUAL || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible())) {
            class_276 leftEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            class_276 rightEye = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
            int screenWidth = ShaderHelper.MC.field_1689.field_1482 / 2;
            int screenHeight = ShaderHelper.MC.field_1689.field_1481;
            if (leftEye != null) {
                ShaderHelper.blitToScreen(leftEye, 0, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
            if (rightEye != null) {
                ShaderHelper.blitToScreen(rightEye, screenWidth, screenWidth, screenHeight, 0, 0.0f, 0.0f, false);
            }
        } else {
            float xCrop = 0.0f;
            float yCrop = 0.0f;
            boolean keepAspect = false;
            class_276 source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0;
            if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible()) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer;
                keepAspect = true;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.FIRST_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) {
                source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.GUI) {
                source = GuiHandler.GUI_FRAMEBUFFER;
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.SINGLE || ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.OFF) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
            } else if (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorMode == VRSettings.MirrorMode.CROPPED) {
                if (!ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye) {
                    source = ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1;
                }
                xCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                yCrop = ShaderHelper.DATA_HOLDER.vrSettings.mirrorCrop;
                keepAspect = true;
            }
            if (source != null) {
                ShaderHelper.blitToScreen(source, 0, ShaderHelper.MC.field_1689.field_1482, ShaderHelper.MC.field_1689.field_1481, 0, xCrop, yCrop, keepAspect);
            }
        }
        MirrorNotification.render();
    }

    public static void doMixedRealityMirror() {
        Vector3f camPlayer = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getHeadPivotF().sub((Vector3fc)ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getPositionF());
        Matrix4f viewMatrix = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getMatrix().transpose();
        Vector3f cameraLook = ShaderHelper.DATA_HOLDER.vrPlayer.vrdata_room_pre.getEye(RenderPass.THIRD).getDirection();
        cameraLook.set(-cameraLook.x, 0.0f, -cameraLook.z);
        boolean alphaMask = ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike && ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityAlphaMask;
        ShaderHelper.renderFullscreenQuad(VRShaders.MIXED_REALITY_PIPELINE, renderPass -> {
            renderPass.setUniform("projectionMatrix", ((GameRendererExtension)ShaderHelper.MC.field_1773).vivecraft$getThirdPassProjectionMatrix());
            renderPass.setUniform("viewMatrix", viewMatrix);
            renderPass.setUniform("hmdViewPosition", new float[]{camPlayer.x, camPlayer.y, camPlayer.z});
            renderPass.setUniform("hmdPlaneNormal", new float[]{cameraLook.x, cameraLook.y, cameraLook.z});
            if (!alphaMask) {
                renderPass.setUniform("keyColor", new float[]{(float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getRed() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getGreen() / 255.0f, (float)ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityKeyColor.getBlue() / 255.0f});
            } else {
                renderPass.setUniform("keyColor", new float[]{0.0f, 0.0f, 0.0f});
            }
            renderPass.setUniform("alphaMode", new int[]{alphaMask ? 1 : 0});
            renderPass.setUniform("firstPersonPass", new int[]{ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike ? 1 : 0});
            renderPass.bindSampler("thirdPersonColor", ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.method_30277());
            renderPass.bindSampler("thirdPersonDepth", ShaderHelper.DATA_HOLDER.vrRenderer.framebufferMR.method_30278());
            if (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUnityLike) {
                class_276 source = ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorUseScreenshotCamera && ShaderHelper.DATA_HOLDER.cameraTracker.isVisible() ? ShaderHelper.DATA_HOLDER.vrRenderer.cameraFramebuffer : (ShaderHelper.DATA_HOLDER.vrSettings.mixedRealityUndistorted ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferUndistorted : (ShaderHelper.DATA_HOLDER.vrSettings.displayMirrorLeftEye ? ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye0 : ShaderHelper.DATA_HOLDER.vrRenderer.framebufferEye1));
                renderPass.bindSampler("firstPersonColor", source.method_30277());
            }
        }, null);
    }

    public static void doFSAA(class_276 source, class_276 firstPass, class_276 secondPass) {
        if (firstPass == null) {
            ShaderHelper.DATA_HOLDER.vrRenderer.reinitFrameBuffers("FSAA Setting Changed");
        } else {
            ShaderHelper.renderFullscreenQuad(VRShaders.LANCZOS_PIPELINE, renderPass -> {
                renderPass.bindSampler("Sampler0", source.method_30277());
                renderPass.bindSampler("Sampler1", source.method_30278());
                renderPass.setUniform("texelWidthOffset", new float[]{1.0f / (3.0f * (float)firstPass.field_1480)});
                renderPass.setUniform("texelHeightOffset", new float[]{0.0f});
            }, firstPass.method_30277());
            ShaderHelper.renderFullscreenQuad(VRShaders.LANCZOS_PIPELINE, renderPass -> {
                renderPass.bindSampler("Sampler0", firstPass.method_30277());
                renderPass.bindSampler("Sampler1", firstPass.method_30278());
                renderPass.setUniform("texelWidthOffset", new float[]{0.0f});
                renderPass.setUniform("texelHeightOffset", new float[]{1.0f / (3.0f * (float)secondPass.field_1477)});
            }, secondPass.method_30277());
        }
    }

    public static void blitToScreen(class_276 source, int left, int width, int height, int top, float xCropFactor, float yCropFactor, boolean keepAspect) {
        RenderSystem.assertOnRenderThread();
        float drawAspect = (float)width / (float)height;
        float bufferAspect = (float)source.field_1480 / (float)source.field_1477;
        float xMin = xCropFactor;
        float yMin = yCropFactor;
        float xMax = 1.0f - xCropFactor;
        float yMax = 1.0f - yCropFactor;
        if (keepAspect) {
            if (drawAspect > bufferAspect) {
                float heightAspect = bufferAspect / drawAspect * (0.5f - yCropFactor);
                yMin = 0.5f - heightAspect;
                yMax = 0.5f + heightAspect;
            } else {
                float widthAspect = drawAspect / bufferAspect * (0.5f - xCropFactor);
                xMin = 0.5f - widthAspect;
                xMax = 0.5f + widthAspect;
            }
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, VRShaders.BLIT_VR_PIPELINE.getVertexFormat());
        float xMinPos = (float)left / (float)ShaderHelper.MC.method_1522().field_1480 * 2.0f - 1.0f;
        float yMinPos = (float)top / (float)ShaderHelper.MC.method_1522().field_1477 * 2.0f - 1.0f;
        float xMaxPos = xMinPos + (float)width / (float)ShaderHelper.MC.method_1522().field_1480 * 2.0f;
        float yMaxPos = yMinPos + (float)height / (float)ShaderHelper.MC.method_1522().field_1477 * 2.0f;
        bufferBuilder.method_22912(xMinPos, yMinPos, 0.0f).method_22913(xMin, yMin);
        bufferBuilder.method_22912(xMaxPos, yMinPos, 0.0f).method_22913(xMax, yMin);
        bufferBuilder.method_22912(xMaxPos, yMaxPos, 0.0f).method_22913(xMax, yMax);
        bufferBuilder.method_22912(xMinPos, yMaxPos, 0.0f).method_22913(xMin, yMax);
        try (class_9801 meshData = bufferBuilder.method_60800();){
            VertexFormat.class_5595 indexType;
            GpuBuffer indexBuffer;
            GpuBuffer gpuBuffer = VRShaders.BLIT_VR_PIPELINE.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
            if (meshData.method_60821() == null) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
                indexBuffer = autoStorageIndexBuffer.method_68274(6);
                indexType = autoStorageIndexBuffer.method_31924();
            } else {
                indexBuffer = VRShaders.BLIT_VR_PIPELINE.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
                indexType = meshData.method_60822().comp_753();
            }
            try (com.mojang.blaze3d.systems.RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(MC.method_1522().method_30277(), OptionalInt.empty());){
                renderPass.setPipeline(VRShaders.BLIT_VR_PIPELINE);
                renderPass.setVertexBuffer(0, gpuBuffer);
                renderPass.bindSampler("DiffuseSampler", source.method_30277());
                renderPass.setIndexBuffer(indexBuffer, indexType);
                renderPass.drawIndexed(0, 6);
            }
        }
    }
}

