/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.screens;

import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client.gui.framework.widgets.MultilineComponent;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.AutoCalibration;
import org.vivecraft.common.utils.MathUtils;

public class FBTCalibrationScreen
extends class_437 {
    private static final class_2382 COLOR_INACTIVE = new class_2382(128, 64, 64);
    private static final class_2382 COLOR_ACTIVE = new class_2382(64, 128, 64);
    private static final byte ALPHA = -56;
    private final class_437 parent;
    private final boolean wasFbtCalibrated;
    private final boolean wasFbtExtendedCalibrated;
    private final Vector3fc[] oldFbtOffsets;
    private final Quaternionfc[] oldFbtRotations;
    private boolean calibrated = false;
    private boolean usingUnlabeledTrackers = false;
    private boolean rightHandAtPosition = false;
    private boolean leftHandAtPosition = false;
    private Vector3f rightHand = new Vector3f();
    private Vector3f leftHand = new Vector3f();
    private float yaw;
    private MultilineComponent calibrationText;
    private MultilineComponent unlabeledTrackersWarningText;
    private MultilineComponent unlabeledTrackersConfirmationText;
    private class_4185 resetButton;
    private class_4185 cancelButton;

    public FBTCalibrationScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"vivecraft.options.screen.fbtcalibration"));
        this.parent = parent;
        this.wasFbtCalibrated = ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated;
        this.wasFbtExtendedCalibrated = ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated;
        this.oldFbtOffsets = new Vector3fc[ClientDataHolderVR.getInstance().vrSettings.fbtOffsets.length];
        this.oldFbtRotations = new Quaternionfc[ClientDataHolderVR.getInstance().vrSettings.fbtRotations.length];
        for (int i = 0; i < this.oldFbtOffsets.length; ++i) {
            this.oldFbtOffsets[i] = new Vector3f((Vector3fc)ClientDataHolderVR.getInstance().vrSettings.fbtOffsets[i]);
            this.oldFbtRotations[i] = new Quaternionf((Quaternionfc)ClientDataHolderVR.getInstance().vrSettings.fbtRotations[i]);
        }
        ClientDataHolderVR.getInstance().showedFbtCalibrationNotification = true;
        ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = false;
        if (VRState.VR_INITIALIZED) {
            boolean fbt = ClientDataHolderVR.getInstance().vr.hasFBT();
            boolean extended = ClientDataHolderVR.getInstance().vr.hasExtendedFBT();
            int trackers = ClientDataHolderVR.getInstance().vr.getTrackers().size();
            this.usingUnlabeledTrackers = ClientDataHolderVR.getInstance().vrSettings.unlabeledTrackersUsed || !extended && trackers >= 7 || !fbt && trackers >= 3;
        }
    }

    private void reset() {
        this.calibrated = false;
        if (VRState.VR_INITIALIZED) {
            ClientDataHolderVR.getInstance().vr.resetFBT();
        }
        ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = false;
        ClientDataHolderVR.getInstance().vrSettings.unlabeledTrackersUsed = this.usingUnlabeledTrackers;
        ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        this.cancelButton.method_25355((class_2561)class_2561.method_43471((String)"gui.cancel"));
        this.resetButton.field_22764 = false;
    }

    public boolean isCalibrated() {
        return this.calibrated;
    }

    protected void method_25426() {
        this.calibrationText = new MultilineComponent(this.field_22789 / 2, 30, 400, (class_2561)class_2561.method_43471((String)"vivecraft.messages.fbtcalibration"), true, this.field_22793);
        this.unlabeledTrackersWarningText = new MultilineComponent(this.field_22789 / 2, this.calibrationText.method_46427() + this.calibrationText.method_25364(), 400, (class_2561)class_2561.method_43471((String)"vivecraft.messages.fbtcalibration.unlabeledTrackers"), true, this.field_22793);
        this.unlabeledTrackersWarningText.field_22764 = this.usingUnlabeledTrackers;
        this.unlabeledTrackersConfirmationText = new MultilineComponent(this.field_22789 / 2, 30, 400, (class_2561)class_2561.method_43471((String)"vivecraft.messages.fbtcalibration.unlabeledTrackersConfirm"), true, this.field_22793);
        this.unlabeledTrackersConfirmationText.field_22764 = false;
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"controls.reset"), p -> this.reset()).method_46433(this.field_22789 / 2 - 75, this.field_22790 - 54).method_46432(150).method_46431();
        this.resetButton.field_22764 = this.calibrated;
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.calibrated ? "vivecraft.gui.ok" : "gui.cancel")), p -> this.field_22787.method_1507(this.parent)).method_46433(this.field_22789 / 2 - 75, this.field_22790 - 32).method_46432(150).method_46431();
        this.method_37063((class_364)this.calibrationText);
        this.method_37063((class_364)this.unlabeledTrackersWarningText);
        this.method_37063((class_364)this.unlabeledTrackersConfirmationText);
        this.method_37063((class_364)this.resetButton);
        this.method_37063((class_364)this.cancelButton);
        if (VRState.VR_RUNNING) {
            this.yaw = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getYawRad();
        }
    }

    public void method_25432() {
        if (!this.calibrated) {
            ClientDataHolderVR.getInstance().vrSettings.fbtCalibrated = this.wasFbtCalibrated;
            ClientDataHolderVR.getInstance().vrSettings.fbtExtendedCalibrated = this.wasFbtExtendedCalibrated;
            for (int i = 0; i < this.oldFbtOffsets.length; ++i) {
                ClientDataHolderVR.getInstance().vrSettings.fbtOffsets[i].set(this.oldFbtOffsets[i]);
                ClientDataHolderVR.getInstance().vrSettings.fbtRotations[i].set(this.oldFbtRotations[i]);
            }
            ClientDataHolderVR.getInstance().vrSettings.saveOptions();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.calibrationText.field_22764 = !this.calibrated;
        this.unlabeledTrackersWarningText.field_22764 = !this.calibrated && this.usingUnlabeledTrackers;
        this.unlabeledTrackersConfirmationText.field_22764 = this.calibrated && this.usingUnlabeledTrackers;
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        if (!this.calibrated || !this.usingUnlabeledTrackers) {
            class_332.method_49601((class_4587)poseStack, (int)(this.field_22789 / 2 - 64), (int)(this.field_22790 - 32 - 96), (int)48, (int)16, (int)-1);
            class_332.method_49601((class_4587)poseStack, (int)(this.field_22789 / 2 + 16), (int)(this.field_22790 - 32 - 96), (int)48, (int)16, (int)-1);
            poseStack.method_22903();
            poseStack.method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 - 32.0f, 0.0f);
            poseStack.method_22905(4.0f, -4.0f, 4.0f);
            poseStack.method_22907(class_7833.field_40716.rotation((float)Math.PI));
            if (VRState.VR_RUNNING) {
                poseStack.method_22907(class_7833.field_40716.rotation(this.yaw - ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getYawRad()));
            }
            class_2382 color = this.leftHandAtPosition && this.rightHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE;
            class_287 builder = class_289.method_1348().method_1349();
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            RenderHelper.renderBox((class_4588)builder, new class_243(2.0, 0.0, 0.0), new class_243(2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((class_4588)builder, new class_243(-2.0, 0.0, 0.0), new class_243(-2.0, 12.0, 0.0), 4.0f, 4.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((class_4588)builder, new class_243(0.0, 12.0, 0.0), new class_243(0.0, 24.0, 0.0), 8.0f, 4.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((class_4588)builder, new class_243(0.0, 24.0, 0.0), new class_243(0.0, 32.0, 0.0), 8.0f, 8.0f, color, (byte)-56, poseStack);
            RenderHelper.renderBox((class_4588)builder, new class_243(6.0, 22.0, 0.0).method_1023((double)(this.leftHand.x * 2.0f), (double)(this.leftHand.y * 2.0f), (double)(this.leftHand.z * 2.0f)), new class_243(6.0, 22.0, 0.0).method_1031((double)(this.leftHand.x * 10.0f), (double)(this.leftHand.y * 10.0f), (double)(this.leftHand.z * 10.0f)), 4.0f, 4.0f, this.leftHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack);
            RenderHelper.renderBox((class_4588)builder, new class_243(-6.0, 22.0, 0.0).method_1023((double)(this.rightHand.x * 2.0f), (double)(this.rightHand.y * 2.0f), (double)(this.rightHand.z * 2.0f)), new class_243(-6.0, 22.0, 0.0).method_1031((double)(this.rightHand.x * 10.0f), (double)(this.rightHand.y * 10.0f), (double)(this.rightHand.z * 10.0f)), 4.0f, 4.0f, this.rightHandAtPosition ? COLOR_ACTIVE : COLOR_INACTIVE, (byte)-56, poseStack);
            class_286.method_43433((class_287.class_7433)builder.method_1326());
            poseStack.method_22909();
        }
    }

    public void method_25393() {
        boolean leftHandNew;
        if (!VRState.VR_RUNNING) {
            this.rightHand.set(MathUtils.DOWN);
            this.leftHand.set(MathUtils.DOWN);
            return;
        }
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        Vector3f hmdPosAvg = dataHolder.vr.hmdPivotHistory.averagePosition(0.5);
        float height = hmdPosAvg.y / 1.52f;
        float scale = height * 0.9375f;
        int main = dataHolder.vrSettings.reverseHands ? 1 : 0;
        this.rightHand = dataHolder.vrPlayer.vrdata_room_post.getController(main).getPositionF().sub(hmdPosAvg.x, 1.375f * scale, hmdPosAvg.z).rotateY(this.yaw).add(scale * 0.375f, 0.0f, 0.0f).normalize();
        this.leftHand = dataHolder.vrPlayer.vrdata_room_post.getController(1 - main).getPositionF().sub(hmdPosAvg.x, 1.375f * scale, hmdPosAvg.z).rotateY(this.yaw).add(-scale * 0.375f, 0.0f, 0.0f).normalize();
        boolean rightHandNew = this.rightHand.dot(MathUtils.RIGHT) > 0.9f;
        boolean bl = leftHandNew = this.leftHand.dot(MathUtils.LEFT) > 0.9f;
        if (!this.rightHandAtPosition && rightHandNew) {
            dataHolder.vr.triggerHapticPulse(ControllerType.RIGHT, 0.01f, 100.0f, 1.0f);
        }
        if (!this.leftHandAtPosition && leftHandNew) {
            dataHolder.vr.triggerHapticPulse(ControllerType.LEFT, 0.01f, 100.0f, 1.0f);
        }
        this.rightHandAtPosition = rightHandNew;
        this.leftHandAtPosition = leftHandNew;
        if (VRState.VR_RUNNING) {
            if (this.calibrated && this.usingUnlabeledTrackers) {
                dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(false);
            } else {
                dataHolder.vr.getInputAction(VivecraftVRMod.INSTANCE.keyVRInteract).setEnabled(this.leftHandAtPosition && this.rightHandAtPosition);
                if (VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.LEFT) && VivecraftVRMod.INSTANCE.keyVRInteract.isDown(ControllerType.RIGHT) && VivecraftVRMod.INSTANCE.keyVRInteract.method_1436()) {
                    AutoCalibration.calibrateManual();
                    dataHolder.vr.calibrateFBT(this.yaw + (float)Math.PI);
                    dataHolder.vrSettings.unlabeledTrackersUsed = this.usingUnlabeledTrackers;
                    dataHolder.vrSettings.saveOptions();
                    ClientUtils.addChatMessage((class_2561)class_2561.method_43471((String)"vivecraft.messages.fbtcalibrationsuccess"));
                    this.calibrated = true;
                    if (!this.usingUnlabeledTrackers) {
                        this.field_22787.method_1507(this.parent);
                    } else {
                        this.cancelButton.method_25355((class_2561)class_2561.method_43471((String)"vivecraft.gui.ok"));
                        this.resetButton.field_22764 = true;
                    }
                }
            }
        }
    }
}

