/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_151;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.vivecraft.Xloader;
import org.vivecraft.common.network.packet.s2c.AttackWhileBlockingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.CrawlPayloadS2C;
import org.vivecraft.common.network.packet.s2c.DualWieldingPayloadS2C;
import org.vivecraft.common.network.packet.s2c.TeleportPayloadS2C;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ConfigBuilder;
import org.vivecraft.server.config.enums.ClimbeyBlockmode;
import org.vivecraft.server.config.enums.HeadshotIndicator;

public class ServerConfig {
    public static ConfigBuilder.BooleanValue DEBUG;
    public static ConfigBuilder.BooleanValue DEBUG_PARTICLES;
    public static ConfigBuilder.BooleanValue DEBUG_PARTICLES_HEAD;
    public static ConfigBuilder.BooleanValue CHECK_FOR_UPDATES;
    public static ConfigBuilder.InListValue<String> CHECK_FOR_UPDATE_TYPE;
    public static ConfigBuilder.BooleanValue VR_ONLY;
    public static ConfigBuilder.BooleanValue VIVE_ONLY;
    public static ConfigBuilder.BooleanValue ALLOW_OP;
    public static ConfigBuilder.DoubleValue MESSAGE_KICK_DELAY;
    public static ConfigBuilder.BooleanValue VR_FUN;
    public static ConfigBuilder.BooleanValue SEND_DATA_TO_OWNER;
    public static ConfigBuilder.BooleanValue MESSAGES_ENABLED;
    public static ConfigBuilder.StringValue MESSAGES_WELCOME_VR;
    public static ConfigBuilder.StringValue MESSAGES_WELCOME_NONVR;
    public static ConfigBuilder.StringValue MESSAGES_WELCOME_SEATED;
    public static ConfigBuilder.StringValue MESSAGES_WELCOME_VANILLA;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_VR;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_NONVR;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_SEATED;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_VANILLA;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_BY_MOB_VR;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_BY_MOB_NONVR;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_BY_MOB_SEATED;
    public static ConfigBuilder.StringValue MESSAGES_DEATH_BY_MOB_VANILLA;
    public static ConfigBuilder.StringValue MESSAGES_LEAVE_MESSAGE;
    public static ConfigBuilder.StringValue MESSAGES_KICK_VIVE_ONLY;
    public static ConfigBuilder.StringValue MESSAGES_KICK_VR_ONLY;
    public static ConfigBuilder.BooleanValue DUAL_WIELDING;
    public static ConfigBuilder.DoubleValue BOOTS_ARMOR_DAMAGE;
    public static ConfigBuilder.DoubleValue CREEPER_SWELL_DISTANCE;
    public static ConfigBuilder.DoubleValue MOB_ATTACK_RANGE_ADJUSTMENT;
    public static ConfigBuilder.DoubleValue PROJECTILE_INACCURACY_MULTIPLIER;
    public static ConfigBuilder.BooleanValue ALLOW_FASTER_BLOCK_BREAKING;
    public static ConfigBuilder.BooleanValue ALLOW_ROOMSCALE_SHIELD_BLOCKING;
    public static ConfigBuilder.BooleanValue ALLOW_ATTACKS_WHILE_BLOCKING;
    public static ConfigBuilder.DoubleValue BOW_STANDING_MULTIPLIER;
    public static ConfigBuilder.DoubleValue BOW_SEATED_MULTIPLIER;
    public static ConfigBuilder.DoubleValue BOW_STANDING_HEADSHOT_MULTIPLIER;
    public static ConfigBuilder.DoubleValue BOW_SEATED_HEADSHOT_MULTIPLIER;
    public static ConfigBuilder.DoubleValue BOW_VANILLA_HEADSHOT_MULTIPLIER;
    public static ConfigBuilder.EnumValue<HeadshotIndicator> BOW_HEADSHOT_INDICATOR;
    public static ConfigBuilder.BooleanValue PVP_VR_VS_VR;
    public static ConfigBuilder.BooleanValue PVP_SEATEDVR_VS_SEATEDVR;
    public static ConfigBuilder.BooleanValue PVP_VR_VS_NONVR;
    public static ConfigBuilder.BooleanValue PVP_SEATEDVR_VS_NONVR;
    public static ConfigBuilder.BooleanValue PVP_VR_VS_SEATEDVR;
    public static ConfigBuilder.BooleanValue PVP_NOTIFY_BLOCKED_DAMAGE;
    public static ConfigBuilder.BooleanValue CLIMBEY_ENABLED;
    public static ConfigBuilder.EnumValue<ClimbeyBlockmode> CLIMBEY_BLOCKMODE;
    public static ConfigBuilder.ListValue<String> CLIMBEY_BLOCKLIST;
    public static ConfigBuilder.BooleanValue CRAWLING_ENABLED;
    public static ConfigBuilder.BooleanValue TELEPORT_ENABLED;
    public static ConfigBuilder.BooleanValue TELEPORT_LIMITED_SURVIVAL;
    public static ConfigBuilder.IntValue TELEPORT_UP_LIMIT;
    public static ConfigBuilder.IntValue TELEPORT_DOWN_LIMIT;
    public static ConfigBuilder.IntValue TELEPORT_HORIZONTAL_LIMIT;
    public static ConfigBuilder.BooleanValue WORLDSCALE_LIMITED;
    public static ConfigBuilder.DoubleValue WORLDSCALE_MAX;
    public static ConfigBuilder.DoubleValue WORLDSCALE_MIN;
    public static ConfigBuilder.BooleanValue FORCE_THIRD_PERSON_ITEMS;
    public static ConfigBuilder.BooleanValue FORCE_THIRD_PERSON_ITEMS_CUSTOM;
    public static ConfigBuilder.BooleanValue VR_SWITCHING_ENABLED;
    private static CommentedFileConfig CONFIG;
    private static ConfigBuilder BUILDER;

    public static List<ConfigBuilder.ConfigValue> getConfigValues() {
        return BUILDER.getConfigValues();
    }

    public static void init(ConfigSpec.CorrectionListener listener) {
        Config.setInsertionOrderPreserved((boolean)true);
        if (CONFIG != null) {
            CONFIG.close();
        }
        CONFIG = (CommentedFileConfig)CommentedFileConfig.builder((Path)Xloader.getConfigPath("vivecraft-server-config.toml")).autosave().sync().concurrent().build();
        CONFIG.load();
        if (listener == null) {
            listener = (action, path, incorrectValue, correctedValue) -> {
                if (incorrectValue != null) {
                    ServerNetworking.LOGGER.info("Vivecraft: Corrected setting '{}': was '{}', is now '{}'", new Object[]{String.join((CharSequence)".", path), incorrectValue, correctedValue});
                }
            };
        }
        ServerConfig.fixConfig((CommentedConfig)CONFIG, listener);
        CONFIG.save();
    }

    private static void fixConfig(CommentedConfig config, ConfigSpec.CorrectionListener listener) {
        BUILDER = new ConfigBuilder(config, new ConfigSpec());
        BUILDER.push("general");
        DEBUG = BUILDER.push("debug").define(false);
        CHECK_FOR_UPDATES = BUILDER.push("checkForUpdate").define(true);
        CHECK_FOR_UPDATE_TYPE = BUILDER.push("checkForUpdateType").defineInList("r", Arrays.asList("r", "b", "a"));
        VR_ONLY = (ConfigBuilder.BooleanValue)BUILDER.push("vr_only").define(false).setOnUpdate(ServerNetworking::updateViveVROnly);
        VIVE_ONLY = (ConfigBuilder.BooleanValue)BUILDER.push("vive_only").define(false).setOnUpdate(ServerNetworking::updateViveVROnly);
        ALLOW_OP = (ConfigBuilder.BooleanValue)BUILDER.push("allow_op").define(true).setOnUpdate(ServerNetworking::updateViveVROnly);
        MESSAGE_KICK_DELAY = BUILDER.push("messageAndKickDelay").defineInRange(10.0, 0.0, 100.0);
        VR_FUN = BUILDER.push("vrFun").define(true);
        SEND_DATA_TO_OWNER = BUILDER.push("sendDataToOwner").define(false);
        BUILDER.pop();
        BUILDER.push("messages", true);
        MESSAGES_ENABLED = BUILDER.push("enabled").define(false);
        MESSAGES_WELCOME_VR = BUILDER.push("welcomeVR").define("%s has joined with standing VR!");
        MESSAGES_WELCOME_NONVR = BUILDER.push("welcomeNonVR").define("%s has joined with Non-VR companion!");
        MESSAGES_WELCOME_SEATED = BUILDER.push("welcomeSeated").define("%s has joined with seated VR!");
        MESSAGES_WELCOME_VANILLA = BUILDER.push("welcomeVanilla").define("%s has joined as a Muggle!");
        MESSAGES_LEAVE_MESSAGE = BUILDER.push("leaveMessage").define("%s has disconnected from the server!");
        MESSAGES_DEATH_VR = BUILDER.push("deathVR").define("%s died in standing VR!");
        MESSAGES_DEATH_NONVR = BUILDER.push("deathNonVR").define("%s died in Non-VR companion!");
        MESSAGES_DEATH_SEATED = BUILDER.push("deathSeated").define("%s died in seated VR!");
        MESSAGES_DEATH_VANILLA = BUILDER.push("deathVanilla").define("%s died as a Muggle!");
        MESSAGES_DEATH_BY_MOB_VR = BUILDER.push("deathByMobVR").define("%1$s was slain by %2$s in standing VR!");
        MESSAGES_DEATH_BY_MOB_NONVR = BUILDER.push("deathByMobNonVR").define("%1$s was slain by %2$s in Non-VR companion!");
        MESSAGES_DEATH_BY_MOB_SEATED = BUILDER.push("deathByMobSeated").define("%1$s was slain by %2$s in seated VR!");
        MESSAGES_DEATH_BY_MOB_VANILLA = BUILDER.push("deathByMobVanilla").define("%1$s was slain by %2$s as a Muggle!");
        MESSAGES_KICK_VIVE_ONLY = BUILDER.push("KickViveOnly").define("This server is configured for Vivecraft players only.");
        MESSAGES_KICK_VR_ONLY = BUILDER.push("KickVROnly").define("This server is configured for VR players only.");
        BUILDER.pop();
        BUILDER.push("vrChanges");
        CREEPER_SWELL_DISTANCE = BUILDER.push("creeperSwellDistance").defineInRange(1.75, 0.1, 10.0);
        MOB_ATTACK_RANGE_ADJUSTMENT = BUILDER.push("mobAttackRangeAdjustment").defineInRange(-0.4, -0.7, 0.0);
        DUAL_WIELDING = (ConfigBuilder.BooleanValue)BUILDER.push("dualWielding").define(true).setPacketFunction(v -> new DualWieldingPayloadS2C((Boolean)DUAL_WIELDING.get()));
        BOOTS_ARMOR_DAMAGE = BUILDER.push("bootsArmorDamage").defineInRange(0.0, 0.0, 5.0);
        PROJECTILE_INACCURACY_MULTIPLIER = BUILDER.push("projectileInaccuracyMultiplier").defineInRange(1.0, 0.0, 1.0);
        ALLOW_FASTER_BLOCK_BREAKING = BUILDER.push("allowFasterBlockBreaking").define(true);
        ALLOW_ROOMSCALE_SHIELD_BLOCKING = BUILDER.push("allowRoomscaleShieldBlocking").define(true);
        ALLOW_ATTACKS_WHILE_BLOCKING = (ConfigBuilder.BooleanValue)BUILDER.push("allowAttacksWhileBlocking").define(true).setPacketFunction(v -> new AttackWhileBlockingPayloadS2C((Boolean)ALLOW_ATTACKS_WHILE_BLOCKING.get()));
        BUILDER.push("bow");
        BOW_STANDING_MULTIPLIER = BUILDER.push("standingMultiplier").defineInRange(2.0, 1.0, 10.0);
        BOW_SEATED_MULTIPLIER = BUILDER.push("seatedMultiplier").defineInRange(1.0, 1.0, 10.0);
        BOW_STANDING_HEADSHOT_MULTIPLIER = BUILDER.push("standingHeadshotMultiplier").defineInRange(3.0, 1.0, 10.0);
        BOW_SEATED_HEADSHOT_MULTIPLIER = BUILDER.push("seatedHeadshotMultiplier").defineInRange(2.0, 1.0, 10.0);
        BOW_VANILLA_HEADSHOT_MULTIPLIER = BUILDER.push("vanillaHeadshotMultiplier").defineInRange(1.0, 1.0, 10.0);
        BOW_HEADSHOT_INDICATOR = BUILDER.push("headshotIndicator").defineEnum(HeadshotIndicator.BOTH, HeadshotIndicator.class);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("pvp");
        PVP_NOTIFY_BLOCKED_DAMAGE = BUILDER.push("notifyBlockedDamage").define(false);
        PVP_VR_VS_VR = BUILDER.push("VRvsVR").define(true);
        PVP_SEATEDVR_VS_SEATEDVR = BUILDER.push("SEATEDVRvsSEATEDVR").define(true);
        PVP_VR_VS_NONVR = BUILDER.push("VRvsNONVR").define(true);
        PVP_SEATEDVR_VS_NONVR = BUILDER.push("SEATEDVRvsNONVR").define(true);
        PVP_VR_VS_SEATEDVR = BUILDER.push("VRvsSEATEDVR").define(true);
        BUILDER.pop();
        BUILDER.push("climbey");
        CLIMBEY_ENABLED = (ConfigBuilder.BooleanValue)BUILDER.push("enabled").define(true).setPacketFunction(v -> ServerNetworking.getClimbeyServerPayload());
        CLIMBEY_BLOCKMODE = (ConfigBuilder.EnumValue)BUILDER.push("blockmode").defineEnum(ClimbeyBlockmode.DISABLED, ClimbeyBlockmode.class).setPacketFunction(v -> ServerNetworking.getClimbeyServerPayload());
        CLIMBEY_BLOCKLIST = (ConfigBuilder.ListValue)BUILDER.push("blocklist").defineList(Arrays.asList("white_wool", "dirt", "grass_block"), s -> {
            boolean valid = true;
            try {
                class_2248 b = (class_2248)class_7923.field_41175.method_10223(new class_2960((String)s));
                if (b == class_2246.field_10124) {
                    valid = false;
                }
            }
            catch (class_151 e) {
                valid = false;
            }
            if (!valid) {
                ServerNetworking.LOGGER.error("Vivecraft: Ignoring invalid/unknown block in climbey blocklist: {}", s);
            }
            return true;
        }).setPacketFunction(v -> ServerNetworking.getClimbeyServerPayload());
        BUILDER.pop();
        BUILDER.push("crawling");
        CRAWLING_ENABLED = (ConfigBuilder.BooleanValue)((ConfigBuilder.ConfigValue)BUILDER.push("enabled").define(true).setOnUpdate(ServerNetworking::updateCrawling)).setPacketFunction(v -> new CrawlPayloadS2C((Boolean)CRAWLING_ENABLED.get(), v.networkVersion));
        BUILDER.pop();
        BUILDER.push("teleport");
        TELEPORT_ENABLED = (ConfigBuilder.BooleanValue)BUILDER.push("enabled").define(true).setPacketFunction(v -> new TeleportPayloadS2C((Boolean)TELEPORT_ENABLED.get(), v.networkVersion));
        TELEPORT_LIMITED_SURVIVAL = (ConfigBuilder.BooleanValue)BUILDER.push("limitedSurvival").define(false).setPacketFunction(v -> ServerNetworking.getSurvivalTeleportOverridePayload());
        TELEPORT_UP_LIMIT = (ConfigBuilder.IntValue)BUILDER.push("upLimit").defineInRange(4, 1, 16).setPacketFunction(v -> ServerNetworking.getSurvivalTeleportOverridePayload());
        TELEPORT_DOWN_LIMIT = (ConfigBuilder.IntValue)BUILDER.push("downLimit").defineInRange(4, 1, 16).setPacketFunction(v -> ServerNetworking.getSurvivalTeleportOverridePayload());
        TELEPORT_HORIZONTAL_LIMIT = (ConfigBuilder.IntValue)BUILDER.push("horizontalLimit").defineInRange(16, 1, 32).setPacketFunction(v -> ServerNetworking.getSurvivalTeleportOverridePayload());
        BUILDER.pop();
        BUILDER.push("worldScale");
        WORLDSCALE_LIMITED = (ConfigBuilder.BooleanValue)BUILDER.push("limitRange").define(false).setPacketFunction(v -> ServerNetworking.getWorldScaleOverridePayload());
        WORLDSCALE_MIN = (ConfigBuilder.DoubleValue)BUILDER.push("min").defineInRange(0.5, 0.1, 100.0).setPacketFunction(v -> ServerNetworking.getWorldScaleOverridePayload());
        WORLDSCALE_MAX = (ConfigBuilder.DoubleValue)BUILDER.push("max").defineInRange(2.0, 0.1, 100.0).setPacketFunction(v -> ServerNetworking.getWorldScaleOverridePayload());
        BUILDER.pop();
        BUILDER.push("settingOverrides");
        FORCE_THIRD_PERSON_ITEMS = (ConfigBuilder.BooleanValue)BUILDER.push("thirdPersonItems").define(false).setPacketFunction(v -> ServerNetworking.getThirdPersonItemsOverridePayload());
        FORCE_THIRD_PERSON_ITEMS_CUSTOM = (ConfigBuilder.BooleanValue)BUILDER.push("thirdPersonItemsCustom").define(false).setPacketFunction(v -> ServerNetworking.getThirdPersonItemsCustomOverridePayload());
        BUILDER.pop();
        BUILDER.push("vrSwitching");
        VR_SWITCHING_ENABLED = (ConfigBuilder.BooleanValue)BUILDER.push("enabled").define(true).setPacketFunction(v -> ServerNetworking.getVRSwitchingPayload());
        BUILDER.pop();
        BUILDER.push("debug");
        DEBUG_PARTICLES = BUILDER.push("debugParticles").define(false);
        DEBUG_PARTICLES_HEAD = BUILDER.push("debugParticlesHead").define(false);
        BUILDER.pop();
        for (ConfigBuilder.ConfigValue configValue : BUILDER.getConfigValues()) {
            ConfigBuilder.EnumValue enumValue;
            if (!(configValue instanceof ConfigBuilder.EnumValue) || (enumValue = (ConfigBuilder.EnumValue)configValue).get() == null) continue;
            enumValue.set(enumValue.getEnumValue(enumValue.get()));
        }
        BUILDER.correct(listener);
    }
}

