/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRNativeDevice_t")
public class VRNativeDevice
extends Struct<VRNativeDevice>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;

    protected VRNativeDevice(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VRNativeDevice create(long address, @Nullable ByteBuffer container) {
        return new VRNativeDevice(address, container);
    }

    public VRNativeDevice(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRNativeDevice.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRNativeDevice.nhandle(this.address());
    }

    @NativeType(value="EDeviceType")
    public int eType() {
        return VRNativeDevice.neType(this.address());
    }

    public VRNativeDevice handle(@NativeType(value="void *") long value) {
        VRNativeDevice.nhandle(this.address(), value);
        return this;
    }

    public VRNativeDevice eType(@NativeType(value="EDeviceType") int value) {
        VRNativeDevice.neType(this.address(), value);
        return this;
    }

    public VRNativeDevice set(long handle, int eType) {
        this.handle(handle);
        this.eType(eType);
        return this;
    }

    public VRNativeDevice set(VRNativeDevice src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRNativeDevice malloc() {
        return new VRNativeDevice(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VRNativeDevice calloc() {
        return new VRNativeDevice(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VRNativeDevice create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VRNativeDevice(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VRNativeDevice create(long address) {
        return new VRNativeDevice(address, null);
    }

    @Nullable
    public static VRNativeDevice createSafe(long address) {
        return address == 0L ? null : new VRNativeDevice(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VRNativeDevice.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRNativeDevice.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VRNativeDevice malloc(MemoryStack stack) {
        return new VRNativeDevice(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRNativeDevice calloc(MemoryStack stack) {
        return new VRNativeDevice(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static int neType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ETYPE);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void neType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ETYPE, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
    }

    static {
        Struct.Layout layout = VRNativeDevice.__struct((Struct.Member[])new Struct.Member[]{VRNativeDevice.__member((int)POINTER_SIZE), VRNativeDevice.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VRNativeDevice, Buffer>
    implements NativeResource {
        private static final VRNativeDevice ELEMENT_FACTORY = VRNativeDevice.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VRNativeDevice getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRNativeDevice.nhandle(this.address());
        }

        @NativeType(value="EDeviceType")
        public int eType() {
            return VRNativeDevice.neType(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRNativeDevice.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="EDeviceType") int value) {
            VRNativeDevice.neType(this.address(), value);
            return this;
        }
    }
}

