/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.forge.event;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.vivecraft.Xloader;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.config.ServerConfig;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER}, bus=Mod.EventBusSubscriber.Bus.FORGE, modid="vivecraft")
public class ServerForgeEvents {
    @SubscribeEvent
    public static void crashWithForgeExtension(ServerAboutToStartEvent event) {
        if (Xloader.isModLoaded("vivecraftforgeextensions")) {
            throw new RuntimeException("The vivecraft mod cannot be used together with the 'Vivecraft Forge Extension'.\nThe Vivecraft Mod implements all features the forge extension has.\nRemove the 'Vivecraft Forge Extension' to resolve this error");
        }
    }

    @SubscribeEvent
    public static void loadServerConfig(ServerStartingEvent serverStartingEvent) {
        if (!Language.getInstance().has("vivecraft.serverSettings.general")) {
            String langFile = String.format(Locale.ROOT, "lang/%s.json", "en_us");
            CloseableResourceManager resourceManager = serverStartingEvent.getServer().getServerResources().resourceManager();
            MultiPackResourceManager clientResources = new MultiPackResourceManager(PackType.CLIENT_RESOURCES, resourceManager.listPacks().toList());
            HashMap langMap = new HashMap();
            try {
                ResourceLocation langResource = ResourceLocation.fromNamespaceAndPath((String)"vivecraft", (String)langFile);
                for (Resource resource : clientResources.getResourceStack(langResource)) {
                    InputStream stream = resource.open();
                    try {
                        Language.loadFromJson((InputStream)stream, langMap::put);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                Language.getInstance().getLanguageData().putAll(langMap);
                ForgeI18n.loadLanguageData((Map)Language.getInstance().getLanguageData());
            }
            catch (Exception exception) {
                ServerNetworking.LOGGER.error("Vivecraft: failed to load vivecraft lang file", (Throwable)exception);
            }
        }
        ServerConfig.init(null);
    }
}

