/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.gameplay.interact_modules;

import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.api.client.HeldInteractModule;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.gameplay.interact_modules.DebugRenderModule;
import org.vivecraft.client_vr.render.helpers.DebugRenderHelper;
import org.vivecraft.client_vr.settings.VRHotkeys;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.common.utils.MathUtils;

public class ThirdPersonCameraModule
implements DebugRenderModule,
HeldInteractModule {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"vivecraft", (String)"third_person_camera");
    private static final float INTERACT_DIST = 0.15f;
    private final ClientDataHolderVR dh;
    private Vec3 camPos;

    public ThirdPersonCameraModule(ClientDataHolderVR dh) {
        this.dh = dh;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 750;
    }

    @Override
    public boolean isActive(@Nullable LocalPlayer player, InteractionHand hand, Vec3 handPosition) {
        if (this.dh.vrSettings.mixedRealityRenderCameraModel && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON)) {
            VRData.VRDevicePose camData = this.dh.vrPlayer.vrdata_world_pre.getEye(RenderPass.THIRD);
            Vector3f offset = camData.getCustomVector(MathUtils.BACK).mul(0.15f * this.dh.vrPlayer.vrdata_world_pre.worldScale).add((Vector3fc)camData.getCustomVector(MathUtils.DOWN).mul(0.05f * this.dh.vrPlayer.vrdata_world_pre.worldScale));
            this.camPos = camData.getPosition().subtract((double)offset.x, (double)offset.y, (double)offset.z);
            return handPosition.distanceTo(this.camPos) < (double)(0.15f * this.dh.vrPlayer.vrdata_world_pre.worldScale);
        }
        return false;
    }

    @Override
    public boolean onPress(@Nullable LocalPlayer player, InteractionHand hand) {
        VRHotkeys.startMovingThirdPersonCam(hand.ordinal(), VRHotkeys.Triggerer.INTERACTION);
        return true;
    }

    @Override
    public void onRelease(@Nullable LocalPlayer player, InteractionHand hand) {
        if (VRHotkeys.isMovingThirdPersonCam() && VRHotkeys.getMovingThirdPersonCamTriggerer() == VRHotkeys.Triggerer.INTERACTION && VRHotkeys.getMovingThirdPersonCamController() == hand.ordinal()) {
            VRHotkeys.stopMovingThirdPersonCam();
        }
    }

    public boolean isActive() {
        return this.dh.interactTracker.isActiveModule(this);
    }

    @Override
    public void renderDebug(boolean isActive) {
        if (this.dh.vrSettings.mixedRealityRenderCameraModel && (this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.MIXED_REALITY || this.dh.vrSettings.displayMirrorMode == VRSettings.MirrorMode.THIRD_PERSON) && this.camPos != null) {
            VRData world = this.dh.vrPlayer.getVRDataWorld();
            Vec3 cam = this.camPos.subtract(this.dh.vrPlayer.vrdata_world_pre.origin).add(world.origin);
            DebugRenderHelper.renderSphere((Vector3fc)MathUtils.subtractToVector3f(cam, world.getEye(this.dh.currentPass).getPosition()), 0.15f * world.worldScale, isActive ? MathUtils.GREEN : MathUtils.RED);
        }
    }
}

